/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.intellij.jinja.template.psi.impl.Jinja2MemberNameImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateItemReference
extends BaseReference {
    @Nullable
    private final PsiFileSystemItem myItem;

    public DjangoTemplateItemReference(@NotNull PsiElement element, @Nullable PsiFileSystemItem item) {
        if (element == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(0);
        }
        super(element);
        this.myItem = item;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange range = DjangoTemplateItemReference.getRangeInElementInner(this.myElement, this.myItem);
        if (range == null) {
            throw new IllegalStateException("text range cant be null");
        }
        TextRange textRange = range;
        if (textRange == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public static boolean isPossibleToCreate(PsiElement element, @Nullable PsiFileSystemItem item) {
        return element != null && item != null && DjangoTemplateItemReference.getRangeInElementInner(element, item) != null;
    }

    @Nullable
    private static TextRange getRangeInElementInner(@NotNull PsiElement element, PsiFileSystemItem item) {
        if (element == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(2);
        }
        if (element instanceof PyStringLiteralExpression) {
            return DjangoTemplateItemReference.lastSuffixTextRange(item, element, ((PyStringLiteralExpression)element).getStringValue());
        }
        if (element instanceof Jinja2MemberNameImpl) {
            String text = element.getText();
            return TextRange.from((int)0, (int)text.length());
        }
        if (PyTokenTypes.STRING_NODES.contains(element.getNode().getElementType())) {
            return DjangoTemplateItemReference.lastSuffixTextRange(item, element, element.getText());
        }
        throw new IllegalStateException("Unexpected type for fs reference: " + String.valueOf(element.getClass()));
    }

    @Nullable
    private static TextRange lastSuffixTextRange(@NotNull PsiFileSystemItem item, @NotNull PsiElement element, String stringValue) {
        String s;
        if (item == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(4);
        }
        String fullName = DjangoTemplateItemReference.getRelativeItemPath(item, element);
        if (stringValue.isEmpty()) {
            return element.getTextRange();
        }
        if (item instanceof PyFile) {
            fullName = FileUtilRt.getNameWithoutExtension((String)fullName);
        }
        if ((s = PythonStringUtil.intersect((String)fullName, (String)stringValue)) == null) {
            return null;
        }
        return PythonStringUtil.lastSuffixTextRange((String)s, (String)".");
    }

    @Nullable
    public PsiElement resolve() {
        return this.myItem;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(5);
        }
        String oldName = this.getRelativeItemPath();
        if (this.resolve() instanceof PyFile) {
            oldName = PythonStringUtil.removeLastSuffix((String)oldName, (String)".");
            newElementName = PythonStringUtil.removeLastSuffix((String)newElementName, (String)".");
        }
        String newName = PythonStringUtil.replaceLastSuffix((String)oldName, (String)".", (String)newElementName);
        if (!this.myElement.getText().equals(oldName)) {
            oldName = PythonStringUtil.removeFirstPrefix((String)oldName, (String)".");
            newName = PythonStringUtil.removeFirstPrefix((String)newName, (String)".");
        }
        String fullName = this.myElement.getText().replace(oldName, newName);
        PsiElement psiElement = this.myElement.replace(this.createElement(fullName));
        if (psiElement == null) {
            DjangoTemplateItemReference.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    private PsiElement createElement(String fullName) {
        return DjangoTemplateElementGenerator.createMember((String)fullName, (Project)this.myElement.getProject());
    }

    private String getRelativeItemPath() {
        return DjangoTemplateItemReference.getRelativeItemPath(this.myItem, this.myElement);
    }

    private static String getRelativeItemPath(PsiFileSystemItem item, PsiElement element) {
        PsiDirectory djangoRoot = DjangoUtil.getProjectRoot((PsiElement)element);
        if (djangoRoot != null) {
            String filePath;
            djangoRoot = djangoRoot.getParent();
            VirtualFile vFile = item.getVirtualFile();
            if (vFile != null && djangoRoot != null && !(filePath = vFile.getPath().replaceFirst(djangoRoot.getVirtualFile().getPath(), "")).isEmpty()) {
                return filePath.substring(1).replace("/", ".");
            }
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/lang/template/DjangoTemplateItemReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/lang/template/DjangoTemplateItemReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElementInner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lastSuffixTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }
}

