/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001aS\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0007*\u0002H\u0006\"\b\b\u0002\u0010\b*\u0002H\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"switchMode", "Lkotlinx/serialization/json/internal/WriteMode;", "Lkotlinx/serialization/json/Json;", "desc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "selectMapMode", "T", "R1", "R2", "mapDescriptor", "ifMap", "Lkotlin/Function0;", "ifList", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "carrierDescriptor", "module", "Lkotlinx/serialization/modules/SerializersModule;", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nWriteMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteMode.kt\nkotlinx/serialization/json/internal/WriteModeKt\n*L\n1#1,53:1\n36#1,9:54\n*S KotlinDebug\n*F\n+ 1 WriteMode.kt\nkotlinx/serialization/json/internal/WriteModeKt\n*L\n26#1:54,9\n*E\n"})
public final class WriteModeKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final WriteMode switchMode(@NotNull Json $this$switchMode, @NotNull SerialDescriptor desc) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter((Object)$this$switchMode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        SerialKind serialKind = desc.getKind();
        if (serialKind instanceof PolymorphicKind) {
            writeMode = WriteMode.POLY_OBJ;
            return writeMode;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            writeMode = WriteMode.LIST;
            return writeMode;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            Json $this$selectMapMode$iv = $this$switchMode;
            boolean $i$f$selectMapMode = false;
            SerialDescriptor keyDescriptor$iv = WriteModeKt.carrierDescriptor(desc.getElementDescriptor(0), $this$selectMapMode$iv.getSerializersModule());
            SerialKind keyKind$iv = keyDescriptor$iv.getKind();
            if (keyKind$iv instanceof PrimitiveKind || Intrinsics.areEqual((Object)keyKind$iv, (Object)SerialKind.ENUM.INSTANCE)) {
                boolean bl = false;
                writeMode = WriteMode.MAP;
                return writeMode;
            } else {
                if (!$this$selectMapMode$iv.getConfiguration().getAllowStructuredMapKeys()) throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor$iv);
                boolean bl = false;
                writeMode = WriteMode.LIST;
            }
            return writeMode;
        } else {
            writeMode = WriteMode.OBJ;
        }
        return writeMode;
    }

    public static final <T, R1 extends T, R2 extends T> T selectMapMode(@NotNull Json $this$selectMapMode, @NotNull SerialDescriptor mapDescriptor, @NotNull Function0<? extends R1> ifMap, @NotNull Function0<? extends R2> ifList) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$selectMapMode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mapDescriptor, (String)"mapDescriptor");
        Intrinsics.checkNotNullParameter(ifMap, (String)"ifMap");
        Intrinsics.checkNotNullParameter(ifList, (String)"ifList");
        boolean $i$f$selectMapMode = false;
        SerialDescriptor keyDescriptor = WriteModeKt.carrierDescriptor(mapDescriptor.getElementDescriptor(0), $this$selectMapMode.getSerializersModule());
        SerialKind keyKind = keyDescriptor.getKind();
        if (keyKind instanceof PrimitiveKind || Intrinsics.areEqual((Object)keyKind, (Object)SerialKind.ENUM.INSTANCE)) {
            object = ifMap.invoke();
        } else if ($this$selectMapMode.getConfiguration().getAllowStructuredMapKeys()) {
            object = ifList.invoke();
        } else {
            throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor);
        }
        return (T)object;
    }

    @NotNull
    public static final SerialDescriptor carrierDescriptor(@NotNull SerialDescriptor $this$carrierDescriptor, @NotNull SerializersModule module) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$carrierDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (Intrinsics.areEqual((Object)$this$carrierDescriptor.getKind(), (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
            serialDescriptor = ContextAwareKt.getContextualDescriptor((SerializersModule)module, (SerialDescriptor)$this$carrierDescriptor);
            if (serialDescriptor == null || (serialDescriptor = WriteModeKt.carrierDescriptor(serialDescriptor, module)) == null) {
                serialDescriptor = $this$carrierDescriptor;
            }
        } else {
            serialDescriptor = $this$carrierDescriptor.isInline() ? WriteModeKt.carrierDescriptor($this$carrierDescriptor.getElementDescriptor(0), module) : $this$carrierDescriptor;
        }
        return serialDescriptor;
    }
}

