/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.operations;

import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.executor.DataWranglerTransformationStepsManager;
import com.intellij.dataWrangler.impl.fus.DataWranglerProviderCollector;
import com.intellij.dataWrangler.operations.DataWranglerCommand;
import com.intellij.dataWrangler.operations.TransformationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016J\u001a\u0010\u0013\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0018\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\t0\b0\u000fH\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\bH\u0016J\"\u0010\u001c\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R$\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/dataWrangler/impl/operations/DataWranglerTransformationStepsManagerImpl;", "C", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "Lcom/intellij/dataWrangler/executor/DataWranglerTransformationStepsManager;", "<init>", "()V", "transformationsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "Lcom/intellij/dataWrangler/operations/TransformationStep;", "errorsFlow", "", "history", "", "getErrorsFlow", "Lkotlinx/coroutines/flow/Flow;", "removeTransformation", "", "step", "addTransformation", "getTransformationsList", "resetTransformationsTo", "findIndexByStep", "", "(Lcom/intellij/dataWrangler/operations/TransformationStep;)Ljava/lang/Integer;", "getEventFlow", "getExecutedCommands", "Lcom/intellij/dataWrangler/operations/DataWranglerCommand;", "reportState", "state", "Lcom/intellij/dataWrangler/executor/DataWranglerTransformationStepsManager$StepState;", "Companion", "intellij.dataWrangler.impl"})
@SourceDebugExtension(value={"SMAP\nDataWranglerTransformationStepsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataWranglerTransformationStepsManagerImpl.kt\ncom/intellij/dataWrangler/impl/operations/DataWranglerTransformationStepsManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1#2:63\n1563#3:64\n1634#3,3:65\n*S KotlinDebug\n*F\n+ 1 DataWranglerTransformationStepsManagerImpl.kt\ncom/intellij/dataWrangler/impl/operations/DataWranglerTransformationStepsManagerImpl\n*L\n47#1:64\n47#1:65,3\n*E\n"})
public final class DataWranglerTransformationStepsManagerImpl<C extends DataWranglerContext>
implements DataWranglerTransformationStepsManager<C> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedFlow<List<TransformationStep<?, C>>> transformationsFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
    @NotNull
    private final MutableSharedFlow<Throwable> errorsFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
    @NotNull
    private final List<TransformationStep<?, C>> history;

    public DataWranglerTransformationStepsManagerImpl() {
        List list = Collections.synchronizedList(new LinkedList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.history = list;
    }

    @NotNull
    public Flow<Throwable> getErrorsFlow() {
        return (Flow)this.errorsFlow;
    }

    public void removeTransformation(@NotNull TransformationStep<?, ?> step) {
        Intrinsics.checkNotNullParameter(step, (String)"step");
        TypeIntrinsics.asMutableCollection((Object)this.history).remove(step);
        this.transformationsFlow.tryEmit(this.history);
    }

    public void addTransformation(@NotNull TransformationStep<?, C> step) {
        Intrinsics.checkNotNullParameter(step, (String)"step");
        DataWranglerProviderCollector.INSTANCE.logDWOperationExecuted(step.createCommand());
        this.history.add(step);
        this.transformationsFlow.tryEmit(this.history);
    }

    @NotNull
    public List<TransformationStep<?, C>> getTransformationsList() {
        return CollectionsKt.toList((Iterable)this.history);
    }

    public void resetTransformationsTo(@NotNull TransformationStep<?, ?> step) {
        Intrinsics.checkNotNullParameter(step, (String)"step");
        Integer n = this.findIndexByStep(step);
        if (n == null) {
            return;
        }
        int index = n;
        this.history.subList(index + 1, this.history.size()).clear();
        this.transformationsFlow.tryEmit(this.history);
    }

    @Nullable
    public Integer findIndexByStep(@NotNull TransformationStep<?, ?> step) {
        Intrinsics.checkNotNullParameter(step, (String)"step");
        Integer n = CollectionsKt.indexOf(this.history, step);
        int it = ((Number)n).intValue();
        boolean bl = false;
        return it != -1 ? n : null;
    }

    @NotNull
    public Flow<List<TransformationStep<?, ? extends DataWranglerContext>>> getEventFlow() {
        return (Flow)this.transformationsFlow;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DataWranglerCommand<C>> getExecutedCommands() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getTransformationsList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TransformationStep transformationStep = (TransformationStep)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createCommand());
        }
        return (List)destination$iv$iv;
    }

    public void reportState(@NotNull TransformationStep<?, C> step, @NotNull DataWranglerTransformationStepsManager.StepState state) {
        block0: {
            Intrinsics.checkNotNullParameter(step, (String)"step");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (!(state instanceof DataWranglerTransformationStepsManager.StepState.Failed)) break block0;
            this.errorsFlow.tryEmit((Object)((DataWranglerTransformationStepsManager.StepState.Failed)state).getTh());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/dataWrangler/impl/operations/DataWranglerTransformationStepsManagerImpl$Companion;", "", "<init>", "()V", "createDefault", "Lcom/intellij/dataWrangler/impl/operations/DataWranglerTransformationStepsManagerImpl;", "C", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "context", "(Lcom/intellij/dataWrangler/executor/DataWranglerContext;)Lcom/intellij/dataWrangler/impl/operations/DataWranglerTransformationStepsManagerImpl;", "intellij.dataWrangler.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <C extends DataWranglerContext> DataWranglerTransformationStepsManagerImpl<C> createDefault(@NotNull C context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return new DataWranglerTransformationStepsManagerImpl();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

