/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.CodeBlockProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.editor.SqlCodeBlockProviderUtils;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlCodeBlockProvider
implements CodeBlockProvider {
    @Nullable
    public TextRange getCodeBlockRange(Editor editor, PsiFile psiFile) {
        int at = editor.getCaretModel().getOffset();
        PsiElement block = this.findInitialBlock(psiFile, at);
        while (block != null) {
            TextRange range = SqlCodeBlockProvider.getBlockRange(block, at);
            if (range != null) {
                return range;
            }
            block = SqlCodeBlockProvider.findBlock(block.getParent());
        }
        return null;
    }

    @Nullable
    private static TextRange getBlockRange(@NotNull PsiElement block, int at) {
        if (block == null) {
            SqlCodeBlockProvider.$$$reportNull$$$0(0);
        }
        int from = -1;
        int to = -1;
        int last = -1;
        for (PsiElement e : SqlCodeBlockProviderUtils.collectRanges((PsiElement)block)) {
            TextRange rg = e.getTextRange();
            if (last == -1 && at < rg.getStartOffset()) {
                return null;
            }
            if (from == -1 && SqlCodeBlockProviderUtils.STARTERS_C.value((Object)e)) {
                from = rg.getEndOffset();
            } else if (from != -1 && to == -1 && PsiUtilCore.getElementType((PsiElement)e) == SqlCommonKeywords.SQL_END) {
                to = rg.getStartOffset();
            }
            last = rg.getEndOffset();
        }
        return from == -1 || to == -1 || at > last + 1 ? null : TextRange.create((int)from, (int)to);
    }

    @Nullable
    public PsiElement findInitialBlock(PsiFile psiFile, int at) {
        PsiElement block1 = SqlCodeBlockProvider.findBlock(psiFile.findElementAt(at));
        PsiElement block2 = at == 0 ? null : SqlCodeBlockProvider.findBlock(psiFile.findElementAt(at - 1));
        return block1 == null || block2 != null && PsiTreeUtil.isAncestor((PsiElement)block1, (PsiElement)block2, (boolean)true) ? block2 : block1;
    }

    @Nullable
    private static PsiElement findBlock(@Nullable PsiElement element) {
        return element == null ? null : (PsiElement)SqlImplUtil.sqlParents((PsiElement)element).find(e -> SqlCodeBlockProviderUtils.isGoodBlock((PsiElement)e));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/sql/editor/SqlCodeBlockProvider", "getBlockRange"));
    }
}

