/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 107383615582735L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-843173310 + -((char)-6883), -843173310 + -((char)-15004), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-843173310 + -((char)-6882), -843173310 + -((char)-15369), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 26445999018660L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.Z();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1885441950 - -((char)-17110), 1885441950 - (char)-15462, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1885441950 - -((char)-17109), 1885441950 - (char)-18004, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1885441950 - -((char)-17112), 1885441950 - (char)-16368, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 42905376511264L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.Z();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17835, -1346744250 + -((char)-16601), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17838, 1346744250 + (char)-27723, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17837, 1346744250 + 29940, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17848, 1346744250 + (char)-13745, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17847, 1346744250 + (char)-23705, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17850, -1346744250 + -31191, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17848, 1346744250 + (char)-13745, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1346744250 + (char)-17849, -1346744250 + -((char)-17154), (int)l2));
            if (!ActionTimestamp.I()) {
                SshAgentIpcService.Z(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 35853291135077L;
                    nArray = SshAgentIpcService.Z();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    int[] nArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 35244267115562L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            nArray = SshAgentIpcService.Z();
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (nArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(234484230 + 14598, -234484230 + -21646, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14599, 234484230 + 13235, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14600, -234484230 + -25781, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(234484230 + 14598, -234484230 + -21646, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14601, 234484230 + (char)-30007, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (nArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n = Kernel32.INSTANCE.GetLastError();
                            if (n == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(234484230 + 14598, -234484230 + -21646, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14602, 234484230 + 6425, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14603, 234484230 + 32593, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14600, -234484230 + -25781, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(234484230 + 14598, -234484230 + -21646, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(234484230 + 14594, 234484230 + 18685, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(234484230 + 14604, 234484230 + 23398, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 104834011665062L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1845072390 - 29413, 1845072390 - 22007, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 52141283956759L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-381020490 - -((char)-16677), 381020490 - (char)-30524, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u00fe\u00b7{\u00b3\fJ\u0019M\u00c7Wv\u00e1\u00bf\u00d6\u009cX\u00e0\u000bJ\u0014!\u0004\u0080\u00c3h\u0086\u00e8Q{\u00d2$\u00857\u00a3L}\u0017i\u00b3\u00c3";
                                        var4_3 = "\u00fe\u00b7{\u00b3\fJ\u0019M\u00c7Wv\u00e1\u00bf\u00d6\u009cX\u00e0\u000bJ\u0014!\u0004\u0080\u00c3h\u0086\u00e8Q{\u00d2$\u00857\u00a3L}\u0017i\u00b3\u00c3".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 118;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 92;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 27;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 67;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 30;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 68;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 87;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 126;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n, int n2, int n3) {
                                    int n4 = (n ^ n3 ^ 0xFFFF8D87) & 0xFFFF;
                                    if (b[n4] == null) {
                                        int n5;
                                        char[] cArray = a[n4].toCharArray();
                                        int n6 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 28;
                                            case 1 -> 137;
                                            case 2 -> 70;
                                            case 3 -> 136;
                                            case 4 -> 150;
                                            case 5 -> 173;
                                            case 6 -> 110;
                                            case 7 -> 22;
                                            case 8 -> 6;
                                            case 9 -> 205;
                                            case 10 -> 219;
                                            case 11 -> 44;
                                            case 12 -> 74;
                                            case 13 -> 25;
                                            case 14 -> 48;
                                            case 15 -> 79;
                                            case 16 -> 243;
                                            case 17 -> 166;
                                            case 18 -> 41;
                                            case 19 -> 145;
                                            case 20 -> 203;
                                            case 21 -> 52;
                                            case 22 -> 3;
                                            case 23 -> 210;
                                            case 24 -> 171;
                                            case 25 -> 78;
                                            case 26 -> 108;
                                            case 27 -> 84;
                                            case 28 -> 8;
                                            case 29 -> 124;
                                            case 30 -> 88;
                                            case 31 -> 212;
                                            case 32 -> 37;
                                            case 33 -> 29;
                                            case 34 -> 130;
                                            case 35 -> 218;
                                            case 36 -> 54;
                                            case 37 -> 80;
                                            case 38 -> 146;
                                            case 39 -> 115;
                                            case 40 -> 100;
                                            case 41 -> 251;
                                            case 42 -> 53;
                                            case 43 -> 138;
                                            case 44 -> 75;
                                            case 45 -> 158;
                                            case 46 -> 81;
                                            case 47 -> 140;
                                            case 48 -> 187;
                                            case 49 -> 23;
                                            case 50 -> 181;
                                            case 51 -> 83;
                                            case 52 -> 126;
                                            case 53 -> 51;
                                            case 54 -> 156;
                                            case 55 -> 98;
                                            case 56 -> 87;
                                            case 57 -> 7;
                                            case 58 -> 76;
                                            case 59 -> 58;
                                            case 60 -> 154;
                                            case 61 -> 185;
                                            case 62 -> 209;
                                            case 63 -> 97;
                                            case 64 -> 222;
                                            case 65 -> 42;
                                            case 66 -> 235;
                                            case 67 -> 18;
                                            case 68 -> 62;
                                            case 69 -> 190;
                                            case 70 -> 2;
                                            case 71 -> 254;
                                            case 72 -> 86;
                                            case 73 -> 90;
                                            case 74 -> 186;
                                            case 75 -> 57;
                                            case 76 -> 104;
                                            case 77 -> 184;
                                            case 78 -> 176;
                                            case 79 -> 204;
                                            case 80 -> 206;
                                            case 81 -> 15;
                                            case 82 -> 55;
                                            case 83 -> 123;
                                            case 84 -> 183;
                                            case 85 -> 125;
                                            case 86 -> 129;
                                            case 87 -> 112;
                                            case 88 -> 69;
                                            case 89 -> 35;
                                            case 90 -> 172;
                                            case 91 -> 45;
                                            case 92 -> 68;
                                            case 93 -> 116;
                                            case 94 -> 95;
                                            case 95 -> 207;
                                            case 96 -> 33;
                                            case 97 -> 236;
                                            case 98 -> 244;
                                            case 99 -> 193;
                                            case 100 -> 105;
                                            case 101 -> 134;
                                            case 102 -> 180;
                                            case 103 -> 233;
                                            case 104 -> 200;
                                            case 105 -> 163;
                                            case 106 -> 30;
                                            case 107 -> 238;
                                            case 108 -> 21;
                                            case 109 -> 13;
                                            case 110 -> 142;
                                            case 111 -> 216;
                                            case 112 -> 60;
                                            case 113 -> 101;
                                            case 114 -> 131;
                                            case 115 -> 127;
                                            case 116 -> 220;
                                            case 117 -> 132;
                                            case 118 -> 89;
                                            case 119 -> 121;
                                            case 120 -> 151;
                                            case 121 -> 85;
                                            case 122 -> 4;
                                            case 123 -> 211;
                                            case 124 -> 109;
                                            case 125 -> 43;
                                            case 126 -> 111;
                                            case 127 -> 231;
                                            case 128 -> 160;
                                            case 129 -> 14;
                                            case 130 -> 120;
                                            case 131 -> 113;
                                            case 132 -> 31;
                                            case 133 -> 174;
                                            case 134 -> 72;
                                            case 135 -> 117;
                                            case 136 -> 177;
                                            case 137 -> 215;
                                            case 138 -> 241;
                                            case 139 -> 16;
                                            case 140 -> 141;
                                            case 141 -> 77;
                                            case 142 -> 195;
                                            case 143 -> 202;
                                            case 144 -> 249;
                                            case 145 -> 208;
                                            case 146 -> 232;
                                            case 147 -> 144;
                                            case 148 -> 27;
                                            case 149 -> 245;
                                            case 150 -> 242;
                                            case 151 -> 157;
                                            case 152 -> 225;
                                            case 153 -> 228;
                                            case 154 -> 49;
                                            case 155 -> 135;
                                            case 156 -> 170;
                                            case 157 -> 106;
                                            case 158 -> 159;
                                            case 159 -> 155;
                                            case 160 -> 139;
                                            case 161 -> 46;
                                            case 162 -> 63;
                                            case 163 -> 39;
                                            case 164 -> 114;
                                            case 165 -> 197;
                                            case 166 -> 169;
                                            case 167 -> 36;
                                            case 168 -> 189;
                                            case 169 -> 252;
                                            case 170 -> 165;
                                            case 171 -> 24;
                                            case 172 -> 73;
                                            case 173 -> 40;
                                            case 174 -> 153;
                                            case 175 -> 107;
                                            case 176 -> 167;
                                            case 177 -> 66;
                                            case 178 -> 188;
                                            case 179 -> 247;
                                            case 180 -> 93;
                                            case 181 -> 147;
                                            case 182 -> 196;
                                            case 183 -> 38;
                                            case 184 -> 11;
                                            case 185 -> 122;
                                            case 186 -> 227;
                                            case 187 -> 103;
                                            case 188 -> 250;
                                            case 189 -> 253;
                                            case 190 -> 143;
                                            case 191 -> 26;
                                            case 192 -> 32;
                                            case 193 -> 179;
                                            case 194 -> 168;
                                            case 195 -> 178;
                                            case 196 -> 194;
                                            case 197 -> 50;
                                            case 198 -> 255;
                                            case 199 -> 162;
                                            case 200 -> 59;
                                            case 201 -> 133;
                                            case 202 -> 99;
                                            case 203 -> 175;
                                            case 204 -> 71;
                                            case 205 -> 92;
                                            case 206 -> 230;
                                            case 207 -> 67;
                                            case 208 -> 221;
                                            case 209 -> 10;
                                            case 210 -> 91;
                                            case 211 -> 229;
                                            case 212 -> 239;
                                            case 213 -> 237;
                                            case 214 -> 149;
                                            case 215 -> 191;
                                            case 216 -> 213;
                                            case 217 -> 56;
                                            case 218 -> 94;
                                            case 219 -> 161;
                                            case 220 -> 214;
                                            case 221 -> 1;
                                            case 222 -> 9;
                                            case 223 -> 192;
                                            case 224 -> 102;
                                            case 225 -> 19;
                                            case 226 -> 128;
                                            case 227 -> 198;
                                            case 228 -> 199;
                                            case 229 -> 61;
                                            case 230 -> 152;
                                            case 231 -> 65;
                                            case 232 -> 246;
                                            case 233 -> 226;
                                            case 234 -> 118;
                                            case 235 -> 82;
                                            case 236 -> 5;
                                            case 237 -> 64;
                                            case 238 -> 119;
                                            case 239 -> 217;
                                            case 240 -> 240;
                                            case 241 -> 223;
                                            case 242 -> 96;
                                            case 243 -> 248;
                                            case 244 -> 20;
                                            case 245 -> 12;
                                            case 246 -> 34;
                                            case 247 -> 201;
                                            case 248 -> 47;
                                            case 249 -> 148;
                                            case 250 -> 182;
                                            case 251 -> 164;
                                            case 252 -> 0;
                                            case 253 -> 224;
                                            case 254 -> 17;
                                            default -> 234;
                                        };
                                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                                        if (n7 < 0) {
                                            n7 += 256;
                                        }
                                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                                            n5 += 256;
                                        }
                                        int n8 = 0;
                                        while (n8 < cArray.length) {
                                            int n9 = n8 % 2;
                                            int n10 = n8;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n10];
                                            if (n9 == 0) {
                                                cArray2[n10] = (char)(c2 ^ n7);
                                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                                            } else {
                                                cArray2[n10] = (char)(c2 ^ n5);
                                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                                            }
                                            ++n8;
                                        }
                                        accept.3.b[n4] = new String(cArray).intern();
                                    }
                                    return b[n4];
                                }
                            };
                            if (nArray != null) break block32;
                            if (!ActionTimestamp.I()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.Z(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 19340815796989L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.Z();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-578018700 + -((char)-4967), 578018700 + (char)-13777, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-578018700 + -((char)-4971), -578018700 + -((char)-864), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-578018700 + -((char)-4944), 578018700 + (char)-21239, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-578018700 + -((char)-4967), 578018700 + (char)-13777, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-578018700 + -((char)-4971), -578018700 + -((char)-864), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-578018700 + -((char)-4943), 578149770 - (char)-4890, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 77629527133500L;
                        int[] nArray2 = SshAgentIpcService.Z();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(2006681700 + (char)-22113, -2006681700 + -((char)-29420), (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(2006681700 + (char)-22116, -2006681700 + -((char)-27596), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 139565425996819L;
                int[] nArray2 = SshAgentIpcService.Z();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    nArray = nArray2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-463725660 + -4207, 463725660 - 19207, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-463725660 + -4211, -463725660 + -106, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-463725660 + -4214, -463725660 + -2898, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-463725660 + -4211, -463725660 + -106, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-463725660 + -4205, 463725660 - 23264, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-463725660 + -4207, 463725660 - 19207, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-463725660 + -4211, -463725660 + -106, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-463725660 + -4227, -463725660 - -2729, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-463725660 + -4207, 463725660 - 19207, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-463725660 + -4211, -463725660 + -106, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-463725660 + -4228, 463725660 - 4356, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-463725660 + -4207, 463725660 - 19207, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-463725660 + -4211, -463725660 + -106, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-463725660 + -4225, 463725660 + 4273, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 91393173846111L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.Z();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23089), 564780630 - (char)-30403, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23085), -564780630 - -((char)-18996), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23100), -564780630 - -29447, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23105), 564780630 - (char)-25974, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23089), 564780630 - (char)-30403, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23085), -564780630 - -((char)-18996), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23106), 564780630 - (char)-12475, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23089), 564780630 - (char)-30403, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23085), -564780630 - -((char)-18996), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23103), 564780630 - (char)-29325, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23089), 564780630 - (char)-30403, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23085), -564780630 - -((char)-18996), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23104), 564780630 - (char)-21430, (int)l2));
                    if (nArray == null) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23089), 564780630 - (char)-30403, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23085), -564780630 - -((char)-18996), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23125), -564780630 - -27028, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-564780630 - -((char)-23126), 564780630 - 25399, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "I\u00dbG\u00ab\u00b5\u00b6\u00db\u00ef\u0014\u00d6\u00cf\u008c\u00ce2\u0092\u0084qO\u00bb\u0017)B\u00ef\u00ce\u001dL\u0082\u00c6\u00bb\u0006o\u00f2\u0083\u008eGS\u0018\u0083\u0083Fw\u00e9`\u00fd\u00ef\u00a8\u0015\u00e4\u008cZ\u00a4\u009f\u00f6\u00cf\u0096\u0098\u00a4\u00ed\u00e2x\u00c8\t\u00a9\u00b0\u009d\u00a0\u00f9\u0005\u00e7\u000b\u00d7\u0005\u00df\u008d\u0095a\u009f\bK\u00d0\u0007\u00bb\u00ef\u0092\u0096\u0089\u0014RFddB\u00cf\u00bfMF\u00e1\u009d\u00d6Y\u00b3\u0016{E\u009d\u001e\u001a\u0005\u00eb>\u0013\u0017O\u001e\u00e8/fQ|`\u00ed\u0095\u000fN[`\u00e1\u0019J%\u0094}!-v\u00fc\u0007\u00c6I#\u00ddt\u00e9j\u0010?\u00cfx\u0088\u00e8i\u0089M\u00fe\u00e7\u00e8\u00a8\u0091U\u00eb3\t|B\u00f1\u00ef'\u00cb\u001aM\u0086\u00101\f\u00b9\u00f0\u00d0f\u008e\u00ac\u001e\u00db\u00f4/\u0012\u00a5\u009b-?\u0014*\u00f1\u00f1\u0083}\u0097Z1f\u00d9\u009e\u000e0\u008a9I\u009b\u00e74 \u008d\u00b6\u008eo\u00c2\u0014\u00fc\u00e7-\u001b\u0002\u00b2t]\u00f2b\u00d5\u00ce\u00ea=\u00b5q\u00a8/\u00c7ZD\u00aa\u000fI\u00af\u00b2\u00f9\u0080,\u00d6F\u00eaE\u00a0\u00eb\u0090\b\u0091\u00ff\\^\u0084.\u00fb\u001e\f\tR_\u00f0\u00f9\u0099\u00ba\u00ef\u00b1\u00fbS/Fg\u00d1\u0092\u0080@\u0097\u008d.W\u00cf\u0085m\u0013F6\u00d1\"\u00e1\u008a\u00d4\u009f\u00c3Bu\u00c7\u0096\u00f2}\u00844M\u001dD!Ay;\u00e9N\u00a9\u00be\u00c8\u008a\u00fc\u008e\u00c8:\u00d8AdRh>\u0097\u0007\u00fa\u00b9\u00e8\u0091,\u00fc\u00afG\u0003\u009b\u00a4\u001bf\"\u00ae\u001f\u00aa\u008e.eu\u00e6\u00ccE+T\u00df#qlS:\u00ccvW\u0086s\tp\u00d3\u00c6Q;\u00f6(\u00cb\u00da\u000b\u00baS)\u00d07\u009dco\u008a\u00e7>\u0015|\u0088\u00f1\u00a8+\u00fa\f\u00feY5\u008c\u00c4\u00a5<\u00d4f\u00c7i\u00eb\u001c\u00d2)\u00f1\u008cE%\u0018\u00eeaD\u009eti'\u00a3\u00e6\u0097n\u000btta\u00e7\u008d$[#\tP\u0085jQ\u0010\u008f\u0011\u00d6\u008d\n\u00bc\u009a5nr\u0007&/\u00b5K\"~\u00bd\u0007\u00b4\u00d4\u0083X\u0003\u00f3\u008f(\u00fd\u0011\u0088\u00b7\u0011\u00d6\u00b6d\u0014\u00a7\u0012k\u00ef\u00ee\\\u00ecu\u0089\u0015\u009d\u00aa,\u00e2\u00a4kJ\u00ef\u0096\u00aaS\u00d3\u00d6\u0092\u0096c\u00af\u00dbSJ\u00a4\u000fx\u00f0v\u00a2&\u0018\u00f5~\ti\u0010\u00e3\u000f\u00ab\u00de\"\u00be\u00c6\u00acl%\u00c7\u00c6aj\u00d0\u00f7\u00b3sx\u00e9s/\u00fezr\u00cc\u00ef\u00e1G\b\u00de\u00f8\u00a1[\u00e7\u0094^\u00af\u001f\u000e\u0086\u00b7\u00a9J\u00dd\u0005\u008a\u00dd\u00e6\u001d\u00edm\u00bcp\u001b\u0089\u00d7OC\u00fa\u0091\u00fb\u0013\u009fCO\u00a7\u00b8\u001f\u00b6\u0089l\u000b\u00afPM\u009f\u00a2\u00ef+\u00a6\u00c9\n\u00aa8\u00ef\u00b9\u00fa*(NN\u008a\u0018\r(\u00df\u00b1\u00e9s\u00b8\u0011\u00e9\u00caC\t\u0080\u0099Mxd4y\u00ce\u00ef\u0007\u00ad\u00af)\u00f3C\u0005\u00dc\u0010\u00d1`\u00a3\u00be\u0088m\u00b8'\u001c\u0098J\u0094\u0085X\u009aX\u00e2\u009a\u00ba\u0081\u00a7\u0099\u00bc\u0000*\u00e6q\u00ea\u00d7'\u00be7(D8\\\t\u0017T\u009c3\u0080\u009f\u00b8\u009co";
                var4_3 = "I\u00dbG\u00ab\u00b5\u00b6\u00db\u00ef\u0014\u00d6\u00cf\u008c\u00ce2\u0092\u0084qO\u00bb\u0017)B\u00ef\u00ce\u001dL\u0082\u00c6\u00bb\u0006o\u00f2\u0083\u008eGS\u0018\u0083\u0083Fw\u00e9`\u00fd\u00ef\u00a8\u0015\u00e4\u008cZ\u00a4\u009f\u00f6\u00cf\u0096\u0098\u00a4\u00ed\u00e2x\u00c8\t\u00a9\u00b0\u009d\u00a0\u00f9\u0005\u00e7\u000b\u00d7\u0005\u00df\u008d\u0095a\u009f\bK\u00d0\u0007\u00bb\u00ef\u0092\u0096\u0089\u0014RFddB\u00cf\u00bfMF\u00e1\u009d\u00d6Y\u00b3\u0016{E\u009d\u001e\u001a\u0005\u00eb>\u0013\u0017O\u001e\u00e8/fQ|`\u00ed\u0095\u000fN[`\u00e1\u0019J%\u0094}!-v\u00fc\u0007\u00c6I#\u00ddt\u00e9j\u0010?\u00cfx\u0088\u00e8i\u0089M\u00fe\u00e7\u00e8\u00a8\u0091U\u00eb3\t|B\u00f1\u00ef'\u00cb\u001aM\u0086\u00101\f\u00b9\u00f0\u00d0f\u008e\u00ac\u001e\u00db\u00f4/\u0012\u00a5\u009b-?\u0014*\u00f1\u00f1\u0083}\u0097Z1f\u00d9\u009e\u000e0\u008a9I\u009b\u00e74 \u008d\u00b6\u008eo\u00c2\u0014\u00fc\u00e7-\u001b\u0002\u00b2t]\u00f2b\u00d5\u00ce\u00ea=\u00b5q\u00a8/\u00c7ZD\u00aa\u000fI\u00af\u00b2\u00f9\u0080,\u00d6F\u00eaE\u00a0\u00eb\u0090\b\u0091\u00ff\\^\u0084.\u00fb\u001e\f\tR_\u00f0\u00f9\u0099\u00ba\u00ef\u00b1\u00fbS/Fg\u00d1\u0092\u0080@\u0097\u008d.W\u00cf\u0085m\u0013F6\u00d1\"\u00e1\u008a\u00d4\u009f\u00c3Bu\u00c7\u0096\u00f2}\u00844M\u001dD!Ay;\u00e9N\u00a9\u00be\u00c8\u008a\u00fc\u008e\u00c8:\u00d8AdRh>\u0097\u0007\u00fa\u00b9\u00e8\u0091,\u00fc\u00afG\u0003\u009b\u00a4\u001bf\"\u00ae\u001f\u00aa\u008e.eu\u00e6\u00ccE+T\u00df#qlS:\u00ccvW\u0086s\tp\u00d3\u00c6Q;\u00f6(\u00cb\u00da\u000b\u00baS)\u00d07\u009dco\u008a\u00e7>\u0015|\u0088\u00f1\u00a8+\u00fa\f\u00feY5\u008c\u00c4\u00a5<\u00d4f\u00c7i\u00eb\u001c\u00d2)\u00f1\u008cE%\u0018\u00eeaD\u009eti'\u00a3\u00e6\u0097n\u000btta\u00e7\u008d$[#\tP\u0085jQ\u0010\u008f\u0011\u00d6\u008d\n\u00bc\u009a5nr\u0007&/\u00b5K\"~\u00bd\u0007\u00b4\u00d4\u0083X\u0003\u00f3\u008f(\u00fd\u0011\u0088\u00b7\u0011\u00d6\u00b6d\u0014\u00a7\u0012k\u00ef\u00ee\\\u00ecu\u0089\u0015\u009d\u00aa,\u00e2\u00a4kJ\u00ef\u0096\u00aaS\u00d3\u00d6\u0092\u0096c\u00af\u00dbSJ\u00a4\u000fx\u00f0v\u00a2&\u0018\u00f5~\ti\u0010\u00e3\u000f\u00ab\u00de\"\u00be\u00c6\u00acl%\u00c7\u00c6aj\u00d0\u00f7\u00b3sx\u00e9s/\u00fezr\u00cc\u00ef\u00e1G\b\u00de\u00f8\u00a1[\u00e7\u0094^\u00af\u001f\u000e\u0086\u00b7\u00a9J\u00dd\u0005\u008a\u00dd\u00e6\u001d\u00edm\u00bcp\u001b\u0089\u00d7OC\u00fa\u0091\u00fb\u0013\u009fCO\u00a7\u00b8\u001f\u00b6\u0089l\u000b\u00afPM\u009f\u00a2\u00ef+\u00a6\u00c9\n\u00aa8\u00ef\u00b9\u00fa*(NN\u008a\u0018\r(\u00df\u00b1\u00e9s\u00b8\u0011\u00e9\u00caC\t\u0080\u0099Mxd4y\u00ce\u00ef\u0007\u00ad\u00af)\u00f3C\u0005\u00dc\u0010\u00d1`\u00a3\u00be\u0088m\u00b8'\u001c\u0098J\u0094\u0085X\u009aX\u00e2\u009a\u00ba\u0081\u00a7\u0099\u00bc\u0000*\u00e6q\u00ea\u00d7'\u00be7(D8\\\t\u0017T\u009c3\u0080\u009f\u00b8\u009co".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 43;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f93r\u00e4\u00c8\u00e0M\u00b3-\u00bc)\b\u0099<yx\u009e\u00f9\u007f\u00a7\u00dfL\u00af\u0087\u00ba*Y~\u00be\u0014\u00ad\u00b1\u00d57/\u009b\u0011f\u00cbo\u00b1\u0085\u00a0L\u00a4_7\u00fc\u009fB";
                    var4_3 = "\u00f93r\u00e4\u00c8\u00e0M\u00b3-\u00bc)\b\u0099<yx\u009e\u00f9\u007f\u00a7\u00dfL\u00af\u0087\u00ba*Y~\u00be\u0014\u00ad\u00b1\u00d57/\u009b\u0011f\u00cbo\u00b1\u0085\u00a0L\u00a4_7\u00fc\u009fB".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 27;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 50;
                            break;
                        }
                        case 1: {
                            v15 = 116;
                            break;
                        }
                        case 2: {
                            v15 = 104;
                            break;
                        }
                        case 3: {
                            v15 = 49;
                            break;
                        }
                        case 4: {
                            v15 = 48;
                            break;
                        }
                        case 5: {
                            v15 = 3;
                            break;
                        }
                        default: {
                            v15 = 11;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0xFFFFBF2A) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 151;
                case 1 -> 41;
                case 2 -> 2;
                case 3 -> 155;
                case 4 -> 181;
                case 5 -> 140;
                case 6 -> 251;
                case 7 -> 207;
                case 8 -> 106;
                case 9 -> 122;
                case 10 -> 4;
                case 11 -> 82;
                case 12 -> 102;
                case 13 -> 92;
                case 14 -> 31;
                case 15 -> 194;
                case 16 -> 187;
                case 17 -> 132;
                case 18 -> 37;
                case 19 -> 163;
                case 20 -> 32;
                case 21 -> 44;
                case 22 -> 91;
                case 23 -> 165;
                case 24 -> 196;
                case 25 -> 97;
                case 26 -> 17;
                case 27 -> 153;
                case 28 -> 64;
                case 29 -> 52;
                case 30 -> 175;
                case 31 -> 253;
                case 32 -> 178;
                case 33 -> 157;
                case 34 -> 33;
                case 35 -> 239;
                case 36 -> 208;
                case 37 -> 94;
                case 38 -> 14;
                case 39 -> 162;
                case 40 -> 247;
                case 41 -> 30;
                case 42 -> 131;
                case 43 -> 246;
                case 44 -> 7;
                case 45 -> 55;
                case 46 -> 72;
                case 47 -> 105;
                case 48 -> 112;
                case 49 -> 171;
                case 50 -> 202;
                case 51 -> 215;
                case 52 -> 24;
                case 53 -> 50;
                case 54 -> 221;
                case 55 -> 13;
                case 56 -> 84;
                case 57 -> 170;
                case 58 -> 39;
                case 59 -> 206;
                case 60 -> 218;
                case 61 -> 145;
                case 62 -> 233;
                case 63 -> 101;
                case 64 -> 95;
                case 65 -> 6;
                case 66 -> 222;
                case 67 -> 104;
                case 68 -> 78;
                case 69 -> 111;
                case 70 -> 34;
                case 71 -> 11;
                case 72 -> 172;
                case 73 -> 79;
                case 74 -> 107;
                case 75 -> 134;
                case 76 -> 62;
                case 77 -> 136;
                case 78 -> 128;
                case 79 -> 120;
                case 80 -> 177;
                case 81 -> 1;
                case 82 -> 231;
                case 83 -> 245;
                case 84 -> 138;
                case 85 -> 23;
                case 86 -> 116;
                case 87 -> 224;
                case 88 -> 80;
                case 89 -> 74;
                case 90 -> 38;
                case 91 -> 126;
                case 92 -> 255;
                case 93 -> 99;
                case 94 -> 203;
                case 95 -> 67;
                case 96 -> 237;
                case 97 -> 3;
                case 98 -> 12;
                case 99 -> 27;
                case 100 -> 254;
                case 101 -> 9;
                case 102 -> 220;
                case 103 -> 211;
                case 104 -> 152;
                case 105 -> 158;
                case 106 -> 93;
                case 107 -> 43;
                case 108 -> 73;
                case 109 -> 18;
                case 110 -> 53;
                case 111 -> 199;
                case 112 -> 193;
                case 113 -> 47;
                case 114 -> 249;
                case 115 -> 83;
                case 116 -> 238;
                case 117 -> 129;
                case 118 -> 154;
                case 119 -> 48;
                case 120 -> 87;
                case 121 -> 109;
                case 122 -> 243;
                case 123 -> 210;
                case 124 -> 229;
                case 125 -> 212;
                case 126 -> 241;
                case 127 -> 148;
                case 128 -> 36;
                case 129 -> 10;
                case 130 -> 225;
                case 131 -> 46;
                case 132 -> 115;
                case 133 -> 81;
                case 134 -> 100;
                case 135 -> 110;
                case 136 -> 189;
                case 137 -> 103;
                case 138 -> 29;
                case 139 -> 5;
                case 140 -> 184;
                case 141 -> 228;
                case 142 -> 204;
                case 143 -> 57;
                case 144 -> 68;
                case 145 -> 96;
                case 146 -> 216;
                case 147 -> 169;
                case 148 -> 66;
                case 149 -> 90;
                case 150 -> 130;
                case 151 -> 164;
                case 152 -> 123;
                case 153 -> 182;
                case 154 -> 156;
                case 155 -> 235;
                case 156 -> 252;
                case 157 -> 85;
                case 158 -> 161;
                case 159 -> 121;
                case 160 -> 127;
                case 161 -> 141;
                case 162 -> 133;
                case 163 -> 173;
                case 164 -> 108;
                case 165 -> 42;
                case 166 -> 98;
                case 167 -> 174;
                case 168 -> 58;
                case 169 -> 19;
                case 170 -> 28;
                case 171 -> 179;
                case 172 -> 86;
                case 173 -> 118;
                case 174 -> 198;
                case 175 -> 56;
                case 176 -> 142;
                case 177 -> 160;
                case 178 -> 232;
                case 179 -> 244;
                case 180 -> 188;
                case 181 -> 205;
                case 182 -> 223;
                case 183 -> 234;
                case 184 -> 63;
                case 185 -> 113;
                case 186 -> 227;
                case 187 -> 185;
                case 188 -> 70;
                case 189 -> 149;
                case 190 -> 76;
                case 191 -> 60;
                case 192 -> 20;
                case 193 -> 15;
                case 194 -> 69;
                case 195 -> 217;
                case 196 -> 65;
                case 197 -> 21;
                case 198 -> 137;
                case 199 -> 139;
                case 200 -> 201;
                case 201 -> 168;
                case 202 -> 25;
                case 203 -> 250;
                case 204 -> 150;
                case 205 -> 51;
                case 206 -> 166;
                case 207 -> 190;
                case 208 -> 119;
                case 209 -> 59;
                case 210 -> 219;
                case 211 -> 16;
                case 212 -> 191;
                case 213 -> 88;
                case 214 -> 144;
                case 215 -> 89;
                case 216 -> 26;
                case 217 -> 35;
                case 218 -> 114;
                case 219 -> 242;
                case 220 -> 75;
                case 221 -> 8;
                case 222 -> 117;
                case 223 -> 180;
                case 224 -> 49;
                case 225 -> 192;
                case 226 -> 143;
                case 227 -> 248;
                case 228 -> 125;
                case 229 -> 61;
                case 230 -> 40;
                case 231 -> 226;
                case 232 -> 135;
                case 233 -> 186;
                case 234 -> 236;
                case 235 -> 197;
                case 236 -> 147;
                case 237 -> 71;
                case 238 -> 214;
                case 239 -> 240;
                case 240 -> 183;
                case 241 -> 54;
                case 242 -> 167;
                case 243 -> 209;
                case 244 -> 146;
                case 245 -> 159;
                case 246 -> 195;
                case 247 -> 200;
                case 248 -> 45;
                case 249 -> 0;
                case 250 -> 213;
                case 251 -> 230;
                case 252 -> 176;
                case 253 -> 22;
                case 254 -> 124;
                default -> 77;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 73136326054381L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1622908740 + (char)-28199, -1622908740 + -((char)-14570), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 54861278611408L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.Z();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1661312250 + (char)-30169, -1661312250 + -((char)-7938), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1661312250 + (char)-30168, 1661312250 + (char)-19529, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1661312250 + (char)-30167, 1661312250 + (char)-30094, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "|9&\u00ea*n\u00ae\u00bd\u0010\u0004@\u00d8dO\u0004\u00fb\u00a9\u00e5\u00bc\u0096p\u00ae\u00c8E\u00d5";
                    var4_3 = "|9&\u00ea*n\u00ae\u00bd\u0010\u0004@\u00d8dO\u0004\u00fb\u00a9\u00e5\u00bc\u0096p\u00ae\u00c8E\u00d5".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 114;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "DR\u00bd\u001b\u00b55\u00f5\u0082\u009cmC\u0080\u00fe\u000e\u00aeo\u00f1V)z,\u0095\u00d8Fmrw\u00159\u0092~\u00c1E\u00ac\u0088\u00de|\u00ba\u008d\u00b3\u00a4\u009eQ)m1\u0095\u00fb&@\u00cb\u00b0\u001bT,.C\u00f57";
                        var4_3 = "DR\u00bd\u001b\u00b55\u00f5\u0082\u009cmC\u0080\u00fe\u000e\u00aeo\u00f1V)z,\u0095\u00d8Fmrw\u00159\u0092~\u00c1E\u00ac\u0088\u00de|\u00ba\u008d\u00b3\u00a4\u009eQ)m1\u0095\u00fb&@\u00cb\u00b0\u001bT,.C\u00f57".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 36;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 100;
                                break;
                            }
                            case 1: {
                                v15 = 117;
                                break;
                            }
                            case 2: {
                                v15 = 23;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 30;
                                break;
                            }
                            case 5: {
                                v15 = 104;
                                break;
                            }
                            default: {
                                v15 = 58;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x20F0) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 133;
                    case 1 -> 112;
                    case 2 -> 247;
                    case 3 -> 169;
                    case 4 -> 237;
                    case 5 -> 221;
                    case 6 -> 3;
                    case 7 -> 198;
                    case 8 -> 62;
                    case 9 -> 119;
                    case 10 -> 173;
                    case 11 -> 164;
                    case 12 -> 15;
                    case 13 -> 213;
                    case 14 -> 77;
                    case 15 -> 65;
                    case 16 -> 25;
                    case 17 -> 63;
                    case 18 -> 99;
                    case 19 -> 246;
                    case 20 -> 184;
                    case 21 -> 190;
                    case 22 -> 43;
                    case 23 -> 19;
                    case 24 -> 180;
                    case 25 -> 34;
                    case 26 -> 97;
                    case 27 -> 83;
                    case 28 -> 148;
                    case 29 -> 228;
                    case 30 -> 111;
                    case 31 -> 146;
                    case 32 -> 187;
                    case 33 -> 114;
                    case 34 -> 124;
                    case 35 -> 1;
                    case 36 -> 239;
                    case 37 -> 38;
                    case 38 -> 194;
                    case 39 -> 233;
                    case 40 -> 101;
                    case 41 -> 139;
                    case 42 -> 207;
                    case 43 -> 68;
                    case 44 -> 76;
                    case 45 -> 2;
                    case 46 -> 117;
                    case 47 -> 113;
                    case 48 -> 61;
                    case 49 -> 0;
                    case 50 -> 209;
                    case 51 -> 13;
                    case 52 -> 59;
                    case 53 -> 70;
                    case 54 -> 104;
                    case 55 -> 140;
                    case 56 -> 186;
                    case 57 -> 145;
                    case 58 -> 252;
                    case 59 -> 157;
                    case 60 -> 74;
                    case 61 -> 141;
                    case 62 -> 26;
                    case 63 -> 93;
                    case 64 -> 42;
                    case 65 -> 223;
                    case 66 -> 23;
                    case 67 -> 137;
                    case 68 -> 200;
                    case 69 -> 204;
                    case 70 -> 28;
                    case 71 -> 102;
                    case 72 -> 84;
                    case 73 -> 88;
                    case 74 -> 191;
                    case 75 -> 103;
                    case 76 -> 122;
                    case 77 -> 158;
                    case 78 -> 136;
                    case 79 -> 176;
                    case 80 -> 64;
                    case 81 -> 92;
                    case 82 -> 232;
                    case 83 -> 219;
                    case 84 -> 39;
                    case 85 -> 245;
                    case 86 -> 220;
                    case 87 -> 143;
                    case 88 -> 75;
                    case 89 -> 150;
                    case 90 -> 178;
                    case 91 -> 100;
                    case 92 -> 250;
                    case 93 -> 248;
                    case 94 -> 53;
                    case 95 -> 22;
                    case 96 -> 189;
                    case 97 -> 79;
                    case 98 -> 177;
                    case 99 -> 67;
                    case 100 -> 211;
                    case 101 -> 131;
                    case 102 -> 98;
                    case 103 -> 95;
                    case 104 -> 82;
                    case 105 -> 170;
                    case 106 -> 49;
                    case 107 -> 132;
                    case 108 -> 18;
                    case 109 -> 254;
                    case 110 -> 153;
                    case 111 -> 215;
                    case 112 -> 89;
                    case 113 -> 7;
                    case 114 -> 167;
                    case 115 -> 9;
                    case 116 -> 54;
                    case 117 -> 52;
                    case 118 -> 159;
                    case 119 -> 203;
                    case 120 -> 212;
                    case 121 -> 128;
                    case 122 -> 31;
                    case 123 -> 47;
                    case 124 -> 144;
                    case 125 -> 205;
                    case 126 -> 4;
                    case 127 -> 108;
                    case 128 -> 32;
                    case 129 -> 35;
                    case 130 -> 16;
                    case 131 -> 154;
                    case 132 -> 66;
                    case 133 -> 134;
                    case 134 -> 181;
                    case 135 -> 135;
                    case 136 -> 149;
                    case 137 -> 156;
                    case 138 -> 106;
                    case 139 -> 20;
                    case 140 -> 168;
                    case 141 -> 251;
                    case 142 -> 238;
                    case 143 -> 161;
                    case 144 -> 152;
                    case 145 -> 229;
                    case 146 -> 125;
                    case 147 -> 202;
                    case 148 -> 126;
                    case 149 -> 234;
                    case 150 -> 60;
                    case 151 -> 6;
                    case 152 -> 218;
                    case 153 -> 151;
                    case 154 -> 182;
                    case 155 -> 155;
                    case 156 -> 91;
                    case 157 -> 94;
                    case 158 -> 56;
                    case 159 -> 230;
                    case 160 -> 226;
                    case 161 -> 48;
                    case 162 -> 163;
                    case 163 -> 249;
                    case 164 -> 201;
                    case 165 -> 165;
                    case 166 -> 69;
                    case 167 -> 33;
                    case 168 -> 206;
                    case 169 -> 87;
                    case 170 -> 227;
                    case 171 -> 120;
                    case 172 -> 224;
                    case 173 -> 127;
                    case 174 -> 58;
                    case 175 -> 107;
                    case 176 -> 196;
                    case 177 -> 81;
                    case 178 -> 80;
                    case 179 -> 216;
                    case 180 -> 10;
                    case 181 -> 45;
                    case 182 -> 105;
                    case 183 -> 172;
                    case 184 -> 225;
                    case 185 -> 160;
                    case 186 -> 235;
                    case 187 -> 46;
                    case 188 -> 174;
                    case 189 -> 73;
                    case 190 -> 185;
                    case 191 -> 147;
                    case 192 -> 40;
                    case 193 -> 255;
                    case 194 -> 199;
                    case 195 -> 5;
                    case 196 -> 236;
                    case 197 -> 183;
                    case 198 -> 197;
                    case 199 -> 90;
                    case 200 -> 162;
                    case 201 -> 175;
                    case 202 -> 231;
                    case 203 -> 130;
                    case 204 -> 85;
                    case 205 -> 240;
                    case 206 -> 72;
                    case 207 -> 12;
                    case 208 -> 51;
                    case 209 -> 8;
                    case 210 -> 27;
                    case 211 -> 36;
                    case 212 -> 50;
                    case 213 -> 116;
                    case 214 -> 129;
                    case 215 -> 110;
                    case 216 -> 30;
                    case 217 -> 210;
                    case 218 -> 166;
                    case 219 -> 78;
                    case 220 -> 179;
                    case 221 -> 29;
                    case 222 -> 86;
                    case 223 -> 41;
                    case 224 -> 193;
                    case 225 -> 24;
                    case 226 -> 195;
                    case 227 -> 244;
                    case 228 -> 17;
                    case 229 -> 11;
                    case 230 -> 96;
                    case 231 -> 37;
                    case 232 -> 253;
                    case 233 -> 138;
                    case 234 -> 21;
                    case 235 -> 214;
                    case 236 -> 242;
                    case 237 -> 55;
                    case 238 -> 71;
                    case 239 -> 142;
                    case 240 -> 44;
                    case 241 -> 57;
                    case 242 -> 188;
                    case 243 -> 14;
                    case 244 -> 208;
                    case 245 -> 171;
                    case 246 -> 118;
                    case 247 -> 217;
                    case 248 -> 123;
                    case 249 -> 109;
                    case 250 -> 222;
                    case 251 -> 241;
                    case 252 -> 192;
                    case 253 -> 243;
                    case 254 -> 121;
                    default -> 115;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 41257453892718L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "uK*8rc{,\trA92?!f0\u0007";
                    var5_4 = "uK*8rc{,\trA92?!f0\u0007".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 43;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 53;
                                    break;
                                }
                                case 1: {
                                    v11 = 5;
                                    break;
                                }
                                case 2: {
                                    v11 = 115;
                                    break;
                                }
                                case 3: {
                                    v11 = 125;
                                    break;
                                }
                                case 4: {
                                    v11 = 60;
                                    break;
                                }
                                case 5: {
                                    v11 = 36;
                                    break;
                                }
                                default: {
                                    v11 = 99;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 7321201843972L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "K9(71\u0013k\u0004M'$-\nA8/-=\u0011sk9&\tA8/-=\u0011sg3\rF>2 7\u001cig45*6\u0015";
                    var5_4 = "K9(71\u0013k\u0004M'$-\nA8/-=\u0011sk9&\tA8/-=\u0011sg3\rF>2 7\u001cig45*6\u0015".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 108;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\rwb|}P,\u0006\rwb|qZ";
                        var5_4 = "\rwb|}P,\u0006\rwb|qZ".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 32;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 110;
                                break;
                            }
                            case 1: {
                                v15 = 59;
                                break;
                            }
                            case 2: {
                                v15 = 45;
                                break;
                            }
                            case 3: {
                                v15 = 47;
                                break;
                            }
                            case 4: {
                                v15 = 52;
                                break;
                            }
                            case 5: {
                                v15 = 30;
                                break;
                            }
                            default: {
                                v15 = 107;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 523226360760L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(759681720 - (char)-16441, 759681720 - (char)-30314, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 58244274174477L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "?\u00aeL\u0012\u009b\u0003\u00ac\u0006\u008a\u0005H\u00e6\u0084\u00dfa\r%(\u001fL\u00e7\u00e6S<\u0082\u00aeW\u0010\u0002\u0010\na=\u008e\u009c+\u0017\u00b8\u00c3\u00ba\u009c\u00df\u009d\u00ab\u00d7\u0002\u0005a\u0012\u00a1A\u00c53\u0093\u00f3\u00ee\n3\u00ff\u00d26\u0006\u0096\u00afs=o\u00ef\u0085(\r\u00f7\u00f5\u0089\u008b\u00a7q4\u00d1\u000b\u00f2\u0097\u0086\u0018\u00be3{\u0099\u0084+\u0090\u00c0\u00ffSr\u0087d6\u00149\u0004\u00eb|l";
                    var4_3 = "?\u00aeL\u0012\u009b\u0003\u00ac\u0006\u008a\u0005H\u00e6\u0084\u00dfa\r%(\u001fL\u00e7\u00e6S<\u0082\u00aeW\u0010\u0002\u0010\na=\u008e\u009c+\u0017\u00b8\u00c3\u00ba\u009c\u00df\u009d\u00ab\u00d7\u0002\u0005a\u0012\u00a1A\u00c53\u0093\u00f3\u00ee\n3\u00ff\u00d26\u0006\u0096\u00afs=o\u00ef\u0085(\r\u00f7\u00f5\u0089\u008b\u00a7q4\u00d1\u000b\u00f2\u0097\u0086\u0018\u00be3{\u0099\u0084+\u0090\u00c0\u00ffSr\u0087d6\u00149\u0004\u00eb|l".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 76;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0082]1\u0014\u0000e\u0099l\u000f=\u00182\u0010\u000b{\u000bL\u00ee\u00deK\u00aee\u00fa[\u00f1\u00de\u001d\u008e\u008f\u00cc2sU\u00a3\u00dbd\u00c4\u008e\u00d4p%\u00f0\u00ad\u00ab\u00a6dX\u0094\u0017\u00af\u00bdf]\u00fbh\u00fd\u009b\u00df\u001e\u00c4\u0089Vj\u00e3\u00ee_\b\u000f\u0000\u009b\u0014\u00c5n\u00da)Z_COI\u00ca\u00dcc\u00c7>\u008f\u00ffM<\u008b\u00c9l\u0011";
                        var4_3 = "\u0082]1\u0014\u0000e\u0099l\u000f=\u00182\u0010\u000b{\u000bL\u00ee\u00deK\u00aee\u00fa[\u00f1\u00de\u001d\u008e\u008f\u00cc2sU\u00a3\u00dbd\u00c4\u008e\u00d4p%\u00f0\u00ad\u00ab\u00a6dX\u0094\u0017\u00af\u00bdf]\u00fbh\u00fd\u009b\u00df\u001e\u00c4\u0089Vj\u00e3\u00ee_\b\u000f\u0000\u009b\u0014\u00c5n\u00da)Z_COI\u00ca\u00dcc\u00c7>\u008f\u00ffM<\u008b\u00c9l\u0011".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 63;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 97;
                                break;
                            }
                            case 1: {
                                v15 = 62;
                                break;
                            }
                            case 2: {
                                v15 = 106;
                                break;
                            }
                            case 3: {
                                v15 = 32;
                                break;
                            }
                            case 4: {
                                v15 = 39;
                                break;
                            }
                            case 5: {
                                v15 = 40;
                                break;
                            }
                            default: {
                                v15 = 114;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFB949) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 10;
                    case 1 -> 77;
                    case 2 -> 139;
                    case 3 -> 208;
                    case 4 -> 72;
                    case 5 -> 68;
                    case 6 -> 83;
                    case 7 -> 176;
                    case 8 -> 59;
                    case 9 -> 248;
                    case 10 -> 240;
                    case 11 -> 75;
                    case 12 -> 220;
                    case 13 -> 32;
                    case 14 -> 150;
                    case 15 -> 95;
                    case 16 -> 146;
                    case 17 -> 1;
                    case 18 -> 39;
                    case 19 -> 116;
                    case 20 -> 13;
                    case 21 -> 254;
                    case 22 -> 5;
                    case 23 -> 222;
                    case 24 -> 100;
                    case 25 -> 61;
                    case 26 -> 255;
                    case 27 -> 94;
                    case 28 -> 238;
                    case 29 -> 14;
                    case 30 -> 193;
                    case 31 -> 181;
                    case 32 -> 25;
                    case 33 -> 180;
                    case 34 -> 30;
                    case 35 -> 86;
                    case 36 -> 37;
                    case 37 -> 183;
                    case 38 -> 21;
                    case 39 -> 191;
                    case 40 -> 42;
                    case 41 -> 7;
                    case 42 -> 192;
                    case 43 -> 36;
                    case 44 -> 187;
                    case 45 -> 6;
                    case 46 -> 161;
                    case 47 -> 43;
                    case 48 -> 134;
                    case 49 -> 175;
                    case 50 -> 80;
                    case 51 -> 211;
                    case 52 -> 112;
                    case 53 -> 16;
                    case 54 -> 110;
                    case 55 -> 113;
                    case 56 -> 174;
                    case 57 -> 136;
                    case 58 -> 52;
                    case 59 -> 230;
                    case 60 -> 33;
                    case 61 -> 101;
                    case 62 -> 114;
                    case 63 -> 31;
                    case 64 -> 200;
                    case 65 -> 102;
                    case 66 -> 223;
                    case 67 -> 243;
                    case 68 -> 85;
                    case 69 -> 236;
                    case 70 -> 237;
                    case 71 -> 118;
                    case 72 -> 48;
                    case 73 -> 169;
                    case 74 -> 202;
                    case 75 -> 170;
                    case 76 -> 142;
                    case 77 -> 231;
                    case 78 -> 91;
                    case 79 -> 147;
                    case 80 -> 35;
                    case 81 -> 28;
                    case 82 -> 253;
                    case 83 -> 105;
                    case 84 -> 194;
                    case 85 -> 252;
                    case 86 -> 135;
                    case 87 -> 168;
                    case 88 -> 129;
                    case 89 -> 47;
                    case 90 -> 165;
                    case 91 -> 215;
                    case 92 -> 71;
                    case 93 -> 128;
                    case 94 -> 217;
                    case 95 -> 235;
                    case 96 -> 23;
                    case 97 -> 156;
                    case 98 -> 103;
                    case 99 -> 76;
                    case 100 -> 3;
                    case 101 -> 154;
                    case 102 -> 212;
                    case 103 -> 221;
                    case 104 -> 153;
                    case 105 -> 67;
                    case 106 -> 82;
                    case 107 -> 18;
                    case 108 -> 111;
                    case 109 -> 137;
                    case 110 -> 27;
                    case 111 -> 151;
                    case 112 -> 207;
                    case 113 -> 50;
                    case 114 -> 8;
                    case 115 -> 131;
                    case 116 -> 55;
                    case 117 -> 60;
                    case 118 -> 205;
                    case 119 -> 209;
                    case 120 -> 228;
                    case 121 -> 15;
                    case 122 -> 87;
                    case 123 -> 17;
                    case 124 -> 81;
                    case 125 -> 0;
                    case 126 -> 51;
                    case 127 -> 160;
                    case 128 -> 195;
                    case 129 -> 141;
                    case 130 -> 227;
                    case 131 -> 99;
                    case 132 -> 45;
                    case 133 -> 108;
                    case 134 -> 107;
                    case 135 -> 121;
                    case 136 -> 109;
                    case 137 -> 78;
                    case 138 -> 182;
                    case 139 -> 12;
                    case 140 -> 233;
                    case 141 -> 138;
                    case 142 -> 89;
                    case 143 -> 166;
                    case 144 -> 225;
                    case 145 -> 145;
                    case 146 -> 210;
                    case 147 -> 119;
                    case 148 -> 4;
                    case 149 -> 123;
                    case 150 -> 66;
                    case 151 -> 22;
                    case 152 -> 96;
                    case 153 -> 130;
                    case 154 -> 163;
                    case 155 -> 19;
                    case 156 -> 41;
                    case 157 -> 152;
                    case 158 -> 203;
                    case 159 -> 65;
                    case 160 -> 213;
                    case 161 -> 171;
                    case 162 -> 120;
                    case 163 -> 143;
                    case 164 -> 184;
                    case 165 -> 179;
                    case 166 -> 219;
                    case 167 -> 54;
                    case 168 -> 79;
                    case 169 -> 104;
                    case 170 -> 244;
                    case 171 -> 49;
                    case 172 -> 164;
                    case 173 -> 178;
                    case 174 -> 58;
                    case 175 -> 185;
                    case 176 -> 88;
                    case 177 -> 162;
                    case 178 -> 64;
                    case 179 -> 34;
                    case 180 -> 198;
                    case 181 -> 190;
                    case 182 -> 197;
                    case 183 -> 144;
                    case 184 -> 127;
                    case 185 -> 98;
                    case 186 -> 56;
                    case 187 -> 155;
                    case 188 -> 196;
                    case 189 -> 239;
                    case 190 -> 24;
                    case 191 -> 97;
                    case 192 -> 173;
                    case 193 -> 167;
                    case 194 -> 132;
                    case 195 -> 84;
                    case 196 -> 2;
                    case 197 -> 53;
                    case 198 -> 74;
                    case 199 -> 188;
                    case 200 -> 177;
                    case 201 -> 29;
                    case 202 -> 201;
                    case 203 -> 234;
                    case 204 -> 90;
                    case 205 -> 26;
                    case 206 -> 73;
                    case 207 -> 93;
                    case 208 -> 250;
                    case 209 -> 63;
                    case 210 -> 133;
                    case 211 -> 249;
                    case 212 -> 251;
                    case 213 -> 140;
                    case 214 -> 125;
                    case 215 -> 57;
                    case 216 -> 122;
                    case 217 -> 148;
                    case 218 -> 232;
                    case 219 -> 62;
                    case 220 -> 216;
                    case 221 -> 124;
                    case 222 -> 44;
                    case 223 -> 214;
                    case 224 -> 117;
                    case 225 -> 149;
                    case 226 -> 241;
                    case 227 -> 199;
                    case 228 -> 69;
                    case 229 -> 115;
                    case 230 -> 186;
                    case 231 -> 46;
                    case 232 -> 189;
                    case 233 -> 11;
                    case 234 -> 245;
                    case 235 -> 106;
                    case 236 -> 158;
                    case 237 -> 92;
                    case 238 -> 70;
                    case 239 -> 204;
                    case 240 -> 40;
                    case 241 -> 224;
                    case 242 -> 157;
                    case 243 -> 126;
                    case 244 -> 159;
                    case 245 -> 229;
                    case 246 -> 218;
                    case 247 -> 20;
                    case 248 -> 246;
                    case 249 -> 226;
                    case 250 -> 38;
                    case 251 -> 247;
                    case 252 -> 242;
                    case 253 -> 172;
                    case 254 -> 9;
                    default -> 206;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 21542333587563L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1222358820 + -1544, -1222358820 + -3037, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 132534252871270L;
                    int[] nArray = SshAgentIpcService.Z();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(152041200 + (char)-31256, -152041200 + -32409, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 116078694915849L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00d5<^:\u00f1\u0003\u0085`\u0002";
                var4_3 = "\u00d5<^:\u00f1\u0003\u0085`\u0002".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 105;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 47;
                                break;
                            }
                            case 1: {
                                v11 = 72;
                                break;
                            }
                            case 2: {
                                v11 = 109;
                                break;
                            }
                            case 3: {
                                v11 = 21;
                                break;
                            }
                            case 4: {
                                v11 = 110;
                                break;
                            }
                            case 5: {
                                v11 = 101;
                                break;
                            }
                            default: {
                                v11 = 21;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x62BF) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 238;
                    case 1 -> 194;
                    case 2 -> 71;
                    case 3 -> 181;
                    case 4 -> 203;
                    case 5 -> 61;
                    case 6 -> 38;
                    case 7 -> 219;
                    case 8 -> 74;
                    case 9 -> 103;
                    case 10 -> 212;
                    case 11 -> 125;
                    case 12 -> 138;
                    case 13 -> 200;
                    case 14 -> 213;
                    case 15 -> 119;
                    case 16 -> 215;
                    case 17 -> 15;
                    case 18 -> 50;
                    case 19 -> 254;
                    case 20 -> 29;
                    case 21 -> 182;
                    case 22 -> 205;
                    case 23 -> 54;
                    case 24 -> 31;
                    case 25 -> 0;
                    case 26 -> 129;
                    case 27 -> 78;
                    case 28 -> 90;
                    case 29 -> 228;
                    case 30 -> 114;
                    case 31 -> 193;
                    case 32 -> 7;
                    case 33 -> 3;
                    case 34 -> 41;
                    case 35 -> 179;
                    case 36 -> 58;
                    case 37 -> 130;
                    case 38 -> 242;
                    case 39 -> 230;
                    case 40 -> 172;
                    case 41 -> 160;
                    case 42 -> 55;
                    case 43 -> 142;
                    case 44 -> 14;
                    case 45 -> 157;
                    case 46 -> 96;
                    case 47 -> 5;
                    case 48 -> 171;
                    case 49 -> 117;
                    case 50 -> 33;
                    case 51 -> 209;
                    case 52 -> 175;
                    case 53 -> 234;
                    case 54 -> 185;
                    case 55 -> 109;
                    case 56 -> 159;
                    case 57 -> 229;
                    case 58 -> 81;
                    case 59 -> 235;
                    case 60 -> 216;
                    case 61 -> 86;
                    case 62 -> 192;
                    case 63 -> 98;
                    case 64 -> 20;
                    case 65 -> 222;
                    case 66 -> 131;
                    case 67 -> 27;
                    case 68 -> 13;
                    case 69 -> 236;
                    case 70 -> 166;
                    case 71 -> 107;
                    case 72 -> 12;
                    case 73 -> 208;
                    case 74 -> 243;
                    case 75 -> 163;
                    case 76 -> 227;
                    case 77 -> 82;
                    case 78 -> 190;
                    case 79 -> 239;
                    case 80 -> 42;
                    case 81 -> 251;
                    case 82 -> 11;
                    case 83 -> 105;
                    case 84 -> 155;
                    case 85 -> 140;
                    case 86 -> 151;
                    case 87 -> 189;
                    case 88 -> 68;
                    case 89 -> 108;
                    case 90 -> 132;
                    case 91 -> 220;
                    case 92 -> 127;
                    case 93 -> 59;
                    case 94 -> 79;
                    case 95 -> 1;
                    case 96 -> 253;
                    case 97 -> 245;
                    case 98 -> 221;
                    case 99 -> 169;
                    case 100 -> 63;
                    case 101 -> 25;
                    case 102 -> 184;
                    case 103 -> 6;
                    case 104 -> 165;
                    case 105 -> 197;
                    case 106 -> 180;
                    case 107 -> 167;
                    case 108 -> 2;
                    case 109 -> 95;
                    case 110 -> 111;
                    case 111 -> 249;
                    case 112 -> 100;
                    case 113 -> 101;
                    case 114 -> 252;
                    case 115 -> 66;
                    case 116 -> 94;
                    case 117 -> 170;
                    case 118 -> 206;
                    case 119 -> 139;
                    case 120 -> 91;
                    case 121 -> 43;
                    case 122 -> 51;
                    case 123 -> 214;
                    case 124 -> 113;
                    case 125 -> 37;
                    case 126 -> 80;
                    case 127 -> 60;
                    case 128 -> 24;
                    case 129 -> 232;
                    case 130 -> 112;
                    case 131 -> 28;
                    case 132 -> 22;
                    case 133 -> 17;
                    case 134 -> 196;
                    case 135 -> 65;
                    case 136 -> 135;
                    case 137 -> 35;
                    case 138 -> 148;
                    case 139 -> 204;
                    case 140 -> 76;
                    case 141 -> 150;
                    case 142 -> 8;
                    case 143 -> 70;
                    case 144 -> 64;
                    case 145 -> 26;
                    case 146 -> 85;
                    case 147 -> 162;
                    case 148 -> 225;
                    case 149 -> 77;
                    case 150 -> 124;
                    case 151 -> 10;
                    case 152 -> 88;
                    case 153 -> 198;
                    case 154 -> 156;
                    case 155 -> 118;
                    case 156 -> 67;
                    case 157 -> 102;
                    case 158 -> 53;
                    case 159 -> 241;
                    case 160 -> 218;
                    case 161 -> 18;
                    case 162 -> 16;
                    case 163 -> 187;
                    case 164 -> 199;
                    case 165 -> 250;
                    case 166 -> 128;
                    case 167 -> 72;
                    case 168 -> 19;
                    case 169 -> 240;
                    case 170 -> 226;
                    case 171 -> 39;
                    case 172 -> 122;
                    case 173 -> 244;
                    case 174 -> 36;
                    case 175 -> 120;
                    case 176 -> 223;
                    case 177 -> 224;
                    case 178 -> 211;
                    case 179 -> 231;
                    case 180 -> 134;
                    case 181 -> 4;
                    case 182 -> 177;
                    case 183 -> 146;
                    case 184 -> 153;
                    case 185 -> 34;
                    case 186 -> 246;
                    case 187 -> 126;
                    case 188 -> 30;
                    case 189 -> 143;
                    case 190 -> 217;
                    case 191 -> 191;
                    case 192 -> 23;
                    case 193 -> 21;
                    case 194 -> 121;
                    case 195 -> 97;
                    case 196 -> 115;
                    case 197 -> 46;
                    case 198 -> 149;
                    case 199 -> 168;
                    case 200 -> 164;
                    case 201 -> 110;
                    case 202 -> 202;
                    case 203 -> 144;
                    case 204 -> 176;
                    case 205 -> 178;
                    case 206 -> 104;
                    case 207 -> 9;
                    case 208 -> 147;
                    case 209 -> 186;
                    case 210 -> 57;
                    case 211 -> 56;
                    case 212 -> 183;
                    case 213 -> 92;
                    case 214 -> 116;
                    case 215 -> 32;
                    case 216 -> 62;
                    case 217 -> 99;
                    case 218 -> 89;
                    case 219 -> 188;
                    case 220 -> 174;
                    case 221 -> 145;
                    case 222 -> 161;
                    case 223 -> 158;
                    case 224 -> 137;
                    case 225 -> 237;
                    case 226 -> 40;
                    case 227 -> 255;
                    case 228 -> 49;
                    case 229 -> 48;
                    case 230 -> 201;
                    case 231 -> 84;
                    case 232 -> 207;
                    case 233 -> 87;
                    case 234 -> 44;
                    case 235 -> 173;
                    case 236 -> 93;
                    case 237 -> 69;
                    case 238 -> 73;
                    case 239 -> 133;
                    case 240 -> 75;
                    case 241 -> 45;
                    case 242 -> 210;
                    case 243 -> 154;
                    case 244 -> 195;
                    case 245 -> 248;
                    case 246 -> 83;
                    case 247 -> 233;
                    case 248 -> 136;
                    case 249 -> 152;
                    case 250 -> 247;
                    case 251 -> 123;
                    case 252 -> 106;
                    case 253 -> 47;
                    case 254 -> 141;
                    default -> 52;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

