/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.console.evaluation.AbstractTableResult;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequestor;
import com.intellij.database.console.evaluation.OwnerBasedExpressionEvaluator;
import com.intellij.database.console.evaluation.PsiRequestor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcConsoleEvaluationSupport {
    @ApiStatus.Internal
    public static final QuickEvaluateHandler QUICK_EVALUATE_HANDLER = new ConsoleQuickEvaluateHandler();

    @ApiStatus.Internal
    public static boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        if (project == null) {
            JdbcConsoleEvaluationSupport.$$$reportNull$$$0(0);
        }
        if (event == null) {
            JdbcConsoleEvaluationSupport.$$$reportNull$$$0(1);
        }
        return !DbeTierUtilCore.isFreeTier() && JdbcConsoleEvaluationSupport.isEnabled(project, JdbcConsole.findConsole(event)) && (!PlatformUtils.isDataGrip() || !event.getPlace().equals("EditorPopup") || MyInfoFactory.getInfo(project, event) != null);
    }

    private static boolean isEnabled(@NotNull Project project, @Nullable JdbcConsole console) {
        if (project == null) {
            JdbcConsoleEvaluationSupport.$$$reportNull$$$0(2);
        }
        DbDataSource source = console == null ? null : DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)console.getDataSource());
        VirtualFile file = console == null ? null : console.getVirtualFile();
        return file != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE) && source != null && DbImplUtilCore.canConnectTo((DbElement)source);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport";
        objectArray[2] = "isEnabled";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static enum MyInfoFactory {
        DAS_OBJECT{

            @NotNull
            MyDasInfo create(@NotNull JdbcConsole console, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable Disposable parent2, @NotNull EditorEx editor2, @NotNull PositionInfo position) {
                if (console == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (editor2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (position == null) {
                    1.$$$reportNull$$$0(3);
                }
                Pair<DasObject, TextRange> pair = Objects.requireNonNull(MyInfoFactory.getDasRangePair(console, editor2, position));
                DasObject object = (DasObject)pair.getFirst();
                TextRange range = (TextRange)pair.getSecond();
                return new MyDasInfo(console, parent2, dataSource, searchPath, object, console.getProject(), range);
            }

            @Override
            boolean isEnabled(@NotNull JdbcConsole console, @NotNull EditorEx editor2, @NotNull DbDataSource dataSource, @NotNull PositionInfo position) {
                if (console == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (editor2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (dataSource == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (position == null) {
                    1.$$$reportNull$$$0(7);
                }
                return MyInfoFactory.getDasRangePair(console, editor2, position) != null;
            }

            @Override
            int priority(@NotNull Editor editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(8);
                }
                return editor2.getSelectionModel().hasSelection() ? 2 : 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "position";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "create";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "priority";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        SQL_ELEMENT{

            @NotNull
            MyPsiInfo create(@NotNull JdbcConsole console, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable Disposable parent2, @NotNull EditorEx editor2, @NotNull PositionInfo position) {
                if (console == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (editor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (position == null) {
                    2.$$$reportNull$$$0(3);
                }
                SqlExpression expression = PsiRequestor.getExpression(editor2, console.getProject(), position);
                return new MyPsiInfo(console, parent2, dataSource, searchPath, (SqlElement)Objects.requireNonNull(expression), console.getProject());
            }

            @Override
            boolean isEnabled(@NotNull JdbcConsole console, @NotNull EditorEx editor2, @NotNull DbDataSource dataSource, @NotNull PositionInfo position) {
                if (console == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (editor2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (dataSource == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (position == null) {
                    2.$$$reportNull$$$0(7);
                }
                return !PsiRequestor.isUnsupportedExpression(PsiRequestor.getExpression(editor2, console.getProject(), position));
            }

            @Override
            int priority(@NotNull Editor editor2) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(8);
                }
                return editor2.getSelectionModel().hasSelection() ? 3 : 2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "position";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "create";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "priority";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        SELECTED_CODE_FRAGMENT{

            @NotNull
            MyTextInfo create(@NotNull JdbcConsole console, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable Disposable parent2, @NotNull EditorEx editor2, @NotNull PositionInfo position) {
                if (console == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (editor2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (position == null) {
                    3.$$$reportNull$$$0(3);
                }
                return new MyTextInfo(console, (Editor)editor2, parent2, dataSource, searchPath, console.getProject());
            }

            @Override
            boolean isEnabled(@NotNull JdbcConsole console, @NotNull EditorEx editor2, @NotNull DbDataSource dataSource, @NotNull PositionInfo position) {
                TextRange range;
                if (console == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (editor2 == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (dataSource == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (position == null) {
                    3.$$$reportNull$$$0(7);
                }
                return (range = ScriptModelUtil.getSelectedStatementsRange((DatabaseScriptingSessionClient)console, (Editor)editor2, DatabaseSettings.getDefaultExecOption())).contains(position.offset) && JdbcConsole.getQueryText(console, (Editor)editor2) != null;
            }

            @Override
            int priority(@NotNull Editor editor2) {
                if (editor2 == null) {
                    3.$$$reportNull$$$0(8);
                }
                return editor2.getSelectionModel().hasSelection() ? 1 : 3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "position";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "create";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "priority";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        abstract int priority(@NotNull Editor var1);

        @NotNull
        abstract MyEvaluableInfo<?> create(@NotNull JdbcConsole var1, @NotNull DbDataSource var2, @Nullable SearchPath var3, @Nullable Disposable var4, @NotNull EditorEx var5, @NotNull PositionInfo var6);

        abstract boolean isEnabled(@NotNull JdbcConsole var1, @NotNull EditorEx var2, @NotNull DbDataSource var3, @NotNull PositionInfo var4);

        @Nullable
        public static MyEvaluableInfo<?> getInfo(Project project, AnActionEvent event) {
            JdbcConsole console = Objects.requireNonNull(JdbcConsole.findConsole(event));
            EditorEx editor2 = (EditorEx)ObjectUtils.tryCast((Object)event.getData(CommonDataKeys.EDITOR), EditorEx.class);
            if (editor2 == null) {
                return null;
            }
            LocalDataSource source = console.getDataSource();
            DbDataSource dbDataSource = Objects.requireNonNull(DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)source));
            Disposable disposable = Disposer.newDisposable();
            SearchPath searchPath = console.getSearchPath();
            boolean useSelection = !EditorUtil.contextMenuInvokedOutsideOfSelection((AnActionEvent)event);
            return MyInfoFactory.getInfo(console, dbDataSource, searchPath, disposable, editor2, PositionInfo.forEditor((Editor)editor2, useSelection));
        }

        @Nullable
        static MyEvaluableInfo<?> getInfo(@NotNull JdbcConsole console, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable Disposable parent2, @NotNull EditorEx editor2, @NotNull PositionInfo position) {
            if (console == null) {
                MyInfoFactory.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                MyInfoFactory.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                MyInfoFactory.$$$reportNull$$$0(2);
            }
            if (position == null) {
                MyInfoFactory.$$$reportNull$$$0(3);
            }
            MyInfoFactory[] values = MyInfoFactory.values();
            Arrays.sort(values, Comparator.comparingInt(o -> o.priority((Editor)editor2)));
            for (MyInfoFactory mode : values) {
                MyEvaluableInfo<?> info2;
                if (!mode.isEnabled(console, editor2, dataSource, position) || !(info2 = mode.create(console, dataSource, searchPath, parent2, editor2, position)).isEnabled()) continue;
                return info2;
            }
            return null;
        }

        @Nullable
        private static Pair<DasObject, TextRange> getDasRangePair(@NotNull JdbcConsole console, @NotNull EditorEx editor2, @NotNull PositionInfo position) {
            VirtualFile vFile;
            if (console == null) {
                MyInfoFactory.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                MyInfoFactory.$$$reportNull$$$0(5);
            }
            if (position == null) {
                MyInfoFactory.$$$reportNull$$$0(6);
            }
            if ((vFile = editor2.getVirtualFile()) == null) {
                return null;
            }
            PsiFile file = PsiUtilCore.getPsiFile((Project)console.getProject(), (VirtualFile)vFile);
            return MyInfoFactory.getSelectedReference(editor2, file, position);
        }

        @Nullable
        private static Pair<DasObject, TextRange> getSelectedReference(@NotNull EditorEx editor2, @NotNull PsiFile file, @NotNull PositionInfo position) {
            if (editor2 == null) {
                MyInfoFactory.$$$reportNull$$$0(7);
            }
            if (file == null) {
                MyInfoFactory.$$$reportNull$$$0(8);
            }
            if (position == null) {
                MyInfoFactory.$$$reportNull$$$0(9);
            }
            Pair<DasObject, TextRange> reference = MyInfoFactory.getFromElement(editor2, file, SqlReferenceExpression.class, e -> e, position);
            Function function = e -> {
                SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)e, SqlAsExpression.class);
                return asExpression == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)asExpression.getExpression(), SqlReferenceExpression.class);
            };
            return reference == null ? MyInfoFactory.getFromElement(editor2, file, SqlIdentifier.class, function, position) : reference;
        }

        @Nullable
        private static <T extends SqlElement> Pair<DasObject, TextRange> getFromElement(@NotNull EditorEx editor2, @NotNull PsiFile file, @NotNull Class<T> clazz, @NotNull Function<T, SqlReferenceExpression> fun, @NotNull PositionInfo position) {
            if (editor2 == null) {
                MyInfoFactory.$$$reportNull$$$0(10);
            }
            if (file == null) {
                MyInfoFactory.$$$reportNull$$$0(11);
            }
            if (clazz == null) {
                MyInfoFactory.$$$reportNull$$$0(12);
            }
            if (fun == null) {
                MyInfoFactory.$$$reportNull$$$0(13);
            }
            if (position == null) {
                MyInfoFactory.$$$reportNull$$$0(14);
            }
            int start = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor2.getDocument(), (int)position.offset);
            SqlElement element = position.range != null ? (SqlElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)position.range.getStartOffset(), (int)position.range.getEndOffset(), clazz) : (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), clazz);
            return element == null ? null : MyInfoFactory.fromSqlReference((SqlReferenceExpression)fun.fun((Object)element));
        }

        @Nullable
        private static Pair<DasObject, TextRange> fromSqlReference(@Nullable SqlReferenceExpression reference) {
            DasObject object = reference == null ? null : (DasObject)ObjectUtils.tryCast((Object)reference.resolve(), DasObject.class);
            return object == null ? null : Pair.create((Object)object, (Object)reference.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fun";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInfo";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDasRangePair";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedReference";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFromElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static abstract class MyEvaluableInfo<V> {
        final OwnerBasedExpressionEvaluator<V> myEvaluator;

        protected MyEvaluableInfo(@NotNull OwnerBasedExpressionEvaluator<V> evaluator) {
            if (evaluator == null) {
                MyEvaluableInfo.$$$reportNull$$$0(0);
            }
            this.myEvaluator = evaluator;
        }

        @NotNull
        String getQuery() {
            String string = Objects.requireNonNull(this.getQueryIfAny());
            if (string == null) {
                MyEvaluableInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        boolean isEnabled() {
            return this.getQueryIfAny() != null;
        }

        @NotNull
        MyProxy<V> proxy() {
            return new MyProxy<V>(this.myEvaluator){

                @Override
                @NotNull
                public V getValue(@NotNull String expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object v = this.getValue(expression);
                    if (v == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return v;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @ApiStatus.Internal
        @NotNull
        public abstract TextRange getRange();

        @Nullable
        abstract String getQueryIfAny();

        @NotNull
        abstract V getValue(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ConsoleQuickEvaluateHandler
    extends QuickEvaluateHandler {
        private ConsoleQuickEvaluateHandler() {
        }

        public boolean isEnabled(@NotNull Project project) {
            if (project == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(0);
            }
            return false;
        }

        public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
            Component component;
            if (project == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(1);
            }
            if (event == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(2);
            }
            return UIUtil.getParentOfType(GridMainPanel.class, (Component)(component = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT))) == null && JdbcConsoleEvaluationSupport.isEnabled(project, event);
        }

        @Nullable
        public AbstractValueHint createValueHint(@NotNull Project project, @NotNull Editor editor2, @NotNull Point point, ValueHintType type) {
            if (project == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(3);
            }
            if (editor2 == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(4);
            }
            if (point == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(5);
            }
            JdbcConsole console = ConsoleQuickEvaluateHandler.getConsole(project, editor2);
            EditorEx editorEx = (EditorEx)ObjectUtils.tryCast((Object)editor2, EditorEx.class);
            if (console == null || editorEx == null || type == ValueHintType.MOUSE_OVER_HINT) {
                return null;
            }
            DbDataSource source = Objects.requireNonNull(DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)console.getDataSource()));
            PositionInfo position = PositionInfo.forPoint(point, (Editor)editorEx);
            MyTextInfo evInfo = MyInfoFactory.getInfo(console, source, console.getSearchPath(), null, editorEx, position);
            if (evInfo == null || type == ValueHintType.MOUSE_CLICK_HINT && !JdbcConsole.beforeExecuteRange(console, ((MyEvaluableInfo)evInfo).getRange())) {
                return null;
            }
            MyEditorProvider provider = new MyEditorProvider(console, source);
            ExpressionInfo info2 = new ExpressionInfo(((MyEvaluableInfo)evInfo).getRange(), evInfo.getQuery());
            MyTextInfo trueInfo = evInfo instanceof MyTextInfo ? ((MyTextInfo)evInfo).fixedQuery() : evInfo;
            return new MyXValueHint(project, provider, (Editor)editorEx, point, type, position.offset, info2, trueInfo.proxy());
        }

        @Nullable
        private static JdbcConsole getConsole(@NotNull Project project, @NotNull Editor editor2) {
            if (project == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(6);
            }
            if (editor2 == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(7);
            }
            FileDocumentManager instance = FileDocumentManager.getInstance();
            VirtualFile file = instance.getFile(editor2.getDocument());
            return JdbcConsoleProvider.getValidConsole(project, file);
        }

        public boolean canShowHint(@NotNull Project project) {
            if (project == null) {
                ConsoleQuickEvaluateHandler.$$$reportNull$$$0(8);
            }
            return true;
        }

        public int getValueLookupDelay(Project project) {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createValueHint";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getConsole";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canShowHint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class PositionInfo {
        public final int offset;
        public final TextRange range;

        private PositionInfo(@Nullable TextRange range, int offset) {
            this.range = range;
            this.offset = offset;
        }

        @NotNull
        static PositionInfo forPoint(@NotNull Point point, @NotNull Editor editor2) {
            if (point == null) {
                PositionInfo.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                PositionInfo.$$$reportNull$$$0(1);
            }
            return new PositionInfo(PositionInfo.getRange(point, editor2), AbstractValueHint.calculateOffset((Editor)editor2, (Point)point));
        }

        @Nullable
        private static TextRange getRange(@NotNull Point point, @NotNull Editor editor2) {
            if (point == null) {
                PositionInfo.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                PositionInfo.$$$reportNull$$$0(3);
            }
            SelectionModel selectionModel = editor2.getSelectionModel();
            int offset = AbstractValueHint.calculateOffset((Editor)editor2, (Point)point);
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            boolean inSelection = selectionModel.hasSelection() && start <= offset && end >= offset;
            return inSelection ? new TextRange(start, end) : null;
        }

        @NotNull
        public static PositionInfo forEditor(@NotNull Editor editor2, boolean useSelection) {
            if (editor2 == null) {
                PositionInfo.$$$reportNull$$$0(4);
            }
            if (!useSelection) {
                return new PositionInfo(null, editor2.getCaretModel().getCurrentCaret().getOffset());
            }
            SelectionModel selectionModel = editor2.getSelectionModel();
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            return new PositionInfo(selectionModel.hasSelection() ? new TextRange(start, end) : null, start);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forPoint";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyXValueHint
    extends XValueHint {
        MyXValueHint(@NotNull Project project, @NotNull XDebuggerEditorsProvider provider, @NotNull Editor editor2, @NotNull Point point, @NotNull ValueHintType type, int offset, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator) {
            if (project == null) {
                MyXValueHint.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                MyXValueHint.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                MyXValueHint.$$$reportNull$$$0(2);
            }
            if (point == null) {
                MyXValueHint.$$$reportNull$$$0(3);
            }
            if (type == null) {
                MyXValueHint.$$$reportNull$$$0(4);
            }
            if (expressionInfo == null) {
                MyXValueHint.$$$reportNull$$$0(5);
            }
            if (evaluator == null) {
                MyXValueHint.$$$reportNull$$$0(6);
            }
            super(project, provider, editor2, point, type, offset, expressionInfo, evaluator, false);
        }

        @NotNull
        protected JComponent createHintComponent(@Nullable Icon icon, @NotNull SimpleColoredText text, @NotNull XValuePresentation presentation, @Nullable XFullValueEvaluator evaluator) {
            if (text == null) {
                MyXValueHint.$$$reportNull$$$0(7);
            }
            if (presentation == null) {
                MyXValueHint.$$$reportNull$$$0(8);
            }
            JComponent jComponent = presentation instanceof AbstractTableResult.TablePresentation ? ((AbstractTableResult.TablePresentation)presentation).presentationComponent(this.getEditor()) : super.createHintComponent(icon, text, presentation, evaluator);
            if (jComponent == null) {
                MyXValueHint.$$$reportNull$$$0(9);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionInfo";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHintComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createHintComponent";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyValue
    extends XValue {
        private final DatabaseExpressionEvaluator.Result myResult;

        private MyValue(@NotNull DatabaseExpressionEvaluator.Result result2) {
            if (result2 == null) {
                MyValue.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                MyValue.$$$reportNull$$$0(1);
            }
            if (place == null) {
                MyValue.$$$reportNull$$$0(2);
            }
            this.myResult.computePresentation(node, place);
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                MyValue.$$$reportNull$$$0(3);
            }
            this.myResult.computeChildren(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computePresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPsiInfo
    extends MyEvaluableInfo<SqlElement> {
        private final SqlElement myElement;

        MyPsiInfo(@NotNull JdbcConsole console, @Nullable Disposable parent2, @NotNull DbDataSource source, @Nullable SearchPath searchPath, @NotNull SqlElement element, @NotNull Project project) {
            if (console == null) {
                MyPsiInfo.$$$reportNull$$$0(0);
            }
            if (source == null) {
                MyPsiInfo.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MyPsiInfo.$$$reportNull$$$0(2);
            }
            if (project == null) {
                MyPsiInfo.$$$reportNull$$$0(3);
            }
            super(new OwnerBasedExpressionEvaluator.PsiExpressionEvaluator(console, source, searchPath, project, parent2));
            this.myElement = element;
        }

        @Override
        @Nullable
        public String getQueryIfAny() {
            EvaluationRequestor<DataRequest.OwnerEx> requestor = this.myEvaluator.createRequestor(this.myElement);
            return requestor.isEmpty() ? null : requestor.getQuery();
        }

        @Override
        @NotNull
        SqlElement getValue(@NotNull String expression) {
            if (expression == null) {
                MyPsiInfo.$$$reportNull$$$0(4);
            }
            SqlElement sqlElement = this.myElement;
            if (sqlElement == null) {
                MyPsiInfo.$$$reportNull$$$0(5);
            }
            return sqlElement;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myElement.getTextRange();
            if (textRange == null) {
                MyPsiInfo.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyDasInfo
    extends MyEvaluableInfo<DasObject> {
        private final TextRange myRange;
        private final DasObject myObject;

        MyDasInfo(@NotNull JdbcConsole console, @Nullable Disposable parent2, @NotNull DbDataSource source, @Nullable SearchPath searchPath, @NotNull DasObject object, @NotNull Project project, @NotNull TextRange range) {
            if (console == null) {
                MyDasInfo.$$$reportNull$$$0(0);
            }
            if (source == null) {
                MyDasInfo.$$$reportNull$$$0(1);
            }
            if (object == null) {
                MyDasInfo.$$$reportNull$$$0(2);
            }
            if (project == null) {
                MyDasInfo.$$$reportNull$$$0(3);
            }
            if (range == null) {
                MyDasInfo.$$$reportNull$$$0(4);
            }
            super(new OwnerBasedExpressionEvaluator.DasObjectEvaluator((DataRequest.OwnerEx)console, source, searchPath, project, parent2));
            this.myObject = object;
            this.myRange = range;
        }

        @Override
        @Nullable
        String getQueryIfAny() {
            EvaluationRequestor<DataRequest.OwnerEx> requestor = this.myEvaluator.createRequestor(this.myObject);
            return requestor.isEmpty() ? null : requestor.getQuery();
        }

        @Override
        @NotNull
        DasObject getValue(@NotNull String expression) {
            if (expression == null) {
                MyDasInfo.$$$reportNull$$$0(5);
            }
            DasObject dasObject = this.myObject;
            if (dasObject == null) {
                MyDasInfo.$$$reportNull$$$0(6);
            }
            return dasObject;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                MyDasInfo.$$$reportNull$$$0(7);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyTextInfo
    extends MyEvaluableInfo<String> {
        private final Disposable myParent;
        private final DbDataSource mySource;
        private final SearchPath mySearchPath;
        private final Project myProject;
        private final JdbcConsole myConsole;
        private final Editor myEditor;

        MyTextInfo(@NotNull JdbcConsole console, @NotNull Editor editor2, @Nullable Disposable parent2, @NotNull DbDataSource source, @Nullable SearchPath searchPath, @NotNull Project project) {
            if (console == null) {
                MyTextInfo.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                MyTextInfo.$$$reportNull$$$0(1);
            }
            if (source == null) {
                MyTextInfo.$$$reportNull$$$0(2);
            }
            if (project == null) {
                MyTextInfo.$$$reportNull$$$0(3);
            }
            this(new OwnerBasedExpressionEvaluator.TextExpressionEvaluator((DataRequest.OwnerEx)console, source, searchPath, project, parent2), console, editor2, parent2, source, searchPath, project);
        }

        private MyTextInfo(@NotNull OwnerBasedExpressionEvaluator<String> evaluator, @NotNull JdbcConsole console, @NotNull Editor editor2, @Nullable Disposable parent2, @NotNull DbDataSource source, @Nullable SearchPath searchPath, @NotNull Project project) {
            if (evaluator == null) {
                MyTextInfo.$$$reportNull$$$0(4);
            }
            if (console == null) {
                MyTextInfo.$$$reportNull$$$0(5);
            }
            if (editor2 == null) {
                MyTextInfo.$$$reportNull$$$0(6);
            }
            if (source == null) {
                MyTextInfo.$$$reportNull$$$0(7);
            }
            if (project == null) {
                MyTextInfo.$$$reportNull$$$0(8);
            }
            super(evaluator);
            this.myConsole = console;
            this.myParent = parent2;
            this.mySource = source;
            this.mySearchPath = searchPath;
            this.myProject = project;
            this.myEditor = editor2;
        }

        @NotNull
        public MyTextInfo fixedQuery() {
            return new MyTextInfo(new OwnerBasedExpressionEvaluator.ImmutableTextExpressionEvaluator((DataRequest.OwnerEx)this.myConsole, this.mySource, this.mySearchPath, this.myProject, this.myParent), this.myConsole, this.myEditor, this.myParent, this.mySource, this.mySearchPath, this.myProject);
        }

        @Override
        @NotNull
        public String getValue(@NotNull String expression) {
            if (expression == null) {
                MyTextInfo.$$$reportNull$$$0(9);
            }
            String string = expression;
            if (string == null) {
                MyTextInfo.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = ScriptModelUtil.getSelectedStatementsRange((DatabaseScriptingSessionClient)this.myConsole, this.myEditor, DatabaseSettings.getDefaultExecOption());
            if (textRange == null) {
                MyTextInfo.$$$reportNull$$$0(11);
            }
            return textRange;
        }

        @Override
        @Nullable
        public String getQueryIfAny() {
            String query = Objects.requireNonNull(JdbcConsole.getQueryText(this.myConsole, this.myEditor));
            EvaluationRequestor<DataRequest.OwnerEx> requestor = this.myEvaluator.createRequestor(query);
            return requestor.isEmpty() ? null : requestor.getQuery();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static abstract class MyProxy<V>
    extends XDebuggerEvaluator {
        final OwnerBasedExpressionEvaluator<V> myEvaluator;

        protected MyProxy(@NotNull OwnerBasedExpressionEvaluator<V> evaluator) {
            if (evaluator == null) {
                MyProxy.$$$reportNull$$$0(0);
            }
            this.myEvaluator = evaluator;
        }

        public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                MyProxy.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                MyProxy.$$$reportNull$$$0(2);
            }
            CompletionStage future = this.myEvaluator.evaluate((Object)this.getValue(expression));
            ((CompletableFuture)future).whenComplete((r, e) -> DbUIUtil.invokeLaterIfNeeded(() -> {
                if (r != null) {
                    callback.evaluated((XValue)new MyValue((DatabaseExpressionEvaluator.Result)r));
                    return;
                }
                callback.errorOccurred(e == null ? DatabaseBundle.message((String)"dialog.message.can.t.evaluate", (Object[])new Object[]{expression}) : e.getMessage());
            }));
        }

        @NotNull
        public abstract V getValue(@NotNull String var1);

        public boolean isCodeFragmentEvaluationSupported() {
            return false;
        }

        public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
            if (text == null) {
                MyProxy.$$$reportNull$$$0(3);
            }
            return EvaluationMode.EXPRESSION;
        }

        @Nullable
        public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
            if (project == null) {
                MyProxy.$$$reportNull$$$0(4);
            }
            if (document == null) {
                MyProxy.$$$reportNull$$$0(5);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEvaluationMode";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getExpressionInfoAtOffset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class MyEditorProvider
    extends XDebuggerEditorsProvider {
        private final JdbcConsole myConsole;
        private final DbDataSource mySource;

        public MyEditorProvider(@NotNull JdbcConsole console, @NotNull DbDataSource source) {
            if (console == null) {
                MyEditorProvider.$$$reportNull$$$0(0);
            }
            if (source == null) {
                MyEditorProvider.$$$reportNull$$$0(1);
            }
            this.myConsole = console;
            this.mySource = source;
        }

        @NotNull
        public FileType getFileType() {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                MyEditorProvider.$$$reportNull$$$0(2);
            }
            return sqlFileType;
        }

        @NotNull
        public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
            SqlLanguageDialect dialect;
            SqlPsiFacade sqlPsiFacade;
            PsiCodeFragment fragment;
            if (project == null) {
                MyEditorProvider.$$$reportNull$$$0(3);
            }
            if (expression == null) {
                MyEditorProvider.$$$reportNull$$$0(4);
            }
            if (mode == null) {
                MyEditorProvider.$$$reportNull$$$0(5);
            }
            if ((fragment = (sqlPsiFacade = SqlPsiFacade.getInstance((Project)project)).createEvaluableExpressionFragment((Language)(dialect = DbSqlUtilCore.getSqlDialect((DbDataSource)this.mySource)), this.mySource, this.myConsole.getSearchPath(), expression.getExpression())) instanceof SqlCodeFragment) {
                SqlCodeFragment f = (SqlCodeFragment)fragment;
                f.setContext((PsiElement)this.myConsole.getFile());
            }
            Document document = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment));
            if (document == null) {
                MyEditorProvider.$$$reportNull$$$0(6);
            }
            return document;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createDocument";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6 -> new IllegalStateException(string);
            };
        }
    }
}

