/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

final class RunWatchersForFileAction
extends AnAction {
    RunWatchersForFileAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunWatchersForFileAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = e.getProject();
        boolean enabled = files != null && project != null && RunWatchersForFileAction.hasDirOrTasks(project, files);
        presentation.setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunWatchersForFileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static boolean hasDirOrTasks(Project project, VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isDirectory() && ProjectTasksOptions.getInstance(project).findTasksForFile(file).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunWatchersForFileAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = e.getProject();
        if (files == null || project == null) {
            return;
        }
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
                index.iterateContentUnderDirectory(file, descendant -> {
                    if (!descendant.isDirectory()) {
                        filesList.add(descendant);
                    }
                    return true;
                });
                continue;
            }
            filesList.add(file);
        }
        for (VirtualFile virtualFile : filesList) {
            FwTaskRunner.tryFindTasksAndRun(project, virtualFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/action/RunWatchersForFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/action/RunWatchersForFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

