/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintFile;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyFinalInspection$Visitor$visitPyFunction$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyFinalInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyFinalInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001bH\u0016J6\u0010\u001c\u001a(\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u000f0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001e0\u001d2\u0006\u0010 \u001a\u00020\u000bH\u0002J4\u0010!\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001e0\u001d2\u0006\u0010 \u001a\u00020\u000bH\u0002J2\u0010\"\u001a\u00020\t2\u0014\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u000f0\u001e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001eH\u0002J2\u0010%\u001a\u00020\t2\u0014\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u000f0\u001e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001eH\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000bH\u0002JH\u0010&\u001a\u00020\t2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001e2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001e2\b\u0010)\u001a\u0004\u0018\u00010\u001f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0002J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0018\u00102\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0018\u00103\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u00104\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J#\u00108\u001a\u000209\"\f\b\u0000\u0010<*\u00020=*\u00020>2\u0006\u0010\n\u001a\u0002H<H\u0002\u00a2\u0006\u0002\u0010?J\u0012\u0010@\u001a\u0002092\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\u0010\u0010C\u001a\u0002092\u0006\u0010A\u001a\u00020BH\u0002J\u0012\u0010D\u001a\u0002092\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\u0010\u0010E\u001a\u0002092\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010F\u001a\u0002092\u0006\u0010\n\u001a\u00020BH\u0002\u00a8\u0006G"}, d2={"Lcom/jetbrains/python/inspections/PyFinalInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyClass", "", "node", "Lcom/jetbrains/python/psi/PyClass;", "visitPyFunction", "Lcom/jetbrains/python/psi/PyFunction;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "visitPyNamedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPySubscriptionExpression", "Lcom/jetbrains/python/psi/PySubscriptionExpression;", "visitPyForStatement", "Lcom/jetbrains/python/psi/PyForStatement;", "visitPyWhileStatement", "Lcom/jetbrains/python/psi/PyWhileStatement;", "visitPyAugAssignmentStatement", "Lcom/jetbrains/python/psi/PyAugAssignmentStatement;", "getClassLevelFinalsAndInitAttributes", "Lkotlin/Pair;", "", "", "cls", "getDeclaredClassAndInstanceFinals", "checkClassLevelFinalsAreInitialized", "classLevelFinals", "initAttributes", "checkSameNameClassAndInstanceFinals", "checkOverridingInheritedFinalWithNewOne", "newFinals", "inheritedFinals", "ancestorName", "notRegistered", "", "checkInstanceFinalsOutsideInit", "method", "checkFinalReassignment", "target", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "checkClassFinalReassignment", "checkInstanceFinalReassignment", "checkInheritedClassFinalReassignmentOnClassLevel", "checkFinalIsOuterMost", "checkFinalInsideLoop", "loop", "Lcom/jetbrains/python/psi/PyLoopStatement;", "isFinal", "", "decoratable", "Lcom/jetbrains/python/psi/PyDecoratable;", "T", "Lcom/jetbrains/python/psi/PyAnnotationOwner;", "Lcom/jetbrains/python/psi/PyTypeCommentOwner;", "(Lcom/jetbrains/python/psi/PyAnnotationOwner;)Z", "resolvesToFinal", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "resolvesToClassVar", "resolvesToClassVarFinal", "isDataclass", "isTopLevelInAnnotationOrTypeComment", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyFinalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyFinalInspection.kt\ncom/jetbrains/python/inspections/PyFinalInspection$Visitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,489:1\n3829#2:490\n4344#2,2:491\n11476#2,9:518\n13402#2:527\n13403#2:529\n11485#2:530\n477#3:493\n183#3,2:494\n1755#4,3:496\n1755#4,3:499\n1863#4,2:502\n1863#4,2:516\n1611#4,9:531\n1863#4:540\n1864#4:542\n1620#4:543\n1755#4,3:544\n1755#4,3:547\n1755#4,3:550\n1#5:504\n1#5:528\n1#5:541\n503#6,7:505\n216#7,2:512\n216#7,2:514\n*S KotlinDebug\n*F\n+ 1 PyFinalInspection.kt\ncom/jetbrains/python/inspections/PyFinalInspection$Visitor\n*L\n40#1:490\n40#1:491,2\n319#1:518,9\n319#1:527\n319#1:529\n319#1:530\n83#1:493\n84#1:494,2\n119#1:496,3\n156#1:499,3\n207#1:502,2\n300#1:516,2\n330#1:531,9\n330#1:540\n330#1:542\n330#1:543\n336#1:544,3\n455#1:547,3\n460#1:550,3\n319#1:528\n330#1:541\n232#1:505,7\n240#1:512,2\n249#1:514,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyClass(@NotNull PyClass node) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            PyClass[] pyClassArray = node.getSuperClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)pyClassArray, (String)"getSuperClasses(...)");
            Object[] $this$filter$iv = pyClassArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PyClass it = (PyClass)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.isFinal(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List finalSuperClasses = (List)destination$iv$iv;
            boolean bl = false;
            if (!finalSuperClasses.isEmpty()) {
                String superClassList = CollectionsKt.joinToString$default((Iterable)finalSuperClasses, null, null, null, (int)0, null, Visitor::visitPyClass$lambda$2$lambda$1, (int)31, null);
                Object[] objectArray2 = new Object[]{superClassList, finalSuperClasses.size()};
                this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.super.classes.are.marked.as.final.and.should.not.be.subclassed", objectArray2));
            }
            if (PyiUtil.isInsideStub(node)) {
                Set visitedNames = new LinkedHashSet();
                node.visitMethods((Processor<? super PyFunction>)((Processor)arg_0 -> Visitor.visitPyClass$lambda$4(arg_0 -> Visitor.visitPyClass$lambda$3(visitedNames, this, arg_0), arg_0)), false, this.myTypeEvalContext);
            } else {
                Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair = this.getClassLevelFinalsAndInitAttributes(node);
                Map classLevelFinals = (Map)pair.component1();
                Map initAttributes = (Map)pair.component2();
                if (!this.isDataclass(node)) {
                    this.checkClassLevelFinalsAreInitialized(classLevelFinals, initAttributes);
                }
                this.checkSameNameClassAndInstanceFinals(classLevelFinals, initAttributes);
            }
            this.checkOverridingInheritedFinalWithNewOne(node);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            block23: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super.visitPyFunction(node);
                PyClass cls = node.getContainingClass();
                if (cls != null) {
                    if (!PyiUtil.isOverload(node, this.myTypeEvalContext)) {
                        Object v2;
                        Object[] it;
                        block21: {
                            void $this$firstOrNull$iv;
                            Sequence $this$filterIsInstance$iv;
                            Query<PsiElement> query = PySuperMethodsSearch.search(node, this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue(query, (String)"search(...)");
                            Sequence sequence = CollectionsKt.asSequence((Iterable)((Iterable)query));
                            boolean $i$f$filterIsInstance = false;
                            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyFunction$$inlined$filterIsInstance$1.INSTANCE);
                            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                            $this$filterIsInstance$iv = sequence2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (Object[])element$iv;
                                boolean bl = false;
                                if (!this.isFinal((PyDecoratable)it)) continue;
                                v2 = element$iv;
                                break block21;
                            }
                            v2 = null;
                        }
                        PyFunction pyFunction = v2;
                        if (pyFunction != null) {
                            PyFunction it2 = pyFunction;
                            boolean bl = false;
                            Object object = it2.getQualifiedName();
                            if (object == null) {
                                PyClass pyClass = it2.getContainingClass();
                                object = (pyClass != null ? pyClass.getName() : null) + "." + it2.getName();
                            }
                            String qualifiedName = object;
                            it = new Object[]{qualifiedName};
                            this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.method.marked.as.final.should.not.be.overridden", it));
                        }
                    }
                    if (!PyiUtil.isInsideStub(node)) {
                        if (this.isFinal(node) && PyiUtil.isOverload(node, this.myTypeEvalContext)) {
                            this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.final.should.be.placed.on.implementation", new Object[0]));
                        }
                        this.checkInstanceFinalsOutsideInit(node);
                    }
                    if (PyKnownDecoratorUtil.hasAbstractDecorator(node, this.myTypeEvalContext)) {
                        if (this.isFinal(node)) {
                            this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.final.could.not.be.mixed.with.abstract.decorators", new Object[0]));
                        } else if (this.isFinal(cls)) {
                            String string = PyPsiBundle.message("INSP.final.final.class.could.not.contain.abstract.methods", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            String message = string;
                            this.registerProblem(node.getNameIdentifier(), message);
                            this.registerProblem(cls.getNameIdentifier(), message);
                        }
                    } else if (this.isFinal(node) && this.isFinal(cls)) {
                        this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.no.need.to.mark.method.in.final.class.as.final", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                    }
                } else if (this.isFinal(node)) {
                    this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.non.method.function.could.not.be.marked.as.final", new Object[0]));
                }
                PyFunctionTypeAnnotation pyFunctionTypeAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(node);
                if (pyFunctionTypeAnnotation != null) {
                    boolean bl;
                    block22: {
                        PyFunctionTypeAnnotation comment = pyFunctionTypeAnnotation;
                        boolean bl2 = false;
                        List<PyExpression> list = comment.getParameterTypeList().getParameterTypes();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameterTypes(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PyExpression it = (PyExpression)element$iv;
                                boolean bl3 = false;
                                if (!this.resolvesToFinal(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it)) continue;
                                bl = true;
                                break block22;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.registerProblem((PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.final.final.could.not.be.used.in.annotations.for.function.parameters", new Object[0]));
                    }
                }
                PyExpression pyExpression = PyTypingTypeProvider.getReturnTypeAnnotation(node, this.myTypeEvalContext);
                if (pyExpression == null) break block23;
                PyExpression it = pyExpression;
                boolean bl = false;
                if (this.resolvesToFinal(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it)) {
                    PsiComment psiComment = node.getTypeComment();
                    this.registerProblem(psiComment != null ? (PsiElement)psiComment : (PsiElement)node.getAnnotation(), PyPsiBundle.message("INSP.final.final.could.not.be.used.in.annotation.for.function.return.value", new Object[0]));
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            PyStatement parent = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyStatement.class);
            if (parent instanceof PyTypeDeclarationStatement || parent instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement) {
                PyElement pyElement = node.getAnnotation();
                if (pyElement != null && (pyElement = pyElement.getValue()) != null) {
                    PyElement pyElement2 = pyElement;
                    boolean bl2 = false;
                    if (PyiUtil.isInsideStub(node) || ScopeUtil.getScopeOwner(node) instanceof PyClass) {
                        if (this.resolvesToFinal((PyExpression)pyElement2)) {
                            this.registerProblem((PsiElement)pyElement2, PyPsiBundle.message("INSP.final.if.assigned.value.omitted.there.should.be.explicit.type.argument.to.final", new Object[0]));
                        }
                    } else if (this.resolvesToFinal((PyExpression)(pyElement2 instanceof PySubscriptionExpression ? ((PySubscriptionExpression)pyElement2).getOperand() : pyElement2))) {
                        this.registerProblem(node, PyPsiBundle.message("INSP.final.final.name.should.be.initialized.with.value", new Object[0]));
                    }
                }
            } else if (!this.isFinal((PyAnnotationOwner)node)) {
                this.checkFinalReassignment(node);
            }
            if (!this.isFinal((PyAnnotationOwner)node)) return;
            List<PsiElement> list = PyUtil.multiResolveTopPriority(node, this.getResolveContext());
            Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveTopPriority(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return;
                Object t = iterator.next();
                PsiElement it = (PsiElement)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)node)) {
                    PsiElement psiElement2 = node;
                    psiElement2 = it;
                    Intrinsics.checkNotNull((Object)psiElement2);
                    if (!PyDefUseUtil.isDefinedBefore(psiElement, psiElement2)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            boolean bl4 = true;
            if (!bl4) return;
            this.registerProblem(node, PyPsiBundle.message("INSP.final.already.declared.name.could.not.be.redefined.as.final", new Object[0]));
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyNamedParameter(node);
            if (this.isFinal((PyAnnotationOwner)node)) {
                PyElement pyElement = (PyAnnotation)node.getAnnotation();
                this.registerProblem(pyElement != null && (pyElement = pyElement.getValue()) != null ? (PsiElement)pyElement : (PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.final.final.could.not.be.used.in.annotations.for.function.parameters", new Object[0]));
            }
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyReferenceExpression(node);
            this.checkFinalIsOuterMost(node);
        }

        @Override
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.resolvesToFinal(node.getOperand())) {
                return;
            }
            PyExpression pyExpression = node.getIndexExpression();
            if (pyExpression == null) {
                return;
            }
            PyExpression indexExpression = pyExpression;
            if (indexExpression instanceof PyTupleExpression && ((PyTupleExpression)indexExpression).getElements().length > 1) {
                this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.final.can.only.be.parameterized.with.one.type", new Object[0]));
            }
        }

        @Override
        public void visitPyForStatement(@NotNull PyForStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyForStatement(node);
            this.checkFinalInsideLoop(node);
        }

        @Override
        public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyWhileStatement(node);
            this.checkFinalInsideLoop(node);
        }

        @Override
        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyAugAssignmentStatement(node);
            PyExpression pyExpression = node.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getTarget(...)");
            PyExpression target = pyExpression;
            if (target instanceof PyQualifiedExpression) {
                this.checkFinalReassignment((PyQualifiedExpression)target);
            }
        }

        private final Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> getClassLevelFinalsAndInitAttributes(PyClass cls) {
            Map initAttributes;
            Map classLevelFinals;
            block1: {
                classLevelFinals = new LinkedHashMap();
                List<PyTargetExpression> list = cls.getClassAttributes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getClassAttributes(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyTargetExpression it = (PyTargetExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isFinal((PyAnnotationOwner)it)) continue;
                    classLevelFinals.put(it.getName(), it);
                }
                initAttributes = new LinkedHashMap();
                PyFunction pyFunction = cls.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (pyFunction == null) break block1;
                PyFunction it = pyFunction;
                boolean bl = false;
                PyClassImpl.collectInstanceAttributes(it, initAttributes);
            }
            return new Pair((Object)classLevelFinals, (Object)initAttributes);
        }

        private final Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> getDeclaredClassAndInstanceFinals(PyClass cls) {
            Map instanceFinals;
            Map classFinals;
            block2: {
                classFinals = new LinkedHashMap();
                instanceFinals = new LinkedHashMap();
                for (PyTargetExpression classAttribute : cls.getClassAttributes()) {
                    String name2;
                    if (classAttribute.getName() == null) continue;
                    Intrinsics.checkNotNull((Object)classAttribute);
                    if (!this.isFinal((PyAnnotationOwner)classAttribute)) continue;
                    Map mapToPut = classAttribute.hasAssignedValue() ? classFinals : instanceFinals;
                    mapToPut.put(name2, classAttribute);
                }
                PyFunction pyFunction = cls.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (pyFunction == null) break block2;
                PyFunction init2 = pyFunction;
                boolean bl = false;
                Map attributesInInit = new LinkedHashMap();
                PyClassImpl.collectInstanceAttributes(init2, attributesInInit);
                attributesInInit.keySet().removeAll(instanceFinals.keySet());
                Map map2 = instanceFinals;
                Map $this$filterValues$iv = attributesInInit;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    PyTargetExpression it = (PyTargetExpression)entry$iv.getValue();
                    boolean bl2 = false;
                    if (!this.isFinal((PyAnnotationOwner)it)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map map3 = result$iv;
                map2.putAll(map3);
            }
            return new Pair((Object)classFinals, (Object)instanceFinals);
        }

        private final void checkClassLevelFinalsAreInitialized(Map<String, ? extends PyTargetExpression> classLevelFinals, Map<String, ? extends PyTargetExpression> initAttributes) {
            Map<String, ? extends PyTargetExpression> $this$forEach$iv = classLevelFinals;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends PyTargetExpression>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ? extends PyTargetExpression> element$iv;
                Map.Entry<String, ? extends PyTargetExpression> entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = entry.getKey();
                PyTargetExpression psi = entry.getValue();
                if (psi.hasAssignedValue() || initAttributes.containsKey(name2)) continue;
                this.registerProblem(psi, PyPsiBundle.message("INSP.final.final.name.should.be.initialized.with.value", new Object[0]));
            }
        }

        private final void checkSameNameClassAndInstanceFinals(Map<String, ? extends PyTargetExpression> classLevelFinals, Map<String, ? extends PyTargetExpression> initAttributes) {
            Map<String, ? extends PyTargetExpression> $this$forEach$iv = initAttributes;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends PyTargetExpression>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                String message;
                Map.Entry<String, ? extends PyTargetExpression> element$iv;
                Map.Entry<String, ? extends PyTargetExpression> entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = entry.getKey();
                PyTargetExpression initAttribute = entry.getValue();
                PyTargetExpression sameNameClassLevelFinal = classLevelFinals.get(name2);
                if (sameNameClassLevelFinal == null || !this.isFinal((PyAnnotationOwner)initAttribute)) continue;
                if (sameNameClassLevelFinal.hasAssignedValue()) {
                    this.registerProblem(initAttribute, PyPsiBundle.message("INSP.final.already.declared.name.could.not.be.redefined.as.final", new Object[0]));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)PyPsiBundle.message("INSP.final.either.instance.attribute.or.class.attribute.could.be.type.hinted.as.final", new Object[0]), (String)"message(...)");
                this.registerProblem(sameNameClassLevelFinal, message);
                this.registerProblem(initAttribute, message);
            }
        }

        private final void checkOverridingInheritedFinalWithNewOne(PyClass cls) {
            Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair = this.getDeclaredClassAndInstanceFinals(cls);
            Map newClassFinals = (Map)pair.component1();
            Map newInstanceFinals = (Map)pair.component2();
            Set notRegisteredClassFinals = CollectionsKt.toMutableSet((Iterable)newClassFinals.keySet());
            Set notRegisteredInstanceFinals = CollectionsKt.toMutableSet((Iterable)newInstanceFinals.keySet());
            if (notRegisteredClassFinals.isEmpty() && notRegisteredInstanceFinals.isEmpty()) {
                return;
            }
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                Intrinsics.checkNotNull((Object)ancestor);
                Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair2 = this.getDeclaredClassAndInstanceFinals(ancestor);
                Map inheritedClassFinals = (Map)pair2.component1();
                Map inheritedInstanceFinals = (Map)pair2.component2();
                this.checkOverridingInheritedFinalWithNewOne(newClassFinals, inheritedClassFinals, ancestor.getName(), notRegisteredClassFinals);
                this.checkOverridingInheritedFinalWithNewOne(newInstanceFinals, inheritedInstanceFinals, ancestor.getName(), notRegisteredInstanceFinals);
                if (!notRegisteredClassFinals.isEmpty() || !notRegisteredInstanceFinals.isEmpty()) continue;
                break;
            }
        }

        private final void checkOverridingInheritedFinalWithNewOne(Map<String, ? extends PyTargetExpression> newFinals, Map<String, ? extends PyTargetExpression> inheritedFinals, String ancestorName, Set<String> notRegistered) {
            if (notRegistered.isEmpty()) {
                return;
            }
            for (String commonFinal : CollectionsKt.intersect((Iterable)newFinals.keySet(), (Iterable)inheritedFinals.keySet())) {
                String qualifiedName = ancestorName + "." + commonFinal;
                Object[] objectArray = new Object[]{qualifiedName};
                this.registerProblem(newFinals.get(commonFinal), PyPsiBundle.message("INSP.final.final.attribute.could.not.be.overridden", objectArray));
                notRegistered.remove(commonFinal);
            }
        }

        private final void checkInstanceFinalsOutsideInit(PyFunction method) {
            if (PyUtil.isInitMethod(method)) {
                return;
            }
            Map instanceAttributes = new LinkedHashMap();
            PyClassImpl.collectInstanceAttributes(method, instanceAttributes);
            Iterable $this$forEach$iv = instanceAttributes.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTargetExpression it = (PyTargetExpression)element$iv;
                boolean bl = false;
                if (!this.isFinal((PyAnnotationOwner)it)) continue;
                this.registerProblem(it, PyPsiBundle.message("INSP.final.final.attribute.should.be.declared.in.class.body.or.init", new Object[0]));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkFinalReassignment(PyQualifiedExpression target) {
            void $this$mapNotNullTo$iv$iv;
            List list;
            PsiElement it$iv$iv;
            ResolveResult it;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable<PsiElement> destination$iv$iv;
            PyType qualifierType;
            PyExpression pyExpression = target.getQualifier();
            if (pyExpression != null) {
                PyExpression it2 = pyExpression;
                boolean bl = false;
                v1 = this.myTypeEvalContext.getType(it2);
            } else {
                v1 = qualifierType = null;
            }
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
                this.checkInstanceFinalReassignment(target, pyClass);
                return;
            }
            if (qualifierType instanceof PyClassType && ((PyClassType)qualifierType).isDefinition()) {
                PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
                this.checkClassFinalReassignment(target, pyClass);
                return;
            }
            if (target instanceof PyReferenceOwner) {
                void $this$mapNotNullTo$iv$iv2;
                ResolveResult[] resolveResultArray = ((PyReferenceOwner)((Object)target)).getReference(this.getResolveContext()).multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                Object[] $this$mapNotNull$iv = resolveResultArray;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    it = (ResolveResult)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getElement() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                List list2 = PyUtil.multiResolveTopPriority((PsiElement)target, this.getResolveContext());
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"multiResolveTopPriority(...)");
            }
            List resolved = CollectionsKt.toMutableList((Collection)list);
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
            if (!target.isQualified() && scopeOwner != null) {
                Collection collection = resolved;
                Collection<PsiNamedElement> collection2 = ControlFlowCache.getScope(scopeOwner).getNamedElements(target.getReferencedName(), false);
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getNamedElements(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)collection2);
            }
            Iterable $this$mapNotNull$iv = resolved;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                it = (PsiElement)element$iv$iv;
                boolean bl4 = false;
                if ((it instanceof PyTargetExpression ? (PyTargetExpression)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            for (PyTargetExpression e : (List)destination$iv$iv2) {
                boolean bl;
                block15: {
                    if (this.isFinal((PyAnnotationOwner)e) && !PyDefUseUtil.isDefinedBefore((PsiElement)target, e)) {
                        Object[] $i$f$mapNotNull2 = new Object[]{target.getName()};
                        this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", $i$f$mapNotNull2));
                        return;
                    }
                    PsiElement it3 = e.getParent();
                    boolean bl6 = false;
                    boolean bl7 = it3 instanceof PyNonlocalStatement || it3 instanceof PyGlobalStatement;
                    if (!bl7) continue;
                    List<PsiElement> list3 = PyUtil.multiResolveTopPriority(e, this.getResolveContext());
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"multiResolveTopPriority(...)");
                    Iterable $this$any$iv = list3;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it4 = (PsiElement)element$iv;
                            boolean bl8 = false;
                            if (!(it4 instanceof PyTargetExpression && this.isFinal((PyAnnotationOwner)it4))) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                Object[] objectArray = new Object[]{target.getName()};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                return;
            }
            if (!target.isQualified() && scopeOwner instanceof PyClass) {
                this.checkInheritedClassFinalReassignmentOnClassLevel(target, (PyClass)scopeOwner);
            }
        }

        private final void checkClassFinalReassignment(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            PyTargetExpression classAttribute = cls.findClassAttribute(name2, true, this.myTypeEvalContext);
            if (classAttribute != null) {
                boolean isFinal = this.isFinal((PyAnnotationOwner)classAttribute);
                if (!isFinal && this.isDataclass(cls)) {
                    PyAnnotation pyAnnotation = classAttribute.getAnnotation();
                    isFinal = this.resolvesToClassVarFinal(pyAnnotation != null ? pyAnnotation.getValue() : null);
                }
                if (isFinal) {
                    Object[] objectArray = new Object[]{name2};
                    this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                }
            }
        }

        private final void checkInstanceFinalReassignment(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            PyTargetExpression classAttribute = cls.findClassAttribute(name2, false, this.myTypeEvalContext);
            if (classAttribute != null && this.isFinal((PyAnnotationOwner)classAttribute)) {
                if (!classAttribute.hasAssignedValue() && target instanceof PyTargetExpression) {
                    ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
                    boolean bl = false;
                    boolean bl2 = scopeOwner instanceof PyFunction && Intrinsics.areEqual((Object)PyUtil.turnConstructorIntoClass((PyFunction)scopeOwner), (Object)cls);
                    if (bl2) {
                        return;
                    }
                }
                Object[] objectArray = new Object[]{name2};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
            }
            for (PyClass pyClass : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression inheritedClassAttribute = pyClass.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (inheritedClassAttribute == null || inheritedClassAttribute.hasAssignedValue() || !this.isFinal((PyAnnotationOwner)inheritedClassAttribute)) continue;
                String qualifiedName = pyClass.getName() + "." + name2;
                Object[] objectArray = new Object[]{qualifiedName};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                return;
            }
            Object[] objectArray = new PyClass[]{cls};
            Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
            List<PyClass> list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAncestorClasses(...)");
            for (PyClass pyClass : SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)list))) {
                boolean bl;
                PyFunction init2 = pyClass.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (init2 == null) continue;
                Map attributesInInit = new LinkedHashMap();
                PyClassImpl.collectInstanceAttributes(init2, attributesInInit);
                if ((PyTargetExpression)attributesInInit.get(name2) != null) {
                    PyTargetExpression it;
                    boolean bl3 = false;
                    bl = !Intrinsics.areEqual((Object)it, (Object)target) && this.isFinal((PyAnnotationOwner)it);
                } else {
                    bl = false;
                }
                if (!bl) continue;
                String qualifiedName = (String)(Intrinsics.areEqual((Object)cls, (Object)pyClass) ? "" : pyClass.getName() + ".") + name2;
                Object[] objectArray2 = new Object[]{qualifiedName};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray2));
                break;
            }
        }

        private final void checkInheritedClassFinalReassignmentOnClassLevel(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            if (PyUtil.isClassPrivateName(name2)) {
                return;
            }
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression ancestorClassAttribute = ancestor.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (ancestorClassAttribute == null || !ancestorClassAttribute.hasAssignedValue() || !this.isFinal((PyAnnotationOwner)ancestorClassAttribute)) continue;
                String qualifiedName = ancestor.getName() + "." + name2;
                Object[] objectArray = new Object[]{qualifiedName};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                break;
            }
        }

        private final void checkFinalIsOuterMost(PyReferenceExpression node) {
            ScopeOwner scopeOwner;
            if (this.isTopLevelInAnnotationOrTypeComment(node)) {
                return;
            }
            PsiElement psiElement = node.getParent();
            PySubscriptionExpression pySubscriptionExpression = psiElement instanceof PySubscriptionExpression ? (PySubscriptionExpression)psiElement : null;
            if (pySubscriptionExpression != null) {
                PySubscriptionExpression it = pySubscriptionExpression;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getOperand(), (Object)node) && this.isTopLevelInAnnotationOrTypeComment(it)) {
                    return;
                }
            }
            if ((scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node)) instanceof PyClass && this.isDataclass((PyClass)scopeOwner) && this.resolvesToClassVarFinal((psiElement = node.getParent().getParent()) instanceof PyExpression ? (PyExpression)psiElement : null)) {
                return;
            }
            if (PyTypingTypeProvider.isInsideTypeHint((PsiElement)node, this.myTypeEvalContext) && this.resolvesToFinal(node)) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.final.final.could.only.be.used.as.outermost.type", new Object[0]));
            }
        }

        private final void checkFinalInsideLoop(PyLoopStatement loop) {
            loop.acceptChildren(new PyRecursiveElementVisitor(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof ScopeOwner)) {
                        super.visitElement(element);
                    }
                }

                public void visitPyForStatement(PyForStatement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                }

                public void visitPyWhileStatement(PyWhileStatement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                }

                public void visitPyTargetExpression(PyTargetExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Visitor.access$isFinal(this.this$0, node)) {
                        this.this$0.registerProblem(node, PyPsiBundle.message("INSP.final.final.could.not.be.used.inside.loop", new Object[0]));
                    }
                }
            });
        }

        private final boolean isFinal(PyDecoratable decoratable) {
            return PyTypingTypeProvider.isFinal(decoratable, this.myTypeEvalContext);
        }

        private final <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isFinal(T node) {
            return PyTypingTypeProvider.isFinal(node, this.myTypeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean resolvesToFinal(PyExpression expression) {
            boolean bl;
            if (!(expression instanceof PyReferenceExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it, (Object)"typing.Final")) return true;
                if (Intrinsics.areEqual((Object)it, (Object)"typing_extensions.Final")) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean resolvesToClassVar(PyExpression expression) {
            String it;
            if (!(expression instanceof PyReferenceExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual((Object)it, (Object)"typing.ClassVar"));
            return true;
        }

        private final boolean resolvesToClassVarFinal(PyExpression expression) {
            PySubscriptionExpression pySubscriptionExpression;
            PySubscriptionExpression pySubscriptionExpression2 = pySubscriptionExpression = expression instanceof PySubscriptionExpression ? (PySubscriptionExpression)expression : null;
            if (pySubscriptionExpression != null) {
                PySubscriptionExpression it = pySubscriptionExpression;
                boolean bl = false;
                PyExpression pyExpression = it.getOperand();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getOperand(...)");
                if (this.resolvesToClassVar(pyExpression)) {
                    if (it.getIndexExpression() instanceof PySubscriptionExpression) {
                        PyExpression pyExpression2 = it.getIndexExpression();
                        Intrinsics.checkNotNull((Object)pyExpression2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySubscriptionExpression");
                        return this.resolvesToFinal(((PySubscriptionExpression)pyExpression2).getOperand());
                    }
                    return this.resolvesToFinal(it.getIndexExpression());
                }
                return false;
            }
            return false;
        }

        private final boolean isDataclass(PyClass cls) {
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            return PyDataclassesKt.parseDataclassParameters(cls, typeEvalContext) != null;
        }

        private final boolean isTopLevelInAnnotationOrTypeComment(PyExpression node) {
            PsiElement parent = node.getParent();
            if (parent instanceof PyAnnotation) {
                return true;
            }
            if (parent instanceof PyExpressionStatement && ((PyExpressionStatement)parent).getParent() instanceof PyTypeHintFile) {
                return true;
            }
            if (parent instanceof PyParameterTypeList) {
                return true;
            }
            return parent instanceof PyFunctionTypeAnnotation;
        }

        private static final CharSequence visitPyClass$lambda$2$lambda$1(PyClass it) {
            return "'" + it.getName() + "'";
        }

        private static final boolean visitPyClass$lambda$3(Set $visitedNames, Visitor this$0, PyFunction m) {
            if (!$visitedNames.add(m.getName())) {
                Intrinsics.checkNotNull((Object)m);
                if (this$0.isFinal(m)) {
                    this$0.registerProblem(m.getNameIdentifier(), PyPsiBundle.message("INSP.final.final.should.be.placed.on.first.overload", new Object[0]));
                }
            }
            return true;
        }

        private static final boolean visitPyClass$lambda$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$isFinal(Visitor $this, PyAnnotationOwner node) {
            return $this.isFinal(node);
        }
    }
}

