/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.plugin.freeze;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.plugin.freeze.FreezeReason;
import com.intellij.platform.diagnostic.plugin.freeze.PluginFreezeBundle;
import com.intellij.platform.diagnostic.plugin.freeze.PluginFreezeWatcher;
import com.intellij.platform.diagnostic.plugin.freeze.PluginsFreezesService;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0007\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\t\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeNotificationPanel;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "reported", "", "Lcom/intellij/platform/diagnostic/plugin/freeze/FreezeReason;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "reportFreeze", "", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "freezeReason", "ijProject", "", "closePanel", "intellij.platform.diagnostic.freezes"})
public final class PluginFreezeNotificationPanel
implements EditorNotificationProvider {
    @NotNull
    private final Set<FreezeReason> reported;

    public PluginFreezeNotificationPanel() {
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.reported = set;
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.Companion.get("ide.diagnostics.notification.freezes.in.plugins").asBoolean()) {
            return null;
        }
        FreezeReason freezeReason = PluginFreezeWatcher.Companion.getInstance().getFreezeReason();
        if (freezeReason == null) {
            return null;
        }
        FreezeReason freezeReason2 = freezeReason;
        PluginId frozenPlugin = freezeReason2.getPluginId();
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)frozenPlugin);
        if (ideaPluginDescriptor == null) {
            return null;
        }
        IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
        boolean ijProject = IntelliJProjectUtil.isIntelliJPlatformProject((Project)project) || IntelliJProjectUtil.isIntelliJPluginProject((Project)project);
        return arg_0 -> PluginFreezeNotificationPanel.collectNotificationData$lambda$6(pluginDescriptor, this, project, freezeReason2, ijProject, frozenPlugin, arg_0);
    }

    private final void reportFreeze(Project project, PluginDescriptor pluginDescriptor, FreezeReason freezeReason, boolean ijProject) {
        if (this.reported.add(freezeReason)) {
            MessagePool.getInstance().addIdeFatalMessage((AbstractMessage)freezeReason.getEvent());
        }
        MessagePool messagePool = MessagePool.getInstance();
        LogMessage logMessage = freezeReason.getEvent();
        IdeErrorsDialog dialog2 = new IdeErrorsDialog(project, ijProject, pluginDescriptor, this, messagePool, logMessage){
            final /* synthetic */ Project $project;
            final /* synthetic */ PluginDescriptor $pluginDescriptor;
            final /* synthetic */ PluginFreezeNotificationPanel this$0;
            {
                this.$project = $project;
                this.$pluginDescriptor = $pluginDescriptor;
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $project, $ijProject, $super_call_param$2);
            }

            protected void updateOnSubmit() {
                super.updateOnSubmit();
                PluginsFreezesService pluginsFreezesService = PluginsFreezesService.Companion.getInstance();
                PluginId pluginId = this.$pluginDescriptor.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
                pluginsFreezesService.mutePlugin(pluginId);
                LifecycleUsageTriggerCollector.pluginFreezeReported((PluginId)this.$pluginDescriptor.getPluginId());
                PluginFreezeNotificationPanel.access$closePanel(this.this$0, this.$project);
            }
        };
        dialog2.show();
    }

    private final void closePanel(Project project) {
        PluginFreezeWatcher.Companion.getInstance().reset();
        this.reported.clear();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
    }

    private static final void collectNotificationData$lambda$6$lambda$5$lambda$0(PluginFreezeNotificationPanel this$0, Project $project, IdeaPluginDescriptor $pluginDescriptor, FreezeReason $freezeReason, boolean $ijProject) {
        this$0.reportFreeze($project, (PluginDescriptor)$pluginDescriptor, $freezeReason, $ijProject);
    }

    private static final void collectNotificationData$lambda$6$lambda$5$lambda$1(PluginId $frozenPlugin, PluginFreezeNotificationPanel this$0, Project $project) {
        PluginsFreezesService.Companion.getInstance().mutePlugin($frozenPlugin);
        LifecycleUsageTriggerCollector.pluginFreezeIgnored((PluginId)$frozenPlugin);
        this$0.closePanel($project);
    }

    private static final void collectNotificationData$lambda$6$lambda$5$lambda$3(PluginFreezeNotificationPanel this$0, Project $project) {
        this$0.closePanel($project);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$6(IdeaPluginDescriptor $pluginDescriptor, PluginFreezeNotificationPanel this$0, Project $project, FreezeReason $freezeReason, boolean $ijProject, PluginId $frozenPlugin, FileEditor it) {
        String string;
        Object[] objectArray;
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u246_u24lambda_u245 = editorNotificationPanel = new EditorNotificationPanel(EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        String string2 = $pluginDescriptor.getVendor();
        if (string2 == null) {
            string2 = "";
        }
        if (PluginManagerCore.isVendorJetBrains((String)string2)) {
            objectArray = new Object[]{ApplicationInfoImpl.getShadowInstance().getVersionName()};
            string = PluginFreezeBundle.message("notification.content.freeze.detected", objectArray);
        } else {
            objectArray = new Object[]{$pluginDescriptor.getName()};
            string = PluginFreezeBundle.message("notification.content.plugin.caused.freeze", objectArray);
        }
        $this$collectNotificationData_u24lambda_u246_u24lambda_u245.setText(string);
        $this$collectNotificationData_u24lambda_u246_u24lambda_u245.createActionLabel(PluginFreezeBundle.message("action.report.text", new Object[0]), () -> PluginFreezeNotificationPanel.collectNotificationData$lambda$6$lambda$5$lambda$0(this$0, $project, $pluginDescriptor, $freezeReason, $ijProject));
        Object[] $this$collectNotificationData_u24lambda_u246_u24lambda_u245_u24lambda_u242 = objectArray = $this$collectNotificationData_u24lambda_u246_u24lambda_u245.createActionLabel(PluginFreezeBundle.message("action.ignore.plugin.text", new Object[0]), () -> PluginFreezeNotificationPanel.collectNotificationData$lambda$6$lambda$5$lambda$1($frozenPlugin, this$0, $project));
        boolean bl2 = false;
        $this$collectNotificationData_u24lambda_u246_u24lambda_u245_u24lambda_u242.setToolTipText(PluginFreezeBundle.message("action.ignore.plugin.tooltip", new Object[0]));
        Object[] $this$collectNotificationData_u24lambda_u246_u24lambda_u245_u24lambda_u244 = objectArray = $this$collectNotificationData_u24lambda_u246_u24lambda_u245.createActionLabel(PluginFreezeBundle.message("action.close.panel.text", new Object[0]), () -> PluginFreezeNotificationPanel.collectNotificationData$lambda$6$lambda$5$lambda$3(this$0, $project));
        boolean bl3 = false;
        $this$collectNotificationData_u24lambda_u246_u24lambda_u245_u24lambda_u244.setToolTipText(PluginFreezeBundle.message("action.dismiss.tooltip", new Object[0]));
        return editorNotificationPanel;
    }

    public static final /* synthetic */ void access$closePanel(PluginFreezeNotificationPanel $this, Project project) {
        $this.closePanel(project);
    }
}

