/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002\u001a\u001b\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a)\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "POINTS_IN_READONLY_MODE", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "CHECK_CANCELED", "Lkotlin/Function0;", "", "findInsertionIndexForAnyOrder", "", "adapters", "", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "checkThatClassloaderIsActive", "", "adapter", "isInsideClassInitializer", "trace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Z", "getOrCreateExtensionInstance", "T", "", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "(Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;Lcom/intellij/openapi/components/ComponentManager;)Ljava/lang/Object;", "intellij.platform.extensions"})
@SourceDebugExtension(value={"SMAP\nExtensionPointImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionPointImplKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1073:1\n12567#2,2:1074\n62#3,5:1076\n15#3:1081\n*S KotlinDebug\n*F\n+ 1 ExtensionPointImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionPointImplKt\n*L\n1047#1:1074,2\n1061#1:1076,5\n36#1:1081\n*E\n"})
public final class ExtensionPointImplKt {
    @NotNull
    private static final Logger LOG;
    @Nullable
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    @Nullable
    private static Function0<Unit> CHECK_CANCELED;

    private static final int findInsertionIndexForAnyOrder(List<? extends ExtensionComponentAdapter> adapters) {
        ExtensionComponentAdapter lastAdapter;
        int index;
        for (index = adapters.size(); index > 0 && (lastAdapter = adapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
        }
        return index;
    }

    private static final boolean checkThatClassloaderIsActive(ExtensionComponentAdapter adapter) {
        ClassLoader classLoader = adapter.pluginDescriptor.getPluginClassLoader();
        if (classLoader instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)classLoader)).getState() != 1) {
            LOG.warn(adapter + " not loaded because classloader is being unloaded");
            return false;
        }
        return true;
    }

    private static final boolean isInsideClassInitializer(StackTraceElement[] trace) {
        boolean bl;
        block1: {
            StackTraceElement[] $this$any$iv = trace;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)"<clinit>", (Object)it.getMethodName())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final <T> T getOrCreateExtensionInstance(ExtensionComponentAdapter adapter, ComponentManager componentManager) {
        if (!ExtensionPointImplKt.checkThatClassloaderIsActive(adapter)) {
            return null;
        }
        try {
            Object instance2 = adapter.createInstance(componentManager);
            if (instance2 == null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(adapter + " not loaded because it reported that not applicable", e$iv);
                }
            }
            return instance2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Throwable)componentManager.createError(e, adapter.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    public static final /* synthetic */ void access$setCHECK_CANCELED$p(Function0 function0) {
        CHECK_CANCELED = function0;
    }

    public static final /* synthetic */ boolean access$isInsideClassInitializer(StackTraceElement[] trace) {
        return ExtensionPointImplKt.isInsideClassInitializer(trace);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Object access$getOrCreateExtensionInstance(ExtensionComponentAdapter adapter, ComponentManager componentManager) {
        return ExtensionPointImplKt.getOrCreateExtensionInstance(adapter, componentManager);
    }

    public static final /* synthetic */ Function0 access$getCHECK_CANCELED$p() {
        return CHECK_CANCELED;
    }

    public static final /* synthetic */ boolean access$checkThatClassloaderIsActive(ExtensionComponentAdapter adapter) {
        return ExtensionPointImplKt.checkThatClassloaderIsActive(adapter);
    }

    public static final /* synthetic */ Set access$getPOINTS_IN_READONLY_MODE$p() {
        return POINTS_IN_READONLY_MODE;
    }

    public static final /* synthetic */ void access$setPOINTS_IN_READONLY_MODE$p(Set set) {
        POINTS_IN_READONLY_MODE = set;
    }

    public static final /* synthetic */ int access$findInsertionIndexForAnyOrder(List adapters) {
        return ExtensionPointImplKt.findInsertionIndexForAnyOrder(adapters);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExtensionPointImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

