/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.plugins;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnableStateChangedListener;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.settingsSync.core.RestartForPluginDisable;
import com.intellij.settingsSync.core.RestartForPluginEnable;
import com.intellij.settingsSync.core.RestartReason;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotKt;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.core.SettingsSynchronizerKt;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.intellij.settingsSync.core.plugins.PluginManagerProxy;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginCategoryFinder;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginsState;
import java.nio.file.FileVisitResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 J2\u00020\u0001:\u0003HIJB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b\u001eJ$\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020$0\u0010H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015H\u0002J8\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u000e2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020-0\u00102\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020-0\u0010H\u0002J\u001c\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0002J \u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u000e\u00101\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0002J!\u00103\u001a\u00020-2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u00104\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u00108J\u001e\u00109\u001a\u00020(2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010:\u001a\u00020 H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\"2\u0006\u0010<\u001a\u00020\u000eH\u0002J\u0018\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020-H\u0002J\u0010\u0010@\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010A\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010A\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00112\u0006\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020\u0013H\u0002J\b\u0010D\u001a\u00020(H\u0016J\r\u0010E\u001a\u00020FH\u0001\u00a2\u0006\u0002\bGR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00130\u00120\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u001aj\b\u0012\u0004\u0012\u00020\u000e`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager;", "Lcom/intellij/openapi/Disposable;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "pluginInstallationStateListener", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager$PluginInstallationStateListener;", "pluginEnabledStateListener", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager$PluginEnabledStateListener;", "LOCK", "Ljava/lang/Object;", "PLUGIN_EXCEPTIONS", "", "", "PLUGIN_DEPENDENCIES", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lkotlin/Pair;", "Lcom/intellij/openapi/components/SettingsCategory;", "value", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;", "state", "getState$intellij_settingsSync_core", "()Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;", "sessionUninstalledPlugins", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "updateStateFromIdeOnStart", "lastSavedPluginsState", "updateStateFromIdeOnStart$intellij_settingsSync_core", "isUltimate", "", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "pluginIdMap", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "isPluginSynceable", "pluginId", "firePluginsStateChangeEvent", "", "pluginsState", "logChangedState", "message", "oldPlugins", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState$PluginData;", "newPlugins", "getLineIfNotEmpty", "prefix", "plugins", "", "getPluginData", "explicitEnabled", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/lang/Boolean;)Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState$PluginData;", "pushChangesToIde", "newState", "(Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changePluginsStateAndReport", "enable", "findPlugin", "idString", "checkDependencies", "id", "pluginState", "shouldSaveState", "isPluginSyncEnabled", "isBundled", "category", "dispose", "getPluginStateListener", "Lcom/intellij/ide/plugins/PluginStateListener;", "getPluginStateListener$intellij_settingsSync_core", "PluginInstallationStateListener", "PluginEnabledStateListener", "Companion", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncPluginManager.kt\ncom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,421:1\n11158#2:422\n11493#2,3:423\n535#3:426\n520#3,6:427\n535#3:433\n520#3,6:434\n535#3:440\n520#3,6:441\n126#4:447\n153#4,3:448\n774#5:451\n865#5,2:452\n1557#5:454\n1628#5,3:455\n1#6:458\n15#7:459\n*S KotlinDebug\n*F\n+ 1 SettingsSyncPluginManager.kt\ncom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager\n*L\n62#1:422\n62#1:423,3\n154#1:426\n154#1:427,6\n158#1:433\n158#1:434,6\n161#1:440\n161#1:441,6\n165#1:447\n165#1:448,3\n190#1:451\n190#1:452,2\n190#1:454\n190#1:455,3\n419#1:459\n*E\n"})
public final class SettingsSyncPluginManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final PluginInstallationStateListener pluginInstallationStateListener;
    @NotNull
    private final PluginEnabledStateListener pluginEnabledStateListener;
    @NotNull
    private final Object LOCK;
    @NotNull
    private final Set<String> PLUGIN_EXCEPTIONS;
    @NotNull
    private final Map<PluginId, Set<Pair<PluginId, SettingsCategory>>> PLUGIN_DEPENDENCIES;
    @NotNull
    private SettingsSyncPluginsState state;
    @NotNull
    private final HashSet<String> sessionUninstalledPlugins;
    @NotNull
    private static final Logger LOG;

    public SettingsSyncPluginManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.pluginInstallationStateListener = new PluginInstallationStateListener();
        this.pluginEnabledStateListener = new PluginEnabledStateListener();
        this.LOCK = new Object();
        Object[] objectArray = new String[]{"com.intellij.ja", "com.intellij.ko", "com.intellij.zh", "com.intellij.marketplace", PluginManagerCore.ULTIMATE_PLUGIN_ID.getIdString()};
        this.PLUGIN_EXCEPTIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)PluginId.getId((String)"Pythonid"), (Object)SetsKt.setOf((Object)TuplesKt.to((Object)PluginId.getId((String)"PythonCore"), (Object)SettingsCategory.PLUGINS))), TuplesKt.to((Object)PluginId.getId((String)"intellij.jupyter"), (Object)SetsKt.setOf((Object)TuplesKt.to((Object)PluginId.getId((String)"com.intellij.notebooks.core"), (Object)SettingsCategory.PLUGINS))), TuplesKt.to((Object)PluginId.getId((String)"R4Intellij"), (Object)SetsKt.setOf((Object)TuplesKt.to((Object)PluginId.getId((String)"com.intellij.notebooks.core"), (Object)SettingsCategory.PLUGINS)))};
        this.PLUGIN_DEPENDENCIES = MapsKt.mapOf((Pair[])objectArray);
        this.state = new SettingsSyncPluginsState(MapsKt.emptyMap());
        this.sessionUninstalledPlugins = new HashSet();
        PluginStateManager.addStateListener((PluginStateListener)this.pluginInstallationStateListener);
        PluginManagerProxy.Companion.getInstance().addPluginStateChangedListener(this.pluginEnabledStateListener, this);
    }

    @NotNull
    public final SettingsSyncPluginsState getState$intellij_settingsSync_core() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final SettingsSyncPluginsState updateStateFromIdeOnStart$intellij_settingsSync_core(@Nullable SettingsSyncPluginsState lastSavedPluginsState) {
        Object object = this.LOCK;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            IdeaPluginDescriptor[] currentIdePlugins;
            boolean bl = false;
            IdeaPluginDescriptor[] $this$map$iv = currentIdePlugins = PluginManagerProxy.Companion.getInstance().getPlugins();
            boolean $i$f$map = false;
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getPluginId());
            }
            Set currentIdePluginIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Object object2 = lastSavedPluginsState;
            if (object2 == null || (object2 = ((SettingsSyncPluginsState)object2).getPlugins()) == null) {
                object2 = MapsKt.emptyMap();
            }
            Object oldPlugins = object2;
            Map newPlugins = MapsKt.toMutableMap((Map)oldPlugins);
            Set removedPluginIds = SetsKt.minus(newPlugins.keySet(), (Iterable)currentIdePluginIds);
            ArrayList<PluginId> removed2disable = new ArrayList<PluginId>();
            ArrayList<PluginId> removed2ignore = new ArrayList<PluginId>();
            if (!((Collection)removedPluginIds).isEmpty()) {
                LOG.info("Plugins " + CollectionsKt.joinToString$default((Iterable)removedPluginIds, null, null, null, (int)0, null, null, (int)63, null) + " have been deleted from disk");
                for (PluginId pluginId : removedPluginIds) {
                    boolean bl3;
                    SettingsSyncPluginsState.PluginData pluginData;
                    if ((SettingsSyncPluginsState.PluginData)newPlugins.get(pluginId) == null) continue;
                    if (this.checkDependencies(pluginId, pluginData) && this.isPluginSynceable(pluginId)) {
                        newPlugins.computeIfPresent(pluginId, (arg_0, arg_1) -> SettingsSyncPluginManager.updateStateFromIdeOnStart$lambda$3$lambda$2(SettingsSyncPluginManager::updateStateFromIdeOnStart$lambda$3$lambda$1, arg_0, arg_1));
                        bl3 = removed2disable.add(pluginId);
                        continue;
                    }
                    bl3 = removed2ignore.add(pluginId);
                }
                if (!((Collection)removed2disable).isEmpty()) {
                    LOG.info("Will mark compatible plugin(s) " + CollectionsKt.joinToString$default((Iterable)removed2disable, null, null, null, (int)0, null, null, (int)63, null) + " as disabled in setting sync");
                }
                if (!((Collection)removed2ignore).isEmpty()) {
                    LOG.info("Plugins " + CollectionsKt.joinToString$default((Iterable)removed2ignore, null, null, null, (int)0, null, null, (int)63, null) + " are incompatible with current IDE/version. Won't change their sync status in plugins.json");
                }
            }
            Map pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
            for (IdeaPluginDescriptor plugin : currentIdePlugins) {
                PluginId id;
                Intrinsics.checkNotNullExpressionValue((Object)plugin.getPluginId(), (String)"getPluginId(...)");
                if (!this.isPluginSynceable(id) || PluginManagerProxy.Companion.getInstance().isIncompatible(plugin)) {
                    LOG.info("Plugin " + id + " is not syncable!");
                    continue;
                }
                if (PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID) && this.isUltimate(plugin, pluginIdMap)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skipped syncing ultimate plugin " + plugin.getPluginId());
                    continue;
                }
                if (this.shouldSaveState(plugin)) {
                    newPlugins.put(id, SettingsSyncPluginManager.getPluginData$default(this, plugin, null, 2, null));
                    continue;
                }
                newPlugins.remove(id);
            }
            this.logChangedState("Updated component state by the state of IDE.", (Map<PluginId, SettingsSyncPluginsState.PluginData>)oldPlugins, newPlugins);
            SettingsSyncPluginsState settingsSyncPluginsState = this.state = new SettingsSyncPluginsState(newPlugins);
            return settingsSyncPluginsState;
        }
    }

    private final boolean isUltimate(IdeaPluginDescriptor plugin, Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        Ref.BooleanRef isUltimate = new Ref.BooleanRef();
        Intrinsics.checkNotNull((Object)plugin, (String)"null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
        PluginManagerCore.INSTANCE.processAllNonOptionalDependencyIds((IdeaPluginDescriptorImpl)plugin, pluginIdMap, arg_0 -> SettingsSyncPluginManager.isUltimate$lambda$4(isUltimate, arg_0));
        return isUltimate.element;
    }

    private final boolean isPluginSynceable(PluginId pluginId) {
        return !PluginManagerProxy.Companion.getInstance().isEssential(pluginId) && !this.PLUGIN_EXCEPTIONS.contains(pluginId.getIdString());
    }

    private final void firePluginsStateChangeEvent(SettingsSyncPluginsState pluginsState) {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        SettingsSnapshot snapshot = new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), SetsKt.emptySet(), pluginsState, MapsKt.emptyMap(), SetsKt.emptySet());
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.IdeChange(snapshot));
    }

    /*
     * WARNING - void declaration
     */
    private final void logChangedState(String message, Map<PluginId, SettingsSyncPluginsState.PluginData> oldPlugins, Map<PluginId, SettingsSyncPluginsState.PluginData> newPlugins) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Map<PluginId, SettingsSyncPluginsState.PluginData> $this$filter$iv = newPlugins;
        boolean $i$f$filter = false;
        Map<PluginId, SettingsSyncPluginsState.PluginData> map = $this$filter$iv;
        Map<PluginId, SettingsSyncPluginsState.PluginData> destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl = false;
            PluginId newKey = (PluginId)entry2.getKey();
            SettingsSyncPluginsState.PluginData newData = (SettingsSyncPluginsState.PluginData)entry2.getValue();
            SettingsSyncPluginsState.PluginData oldData = oldPlugins.get(newKey);
            if (!(oldData != null && oldData.getEnabled() != newData.getEnabled())) continue;
            destination$iv$iv.put((PluginId)entry.getKey(), (SettingsSyncPluginsState.PluginData)entry.getValue());
        }
        Map<PluginId, SettingsSyncPluginsState.PluginData> pluginsWithEnabledStateChanged = destination$iv$iv;
        Map<PluginId, SettingsSyncPluginsState.PluginData> $this$filter$iv2 = newPlugins;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Map<PluginId, SettingsSyncPluginsState.PluginData> destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry bl = entry = iterator2.next();
            boolean bl2 = false;
            PluginId newKey = (PluginId)bl.getKey();
            SettingsSyncPluginsState.PluginData newData = (SettingsSyncPluginsState.PluginData)bl.getValue();
            if (!Intrinsics.areEqual((Object)oldPlugins.get(newKey), (Object)newData)) continue;
            destination$iv$iv2.put((PluginId)entry.getKey(), (SettingsSyncPluginsState.PluginData)entry.getValue());
        }
        Map<PluginId, SettingsSyncPluginsState.PluginData> pluginsWithNoChanges = destination$iv$iv2;
        Map<PluginId, SettingsSyncPluginsState.PluginData> $this$filter$iv3 = newPlugins;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Map<PluginId, SettingsSyncPluginsState.PluginData> destination$iv$iv3 = new LinkedHashMap();
        boolean bl = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv4;
            Map.Entry bl2 = element$iv$iv4 = iterator3.next();
            boolean bl3 = false;
            PluginId newKey = (PluginId)bl2.getKey();
            SettingsSyncPluginsState.PluginData newData = (SettingsSyncPluginsState.PluginData)bl2.getValue();
            SettingsSyncPluginsState.PluginData oldData = oldPlugins.get(newKey);
            if (!(oldData != null && !Intrinsics.areEqual((Object)oldData, (Object)newData) && oldData.getEnabled() == newData.getEnabled())) continue;
            destination$iv$iv3.put((PluginId)element$iv$iv4.getKey(), (SettingsSyncPluginsState.PluginData)element$iv$iv4.getValue());
        }
        Map<PluginId, SettingsSyncPluginsState.PluginData> pluginsWithOtherChanges = destination$iv$iv3;
        Map<PluginId, SettingsSyncPluginsState.PluginData> $this$map$iv = pluginsWithEnabledStateChanged;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection collection = new ArrayList($this$map$iv.size());
        boolean bl4 = false;
        Iterator iterator4 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator4.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator4.next();
            Collection collection2 = collection;
            boolean bl5 = false;
            PluginId id = (PluginId)entry.getKey();
            SettingsSyncPluginsState.PluginData pluginData = oldPlugins.get(id);
            SettingsSyncPluginsState.PluginData pluginData2 = newPlugins.get(id);
            collection2.add(id + ": " + SettingsSynchronizerKt.enabledOrDisabled(pluginData != null ? Boolean.valueOf(pluginData.getEnabled()) : null) + " -> " + SettingsSynchronizerKt.enabledOrDisabled(pluginData2 != null ? Boolean.valueOf(pluginData2.getEnabled()) : null));
        }
        List enabledStateChanges = (List)collection;
        Set addedPlugins = SetsKt.minus(newPlugins.keySet(), (Iterable)oldPlugins.keySet());
        Set removedPlugins = SetsKt.minus(oldPlugins.keySet(), (Iterable)newPlugins.keySet());
        LOG.info(message + "\n" + this.getLineIfNotEmpty("Added", addedPlugins) + this.getLineIfNotEmpty("Removed", removedPlugins) + this.getLineIfNotEmpty("Changed enabled state", enabledStateChanges) + this.getLineIfNotEmpty("No changes", pluginsWithNoChanges) + this.getLineIfNotEmpty("Other changes", pluginsWithOtherChanges));
    }

    private final String getLineIfNotEmpty(String prefix, Collection<?> plugins) {
        return !plugins.isEmpty() ? prefix + ": " + plugins + "\n" : "";
    }

    private final String getLineIfNotEmpty(String prefix, Map<?, ?> plugins) {
        return !plugins.isEmpty() ? prefix + ": " + plugins + "\n" : "";
    }

    /*
     * WARNING - void declaration
     */
    private final SettingsSyncPluginsState.PluginData getPluginData(IdeaPluginDescriptor plugin, Boolean explicitEnabled) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IdeaPluginDependency it;
        void $this$filterTo$iv$iv;
        boolean isEnabled = explicitEnabled != null ? explicitEnabled : plugin.isEnabled() && !this.sessionUninstalledPlugins.contains(plugin.getPluginId().getIdString());
        List list = plugin.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDependency)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOptional())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeaPluginDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPluginId().getIdString());
        }
        Set dependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new SettingsSyncPluginsState.PluginData(isEnabled, SettingsSyncPluginCategoryFinder.INSTANCE.getPluginCategory(plugin), dependencies);
    }

    static /* synthetic */ SettingsSyncPluginsState.PluginData getPluginData$default(SettingsSyncPluginManager settingsSyncPluginManager, IdeaPluginDescriptor ideaPluginDescriptor, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return settingsSyncPluginManager.getPluginData(ideaPluginDescriptor, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object pushChangesToIde(@NotNull SettingsSyncPluginsState newState, @NotNull Continuation<? super Unit> $completion) {
        Set pluginsToDisable = new LinkedHashSet();
        Set pluginsToEnable = new LinkedHashSet();
        List pluginsToInstall = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Map<PluginId, SettingsSyncPluginsState.PluginData> oldPlugins = this.state.getPlugins();
            Map<PluginId, SettingsSyncPluginsState.PluginData> newPlugins = newState.getPlugins();
            this.logChangedState("Pushed new changes to the IDE", oldPlugins, newPlugins);
            this.state = new SettingsSyncPluginsState(newPlugins);
            Set removedPluginData = SetsKt.minus(oldPlugins.keySet(), (Iterable)newPlugins.keySet());
            for (PluginId entry : removedPluginData) {
                IdeaPluginDescriptor plugin = PluginManagerProxy.Companion.getInstance().findPlugin(entry);
                if (plugin == null || !this.isPluginSyncEnabled(plugin) || !plugin.isBundled() || plugin.isEnabled()) continue;
                ((Collection)pluginsToEnable).add(plugin.getPluginId());
            }
            for (Map.Entry entry : newPlugins.entrySet()) {
                PluginId pluginId = (PluginId)entry.getKey();
                SettingsSyncPluginsState.PluginData pluginData = (SettingsSyncPluginsState.PluginData)entry.getValue();
                IdeaPluginDescriptor plugin = PluginManagerProxy.Companion.getInstance().findPlugin(pluginId);
                if (plugin != null) {
                    SettingsSyncPluginsState.PluginData oldData;
                    if (!this.isPluginSyncEnabled(plugin) || (oldData = oldPlugins.get(pluginId)) != null && pluginData.getEnabled() == oldData.getEnabled()) continue;
                    if (pluginData.getEnabled()) {
                        ((Collection)pluginsToEnable).add(pluginId);
                        continue;
                    }
                    ((Collection)pluginsToDisable).add(pluginId);
                    continue;
                }
                if (pluginData.getEnabled() && this.isPluginSyncEnabled(pluginId, false, pluginData.getCategory()) && this.checkDependencies(pluginId, pluginData)) {
                    if (this.PLUGIN_DEPENDENCIES.get(pluginId) != null) {
                        Set<Pair<PluginId, SettingsCategory>> set = this.PLUGIN_DEPENDENCIES.get(pluginId);
                        Intrinsics.checkNotNull(set);
                        for (Pair<PluginId, SettingsCategory> depPluginPair : set) {
                            PluginId depPluginId = (PluginId)depPluginPair.getFirst();
                            if (PluginManagerProxy.Companion.getInstance().findPlugin(depPluginId) != null) continue;
                            LOG.info("Installation of '" + pluginId + "' requires '" + depPluginId + "' that is not installed");
                            if (this.isPluginSyncEnabled(depPluginId, false, (SettingsCategory)depPluginPair.getSecond())) {
                                ((Collection)pluginsToInstall).add(depPluginId);
                                continue;
                            }
                            LOG.warn("Syncing of '" + depPluginId + "' required of '" + pluginId + "' is disabled! The plugin will fail to start");
                        }
                    }
                    ((Collection)pluginsToInstall).add(pluginId);
                }
                if (!oldPlugins.containsKey(pluginId)) continue;
                LOG.warn("Plugin " + pluginId + " was in the state but not installed");
            }
            Unit unit = Unit.INSTANCE;
        }
        this.changePluginsStateAndReport(pluginsToDisable, false);
        this.changePluginsStateAndReport(pluginsToEnable, true);
        LOG.info("Installing plugins: " + pluginsToInstall);
        Object object2 = PluginManagerProxy.createInstaller$default(PluginManagerProxy.Companion.getInstance(), false, 1, null).installPlugins(pluginsToInstall, $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private final void changePluginsStateAndReport(Set<PluginId> plugins, boolean enable) {
        if (plugins.isEmpty()) {
            return;
        }
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> SettingsSyncPluginManager.changePluginsStateAndReport$lambda$12(enable, plugins), (int)1, null);
    }

    private final IdeaPluginDescriptor findPlugin(String idString) {
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId = PluginId.findId((String)idString);
        if (pluginId != null) {
            PluginId it = pluginId;
            boolean bl = false;
            ideaPluginDescriptor = PluginManagerProxy.Companion.getInstance().findPlugin(it);
        } else {
            ideaPluginDescriptor = null;
        }
        return ideaPluginDescriptor;
    }

    private final boolean checkDependencies(PluginId id, SettingsSyncPluginsState.PluginData pluginState) {
        for (String dependency : pluginState.getDependencies()) {
            if (this.findPlugin(dependency) != null) continue;
            LOG.info("Skipping " + id + " plugin installation due to missing dependency: " + dependency);
            return false;
        }
        return true;
    }

    private final boolean shouldSaveState(IdeaPluginDescriptor plugin) {
        return this.isPluginSyncEnabled(plugin) && (!plugin.isBundled() || !plugin.isEnabled());
    }

    private final boolean isPluginSyncEnabled(IdeaPluginDescriptor plugin) {
        PluginId pluginId = plugin.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        return this.isPluginSyncEnabled(pluginId, plugin.isBundled(), SettingsSyncPluginCategoryFinder.INSTANCE.getPluginCategory(plugin));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPluginSyncEnabled(PluginId id, boolean isBundled, SettingsCategory category) {
        if (!this.isPluginSynceable(id)) {
            return false;
        }
        SettingsSyncSettings settings = SettingsSyncSettings.Companion.getInstance();
        if (!settings.isCategoryEnabled(category)) return false;
        if (category != SettingsCategory.PLUGINS) return true;
        if (isBundled) {
            if (settings.isSubcategoryEnabled(SettingsCategory.PLUGINS, "bundled")) return true;
        }
        if (isBundled) return false;
        String string = id.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
        if (!settings.isSubcategoryEnabled(SettingsCategory.PLUGINS, string)) return false;
        return true;
    }

    public void dispose() {
        PluginStateManager.removeStateListener((PluginStateListener)this.pluginInstallationStateListener);
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
    }

    @TestOnly
    @NotNull
    public final PluginStateListener getPluginStateListener$intellij_settingsSync_core() {
        return this.pluginInstallationStateListener;
    }

    private static final SettingsSyncPluginsState.PluginData updateStateFromIdeOnStart$lambda$3$lambda$1(PluginId pluginId, SettingsSyncPluginsState.PluginData data) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new SettingsSyncPluginsState.PluginData(false, data.getCategory(), data.getDependencies());
    }

    private static final SettingsSyncPluginsState.PluginData updateStateFromIdeOnStart$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (SettingsSyncPluginsState.PluginData)$tmp0.invoke(p0, p1);
    }

    private static final FileVisitResult isUltimate$lambda$4(Ref.BooleanRef $isUltimate, PluginId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it, (Object)PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            $isUltimate.element = true;
        }
        return $isUltimate.element ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    private static final Unit changePluginsStateAndReport$lambda$12(boolean $enable, Set $plugins) {
        String actionName = $enable ? "enable" : "disable";
        try {
            boolean result2;
            LOG.info("Going to " + actionName + " plugins: " + $plugins);
            boolean bl = result2 = $enable ? PluginManagerProxy.Companion.getInstance().enablePlugins($plugins) : PluginManagerProxy.Companion.getInstance().disablePlugins($plugins);
            if (!result2) {
                List pluginsReqRestart = new ArrayList();
                for (PluginId pluginId : $plugins) {
                    IdeaPluginDescriptor plugin;
                    if (PluginManagerProxy.Companion.getInstance().findPlugin(pluginId) == null || plugin.isEnabled() == $enable) continue;
                    String string = plugin.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    pluginsReqRestart.add(string);
                }
                LOG.warn("The " + actionName + " for the following plugins require restart: " + CollectionsKt.joinToString$default((Iterable)pluginsReqRestart, null, null, null, (int)0, null, null, (int)63, null));
                RestartReason restartReason = $enable ? (RestartReason)new RestartForPluginEnable(pluginsReqRestart) : (RestartReason)new RestartForPluginDisable(pluginsReqRestart);
                SettingsSyncEvents.Companion.getInstance().fireRestartRequired(restartReason);
            }
        }
        catch (Exception ex) {
            LOG.warn("An exception occurred while " + actionName + " plugins: " + $plugins, (Throwable)ex);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isPluginSyncEnabled(SettingsSyncPluginManager $this, IdeaPluginDescriptor plugin) {
        return $this.isPluginSyncEnabled(plugin);
    }

    public static final /* synthetic */ SettingsSyncPluginsState.PluginData access$getPluginData(SettingsSyncPluginManager $this, IdeaPluginDescriptor plugin, Boolean explicitEnabled) {
        return $this.getPluginData(plugin, explicitEnabled);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncPluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SettingsSyncPluginManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(SettingsSyncPluginManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SettingsSyncPluginManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager$PluginEnabledStateListener;", "Lcom/intellij/ide/plugins/PluginEnableStateChangedListener;", "<init>", "(Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager;)V", "ed", "", "b", "", "stateChanged", "", "pluginDescriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enable", "intellij.settingsSync.core"})
    private final class PluginEnabledStateListener
    implements PluginEnableStateChangedListener {
        private final String ed(boolean b) {
            return b ? "enable" : "disable";
        }

        public void stateChanged(@NotNull Collection<? extends IdeaPluginDescriptor> pluginDescriptors, boolean enable) {
            Intrinsics.checkNotNullParameter(pluginDescriptors, (String)"pluginDescriptors");
            BuildersKt.launch$default((CoroutineScope)SettingsSyncPluginManager.this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(SettingsSyncPluginManager.this, pluginDescriptors, this, enable, null){
                int label;
                final /* synthetic */ SettingsSyncPluginManager this$0;
                final /* synthetic */ Collection<IdeaPluginDescriptor> $pluginDescriptors;
                final /* synthetic */ PluginEnabledStateListener this$1;
                final /* synthetic */ boolean $enable;
                {
                    this.this$0 = $receiver;
                    this.$pluginDescriptors = $pluginDescriptors;
                    this.this$1 = $receiver2;
                    this.$enable = $enable;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Object object2 = SettingsSyncPluginManager.access$getLOCK$p(this.this$0);
                            SettingsSyncPluginManager settingsSyncPluginManager = this.this$0;
                            Collection<IdeaPluginDescriptor> collection = this.$pluginDescriptors;
                            PluginEnabledStateListener pluginEnabledStateListener = this.this$1;
                            boolean bl = this.$enable;
                            Object object3 = object2;
                            synchronized (object3) {
                                boolean bl2 = false;
                                Map<PluginId, SettingsSyncPluginsState.PluginData> oldPlugins = settingsSyncPluginManager.getState$intellij_settingsSync_core().getPlugins();
                                Map newPlugins = MapsKt.toMutableMap(oldPlugins);
                                for (IdeaPluginDescriptor pluginDescriptor : collection) {
                                    PluginManagerProxy pluginManagerProxy = PluginManagerProxy.Companion.getInstance();
                                    PluginId pluginId = pluginDescriptor.getPluginId();
                                    Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
                                    IdeaPluginDescriptor plugin = pluginManagerProxy.findPlugin(pluginId);
                                    if (plugin == null) {
                                        SettingsSyncPluginManager.access$getLOG$cp().warn("got " + PluginEnabledStateListener.access$ed(pluginEnabledStateListener, bl) + " info about non-existing plugin " + pluginDescriptor.getPluginId());
                                        continue;
                                    }
                                    if (!SettingsSyncPluginManager.access$isPluginSyncEnabled(settingsSyncPluginManager, plugin)) {
                                        SettingsSyncPluginManager.access$getLOG$cp().info("Sync of state of " + plugin.getPluginId() + " is disabled. Won't touch its info in plugins.json");
                                        continue;
                                    }
                                    if (plugin.isEnabled() != bl) {
                                        SettingsSyncPluginManager.access$getLOG$cp().info("State of plugin " + pluginDescriptor.getPluginId() + " is inconsistent: received " + PluginEnabledStateListener.access$ed(pluginEnabledStateListener, bl) + " event, but plugin is " + PluginEnabledStateListener.access$ed(pluginEnabledStateListener, plugin.isEnabled()) + "d. Probably, a restart is required.");
                                    }
                                    if (plugin.isBundled() && bl) {
                                        newPlugins.remove(pluginDescriptor.getPluginId());
                                        SettingsSyncPluginManager.access$getLOG$cp().info("Bundled plugin " + pluginDescriptor.getPluginId() + " is " + PluginEnabledStateListener.access$ed(pluginEnabledStateListener, bl) + "d. Will remove its info from plugins.json");
                                        continue;
                                    }
                                    newPlugins.put(pluginDescriptor.getPluginId(), SettingsSyncPluginManager.access$getPluginData(settingsSyncPluginManager, pluginDescriptor, Boxing.boxBoolean((bl ? 1 : 0) != 0)));
                                    SettingsSyncPluginManager.access$getLOG$cp().info((plugin.isBundled() ? "Bundled " : "") + "Plugin " + pluginDescriptor.getPluginId() + " is " + PluginEnabledStateListener.access$ed(pluginEnabledStateListener, bl) + "d");
                                }
                                if (!Intrinsics.areEqual(oldPlugins, (Object)newPlugins)) {
                                    SettingsSyncPluginManager.access$setState$p(settingsSyncPluginManager, new SettingsSyncPluginsState(MapsKt.toMap((Map)newPlugins)));
                                    SettingsSyncPluginManager.access$firePluginsStateChangeEvent(settingsSyncPluginManager, settingsSyncPluginManager.getState$intellij_settingsSync_core());
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ String access$ed(PluginEnabledStateListener $this, boolean b) {
            return $this.ed(b);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager$PluginInstallationStateListener;", "Lcom/intellij/ide/plugins/PluginStateListener;", "<init>", "(Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginManager;)V", "install", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "uninstall", "intellij.settingsSync.core"})
    private final class PluginInstallationStateListener
    implements PluginStateListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void install(@NotNull IdeaPluginDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PluginId pluginId = descriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            PluginId pluginId2 = pluginId;
            LOG.info("Installed plugin " + pluginId2.getIdString());
            Object object = SettingsSyncPluginManager.this.LOCK;
            SettingsSyncPluginManager settingsSyncPluginManager = SettingsSyncPluginManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                settingsSyncPluginManager.sessionUninstalledPlugins.remove(pluginId2.getIdString());
                if (settingsSyncPluginManager.shouldSaveState(descriptor)) {
                    Map<PluginId, SettingsSyncPluginsState.PluginData> oldPlugins = settingsSyncPluginManager.getState$intellij_settingsSync_core().getPlugins();
                    Map newPlugins = MapsKt.plus(oldPlugins, (Pair)TuplesKt.to((Object)pluginId2, (Object)SettingsSyncPluginManager.getPluginData$default(settingsSyncPluginManager, descriptor, null, 2, null)));
                    settingsSyncPluginManager.state = new SettingsSyncPluginsState(newPlugins);
                    settingsSyncPluginManager.firePluginsStateChangeEvent(settingsSyncPluginManager.getState$intellij_settingsSync_core());
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PluginId pluginId = descriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            PluginId pluginId2 = pluginId;
            LOG.info("Uninstalled plugin " + pluginId2);
            Object object = SettingsSyncPluginManager.this.LOCK;
            SettingsSyncPluginManager settingsSyncPluginManager = SettingsSyncPluginManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                settingsSyncPluginManager.sessionUninstalledPlugins.add(pluginId2.getIdString());
                if (settingsSyncPluginManager.shouldSaveState(descriptor)) {
                    Map<PluginId, SettingsSyncPluginsState.PluginData> oldPlugins = settingsSyncPluginManager.getState$intellij_settingsSync_core().getPlugins();
                    Map newPlugins = MapsKt.plus(oldPlugins, (Pair)TuplesKt.to((Object)pluginId2, (Object)SettingsSyncPluginManager.getPluginData$default(settingsSyncPluginManager, descriptor, null, 2, null)));
                    settingsSyncPluginManager.state = new SettingsSyncPluginsState(newPlugins);
                    settingsSyncPluginManager.firePluginsStateChangeEvent(settingsSyncPluginManager.getState$intellij_settingsSync_core());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

