/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeRectProvider;
import com.intellij.ui.BadgeShapeProvider;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.BadgeDotProviderModel;
import com.jetbrains.rd.ide.model.BadgeIconModel;
import com.jetbrains.rd.ide.model.BadgeRectProviderModel;
import com.jetbrains.rd.ide.model.BadgeShapeProviderModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.UtilKt;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/BadgeIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/BadgeIcon;", "Lcom/jetbrains/rd/ide/model/BadgeIconModel;", "<init>", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nBadgeIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadgeIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/BadgeIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n25#2:50\n25#2:51\n*S KotlinDebug\n*F\n+ 1 BadgeIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/BadgeIconConverter\n*L\n28#1:50\n43#1:51\n*E\n"})
public final class BadgeIconConverter
implements ProtocolIconConverter<BadgeIcon, BadgeIconModel> {
    @Override
    @Nullable
    public Icon createIcon(@NotNull BadgeIconModel model, @NotNull ProtocolIconRegistry registry) {
        BadgeShapeProvider badgeShapeProvider;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Icon icon = UtilKt.fromModel(model.getIcon());
        Color color = ColorHostKt.toColor(model.getColor());
        BadgeShapeProviderModel it = model.getProvider();
        if (it instanceof BadgeDotProviderModel) {
            badgeShapeProvider = (BadgeShapeProvider)new BadgeDotProvider(((BadgeDotProviderModel)it).getX(), ((BadgeDotProviderModel)it).getY(), ((BadgeDotProviderModel)it).getRadius(), it.getBorder());
        } else if (it instanceof BadgeRectProviderModel) {
            badgeShapeProvider = (BadgeShapeProvider)new BadgeRectProvider(((BadgeRectProviderModel)it).getArc(), ((BadgeRectProviderModel)it).getTop(), ((BadgeRectProviderModel)it).getLeft(), ((BadgeRectProviderModel)it).getRight(), ((BadgeRectProviderModel)it).getBottom(), it.getBorder());
        } else {
            BadgeIconConverter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BadgeIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown BadgeIconProviderModel. " + model.getProvider());
            return null;
        }
        BadgeShapeProvider provider = badgeShapeProvider;
        return (Icon)new BadgeIcon(icon, (Paint)color, provider);
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull BadgeIcon icon, @NotNull ProtocolIconRegistry registry) {
        BadgeShapeProviderModel badgeShapeProviderModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel iconModel = registry.createModel(icon.getIcon());
        if (iconModel == null) {
            return null;
        }
        IconModel iconModel2 = iconModel;
        Paint paint = icon.getPaint();
        Object object = paint instanceof Color ? (Color)paint : null;
        if (object == null || (object = ColorHostKt.toModel((Color)object)) == null) {
            return null;
        }
        Object colorModel = object;
        BadgeShapeProvider it = icon.getProvider();
        if (it instanceof BadgeDotProvider) {
            badgeShapeProviderModel = new BadgeDotProviderModel(((BadgeDotProvider)it).getX(), ((BadgeDotProvider)it).getY(), ((BadgeDotProvider)it).getRadius(), it.getBorder());
        } else if (it instanceof BadgeRectProvider) {
            badgeShapeProviderModel = new BadgeRectProviderModel(((BadgeRectProvider)it).getArc(), ((BadgeRectProvider)it).getTop(), ((BadgeRectProvider)it).getLeft(), ((BadgeRectProvider)it).getRight(), ((BadgeRectProvider)it).getBottom(), it.getBorder());
        } else {
            BadgeIconConverter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BadgeIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown BadgeIconProvider. " + icon.getProvider().getClass());
            return null;
        }
        BadgeShapeProviderModel provider = badgeShapeProviderModel;
        return new BadgeIconModel(iconModel2, (AbstractColor)colorModel, provider);
    }
}

