/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.thirdparty;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0000\u001aN\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a`\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a6\u0010\u0011\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"VENDOR_NAME", "", "commonDataPath", "Ljava/nio/file/Path;", "getJetBrainsCommonDataPath", "platformPath", "selector", "macDir", "macSub", "winVar", "winSub", "xdgVar", "xdgDfl", "xdgSub", "os", "Lcom/intellij/openapi/application/PathManager$OS;", "userHome", "getUnixPlatformPath", "intellij.marketplace.statistics"})
public final class PathsKt {
    @NotNull
    public static final String VENDOR_NAME = "JetBrains";
    @Nullable
    private static Path commonDataPath;

    @NotNull
    public static final synchronized Path getJetBrainsCommonDataPath() {
        LinkOption[] linkOptionArray;
        LinkOption[] path = commonDataPath;
        if (path == null) {
            path = Paths.get(PathsKt.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            if (!Files.exists((Path)path, linkOptionArray)) {
                try {
                    Files.createDirectories((Path)path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            commonDataPath = path;
        }
        linkOptionArray = path;
        Intrinsics.checkNotNull((Object)linkOptionArray);
        return linkOptionArray;
    }

    private static final String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        PathManager.OS oS = PathManager.getLocalOS();
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"getLocalOS(...)");
        return PathsKt.platformPath(oS, System.getProperty("user.home"), selector, macDir, macSub, winVar, winSub, xdgVar, xdgDfl, xdgSub);
    }

    private static final String platformPath(PathManager.OS os, String userHome, String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String vendorName = VENDOR_NAME;
        if (os == PathManager.OS.MACOS) {
            String dir = userHome + "/Library/" + macDir + "/" + vendorName;
            if (!(((CharSequence)selector).length() == 0)) {
                dir = dir + "/" + selector;
            }
            if (!(((CharSequence)macSub).length() == 0)) {
                dir = dir + "/" + macSub;
            }
            return dir;
        }
        if (os == PathManager.OS.WINDOWS) {
            Object dir = System.getenv(winVar);
            if (dir == null || ((CharSequence)dir).length() == 0) {
                dir = userHome + "\\AppData\\" + (StringsKt.startsWith$default((String)winVar, (String)"LOCAL", (boolean)false, (int)2, null) ? "Local" : "Roaming");
            }
            dir = (String)dir + "\\" + vendorName;
            if (!(((CharSequence)selector).length() == 0)) {
                dir = (String)dir + "\\" + selector;
            }
            if (!(((CharSequence)winSub).length() == 0)) {
                dir = (String)dir + "\\" + winSub;
            }
            return dir;
        }
        if (os == PathManager.OS.LINUX) {
            return PathsKt.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static final String getUnixPlatformPath(String userHome, String selector, String xdgVar, String xdgDfl, String xdgSub) {
        Object dir;
        String string = xdgVar;
        Object object = dir = string != null ? System.getenv(string) : null;
        if (dir == null || ((CharSequence)dir).length() == 0) {
            dir = userHome + "/" + xdgDfl;
        }
        dir = (String)dir + "/JetBrains";
        if (!(((CharSequence)selector).length() == 0)) {
            dir = (String)dir + "/" + selector;
        }
        if (!(((CharSequence)xdgSub).length() == 0)) {
            dir = (String)dir + "/" + xdgSub;
        }
        return dir;
    }
}

