/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public final class ProgressManagerQueue {
    private static final Logger LOG = Logger.getInstance(ProgressManagerQueue.class);
    private final Object myLock;
    private final Queue<Runnable> myQueue;
    @NotNull
    private final Project myProject;
    @NotNull
    private final @NlsContexts.ProgressTitle String myTitle;
    private boolean myIsStarted;
    private boolean myActive;

    public ProgressManagerQueue(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String title) {
        if (project == null) {
            ProgressManagerQueue.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ProgressManagerQueue.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myQueue = new ArrayDeque<Runnable>();
        this.myProject = project;
        this.myTitle = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.myLock;
        synchronized (object) {
            this.myIsStarted = true;
        }
        this.startProgressIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProgressIfNeeded() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myIsStarted || this.myActive || this.myQueue.isEmpty()) {
                return;
            }
            this.myActive = true;
        }
        new Task.Backgroundable(this.myProject, this.myTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManagerQueue.this.pumpQueue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/ProgressManagerQueue$1", "run"));
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Runnable stuff) {
        if (stuff == null) {
            ProgressManagerQueue.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            stuff.run();
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.add(stuff);
        }
        this.startProgressIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpQueue() {
        while (true) {
            Runnable stuff;
            Object object = this.myLock;
            synchronized (object) {
                stuff = this.myQueue.poll();
                if (stuff == null) {
                    this.myActive = false;
                    return;
                }
            }
            try {
                stuff.run();
                continue;
            }
            catch (ProcessCanceledException processCanceledException) {
                continue;
            }
            catch (Throwable t) {
                LOG.warn(t);
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stuff";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/ProgressManagerQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

