/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexDiagnostic;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\b \u0018\u00002\u00020\u0001B\u001a\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/ui/actions/IndexDiagnosticActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "dynamicText", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "<init>", "(Ljava/util/function/Supplier;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "getCommitsToCheck", "", "", "intellij.platform.vcs.log.impl"})
public abstract class IndexDiagnosticActionBase
extends DumbAwareAction {
    public IndexDiagnosticActionBase(@NotNull Supplier<String> dynamicText) {
        Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
        super(dynamicText);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsLogManager logManager2 = VcsProjectLog.Companion.getInstance(project).getLogManager();
        if (logManager2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (logManager2.getDataManager().getIndex().getDataGetter() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.update(e, logManager2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project2).getLogManager();
        if (vcsLogManager == null) {
            return;
        }
        VcsLogManager logManager2 = vcsLogManager;
        IndexDataGetter indexDataGetter = logManager2.getDataManager().getIndex().getDataGetter();
        if (indexDataGetter == null) {
            return;
        }
        IndexDataGetter dataGetter = indexDataGetter;
        List<Integer> commitIds2 = this.getCommitsToCheck(e, logManager2);
        if (commitIds2.isEmpty()) {
            return;
        }
        String report = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> IndexDiagnosticActionBase.actionPerformed$lambda$0(logManager2, commitIds2, dataGetter), VcsLogBundle.message("vcs.log.index.diagnostic.progress.title", new Object[0]), true, project2);
        Intrinsics.checkNotNull((Object)report);
        if (StringsKt.isBlank((CharSequence)report)) {
            Object[] objectArray = new Object[]{commitIds2.size()};
            VcsNotifier.getInstance((Project)project2).notifyInfo(null, "", VcsLogBundle.message("vcs.log.index.diagnostic.success.message", objectArray));
            return;
        }
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((Date)new Date())};
        LightVirtualFile reportFile = new LightVirtualFile(VcsLogBundle.message("vcs.log.index.diagnostic.report.title", objectArray), (CharSequence)report.toString());
        new OpenFileDescriptor(project2, (VirtualFile)reportFile, 0).navigate(true);
    }

    public abstract void update(@NotNull AnActionEvent var1, @NotNull VcsLogManager var2);

    @NotNull
    public abstract List<Integer> getCommitsToCheck(@NotNull AnActionEvent var1, @NotNull VcsLogManager var2);

    private static final String actionPerformed$lambda$0(VcsLogManager $logManager, List $commitIds, IndexDataGetter $dataGetter) {
        CommitDetailsGetter commitDetailsGetter = $logManager.getDataManager().getCommitDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)commitDetailsGetter, (String)"getCommitDetailsGetter(...)");
        List detailsList = AbstractDataGetter.Companion.getCommitDetails(commitDetailsGetter, $commitIds);
        return IndexDiagnostic.getDiffFor$default(IndexDiagnostic.INSTANCE, $dataGetter, $commitIds, detailsList, false, 4, null);
    }
}

