/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 98381367830919L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(846974340 - 26499, 846974340 - (char)-28513, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(846974340 - 26500, 846974340 - (char)-31217, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 29080847636478L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.L();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-375908760 + -15854, -375908760 + -27611, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-375908760 + -15853, 375908760 + 17980, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-375908760 + -15852, -375908760 + -20130, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 70688825344247L;
                Object object = this.lock;
                String[] stringArray = SshAgentIpcService.L();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27194), -2041284180 + -((char)-1183), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27191), -2041415250 - -((char)-13989), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27192), 2041415250 - (char)-13766, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27189), 2041415250 - (char)-31078, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27190), -2041415250 - -((char)-25739), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27192), 2041415250 - (char)-13766, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2041415250 - -((char)-27187), -2041415250 - -((char)-24395), (int)l2));
            if (ActionTimestamp.L() == null) {
                SshAgentIpcService.L(new String[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 52234894014032L;
                    stringArray = SshAgentIpcService.L();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 110608517150774L;
                String[] stringArray2 = SshAgentIpcService.L();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            stringArray = stringArray2;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(224391840 - 15077, -224391840 - -8987, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15076, -224391840 - -27461, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15075, 224391840 + 2991, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(224391840 - 15077, -224391840 - -8987, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15074, 224391840 - 24336, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(224391840 - 15077, -224391840 - -8987, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15073, 224391840 - 6415, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15104, 224391840 - 15814, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15075, 224391840 + 2991, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(224391840 - 15077, -224391840 - -8987, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(224391840 - 15081, -224391840 + -2183, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(224391840 - 15103, 224391840 - 26725, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 38854801360433L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1767741090 + 7222, 1767741090 - 2327, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 56205847952186L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1905888870 + -8648, 1905888870 - 3072, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ff\u00ae\u00d2\u00feHJ1\u00171\u0095\u00c6\u00c8\u0000S1\u001b\u00dc\r\u00bc\u0014\u00f2\u001ds\u008eg\u0086\u00a9\u000b\u00a0\u00101\u00ac<&w>\u00f9o\u001f\u00aa";
                        var4_3 = "\u00ff\u00ae\u00d2\u00feHJ1\u00171\u0095\u00c6\u00c8\u0000S1\u001b\u00dc\r\u00bc\u0014\u00f2\u001ds\u008eg\u0086\u00a9\u000b\u00a0\u00101\u00ac<&w>\u00f9o\u001f\u00aa".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 2;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 119;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 85;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 102;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 13;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 11;
                                        break;
                                    }
                                    default: {
                                        v11 = 13;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFB4E9) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 27;
                            case 1 -> 106;
                            case 2 -> 255;
                            case 3 -> 62;
                            case 4 -> 160;
                            case 5 -> 101;
                            case 6 -> 215;
                            case 7 -> 82;
                            case 8 -> 79;
                            case 9 -> 185;
                            case 10 -> 195;
                            case 11 -> 250;
                            case 12 -> 159;
                            case 13 -> 4;
                            case 14 -> 196;
                            case 15 -> 191;
                            case 16 -> 222;
                            case 17 -> 87;
                            case 18 -> 173;
                            case 19 -> 210;
                            case 20 -> 112;
                            case 21 -> 142;
                            case 22 -> 105;
                            case 23 -> 183;
                            case 24 -> 204;
                            case 25 -> 167;
                            case 26 -> 169;
                            case 27 -> 149;
                            case 28 -> 13;
                            case 29 -> 116;
                            case 30 -> 56;
                            case 31 -> 179;
                            case 32 -> 6;
                            case 33 -> 213;
                            case 34 -> 180;
                            case 35 -> 46;
                            case 36 -> 36;
                            case 37 -> 253;
                            case 38 -> 55;
                            case 39 -> 30;
                            case 40 -> 249;
                            case 41 -> 174;
                            case 42 -> 89;
                            case 43 -> 8;
                            case 44 -> 132;
                            case 45 -> 241;
                            case 46 -> 91;
                            case 47 -> 166;
                            case 48 -> 71;
                            case 49 -> 131;
                            case 50 -> 34;
                            case 51 -> 219;
                            case 52 -> 244;
                            case 53 -> 108;
                            case 54 -> 40;
                            case 55 -> 203;
                            case 56 -> 155;
                            case 57 -> 97;
                            case 58 -> 114;
                            case 59 -> 120;
                            case 60 -> 3;
                            case 61 -> 113;
                            case 62 -> 223;
                            case 63 -> 165;
                            case 64 -> 52;
                            case 65 -> 199;
                            case 66 -> 35;
                            case 67 -> 130;
                            case 68 -> 135;
                            case 69 -> 235;
                            case 70 -> 239;
                            case 71 -> 151;
                            case 72 -> 90;
                            case 73 -> 16;
                            case 74 -> 104;
                            case 75 -> 181;
                            case 76 -> 220;
                            case 77 -> 237;
                            case 78 -> 37;
                            case 79 -> 182;
                            case 80 -> 188;
                            case 81 -> 80;
                            case 82 -> 201;
                            case 83 -> 245;
                            case 84 -> 152;
                            case 85 -> 154;
                            case 86 -> 246;
                            case 87 -> 14;
                            case 88 -> 121;
                            case 89 -> 162;
                            case 90 -> 172;
                            case 91 -> 33;
                            case 92 -> 207;
                            case 93 -> 65;
                            case 94 -> 25;
                            case 95 -> 68;
                            case 96 -> 184;
                            case 97 -> 134;
                            case 98 -> 156;
                            case 99 -> 140;
                            case 100 -> 236;
                            case 101 -> 21;
                            case 102 -> 146;
                            case 103 -> 72;
                            case 104 -> 51;
                            case 105 -> 77;
                            case 106 -> 38;
                            case 107 -> 168;
                            case 108 -> 145;
                            case 109 -> 200;
                            case 110 -> 202;
                            case 111 -> 26;
                            case 112 -> 54;
                            case 113 -> 124;
                            case 114 -> 7;
                            case 115 -> 47;
                            case 116 -> 92;
                            case 117 -> 240;
                            case 118 -> 192;
                            case 119 -> 147;
                            case 120 -> 94;
                            case 121 -> 99;
                            case 122 -> 205;
                            case 123 -> 95;
                            case 124 -> 98;
                            case 125 -> 22;
                            case 126 -> 58;
                            case 127 -> 45;
                            case 128 -> 23;
                            case 129 -> 177;
                            case 130 -> 12;
                            case 131 -> 128;
                            case 132 -> 107;
                            case 133 -> 194;
                            case 134 -> 161;
                            case 135 -> 115;
                            case 136 -> 189;
                            case 137 -> 233;
                            case 138 -> 214;
                            case 139 -> 103;
                            case 140 -> 221;
                            case 141 -> 123;
                            case 142 -> 76;
                            case 143 -> 143;
                            case 144 -> 85;
                            case 145 -> 229;
                            case 146 -> 198;
                            case 147 -> 18;
                            case 148 -> 78;
                            case 149 -> 158;
                            case 150 -> 59;
                            case 151 -> 234;
                            case 152 -> 88;
                            case 153 -> 209;
                            case 154 -> 211;
                            case 155 -> 19;
                            case 156 -> 178;
                            case 157 -> 137;
                            case 158 -> 129;
                            case 159 -> 193;
                            case 160 -> 5;
                            case 161 -> 110;
                            case 162 -> 247;
                            case 163 -> 1;
                            case 164 -> 243;
                            case 165 -> 163;
                            case 166 -> 232;
                            case 167 -> 75;
                            case 168 -> 157;
                            case 169 -> 28;
                            case 170 -> 242;
                            case 171 -> 70;
                            case 172 -> 66;
                            case 173 -> 73;
                            case 174 -> 64;
                            case 175 -> 61;
                            case 176 -> 224;
                            case 177 -> 118;
                            case 178 -> 230;
                            case 179 -> 60;
                            case 180 -> 117;
                            case 181 -> 141;
                            case 182 -> 136;
                            case 183 -> 187;
                            case 184 -> 216;
                            case 185 -> 53;
                            case 186 -> 164;
                            case 187 -> 231;
                            case 188 -> 86;
                            case 189 -> 67;
                            case 190 -> 139;
                            case 191 -> 63;
                            case 192 -> 100;
                            case 193 -> 254;
                            case 194 -> 29;
                            case 195 -> 31;
                            case 196 -> 228;
                            case 197 -> 126;
                            case 198 -> 24;
                            case 199 -> 150;
                            case 200 -> 144;
                            case 201 -> 226;
                            case 202 -> 32;
                            case 203 -> 125;
                            case 204 -> 10;
                            case 205 -> 248;
                            case 206 -> 133;
                            case 207 -> 176;
                            case 208 -> 42;
                            case 209 -> 218;
                            case 210 -> 127;
                            case 211 -> 225;
                            case 212 -> 84;
                            case 213 -> 9;
                            case 214 -> 81;
                            case 215 -> 102;
                            case 216 -> 50;
                            case 217 -> 44;
                            case 218 -> 74;
                            case 219 -> 251;
                            case 220 -> 83;
                            case 221 -> 190;
                            case 222 -> 20;
                            case 223 -> 57;
                            case 224 -> 197;
                            case 225 -> 0;
                            case 226 -> 252;
                            case 227 -> 153;
                            case 228 -> 43;
                            case 229 -> 39;
                            case 230 -> 2;
                            case 231 -> 206;
                            case 232 -> 217;
                            case 233 -> 11;
                            case 234 -> 109;
                            case 235 -> 111;
                            case 236 -> 208;
                            case 237 -> 15;
                            case 238 -> 238;
                            case 239 -> 212;
                            case 240 -> 175;
                            case 241 -> 138;
                            case 242 -> 69;
                            case 243 -> 171;
                            case 244 -> 122;
                            case 245 -> 186;
                            case 246 -> 17;
                            case 247 -> 170;
                            case 248 -> 41;
                            case 249 -> 119;
                            case 250 -> 93;
                            case 251 -> 148;
                            case 252 -> 49;
                            case 253 -> 227;
                            case 254 -> 96;
                            default -> 48;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray != null) {
                ActionTimestamp.L("oCV4z");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 135842033655795L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.L();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(808046550 - 32600, -808046550 - -((char)-22636), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(808046550 - 32612, -808046550 - -((char)-19726), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(808046550 - 32623, -808046550 - -((char)-17862), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(808046550 - 32600, -808046550 - -((char)-22636), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(808046550 - 32612, -808046550 - -((char)-19726), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(808046550 - 32624, 808046550 - (char)-29550, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 88649825719823L;
                        String[] stringArray2 = SshAgentIpcService.L();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1700764320 - (char)-32509, -1700764320 - -21625, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1700764320 - (char)-32508, -1700764320 - -28568, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 50052851871537L;
                String[] stringArray2 = SshAgentIpcService.L();
                this.assertConnectionThread();
                Object object2 = this.lock;
                stringArray = stringArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-697030260 - -30512, 697030260 - (char)-20744, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-697030260 - -30500, 697030260 - (char)-15722, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-697030260 - -30485, -697030260 - -29283, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-697030260 - -30500, 697030260 - (char)-15722, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-697030260 - -30510, -697030260 - -((char)-16452), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-697030260 - -30512, 697030260 - (char)-20744, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-697030260 - -30500, 697030260 - (char)-15722, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-697030260 - -30484, 697030260 - 29010, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-697030260 - -30512, 697030260 - (char)-20744, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-697030260 - -30500, 697030260 - (char)-15722, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-697030260 - -30499, 697030260 - (char)-28481, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-697030260 - -30512, 697030260 - (char)-20744, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-697030260 - -30500, 697030260 - (char)-15722, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-697030260 - -30498, -697030260 - -32292, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 32796933552452L;
                    Object object = this.lock;
                    stringArray = SshAgentIpcService.L();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(563338860 - (char)-6237, -563207790 + -((char)-20343), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(563338860 - (char)-6233, -563207790 + -((char)-9241), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(563338860 - (char)-6252, -563207790 + -((char)-12227), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(563338860 - (char)-6253, -563207790 + -((char)-8525), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(563338860 - (char)-6237, -563207790 + -((char)-20343), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(563338860 - (char)-6233, -563207790 + -((char)-9241), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(563338860 - (char)-6258, -563207790 + -((char)-10750), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(563338860 - (char)-6237, -563207790 + -((char)-20343), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(563338860 - (char)-6233, -563207790 + -((char)-9241), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(563338860 - (char)-6259, 563207790 + (char)-11240, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(563338860 - (char)-6237, -563207790 + -((char)-20343), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(563338860 - (char)-6233, -563207790 + -((char)-9241), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(563338860 - (char)-6256, 563338860 - (char)-6043, (int)l2));
                    if (stringArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(563338860 - (char)-6237, -563207790 + -((char)-20343), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(563338860 - (char)-6233, -563207790 + -((char)-9241), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(563338860 - (char)-6257, 563207790 + (char)-5667, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u0084\u00a4\u00fa\u0007/W}A\u0014\u00cf\u00b8\u00abc\u00fbSH\u00db\u009f\u00eaN.\u001d\u00fa\u00b7\u00f6g\u00bc\u008e\b\u0006<\u001b\u00ed\u00f0\u00a7\u00e8\u0018\u00ad\u0018\u0087G\u00fc\u0012\u00aa3\u000b\u008a\u00d3R\u00c8\u008a_z\u00d3D6\u008a\u00cd\u00b55&\t@ \u00a4\u00f1\u00f3[SR\b\u0005\u0081\u00eeZNK\b(\u00bdoU\u00cf;g.\u0005\u00a9\u00c9_\u00aa\u00eb\u001e\u00abU\n]\u00dc\u0095\f\u00b9z\u00cf\u00b6}(O\u00e1\u00a6\u00e5N\"?\u00e3,\u00fc\u00d8u\u00cd.\\\u0005&\u0010P'\u0091\u00d6\u00f8\u00d6~(IO]\u0090S\u00a7!$\t\u0087'\u008a\u0000eB\u00a7\u00eex\u0010\u0016\u00ebYO\u00e1\u00e5]N-\u0083\u00d1\t\u00c2\u0094\u0013B?\u00e3 \u000b\u00f3\u00f1I,N\u000f\u00e0]c\u00eaz\u00849\u008c\u00d8r(g\u009c\u0017\u00a8\u0018+\u008e4&}'K\u0018)\u00fd\u00cb?\u00f6&\u00a3Ti\u00cez\u00dc\u00de\t\u00135w\u00f3\u00a4\u00a6\u00b5vP\u009a\u0080g\u00de<\u00ec\u00f6\bU.\u00c0':u\u00d9\u00e7\f1\u009a\\\u00aa\u00b4\u00a6\u00e6\u009asQHWF\u00a4L\u00eep\u00e2\u00fd,\u00f1*0i\u00bf\u00fa\u00e9\u0099m\u00d35\u0099:\b\u008c\u00f9\u0098\u00f3\u0006\u0000\u009aH\u0081\u00d0\u00e8\u00da\u00ebg\u00b2\u00b6\u0094\u00bc+\u0094m]\u0001p4\u00c83\u00ea\u008bn\u0091\u00fa\u0085\u00ebM\u00b6Wt\u0098mM\u0080\u00cd*yn\u00f0\u00f8\u0089\u001fs\u00bd\u0011@\u00bf6`\u00cd\u00f7A\u0007\u00ac\u001eh,\u00f3'\f\u0007\u00bd\u008c\u00fc\u00c6iS+\u00fdLb\u00d5\u0097\u000bi\u00a2W\u00ad\u00d5F\u00ca\u0086\u00f6\u00de\u00f2\u0015}\u00b1\u00d5\u00cc\u0082\u0002\u00ccs\b\u0080\u00e5_\u00fc\u00bam\u00ff\u00f4\u0019\u00a0fN)\u0002K?\u009ez\u00ed\u00d8\u00b6\u00e0.\u00e5AF\u00df\u00b9\u0000\u00ca\u00faa\u00c4\u00b0\u00ab\u0087\u009b\u0014<\u00c2\u00d6\u00aar\f\u00a8\u00bfF\u00ad\u008a\u00f1\u008e\u00df\u00c1[\u0007L\u0081\u00fc\u00dd&\u00d8\u00c8\u0007\u008c\u00cf\u0080xN\u0083\u00d3(\u00e1J\u000f\u009f\u00cc\u00a7\u00f8\u00d8\u00944A4\u00f1\u00f0\rf[\u009b\u00fd\u00abBx\u00b6*\u00a2\u00b6\u00a2\u00fc\u0091W\u00b0\u0015\u00d3\u009a\u00be\u00bc)5WE\u000f\u00c1\u00b4Eim\u0015iM\u00d3\u000b\b\u0082xr\u00a2\"F\u0086\u00b7'k\u00da\u00faP\u00a4\u00f2m\u00daT\u00a0\u009f!\u00e5\u00f7\u000e'\u00b7\u00d7\u00c7D\u008f\u0093|\u00fdY%\u00d0E\n\b\u000e\u00ac{\u00e8\u0090\u00d8*\u00df\u00aa\u0005\u00f7\u00d2\u001d/\u008b\u001b\u00eb\u00b2\u0007\u00ac\u00de\u0018\u008a\u00b0\u00f83\u00e0\u00849\u008e\u0014\u00f2<'\u0088\u00a1\\3\u00c9~\u0005\u00b9x\nIQ\u0097\u00d7\u00d8\u0093\u0099\u00eb1:\u0018\u001c\u00d0\u00f9\u00ed\u0000\u008cp|\u00b9c\n\u0011\u00ddot\u00efG\u00850\u008c3\u00dd\u007f\u00f0)\u00a6\u0003\u00ab\u0097\u00e8\u00cc\u008a\u0092\u00aa\u00aa\u00ac\u00d1k\u00c4\u0083\u0018\u00f3\u008c\u0099\u00cf\u0095\u00daj\u00b9\u00dc\u00eaF\u00e0i\u00e8\u00cfj\u00e2\u00c0\u00d3\u00ce\u00e0\"\u00fdT\u001f";
                var4_3 = "\u0084\u00a4\u00fa\u0007/W}A\u0014\u00cf\u00b8\u00abc\u00fbSH\u00db\u009f\u00eaN.\u001d\u00fa\u00b7\u00f6g\u00bc\u008e\b\u0006<\u001b\u00ed\u00f0\u00a7\u00e8\u0018\u00ad\u0018\u0087G\u00fc\u0012\u00aa3\u000b\u008a\u00d3R\u00c8\u008a_z\u00d3D6\u008a\u00cd\u00b55&\t@ \u00a4\u00f1\u00f3[SR\b\u0005\u0081\u00eeZNK\b(\u00bdoU\u00cf;g.\u0005\u00a9\u00c9_\u00aa\u00eb\u001e\u00abU\n]\u00dc\u0095\f\u00b9z\u00cf\u00b6}(O\u00e1\u00a6\u00e5N\"?\u00e3,\u00fc\u00d8u\u00cd.\\\u0005&\u0010P'\u0091\u00d6\u00f8\u00d6~(IO]\u0090S\u00a7!$\t\u0087'\u008a\u0000eB\u00a7\u00eex\u0010\u0016\u00ebYO\u00e1\u00e5]N-\u0083\u00d1\t\u00c2\u0094\u0013B?\u00e3 \u000b\u00f3\u00f1I,N\u000f\u00e0]c\u00eaz\u00849\u008c\u00d8r(g\u009c\u0017\u00a8\u0018+\u008e4&}'K\u0018)\u00fd\u00cb?\u00f6&\u00a3Ti\u00cez\u00dc\u00de\t\u00135w\u00f3\u00a4\u00a6\u00b5vP\u009a\u0080g\u00de<\u00ec\u00f6\bU.\u00c0':u\u00d9\u00e7\f1\u009a\\\u00aa\u00b4\u00a6\u00e6\u009asQHWF\u00a4L\u00eep\u00e2\u00fd,\u00f1*0i\u00bf\u00fa\u00e9\u0099m\u00d35\u0099:\b\u008c\u00f9\u0098\u00f3\u0006\u0000\u009aH\u0081\u00d0\u00e8\u00da\u00ebg\u00b2\u00b6\u0094\u00bc+\u0094m]\u0001p4\u00c83\u00ea\u008bn\u0091\u00fa\u0085\u00ebM\u00b6Wt\u0098mM\u0080\u00cd*yn\u00f0\u00f8\u0089\u001fs\u00bd\u0011@\u00bf6`\u00cd\u00f7A\u0007\u00ac\u001eh,\u00f3'\f\u0007\u00bd\u008c\u00fc\u00c6iS+\u00fdLb\u00d5\u0097\u000bi\u00a2W\u00ad\u00d5F\u00ca\u0086\u00f6\u00de\u00f2\u0015}\u00b1\u00d5\u00cc\u0082\u0002\u00ccs\b\u0080\u00e5_\u00fc\u00bam\u00ff\u00f4\u0019\u00a0fN)\u0002K?\u009ez\u00ed\u00d8\u00b6\u00e0.\u00e5AF\u00df\u00b9\u0000\u00ca\u00faa\u00c4\u00b0\u00ab\u0087\u009b\u0014<\u00c2\u00d6\u00aar\f\u00a8\u00bfF\u00ad\u008a\u00f1\u008e\u00df\u00c1[\u0007L\u0081\u00fc\u00dd&\u00d8\u00c8\u0007\u008c\u00cf\u0080xN\u0083\u00d3(\u00e1J\u000f\u009f\u00cc\u00a7\u00f8\u00d8\u00944A4\u00f1\u00f0\rf[\u009b\u00fd\u00abBx\u00b6*\u00a2\u00b6\u00a2\u00fc\u0091W\u00b0\u0015\u00d3\u009a\u00be\u00bc)5WE\u000f\u00c1\u00b4Eim\u0015iM\u00d3\u000b\b\u0082xr\u00a2\"F\u0086\u00b7'k\u00da\u00faP\u00a4\u00f2m\u00daT\u00a0\u009f!\u00e5\u00f7\u000e'\u00b7\u00d7\u00c7D\u008f\u0093|\u00fdY%\u00d0E\n\b\u000e\u00ac{\u00e8\u0090\u00d8*\u00df\u00aa\u0005\u00f7\u00d2\u001d/\u008b\u001b\u00eb\u00b2\u0007\u00ac\u00de\u0018\u008a\u00b0\u00f83\u00e0\u00849\u008e\u0014\u00f2<'\u0088\u00a1\\3\u00c9~\u0005\u00b9x\nIQ\u0097\u00d7\u00d8\u0093\u0099\u00eb1:\u0018\u001c\u00d0\u00f9\u00ed\u0000\u008cp|\u00b9c\n\u0011\u00ddot\u00efG\u00850\u008c3\u00dd\u007f\u00f0)\u00a6\u0003\u00ab\u0097\u00e8\u00cc\u008a\u0092\u00aa\u00aa\u00ac\u00d1k\u00c4\u0083\u0018\u00f3\u008c\u0099\u00cf\u0095\u00daj\u00b9\u00dc\u00eaF\u00e0i\u00e8\u00cfj\u00e2\u00c0\u00d3\u00ce\u00e0\"\u00fdT\u001f".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 51;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "q\u008b\u00fe!K\u0003\u009e7H\u001d\u0005\u00c9ud\u0099\u0018\u000e\u00a2\u0090\u0006A\u00ee|\u0089\u00cb\u001bPJ\u00179\u00bb\u0091\u00f6\u00a4N\u00ff/\u00ad~";
                    var4_3 = "q\u008b\u00fe!K\u0003\u009e7H\u001d\u0005\u00c9ud\u0099\u0018\u000e\u00a2\u0090\u0006A\u00ee|\u0089\u00cb\u001bPJ\u00179\u00bb\u0091\u00f6\u00a4N\u00ff/\u00ad~".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 85;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 26;
                            break;
                        }
                        case 1: {
                            v15 = 46;
                            break;
                        }
                        case 2: {
                            v15 = 114;
                            break;
                        }
                        case 3: {
                            v15 = 34;
                            break;
                        }
                        case 4: {
                            v15 = 69;
                            break;
                        }
                        case 5: {
                            v15 = 14;
                            break;
                        }
                        default: {
                            v15 = 75;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xF86) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 121;
                case 1 -> 195;
                case 2 -> 214;
                case 3 -> 137;
                case 4 -> 165;
                case 5 -> 155;
                case 6 -> 162;
                case 7 -> 156;
                case 8 -> 248;
                case 9 -> 150;
                case 10 -> 198;
                case 11 -> 191;
                case 12 -> 208;
                case 13 -> 57;
                case 14 -> 203;
                case 15 -> 164;
                case 16 -> 32;
                case 17 -> 230;
                case 18 -> 21;
                case 19 -> 10;
                case 20 -> 130;
                case 21 -> 14;
                case 22 -> 201;
                case 23 -> 142;
                case 24 -> 132;
                case 25 -> 231;
                case 26 -> 232;
                case 27 -> 35;
                case 28 -> 144;
                case 29 -> 86;
                case 30 -> 73;
                case 31 -> 19;
                case 32 -> 53;
                case 33 -> 60;
                case 34 -> 77;
                case 35 -> 68;
                case 36 -> 128;
                case 37 -> 224;
                case 38 -> 113;
                case 39 -> 16;
                case 40 -> 74;
                case 41 -> 239;
                case 42 -> 226;
                case 43 -> 166;
                case 44 -> 168;
                case 45 -> 129;
                case 46 -> 66;
                case 47 -> 38;
                case 48 -> 6;
                case 49 -> 252;
                case 50 -> 99;
                case 51 -> 154;
                case 52 -> 23;
                case 53 -> 197;
                case 54 -> 114;
                case 55 -> 131;
                case 56 -> 48;
                case 57 -> 118;
                case 58 -> 5;
                case 59 -> 250;
                case 60 -> 141;
                case 61 -> 116;
                case 62 -> 63;
                case 63 -> 245;
                case 64 -> 147;
                case 65 -> 22;
                case 66 -> 18;
                case 67 -> 254;
                case 68 -> 83;
                case 69 -> 216;
                case 70 -> 100;
                case 71 -> 183;
                case 72 -> 102;
                case 73 -> 225;
                case 74 -> 159;
                case 75 -> 185;
                case 76 -> 115;
                case 77 -> 177;
                case 78 -> 39;
                case 79 -> 64;
                case 80 -> 221;
                case 81 -> 127;
                case 82 -> 84;
                case 83 -> 161;
                case 84 -> 41;
                case 85 -> 75;
                case 86 -> 31;
                case 87 -> 101;
                case 88 -> 202;
                case 89 -> 36;
                case 90 -> 140;
                case 91 -> 153;
                case 92 -> 125;
                case 93 -> 46;
                case 94 -> 249;
                case 95 -> 89;
                case 96 -> 79;
                case 97 -> 175;
                case 98 -> 213;
                case 99 -> 188;
                case 100 -> 54;
                case 101 -> 193;
                case 102 -> 17;
                case 103 -> 205;
                case 104 -> 139;
                case 105 -> 243;
                case 106 -> 78;
                case 107 -> 192;
                case 108 -> 105;
                case 109 -> 229;
                case 110 -> 180;
                case 111 -> 47;
                case 112 -> 167;
                case 113 -> 204;
                case 114 -> 234;
                case 115 -> 187;
                case 116 -> 181;
                case 117 -> 215;
                case 118 -> 210;
                case 119 -> 93;
                case 120 -> 233;
                case 121 -> 182;
                case 122 -> 96;
                case 123 -> 212;
                case 124 -> 51;
                case 125 -> 88;
                case 126 -> 220;
                case 127 -> 251;
                case 128 -> 255;
                case 129 -> 160;
                case 130 -> 151;
                case 131 -> 171;
                case 132 -> 134;
                case 133 -> 194;
                case 134 -> 227;
                case 135 -> 26;
                case 136 -> 69;
                case 137 -> 223;
                case 138 -> 90;
                case 139 -> 45;
                case 140 -> 126;
                case 141 -> 240;
                case 142 -> 152;
                case 143 -> 13;
                case 144 -> 145;
                case 145 -> 24;
                case 146 -> 219;
                case 147 -> 190;
                case 148 -> 238;
                case 149 -> 157;
                case 150 -> 49;
                case 151 -> 30;
                case 152 -> 176;
                case 153 -> 235;
                case 154 -> 72;
                case 155 -> 211;
                case 156 -> 8;
                case 157 -> 135;
                case 158 -> 178;
                case 159 -> 85;
                case 160 -> 209;
                case 161 -> 97;
                case 162 -> 110;
                case 163 -> 80;
                case 164 -> 37;
                case 165 -> 33;
                case 166 -> 196;
                case 167 -> 2;
                case 168 -> 228;
                case 169 -> 59;
                case 170 -> 104;
                case 171 -> 108;
                case 172 -> 91;
                case 173 -> 133;
                case 174 -> 0;
                case 175 -> 55;
                case 176 -> 71;
                case 177 -> 169;
                case 178 -> 70;
                case 179 -> 136;
                case 180 -> 218;
                case 181 -> 189;
                case 182 -> 1;
                case 183 -> 179;
                case 184 -> 92;
                case 185 -> 200;
                case 186 -> 207;
                case 187 -> 247;
                case 188 -> 236;
                case 189 -> 87;
                case 190 -> 44;
                case 191 -> 3;
                case 192 -> 146;
                case 193 -> 82;
                case 194 -> 25;
                case 195 -> 42;
                case 196 -> 40;
                case 197 -> 172;
                case 198 -> 58;
                case 199 -> 241;
                case 200 -> 246;
                case 201 -> 11;
                case 202 -> 163;
                case 203 -> 138;
                case 204 -> 98;
                case 205 -> 15;
                case 206 -> 94;
                case 207 -> 9;
                case 208 -> 28;
                case 209 -> 124;
                case 210 -> 50;
                case 211 -> 244;
                case 212 -> 174;
                case 213 -> 34;
                case 214 -> 20;
                case 215 -> 206;
                case 216 -> 186;
                case 217 -> 4;
                case 218 -> 222;
                case 219 -> 103;
                case 220 -> 111;
                case 221 -> 123;
                case 222 -> 107;
                case 223 -> 120;
                case 224 -> 122;
                case 225 -> 184;
                case 226 -> 170;
                case 227 -> 62;
                case 228 -> 81;
                case 229 -> 242;
                case 230 -> 67;
                case 231 -> 119;
                case 232 -> 65;
                case 233 -> 7;
                case 234 -> 29;
                case 235 -> 237;
                case 236 -> 56;
                case 237 -> 217;
                case 238 -> 61;
                case 239 -> 95;
                case 240 -> 12;
                case 241 -> 106;
                case 242 -> 253;
                case 243 -> 149;
                case 244 -> 27;
                case 245 -> 173;
                case 246 -> 148;
                case 247 -> 76;
                case 248 -> 109;
                case 249 -> 143;
                case 250 -> 117;
                case 251 -> 112;
                case 252 -> 43;
                case 253 -> 199;
                case 254 -> 158;
                default -> 52;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 27751990174496L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2088469380 + 24382, 2088469380 + 13403, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 14057032932921L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.L();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(395044980 - 18586, -395044980 - -2667, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(395044980 - 18587, -395044980 - -23706, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(395044980 - 18588, 395044980 - 4926, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00f5\u00c9\u0001\u0012\u00dc@r2\u0010cn\"G\u0002QPI\u00ba\u00b6\u009b#>\u00a0\u001d\u00f2";
                    var4_3 = "\u00f5\u00c9\u0001\u0012\u00dc@r2\u0010cn\"G\u0002QPI\u00ba\u00b6\u009b#>\u00a0\u001d\u00f2".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 69;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d4\u0098gz\"5Ltc\u008bp\u00b3D\u00fc\r\u00f9\u00bdHOet\u0082\u001b\u009c\u00d9\u00c6=\u0017\u0084\u001a\u00f1\u001c[\u00cb\u00df\u00c6^\u0081\u0005;i\u001b\u001cQ\u00fc\u00f2H_\t \u00e6\u0084r=\u00dd\u0097\u0089\nV";
                        var4_3 = "\u00d4\u0098gz\"5Ltc\u008bp\u00b3D\u00fc\r\u00f9\u00bdHOet\u0082\u001b\u009c\u00d9\u00c6=\u0017\u0084\u001a\u00f1\u001c[\u00cb\u00df\u00c6^\u0081\u0005;i\u001b\u001cQ\u00fc\u00f2H_\t \u00e6\u0084r=\u00dd\u0097\u0089\nV".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 71;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 109;
                                break;
                            }
                            case 2: {
                                v15 = 58;
                                break;
                            }
                            case 3: {
                                v15 = 74;
                                break;
                            }
                            case 4: {
                                v15 = 120;
                                break;
                            }
                            case 5: {
                                v15 = 14;
                                break;
                            }
                            default: {
                                v15 = 37;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC1E2) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 181;
                    case 1 -> 66;
                    case 2 -> 26;
                    case 3 -> 178;
                    case 4 -> 35;
                    case 5 -> 193;
                    case 6 -> 120;
                    case 7 -> 200;
                    case 8 -> 147;
                    case 9 -> 195;
                    case 10 -> 216;
                    case 11 -> 32;
                    case 12 -> 245;
                    case 13 -> 172;
                    case 14 -> 159;
                    case 15 -> 135;
                    case 16 -> 62;
                    case 17 -> 64;
                    case 18 -> 48;
                    case 19 -> 124;
                    case 20 -> 129;
                    case 21 -> 92;
                    case 22 -> 240;
                    case 23 -> 58;
                    case 24 -> 202;
                    case 25 -> 196;
                    case 26 -> 47;
                    case 27 -> 43;
                    case 28 -> 164;
                    case 29 -> 45;
                    case 30 -> 231;
                    case 31 -> 14;
                    case 32 -> 251;
                    case 33 -> 213;
                    case 34 -> 127;
                    case 35 -> 223;
                    case 36 -> 110;
                    case 37 -> 25;
                    case 38 -> 187;
                    case 39 -> 22;
                    case 40 -> 122;
                    case 41 -> 11;
                    case 42 -> 82;
                    case 43 -> 27;
                    case 44 -> 63;
                    case 45 -> 73;
                    case 46 -> 98;
                    case 47 -> 24;
                    case 48 -> 144;
                    case 49 -> 239;
                    case 50 -> 54;
                    case 51 -> 61;
                    case 52 -> 160;
                    case 53 -> 71;
                    case 54 -> 87;
                    case 55 -> 21;
                    case 56 -> 13;
                    case 57 -> 215;
                    case 58 -> 183;
                    case 59 -> 152;
                    case 60 -> 106;
                    case 61 -> 118;
                    case 62 -> 141;
                    case 63 -> 16;
                    case 64 -> 208;
                    case 65 -> 101;
                    case 66 -> 99;
                    case 67 -> 198;
                    case 68 -> 142;
                    case 69 -> 81;
                    case 70 -> 107;
                    case 71 -> 89;
                    case 72 -> 197;
                    case 73 -> 72;
                    case 74 -> 220;
                    case 75 -> 69;
                    case 76 -> 209;
                    case 77 -> 34;
                    case 78 -> 212;
                    case 79 -> 97;
                    case 80 -> 253;
                    case 81 -> 8;
                    case 82 -> 115;
                    case 83 -> 114;
                    case 84 -> 52;
                    case 85 -> 123;
                    case 86 -> 204;
                    case 87 -> 15;
                    case 88 -> 17;
                    case 89 -> 75;
                    case 90 -> 148;
                    case 91 -> 6;
                    case 92 -> 235;
                    case 93 -> 88;
                    case 94 -> 103;
                    case 95 -> 105;
                    case 96 -> 65;
                    case 97 -> 146;
                    case 98 -> 250;
                    case 99 -> 233;
                    case 100 -> 140;
                    case 101 -> 3;
                    case 102 -> 149;
                    case 103 -> 246;
                    case 104 -> 59;
                    case 105 -> 1;
                    case 106 -> 53;
                    case 107 -> 186;
                    case 108 -> 136;
                    case 109 -> 76;
                    case 110 -> 60;
                    case 111 -> 218;
                    case 112 -> 91;
                    case 113 -> 205;
                    case 114 -> 176;
                    case 115 -> 111;
                    case 116 -> 77;
                    case 117 -> 222;
                    case 118 -> 40;
                    case 119 -> 143;
                    case 120 -> 252;
                    case 121 -> 167;
                    case 122 -> 100;
                    case 123 -> 134;
                    case 124 -> 173;
                    case 125 -> 165;
                    case 126 -> 158;
                    case 127 -> 180;
                    case 128 -> 33;
                    case 129 -> 241;
                    case 130 -> 243;
                    case 131 -> 12;
                    case 132 -> 249;
                    case 133 -> 20;
                    case 134 -> 28;
                    case 135 -> 170;
                    case 136 -> 67;
                    case 137 -> 57;
                    case 138 -> 7;
                    case 139 -> 224;
                    case 140 -> 9;
                    case 141 -> 70;
                    case 142 -> 56;
                    case 143 -> 236;
                    case 144 -> 125;
                    case 145 -> 51;
                    case 146 -> 104;
                    case 147 -> 44;
                    case 148 -> 137;
                    case 149 -> 247;
                    case 150 -> 116;
                    case 151 -> 201;
                    case 152 -> 244;
                    case 153 -> 156;
                    case 154 -> 162;
                    case 155 -> 117;
                    case 156 -> 225;
                    case 157 -> 184;
                    case 158 -> 248;
                    case 159 -> 177;
                    case 160 -> 79;
                    case 161 -> 211;
                    case 162 -> 130;
                    case 163 -> 80;
                    case 164 -> 203;
                    case 165 -> 139;
                    case 166 -> 126;
                    case 167 -> 94;
                    case 168 -> 85;
                    case 169 -> 157;
                    case 170 -> 121;
                    case 171 -> 255;
                    case 172 -> 96;
                    case 173 -> 10;
                    case 174 -> 78;
                    case 175 -> 86;
                    case 176 -> 39;
                    case 177 -> 169;
                    case 178 -> 185;
                    case 179 -> 50;
                    case 180 -> 108;
                    case 181 -> 237;
                    case 182 -> 154;
                    case 183 -> 49;
                    case 184 -> 133;
                    case 185 -> 192;
                    case 186 -> 228;
                    case 187 -> 19;
                    case 188 -> 232;
                    case 189 -> 83;
                    case 190 -> 102;
                    case 191 -> 190;
                    case 192 -> 150;
                    case 193 -> 2;
                    case 194 -> 191;
                    case 195 -> 199;
                    case 196 -> 175;
                    case 197 -> 93;
                    case 198 -> 128;
                    case 199 -> 254;
                    case 200 -> 166;
                    case 201 -> 5;
                    case 202 -> 168;
                    case 203 -> 210;
                    case 204 -> 31;
                    case 205 -> 226;
                    case 206 -> 30;
                    case 207 -> 55;
                    case 208 -> 84;
                    case 209 -> 90;
                    case 210 -> 189;
                    case 211 -> 37;
                    case 212 -> 188;
                    case 213 -> 221;
                    case 214 -> 155;
                    case 215 -> 29;
                    case 216 -> 230;
                    case 217 -> 207;
                    case 218 -> 68;
                    case 219 -> 238;
                    case 220 -> 0;
                    case 221 -> 194;
                    case 222 -> 95;
                    case 223 -> 38;
                    case 224 -> 119;
                    case 225 -> 179;
                    case 226 -> 132;
                    case 227 -> 161;
                    case 228 -> 227;
                    case 229 -> 131;
                    case 230 -> 112;
                    case 231 -> 174;
                    case 232 -> 18;
                    case 233 -> 138;
                    case 234 -> 74;
                    case 235 -> 113;
                    case 236 -> 206;
                    case 237 -> 163;
                    case 238 -> 217;
                    case 239 -> 46;
                    case 240 -> 36;
                    case 241 -> 23;
                    case 242 -> 145;
                    case 243 -> 229;
                    case 244 -> 214;
                    case 245 -> 182;
                    case 246 -> 41;
                    case 247 -> 109;
                    case 248 -> 242;
                    case 249 -> 171;
                    case 250 -> 4;
                    case 251 -> 42;
                    case 252 -> 153;
                    case 253 -> 234;
                    case 254 -> 219;
                    default -> 151;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 67583397956122L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0006\u007f8.6a>_\t\u0001u+${##C3";
                    var5_4 = "\u0006\u007f8.6a>_\t\u0001u+${##C3".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 118;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 27;
                                    break;
                                }
                                case 1: {
                                    v11 = 108;
                                    break;
                                }
                                case 2: {
                                    v11 = 60;
                                    break;
                                }
                                case 3: {
                                    v11 = 54;
                                    break;
                                }
                                case 4: {
                                    v11 = 37;
                                    break;
                                }
                                case 5: {
                                    v11 = 123;
                                    break;
                                }
                                default: {
                                    v11 = 123;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 72603353647074L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "QDs,\nV[\u0004WZ\u007f6\n[Et6\u0006TCqD}\t[Et6\u0006TC}N\r\\Ci;\fYY}In1\rP";
                    var5_4 = "QDs,\nV[\u0004WZ\u007f6\n[Et6\u0006TCqD}\t[Et6\u0006TC}N\r\\Ci;\fYY}In1\rP".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "kvE\u001b:i`\u0006kvE\u001b6c";
                        var5_4 = "kvE\u001b:i`\u0006kvE\u001b6c".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 85;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 125;
                                break;
                            }
                            case 1: {
                                v15 = 79;
                                break;
                            }
                            case 2: {
                                v15 = 127;
                                break;
                            }
                            case 3: {
                                v15 = 61;
                                break;
                            }
                            case 4: {
                                v15 = 6;
                                break;
                            }
                            case 5: {
                                v15 = 82;
                                break;
                            }
                            default: {
                                v15 = 82;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 110137334649814L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1488299850 - -28112, -1488299850 - -24373, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 48827499600932L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0097\u00f3\f\\\u00d1\u0003Ijc\u0005\u00b7\u00f8.\u00f9v\r\u00cf3\u0017\u00ca\u00a4GB\u00a4\u00f0\u00e8\u00fc\u009a\u0006\u0010\u00b4X\u00bfL\u008e\u0002,1\u00f4\u00de\u009f\u0011\u008c\u000bYF\u0005\u0095\u0090j\u00f4\u00fe3\u00c7[1\u00fa\u008a\u0090\u009cw\u009f\u00eby\u009e\u0096\u00ab6MF\u00f1x\u001b\u0001\u00fa\u00e6\n\u00f9\u00fc\u00c3.\"M\u00fb\"\r\u0099't\u00ac\u00db\u00d5\u00d4\u0080nQ\u00b7\u00b9\u008b\u008a\u0086\u00e4\u0080\u00dd";
                    var4_3 = "\u0097\u00f3\f\\\u00d1\u0003Ijc\u0005\u00b7\u00f8.\u00f9v\r\u00cf3\u0017\u00ca\u00a4GB\u00a4\u00f0\u00e8\u00fc\u009a\u0006\u0010\u00b4X\u00bfL\u008e\u0002,1\u00f4\u00de\u009f\u0011\u008c\u000bYF\u0005\u0095\u0090j\u00f4\u00fe3\u00c7[1\u00fa\u008a\u0090\u009cw\u009f\u00eby\u009e\u0096\u00ab6MF\u00f1x\u001b\u0001\u00fa\u00e6\n\u00f9\u00fc\u00c3.\"M\u00fb\"\r\u0099't\u00ac\u00db\u00d5\u00d4\u0080nQ\u00b7\u00b9\u008b\u008a\u0086\u00e4\u0080\u00dd".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 44;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "b\u0018~_\u00ad{S\u0005\u0000C\u001a\u00b9'\u00057\u009cL#\u0013\u00a1\u00f4|\u00c6\u0007\u00dc\u0003\u00eb\u00d6\u0015\u00b0\u001eV\u0086TB\u00de\u0080\u00a6\u00f6#2y\u000b\u00ed\r\u0006{\u008b\u0090\b:\u00ed\u0007\u00dcp\u00fa\u00dcH\u0089\u009c-\u000e\u001d\u00acw\u00c9\u0091\u008b`\u00e8\\\u00dc\u0018S\u00b18\u00afK&7ME\u00c0\u0017\u000e\u00e2\u0086JE8\u0005^\u00ff";
                        var4_3 = "b\u0018~_\u00ad{S\u0005\u0000C\u001a\u00b9'\u00057\u009cL#\u0013\u00a1\u00f4|\u00c6\u0007\u00dc\u0003\u00eb\u00d6\u0015\u00b0\u001eV\u0086TB\u00de\u0080\u00a6\u00f6#2y\u000b\u00ed\r\u0006{\u008b\u0090\b:\u00ed\u0007\u00dcp\u00fa\u00dcH\u0089\u009c-\u000e\u001d\u00acw\u00c9\u0091\u008b`\u00e8\\\u00dc\u0018S\u00b18\u00afK&7ME\u00c0\u0017\u000e\u00e2\u0086JE8\u0005^\u00ff".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 52;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 43;
                                break;
                            }
                            case 1: {
                                v15 = 32;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 106;
                                break;
                            }
                            case 4: {
                                v15 = 7;
                                break;
                            }
                            case 5: {
                                v15 = 124;
                                break;
                            }
                            default: {
                                v15 = 99;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9550) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 42;
                    case 1 -> 162;
                    case 2 -> 19;
                    case 3 -> 170;
                    case 4 -> 95;
                    case 5 -> 117;
                    case 6 -> 188;
                    case 7 -> 60;
                    case 8 -> 112;
                    case 9 -> 31;
                    case 10 -> 104;
                    case 11 -> 166;
                    case 12 -> 100;
                    case 13 -> 173;
                    case 14 -> 247;
                    case 15 -> 196;
                    case 16 -> 203;
                    case 17 -> 81;
                    case 18 -> 192;
                    case 19 -> 43;
                    case 20 -> 15;
                    case 21 -> 180;
                    case 22 -> 77;
                    case 23 -> 48;
                    case 24 -> 54;
                    case 25 -> 240;
                    case 26 -> 243;
                    case 27 -> 115;
                    case 28 -> 26;
                    case 29 -> 216;
                    case 30 -> 246;
                    case 31 -> 49;
                    case 32 -> 39;
                    case 33 -> 30;
                    case 34 -> 69;
                    case 35 -> 83;
                    case 36 -> 82;
                    case 37 -> 150;
                    case 38 -> 63;
                    case 39 -> 151;
                    case 40 -> 194;
                    case 41 -> 233;
                    case 42 -> 18;
                    case 43 -> 90;
                    case 44 -> 44;
                    case 45 -> 88;
                    case 46 -> 237;
                    case 47 -> 40;
                    case 48 -> 67;
                    case 49 -> 138;
                    case 50 -> 133;
                    case 51 -> 105;
                    case 52 -> 248;
                    case 53 -> 184;
                    case 54 -> 205;
                    case 55 -> 106;
                    case 56 -> 124;
                    case 57 -> 255;
                    case 58 -> 137;
                    case 59 -> 200;
                    case 60 -> 168;
                    case 61 -> 245;
                    case 62 -> 164;
                    case 63 -> 212;
                    case 64 -> 91;
                    case 65 -> 93;
                    case 66 -> 58;
                    case 67 -> 145;
                    case 68 -> 148;
                    case 69 -> 51;
                    case 70 -> 136;
                    case 71 -> 35;
                    case 72 -> 253;
                    case 73 -> 139;
                    case 74 -> 217;
                    case 75 -> 85;
                    case 76 -> 72;
                    case 77 -> 204;
                    case 78 -> 234;
                    case 79 -> 101;
                    case 80 -> 114;
                    case 81 -> 80;
                    case 82 -> 50;
                    case 83 -> 126;
                    case 84 -> 4;
                    case 85 -> 215;
                    case 86 -> 191;
                    case 87 -> 236;
                    case 88 -> 129;
                    case 89 -> 135;
                    case 90 -> 193;
                    case 91 -> 147;
                    case 92 -> 222;
                    case 93 -> 110;
                    case 94 -> 96;
                    case 95 -> 6;
                    case 96 -> 65;
                    case 97 -> 25;
                    case 98 -> 242;
                    case 99 -> 174;
                    case 100 -> 158;
                    case 101 -> 175;
                    case 102 -> 171;
                    case 103 -> 218;
                    case 104 -> 250;
                    case 105 -> 109;
                    case 106 -> 66;
                    case 107 -> 190;
                    case 108 -> 183;
                    case 109 -> 46;
                    case 110 -> 73;
                    case 111 -> 57;
                    case 112 -> 55;
                    case 113 -> 14;
                    case 114 -> 123;
                    case 115 -> 206;
                    case 116 -> 160;
                    case 117 -> 97;
                    case 118 -> 47;
                    case 119 -> 140;
                    case 120 -> 161;
                    case 121 -> 122;
                    case 122 -> 108;
                    case 123 -> 84;
                    case 124 -> 102;
                    case 125 -> 229;
                    case 126 -> 125;
                    case 127 -> 189;
                    case 128 -> 94;
                    case 129 -> 34;
                    case 130 -> 107;
                    case 131 -> 78;
                    case 132 -> 116;
                    case 133 -> 207;
                    case 134 -> 226;
                    case 135 -> 13;
                    case 136 -> 167;
                    case 137 -> 154;
                    case 138 -> 3;
                    case 139 -> 141;
                    case 140 -> 79;
                    case 141 -> 120;
                    case 142 -> 210;
                    case 143 -> 155;
                    case 144 -> 76;
                    case 145 -> 254;
                    case 146 -> 56;
                    case 147 -> 75;
                    case 148 -> 10;
                    case 149 -> 235;
                    case 150 -> 208;
                    case 151 -> 143;
                    case 152 -> 5;
                    case 153 -> 165;
                    case 154 -> 132;
                    case 155 -> 181;
                    case 156 -> 239;
                    case 157 -> 61;
                    case 158 -> 32;
                    case 159 -> 70;
                    case 160 -> 98;
                    case 161 -> 23;
                    case 162 -> 131;
                    case 163 -> 178;
                    case 164 -> 186;
                    case 165 -> 29;
                    case 166 -> 134;
                    case 167 -> 37;
                    case 168 -> 8;
                    case 169 -> 231;
                    case 170 -> 195;
                    case 171 -> 199;
                    case 172 -> 24;
                    case 173 -> 169;
                    case 174 -> 221;
                    case 175 -> 121;
                    case 176 -> 228;
                    case 177 -> 225;
                    case 178 -> 153;
                    case 179 -> 219;
                    case 180 -> 92;
                    case 181 -> 9;
                    case 182 -> 45;
                    case 183 -> 214;
                    case 184 -> 172;
                    case 185 -> 53;
                    case 186 -> 0;
                    case 187 -> 71;
                    case 188 -> 103;
                    case 189 -> 157;
                    case 190 -> 230;
                    case 191 -> 68;
                    case 192 -> 62;
                    case 193 -> 159;
                    case 194 -> 156;
                    case 195 -> 113;
                    case 196 -> 21;
                    case 197 -> 27;
                    case 198 -> 89;
                    case 199 -> 74;
                    case 200 -> 87;
                    case 201 -> 130;
                    case 202 -> 127;
                    case 203 -> 241;
                    case 204 -> 20;
                    case 205 -> 176;
                    case 206 -> 224;
                    case 207 -> 197;
                    case 208 -> 249;
                    case 209 -> 227;
                    case 210 -> 52;
                    case 211 -> 86;
                    case 212 -> 99;
                    case 213 -> 220;
                    case 214 -> 244;
                    case 215 -> 33;
                    case 216 -> 142;
                    case 217 -> 118;
                    case 218 -> 163;
                    case 219 -> 111;
                    case 220 -> 1;
                    case 221 -> 12;
                    case 222 -> 251;
                    case 223 -> 28;
                    case 224 -> 22;
                    case 225 -> 213;
                    case 226 -> 146;
                    case 227 -> 7;
                    case 228 -> 11;
                    case 229 -> 177;
                    case 230 -> 119;
                    case 231 -> 64;
                    case 232 -> 179;
                    case 233 -> 59;
                    case 234 -> 187;
                    case 235 -> 38;
                    case 236 -> 128;
                    case 237 -> 185;
                    case 238 -> 149;
                    case 239 -> 232;
                    case 240 -> 252;
                    case 241 -> 152;
                    case 242 -> 2;
                    case 243 -> 209;
                    case 244 -> 202;
                    case 245 -> 144;
                    case 246 -> 16;
                    case 247 -> 201;
                    case 248 -> 41;
                    case 249 -> 182;
                    case 250 -> 211;
                    case 251 -> 198;
                    case 252 -> 223;
                    case 253 -> 238;
                    case 254 -> 36;
                    default -> 17;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 63582856899402L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(0x999F666 - (char)-23933, 0x999F666 - (char)-19633, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 9891493746253L;
                    String[] stringArray = SshAgentIpcService.L();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(184022280 + (char)-17955, -184022280 + -((char)-24073), (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 62239669760375L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00cb\u00e9)\u00b7\u00a3\u0003\"\u0089B";
                var4_3 = "\u00cb\u00e9)\u00b7\u00a3\u0003\"\u0089B".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 51;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 114;
                                break;
                            }
                            case 1: {
                                v11 = 11;
                                break;
                            }
                            case 2: {
                                v11 = 99;
                                break;
                            }
                            case 3: {
                                v11 = 91;
                                break;
                            }
                            case 4: {
                                v11 = 2;
                                break;
                            }
                            case 5: {
                                v11 = 37;
                                break;
                            }
                            default: {
                                v11 = 97;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x38A9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 123;
                    case 1 -> 187;
                    case 2 -> 173;
                    case 3 -> 209;
                    case 4 -> 177;
                    case 5 -> 170;
                    case 6 -> 207;
                    case 7 -> 171;
                    case 8 -> 46;
                    case 9 -> 47;
                    case 10 -> 159;
                    case 11 -> 143;
                    case 12 -> 11;
                    case 13 -> 255;
                    case 14 -> 43;
                    case 15 -> 88;
                    case 16 -> 41;
                    case 17 -> 108;
                    case 18 -> 242;
                    case 19 -> 165;
                    case 20 -> 110;
                    case 21 -> 59;
                    case 22 -> 137;
                    case 23 -> 6;
                    case 24 -> 82;
                    case 25 -> 254;
                    case 26 -> 211;
                    case 27 -> 96;
                    case 28 -> 185;
                    case 29 -> 13;
                    case 30 -> 156;
                    case 31 -> 98;
                    case 32 -> 18;
                    case 33 -> 253;
                    case 34 -> 31;
                    case 35 -> 2;
                    case 36 -> 236;
                    case 37 -> 202;
                    case 38 -> 63;
                    case 39 -> 95;
                    case 40 -> 244;
                    case 41 -> 164;
                    case 42 -> 218;
                    case 43 -> 192;
                    case 44 -> 58;
                    case 45 -> 245;
                    case 46 -> 222;
                    case 47 -> 73;
                    case 48 -> 3;
                    case 49 -> 102;
                    case 50 -> 12;
                    case 51 -> 25;
                    case 52 -> 213;
                    case 53 -> 203;
                    case 54 -> 35;
                    case 55 -> 250;
                    case 56 -> 78;
                    case 57 -> 120;
                    case 58 -> 72;
                    case 59 -> 198;
                    case 60 -> 107;
                    case 61 -> 51;
                    case 62 -> 112;
                    case 63 -> 174;
                    case 64 -> 24;
                    case 65 -> 230;
                    case 66 -> 240;
                    case 67 -> 94;
                    case 68 -> 28;
                    case 69 -> 168;
                    case 70 -> 37;
                    case 71 -> 97;
                    case 72 -> 200;
                    case 73 -> 201;
                    case 74 -> 26;
                    case 75 -> 125;
                    case 76 -> 238;
                    case 77 -> 118;
                    case 78 -> 248;
                    case 79 -> 219;
                    case 80 -> 178;
                    case 81 -> 183;
                    case 82 -> 188;
                    case 83 -> 19;
                    case 84 -> 61;
                    case 85 -> 186;
                    case 86 -> 16;
                    case 87 -> 42;
                    case 88 -> 109;
                    case 89 -> 38;
                    case 90 -> 48;
                    case 91 -> 113;
                    case 92 -> 235;
                    case 93 -> 229;
                    case 94 -> 223;
                    case 95 -> 154;
                    case 96 -> 36;
                    case 97 -> 247;
                    case 98 -> 64;
                    case 99 -> 60;
                    case 100 -> 243;
                    case 101 -> 239;
                    case 102 -> 93;
                    case 103 -> 79;
                    case 104 -> 5;
                    case 105 -> 77;
                    case 106 -> 181;
                    case 107 -> 205;
                    case 108 -> 197;
                    case 109 -> 251;
                    case 110 -> 146;
                    case 111 -> 217;
                    case 112 -> 160;
                    case 113 -> 34;
                    case 114 -> 76;
                    case 115 -> 162;
                    case 116 -> 122;
                    case 117 -> 141;
                    case 118 -> 199;
                    case 119 -> 166;
                    case 120 -> 140;
                    case 121 -> 193;
                    case 122 -> 103;
                    case 123 -> 210;
                    case 124 -> 158;
                    case 125 -> 214;
                    case 126 -> 69;
                    case 127 -> 221;
                    case 128 -> 135;
                    case 129 -> 40;
                    case 130 -> 132;
                    case 131 -> 172;
                    case 132 -> 116;
                    case 133 -> 29;
                    case 134 -> 68;
                    case 135 -> 233;
                    case 136 -> 33;
                    case 137 -> 224;
                    case 138 -> 114;
                    case 139 -> 80;
                    case 140 -> 66;
                    case 141 -> 129;
                    case 142 -> 190;
                    case 143 -> 22;
                    case 144 -> 9;
                    case 145 -> 71;
                    case 146 -> 195;
                    case 147 -> 55;
                    case 148 -> 161;
                    case 149 -> 252;
                    case 150 -> 75;
                    case 151 -> 134;
                    case 152 -> 228;
                    case 153 -> 138;
                    case 154 -> 91;
                    case 155 -> 237;
                    case 156 -> 14;
                    case 157 -> 56;
                    case 158 -> 149;
                    case 159 -> 194;
                    case 160 -> 99;
                    case 161 -> 39;
                    case 162 -> 100;
                    case 163 -> 50;
                    case 164 -> 130;
                    case 165 -> 184;
                    case 166 -> 83;
                    case 167 -> 45;
                    case 168 -> 182;
                    case 169 -> 119;
                    case 170 -> 179;
                    case 171 -> 90;
                    case 172 -> 216;
                    case 173 -> 147;
                    case 174 -> 180;
                    case 175 -> 8;
                    case 176 -> 62;
                    case 177 -> 44;
                    case 178 -> 115;
                    case 179 -> 70;
                    case 180 -> 104;
                    case 181 -> 4;
                    case 182 -> 126;
                    case 183 -> 152;
                    case 184 -> 220;
                    case 185 -> 49;
                    case 186 -> 89;
                    case 187 -> 67;
                    case 188 -> 208;
                    case 189 -> 57;
                    case 190 -> 117;
                    case 191 -> 85;
                    case 192 -> 17;
                    case 193 -> 15;
                    case 194 -> 32;
                    case 195 -> 176;
                    case 196 -> 246;
                    case 197 -> 1;
                    case 198 -> 232;
                    case 199 -> 206;
                    case 200 -> 105;
                    case 201 -> 124;
                    case 202 -> 144;
                    case 203 -> 148;
                    case 204 -> 142;
                    case 205 -> 111;
                    case 206 -> 0;
                    case 207 -> 30;
                    case 208 -> 227;
                    case 209 -> 133;
                    case 210 -> 191;
                    case 211 -> 167;
                    case 212 -> 54;
                    case 213 -> 87;
                    case 214 -> 225;
                    case 215 -> 226;
                    case 216 -> 65;
                    case 217 -> 10;
                    case 218 -> 157;
                    case 219 -> 139;
                    case 220 -> 27;
                    case 221 -> 169;
                    case 222 -> 127;
                    case 223 -> 155;
                    case 224 -> 84;
                    case 225 -> 153;
                    case 226 -> 196;
                    case 227 -> 215;
                    case 228 -> 136;
                    case 229 -> 86;
                    case 230 -> 92;
                    case 231 -> 20;
                    case 232 -> 21;
                    case 233 -> 151;
                    case 234 -> 101;
                    case 235 -> 53;
                    case 236 -> 212;
                    case 237 -> 189;
                    case 238 -> 128;
                    case 239 -> 163;
                    case 240 -> 81;
                    case 241 -> 150;
                    case 242 -> 234;
                    case 243 -> 74;
                    case 244 -> 175;
                    case 245 -> 204;
                    case 246 -> 145;
                    case 247 -> 231;
                    case 248 -> 23;
                    case 249 -> 241;
                    case 250 -> 121;
                    case 251 -> 249;
                    case 252 -> 52;
                    case 253 -> 131;
                    case 254 -> 7;
                    default -> 106;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

