/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 44191336160237L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(417589020 + (char)-20057, -417589020 + -((char)-10666), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(417589020 + (char)-20058, -417720090 - -((char)-3373), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 134066587408181L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-816697170 + -23701, -816697170 + -29830, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-816697170 + -23702, -816697170 + -26291, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-816697170 + -23695, -816697170 + -22774, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 194132698358L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(859163850 - 9453, -859163850 - -12460, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(859163850 - 9452, -859163850 + -4248, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(859163850 - 9451, 859163850 - 10489, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(859163850 - 9466, 859163850 + 8975, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(859163850 - 9465, -859163850 - -303, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(859163850 - 9451, 859163850 - 10489, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(859163850 - 9464, 859163850 - 12649, (int)l2));
            if (ActionTimestamp.J() != null) {
                SshAgentIpcService.J(new ActionTimestamp[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 113873688973473L;
                    actionTimestampArray = SshAgentIpcService.J();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 111403179292484L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            actionTimestampArray = SshAgentIpcService.J();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(317582610 + 1871, 317582610 + 4189, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1876, 317582610 - 7188, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1877, 317582610 - 918, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(317582610 + 1871, 317582610 + 4189, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1874, 317582610 - 23588, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(317582610 + 1871, 317582610 + 4189, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1875, -317582610 - -10624, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1896, 317582610 - 17430, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1877, 317582610 - 918, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(317582610 + 1871, 317582610 + 4189, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(317582610 + 1883, 317582610 + 849, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(317582610 + 1897, -317582610 + -3613, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 112036686186831L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1830654690 + -((char)-7841), -1830654690 + -((char)-28471), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 121857683503862L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(871353360 + (char)-21513, -871353360 + -((char)-27108), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "l|8\u008dF\u0084\u00d4\u00f5RQ\u0083\u0003\b\u000e\u000bo\u0003\u00aa\u0014\u0014w\u00df[\u00ff1\bG\u00e1\u00a2\u00d5XG\u00b1\u007f\u00fd\u00ca0\u00d8u\u00fc";
                        var4_3 = "l|8\u008dF\u0084\u00d4\u00f5RQ\u0083\u0003\b\u000e\u000bo\u0003\u00aa\u0014\u0014w\u00df[\u00ff1\bG\u00e1\u00a2\u00d5XG\u00b1\u007f\u00fd\u00ca0\u00d8u\u00fc".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 26;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 121;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 95;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 23;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 48;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 13;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 122;
                                        break;
                                    }
                                    default: {
                                        v11 = 50;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x42F0) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 201;
                            case 1 -> 242;
                            case 2 -> 143;
                            case 3 -> 225;
                            case 4 -> 88;
                            case 5 -> 109;
                            case 6 -> 222;
                            case 7 -> 166;
                            case 8 -> 243;
                            case 9 -> 38;
                            case 10 -> 216;
                            case 11 -> 65;
                            case 12 -> 108;
                            case 13 -> 42;
                            case 14 -> 253;
                            case 15 -> 185;
                            case 16 -> 86;
                            case 17 -> 193;
                            case 18 -> 164;
                            case 19 -> 142;
                            case 20 -> 168;
                            case 21 -> 37;
                            case 22 -> 198;
                            case 23 -> 177;
                            case 24 -> 118;
                            case 25 -> 9;
                            case 26 -> 212;
                            case 27 -> 52;
                            case 28 -> 44;
                            case 29 -> 48;
                            case 30 -> 240;
                            case 31 -> 101;
                            case 32 -> 144;
                            case 33 -> 220;
                            case 34 -> 125;
                            case 35 -> 140;
                            case 36 -> 126;
                            case 37 -> 124;
                            case 38 -> 245;
                            case 39 -> 71;
                            case 40 -> 233;
                            case 41 -> 32;
                            case 42 -> 123;
                            case 43 -> 195;
                            case 44 -> 251;
                            case 45 -> 223;
                            case 46 -> 116;
                            case 47 -> 53;
                            case 48 -> 199;
                            case 49 -> 59;
                            case 50 -> 158;
                            case 51 -> 34;
                            case 52 -> 43;
                            case 53 -> 100;
                            case 54 -> 255;
                            case 55 -> 91;
                            case 56 -> 229;
                            case 57 -> 11;
                            case 58 -> 73;
                            case 59 -> 84;
                            case 60 -> 12;
                            case 61 -> 170;
                            case 62 -> 97;
                            case 63 -> 122;
                            case 64 -> 181;
                            case 65 -> 219;
                            case 66 -> 246;
                            case 67 -> 107;
                            case 68 -> 204;
                            case 69 -> 156;
                            case 70 -> 68;
                            case 71 -> 72;
                            case 72 -> 19;
                            case 73 -> 187;
                            case 74 -> 151;
                            case 75 -> 22;
                            case 76 -> 74;
                            case 77 -> 205;
                            case 78 -> 254;
                            case 79 -> 89;
                            case 80 -> 51;
                            case 81 -> 18;
                            case 82 -> 15;
                            case 83 -> 120;
                            case 84 -> 173;
                            case 85 -> 137;
                            case 86 -> 81;
                            case 87 -> 0;
                            case 88 -> 25;
                            case 89 -> 85;
                            case 90 -> 27;
                            case 91 -> 13;
                            case 92 -> 136;
                            case 93 -> 114;
                            case 94 -> 95;
                            case 95 -> 28;
                            case 96 -> 92;
                            case 97 -> 29;
                            case 98 -> 207;
                            case 99 -> 96;
                            case 100 -> 117;
                            case 101 -> 206;
                            case 102 -> 213;
                            case 103 -> 146;
                            case 104 -> 111;
                            case 105 -> 21;
                            case 106 -> 244;
                            case 107 -> 178;
                            case 108 -> 175;
                            case 109 -> 23;
                            case 110 -> 182;
                            case 111 -> 2;
                            case 112 -> 176;
                            case 113 -> 1;
                            case 114 -> 55;
                            case 115 -> 228;
                            case 116 -> 249;
                            case 117 -> 40;
                            case 118 -> 128;
                            case 119 -> 64;
                            case 120 -> 45;
                            case 121 -> 191;
                            case 122 -> 75;
                            case 123 -> 110;
                            case 124 -> 208;
                            case 125 -> 76;
                            case 126 -> 105;
                            case 127 -> 90;
                            case 128 -> 210;
                            case 129 -> 131;
                            case 130 -> 7;
                            case 131 -> 183;
                            case 132 -> 200;
                            case 133 -> 98;
                            case 134 -> 79;
                            case 135 -> 189;
                            case 136 -> 234;
                            case 137 -> 157;
                            case 138 -> 215;
                            case 139 -> 163;
                            case 140 -> 203;
                            case 141 -> 78;
                            case 142 -> 161;
                            case 143 -> 139;
                            case 144 -> 46;
                            case 145 -> 5;
                            case 146 -> 209;
                            case 147 -> 20;
                            case 148 -> 247;
                            case 149 -> 148;
                            case 150 -> 113;
                            case 151 -> 47;
                            case 152 -> 188;
                            case 153 -> 202;
                            case 154 -> 190;
                            case 155 -> 217;
                            case 156 -> 70;
                            case 157 -> 106;
                            case 158 -> 87;
                            case 159 -> 231;
                            case 160 -> 248;
                            case 161 -> 147;
                            case 162 -> 39;
                            case 163 -> 127;
                            case 164 -> 50;
                            case 165 -> 8;
                            case 166 -> 35;
                            case 167 -> 63;
                            case 168 -> 62;
                            case 169 -> 232;
                            case 170 -> 174;
                            case 171 -> 6;
                            case 172 -> 197;
                            case 173 -> 152;
                            case 174 -> 149;
                            case 175 -> 145;
                            case 176 -> 58;
                            case 177 -> 56;
                            case 178 -> 54;
                            case 179 -> 165;
                            case 180 -> 41;
                            case 181 -> 77;
                            case 182 -> 133;
                            case 183 -> 179;
                            case 184 -> 49;
                            case 185 -> 236;
                            case 186 -> 33;
                            case 187 -> 150;
                            case 188 -> 93;
                            case 189 -> 239;
                            case 190 -> 155;
                            case 191 -> 238;
                            case 192 -> 99;
                            case 193 -> 14;
                            case 194 -> 10;
                            case 195 -> 36;
                            case 196 -> 121;
                            case 197 -> 17;
                            case 198 -> 192;
                            case 199 -> 31;
                            case 200 -> 171;
                            case 201 -> 61;
                            case 202 -> 80;
                            case 203 -> 82;
                            case 204 -> 162;
                            case 205 -> 26;
                            case 206 -> 83;
                            case 207 -> 112;
                            case 208 -> 16;
                            case 209 -> 172;
                            case 210 -> 103;
                            case 211 -> 154;
                            case 212 -> 3;
                            case 213 -> 169;
                            case 214 -> 138;
                            case 215 -> 94;
                            case 216 -> 237;
                            case 217 -> 224;
                            case 218 -> 24;
                            case 219 -> 30;
                            case 220 -> 115;
                            case 221 -> 167;
                            case 222 -> 130;
                            case 223 -> 186;
                            case 224 -> 134;
                            case 225 -> 153;
                            case 226 -> 104;
                            case 227 -> 235;
                            case 228 -> 119;
                            case 229 -> 241;
                            case 230 -> 184;
                            case 231 -> 69;
                            case 232 -> 218;
                            case 233 -> 160;
                            case 234 -> 214;
                            case 235 -> 60;
                            case 236 -> 221;
                            case 237 -> 132;
                            case 238 -> 227;
                            case 239 -> 196;
                            case 240 -> 57;
                            case 241 -> 180;
                            case 242 -> 226;
                            case 243 -> 135;
                            case 244 -> 194;
                            case 245 -> 159;
                            case 246 -> 252;
                            case 247 -> 250;
                            case 248 -> 4;
                            case 249 -> 102;
                            case 250 -> 230;
                            case 251 -> 129;
                            case 252 -> 211;
                            case 253 -> 66;
                            case 254 -> 141;
                            default -> 67;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray != null) {
                ActionTimestamp.J(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 128628372464832L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1603117170 - -18519, -1603117170 - -20317, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1603117170 - -18523, -1603117170 - -17497, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1603117170 - -18542, 1603117170 - 18133, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1603117170 - -18519, -1603117170 - -20317, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1603117170 - -18523, -1603117170 - -17497, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1603117170 - -18543, -1603117170 - -17895, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 79108326949555L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.J();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-675665850 - -6467, -675665850 + -4836, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-675665850 - -6466, -675665850 - -1158, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 53977310882773L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = SshAgentIpcService.J();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1838125680 - -15200, -1838125680 - -13422, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1838125680 - -15212, -1838125680 - -16226, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1838125680 - -15197, 1838125680 - 15260, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1838125680 - -15212, -1838125680 - -16226, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1838125680 - -15206, -1838125680 - -18525, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1838125680 - -15200, -1838125680 - -13422, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1838125680 - -15212, -1838125680 - -16226, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1838125680 - -15196, -1838125680 - -12251, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1838125680 - -15200, -1838125680 - -13422, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1838125680 - -15212, -1838125680 - -16226, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1838125680 - -15187, 1838125680 - 20997, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1838125680 - -15200, -1838125680 - -13422, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1838125680 - -15212, -1838125680 - -16226, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1838125680 - -15186, -1838125680 - -11605, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 130786605165714L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.J();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(555998940 + 20699, 555998940 + 18397, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(555998940 + 20703, 555998940 + 19673, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(555998940 + 20682, 555998940 + 9694, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(555998940 + 20683, -555998940 + -26277, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(555998940 + 20699, 555998940 + 18397, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(555998940 + 20703, 555998940 + 19673, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(555998940 + 20676, 555998940 + 28366, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(555998940 + 20699, 555998940 + 18397, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(555998940 + 20703, 555998940 + 19673, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(555998940 + 20677, -555998940 + -((char)-26839), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(555998940 + 20699, 555998940 + 18397, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(555998940 + 20703, 555998940 + 19673, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(555998940 + 20678, -555998940 + -32278, (int)l2));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(555998940 + 20699, 555998940 + 18397, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(555998940 + 20703, 555998940 + 19673, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(555998940 + 20679, -555998940 + -12666, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00a6}I\u0005*\u007f\u0010\u0081\u0014=\u00be\u0002\u009a\u00bd\u0004M\u00f4r\u00f8\u00ca\u001f\u00e5\u0011m\u00c6\u00cb\u0083h\u0087\u0006\u00d7\u00c4g2\u0085\u00d8\u0018\u0081^\u00f5\u00b6\u00c1D\u00c0<\u000b\u009c\u00ea\u00e3\u0087qsH\u00a1;\u000b\r\u00a7\u00805w\tE\"\u00f3\u0088j\u001c\u00ad\u007f\u009a\u0005Y\u00eb\u00b6\u00d7\u00a5\b\u00af\u00d3h\u00a1\\\u00cd\u00d85\u0005nOPCy\u001e]\u0003#\u00ae\u008a\u0083\u000b\u00be\u00d7\u00d8:\u00ec\u00d1\u00b0\u001b\u0014M!D\u00ba\u00e2Y\u0091\u0081\u00e1\u0095\u00d4\u009a\u009f\u00b3\u0010\u0014\u00cb\u00eerd* r\u00cf\u00f3\u00b4t\u0006\u00f6NC\tMg$1\u00c3\f\u00be\u00e2\u0016\u0010J?%\u00ec\u001d\u00f9\u000f\b*\u00bc\b\u009d\u0091\u00cb\u00bc\u00e4?\u00ce\u00a3Y\u00ba\u00c8\b\u00c6\u00a3\u001f\u00aafY\u00e5\u00f0\u00a0%\u00ffbo\u0017\t\u00be\u0097\u001b1.\u00c3YJ\u009d]n$\u00e5\u00b7\u0097;\u008a\u009f_\u000b;\u00e0}\u00ee\u0007<@^\u00d8\u00d3\u00a6\u009b\u0086\u00b9\u00fb\u00a6\u00b8\u0017\u00e0AC\u0094\b9\u0011\u00ba\u00f9\u0006\u00c6\u0093T\f\u00cbL\u00f4I\u00d2\u00b2\u00e7\u00dd\u001eN\u00dc\u00c7F\u00fe\u001fR#\u0006\u00ff}tMw\u00bc$(W\u0006\u00f7\u00d7_j\u001f\u00bb\u00ed\u00c2C\u00ad\u000e\u00a3V\u00f9U\u0011K\u0091\u00f7\u00c3\u00f4o\u00ab\u00be\u00bf\u00bc2\u009d\u00a7\u009f\u00d9F\u00e6\u00f6\u00f4\u00a0\u0089\u001a\u00f5\u009f\u008e\u00fdb\u00ea\u0007\u00cd\u00d6Y{\\X\u0099\u00a7n\u00ae\u001fA\u00d8\u00a0\u00d5\u00fa\u00ec\u0005S\u0016e\u0002[\u00d6[\u00f0\u00d8KP\u00f9^\u009eE\u00c9\u00a9\u008b@\u008e\u00ec\u00c9\u008c\u0015\u000b8\u0018\u008a\u00c3\u001d\u00e3\u001e\u00f7!\u00071\u0015n\u008c@RC\u00b99\u00c1\u00fb!\u00a2\u0018|\u009f\u00b8\u0016\u00b9\u001dz\u008e\u00d8)\u00a5\u001b<\u00adi\u00e3w\u00b2XY\u00cb\u00dc\u00eb\u00a1\u00c9\u00823\u0093-\u0081\u00f4\u00c6B\u00c1\u0095\u0004\u009a\u001cdf\"\u0013\tY\u00b6\u00ac\u00df\u00bd#\u00d4\u00ac\u0007\u00bda5\u00f8l\u0014L\u0007\u0014\u007fdW\u00a1\u000e\u00e3(\u00b0%\u00d2K\u0004U,CC\u00b0\u0082\u00d7\u00e1A\u00ca\u001dT\u00cdo\t\u00dd\u00e9\b\u00efL}\u0017H\u00e2\u008c)W\u0093\u00ba{}\u00dc\u00fa\u00d0\u00cf\u000f\u0095_8-\u00b1\u00f5?\u0094T\u00c7\u00c1h)\u00e2M\"\u0095\u00aa:\u009b\u00a9%oj[B\u00ab\u00bf\u00e4\u00c1L@h\u00e2\u00cc\u00ed\"K8 Il\u00cc\u00cf\u008a.]\u001d\u00c8k\u000e\u00e8%\u0097bD\u001c\u0081\u00a9\u0083`;\u009czv\u001bN\u008cDR\u00c5\u00af$\u0083`\u00a2\u00ca\u00c5\u0014kt\u0003\u00c7 \u0084)\u0010\u00e7\r\u0013\u00a4g$\ne\b\u00e5\u00c5\u00e5\u00b9\u00f3k1\u00dd\u00189\u00d2\u00aa\u0094\u0019\u00cb\u009eQ)1!(\u00d0\u0085\u0010\u00ff<\u00be,\u0083}\u00f9\u00fb\u0083)\u00f8~\u0097\u0001\u001cv\u00d9\u0000\u008d\u000fq\u0016\u00b8\u00f1<\u00f3\u00f3\u00c8\u00ea/6\u0003Su\u00c2\u0000\u00edp\u00d9\u00b7.\u00b8\u00ad\u00f2\u00f7M)\u00a5\u00fd\u00d7w";
                var4_3 = "\u00a6}I\u0005*\u007f\u0010\u0081\u0014=\u00be\u0002\u009a\u00bd\u0004M\u00f4r\u00f8\u00ca\u001f\u00e5\u0011m\u00c6\u00cb\u0083h\u0087\u0006\u00d7\u00c4g2\u0085\u00d8\u0018\u0081^\u00f5\u00b6\u00c1D\u00c0<\u000b\u009c\u00ea\u00e3\u0087qsH\u00a1;\u000b\r\u00a7\u00805w\tE\"\u00f3\u0088j\u001c\u00ad\u007f\u009a\u0005Y\u00eb\u00b6\u00d7\u00a5\b\u00af\u00d3h\u00a1\\\u00cd\u00d85\u0005nOPCy\u001e]\u0003#\u00ae\u008a\u0083\u000b\u00be\u00d7\u00d8:\u00ec\u00d1\u00b0\u001b\u0014M!D\u00ba\u00e2Y\u0091\u0081\u00e1\u0095\u00d4\u009a\u009f\u00b3\u0010\u0014\u00cb\u00eerd* r\u00cf\u00f3\u00b4t\u0006\u00f6NC\tMg$1\u00c3\f\u00be\u00e2\u0016\u0010J?%\u00ec\u001d\u00f9\u000f\b*\u00bc\b\u009d\u0091\u00cb\u00bc\u00e4?\u00ce\u00a3Y\u00ba\u00c8\b\u00c6\u00a3\u001f\u00aafY\u00e5\u00f0\u00a0%\u00ffbo\u0017\t\u00be\u0097\u001b1.\u00c3YJ\u009d]n$\u00e5\u00b7\u0097;\u008a\u009f_\u000b;\u00e0}\u00ee\u0007<@^\u00d8\u00d3\u00a6\u009b\u0086\u00b9\u00fb\u00a6\u00b8\u0017\u00e0AC\u0094\b9\u0011\u00ba\u00f9\u0006\u00c6\u0093T\f\u00cbL\u00f4I\u00d2\u00b2\u00e7\u00dd\u001eN\u00dc\u00c7F\u00fe\u001fR#\u0006\u00ff}tMw\u00bc$(W\u0006\u00f7\u00d7_j\u001f\u00bb\u00ed\u00c2C\u00ad\u000e\u00a3V\u00f9U\u0011K\u0091\u00f7\u00c3\u00f4o\u00ab\u00be\u00bf\u00bc2\u009d\u00a7\u009f\u00d9F\u00e6\u00f6\u00f4\u00a0\u0089\u001a\u00f5\u009f\u008e\u00fdb\u00ea\u0007\u00cd\u00d6Y{\\X\u0099\u00a7n\u00ae\u001fA\u00d8\u00a0\u00d5\u00fa\u00ec\u0005S\u0016e\u0002[\u00d6[\u00f0\u00d8KP\u00f9^\u009eE\u00c9\u00a9\u008b@\u008e\u00ec\u00c9\u008c\u0015\u000b8\u0018\u008a\u00c3\u001d\u00e3\u001e\u00f7!\u00071\u0015n\u008c@RC\u00b99\u00c1\u00fb!\u00a2\u0018|\u009f\u00b8\u0016\u00b9\u001dz\u008e\u00d8)\u00a5\u001b<\u00adi\u00e3w\u00b2XY\u00cb\u00dc\u00eb\u00a1\u00c9\u00823\u0093-\u0081\u00f4\u00c6B\u00c1\u0095\u0004\u009a\u001cdf\"\u0013\tY\u00b6\u00ac\u00df\u00bd#\u00d4\u00ac\u0007\u00bda5\u00f8l\u0014L\u0007\u0014\u007fdW\u00a1\u000e\u00e3(\u00b0%\u00d2K\u0004U,CC\u00b0\u0082\u00d7\u00e1A\u00ca\u001dT\u00cdo\t\u00dd\u00e9\b\u00efL}\u0017H\u00e2\u008c)W\u0093\u00ba{}\u00dc\u00fa\u00d0\u00cf\u000f\u0095_8-\u00b1\u00f5?\u0094T\u00c7\u00c1h)\u00e2M\"\u0095\u00aa:\u009b\u00a9%oj[B\u00ab\u00bf\u00e4\u00c1L@h\u00e2\u00cc\u00ed\"K8 Il\u00cc\u00cf\u008a.]\u001d\u00c8k\u000e\u00e8%\u0097bD\u001c\u0081\u00a9\u0083`;\u009czv\u001bN\u008cDR\u00c5\u00af$\u0083`\u00a2\u00ca\u00c5\u0014kt\u0003\u00c7 \u0084)\u0010\u00e7\r\u0013\u00a4g$\ne\b\u00e5\u00c5\u00e5\u00b9\u00f3k1\u00dd\u00189\u00d2\u00aa\u0094\u0019\u00cb\u009eQ)1!(\u00d0\u0085\u0010\u00ff<\u00be,\u0083}\u00f9\u00fb\u0083)\u00f8~\u0097\u0001\u001cv\u00d9\u0000\u008d\u000fq\u0016\u00b8\u00f1<\u00f3\u00f3\u00c8\u00ea/6\u0003Su\u00c2\u0000\u00edp\u00d9\u00b7.\u00b8\u00ad\u00f2\u00f7M)\u00a5\u00fd\u00d7w".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 108;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ca\u00bdA\u00e1\u00f0L\u001b$\u008a\u001dg2\u00f1\u001dE`gW\u00cfp\u00acl\u0096+l=l\u0088\u00dc60\u008a\u00f5\u000f(\u00c6\u00b4x\u00f7";
                    var4_3 = "\u00ca\u00bdA\u00e1\u00f0L\u001b$\u008a\u001dg2\u00f1\u001dE`gW\u00cfp\u00acl\u0096+l=l\u0088\u00dc60\u008a\u00f5\u000f(\u00c6\u00b4x\u00f7".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 50;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 105;
                            break;
                        }
                        case 1: {
                            v15 = 113;
                            break;
                        }
                        case 2: {
                            v15 = 95;
                            break;
                        }
                        case 3: {
                            v15 = 68;
                            break;
                        }
                        case 4: {
                            v15 = 39;
                            break;
                        }
                        case 5: {
                            v15 = 30;
                            break;
                        }
                        default: {
                            v15 = 126;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x432E) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 238;
                case 1 -> 0;
                case 2 -> 166;
                case 3 -> 39;
                case 4 -> 159;
                case 5 -> 147;
                case 6 -> 116;
                case 7 -> 198;
                case 8 -> 167;
                case 9 -> 16;
                case 10 -> 249;
                case 11 -> 212;
                case 12 -> 252;
                case 13 -> 154;
                case 14 -> 107;
                case 15 -> 59;
                case 16 -> 196;
                case 17 -> 29;
                case 18 -> 70;
                case 19 -> 36;
                case 20 -> 62;
                case 21 -> 94;
                case 22 -> 80;
                case 23 -> 83;
                case 24 -> 234;
                case 25 -> 19;
                case 26 -> 171;
                case 27 -> 253;
                case 28 -> 218;
                case 29 -> 148;
                case 30 -> 150;
                case 31 -> 242;
                case 32 -> 136;
                case 33 -> 125;
                case 34 -> 247;
                case 35 -> 165;
                case 36 -> 132;
                case 37 -> 128;
                case 38 -> 68;
                case 39 -> 206;
                case 40 -> 109;
                case 41 -> 240;
                case 42 -> 236;
                case 43 -> 41;
                case 44 -> 49;
                case 45 -> 189;
                case 46 -> 47;
                case 47 -> 96;
                case 48 -> 120;
                case 49 -> 63;
                case 50 -> 95;
                case 51 -> 106;
                case 52 -> 66;
                case 53 -> 82;
                case 54 -> 195;
                case 55 -> 228;
                case 56 -> 227;
                case 57 -> 169;
                case 58 -> 230;
                case 59 -> 45;
                case 60 -> 50;
                case 61 -> 142;
                case 62 -> 177;
                case 63 -> 209;
                case 64 -> 33;
                case 65 -> 211;
                case 66 -> 254;
                case 67 -> 43;
                case 68 -> 58;
                case 69 -> 60;
                case 70 -> 4;
                case 71 -> 11;
                case 72 -> 37;
                case 73 -> 203;
                case 74 -> 55;
                case 75 -> 183;
                case 76 -> 220;
                case 77 -> 34;
                case 78 -> 217;
                case 79 -> 3;
                case 80 -> 170;
                case 81 -> 137;
                case 82 -> 213;
                case 83 -> 1;
                case 84 -> 30;
                case 85 -> 155;
                case 86 -> 110;
                case 87 -> 118;
                case 88 -> 205;
                case 89 -> 115;
                case 90 -> 32;
                case 91 -> 181;
                case 92 -> 232;
                case 93 -> 138;
                case 94 -> 85;
                case 95 -> 7;
                case 96 -> 161;
                case 97 -> 40;
                case 98 -> 100;
                case 99 -> 86;
                case 100 -> 24;
                case 101 -> 38;
                case 102 -> 67;
                case 103 -> 98;
                case 104 -> 81;
                case 105 -> 10;
                case 106 -> 77;
                case 107 -> 12;
                case 108 -> 21;
                case 109 -> 111;
                case 110 -> 191;
                case 111 -> 202;
                case 112 -> 72;
                case 113 -> 13;
                case 114 -> 69;
                case 115 -> 99;
                case 116 -> 17;
                case 117 -> 179;
                case 118 -> 164;
                case 119 -> 186;
                case 120 -> 2;
                case 121 -> 157;
                case 122 -> 26;
                case 123 -> 93;
                case 124 -> 112;
                case 125 -> 251;
                case 126 -> 48;
                case 127 -> 134;
                case 128 -> 57;
                case 129 -> 129;
                case 130 -> 210;
                case 131 -> 146;
                case 132 -> 42;
                case 133 -> 176;
                case 134 -> 143;
                case 135 -> 214;
                case 136 -> 243;
                case 137 -> 152;
                case 138 -> 87;
                case 139 -> 124;
                case 140 -> 84;
                case 141 -> 250;
                case 142 -> 156;
                case 143 -> 153;
                case 144 -> 20;
                case 145 -> 241;
                case 146 -> 31;
                case 147 -> 91;
                case 148 -> 25;
                case 149 -> 219;
                case 150 -> 221;
                case 151 -> 92;
                case 152 -> 122;
                case 153 -> 114;
                case 154 -> 130;
                case 155 -> 163;
                case 156 -> 101;
                case 157 -> 65;
                case 158 -> 225;
                case 159 -> 244;
                case 160 -> 27;
                case 161 -> 52;
                case 162 -> 235;
                case 163 -> 144;
                case 164 -> 74;
                case 165 -> 51;
                case 166 -> 131;
                case 167 -> 53;
                case 168 -> 15;
                case 169 -> 117;
                case 170 -> 216;
                case 171 -> 229;
                case 172 -> 188;
                case 173 -> 23;
                case 174 -> 35;
                case 175 -> 175;
                case 176 -> 76;
                case 177 -> 208;
                case 178 -> 61;
                case 179 -> 75;
                case 180 -> 160;
                case 181 -> 108;
                case 182 -> 255;
                case 183 -> 248;
                case 184 -> 9;
                case 185 -> 46;
                case 186 -> 246;
                case 187 -> 139;
                case 188 -> 190;
                case 189 -> 245;
                case 190 -> 78;
                case 191 -> 185;
                case 192 -> 223;
                case 193 -> 145;
                case 194 -> 187;
                case 195 -> 207;
                case 196 -> 149;
                case 197 -> 200;
                case 198 -> 97;
                case 199 -> 237;
                case 200 -> 231;
                case 201 -> 222;
                case 202 -> 113;
                case 203 -> 201;
                case 204 -> 8;
                case 205 -> 5;
                case 206 -> 182;
                case 207 -> 215;
                case 208 -> 121;
                case 209 -> 127;
                case 210 -> 123;
                case 211 -> 180;
                case 212 -> 194;
                case 213 -> 104;
                case 214 -> 199;
                case 215 -> 126;
                case 216 -> 102;
                case 217 -> 168;
                case 218 -> 79;
                case 219 -> 226;
                case 220 -> 239;
                case 221 -> 174;
                case 222 -> 178;
                case 223 -> 151;
                case 224 -> 64;
                case 225 -> 14;
                case 226 -> 22;
                case 227 -> 192;
                case 228 -> 71;
                case 229 -> 172;
                case 230 -> 73;
                case 231 -> 233;
                case 232 -> 184;
                case 233 -> 88;
                case 234 -> 224;
                case 235 -> 135;
                case 236 -> 197;
                case 237 -> 89;
                case 238 -> 158;
                case 239 -> 141;
                case 240 -> 28;
                case 241 -> 140;
                case 242 -> 90;
                case 243 -> 193;
                case 244 -> 133;
                case 245 -> 6;
                case 246 -> 44;
                case 247 -> 56;
                case 248 -> 54;
                case 249 -> 173;
                case 250 -> 18;
                case 251 -> 105;
                case 252 -> 119;
                case 253 -> 162;
                case 254 -> 204;
                default -> 103;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 81634957055853L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-513663330 + -6723, -513663330 - -22330, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 90117501004381L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.J();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-497148510 + -((char)-23496), 497148510 + (char)-24330, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-497148510 + -((char)-23495), 497279580 - (char)-4174, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-497148510 + -((char)-23494), -497148510 + -((char)-3810), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "$\u00ab&\u00dc_\u00ae\u008a\u00b9\u0010\\\u00c5\u00d8\u00b0:\u0098\u00df&_F\u00a5Z\u00ce\u0007U\u0012";
                    var4_3 = "$\u00ab&\u00dc_\u00ae\u008a\u00b9\u0010\\\u00c5\u00d8\u00b0:\u0098\u00df&_F\u00a5Z\u00ce\u0007U\u0012".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 53;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "T\u00a9\u00dej\u00c65LZ\u00cax\u0096N\u00a4\u00a1\u00b1\u00fb\u001c\u00db\u00f8+`\u00eb0\u0087o&\u00d7\u00e9ylx\u0001\u00e9Tk\u0095a\u00dd13\u00d3\u00f8\u00eb\u00844\u009b\u00d2N\u00b8\u00a2y\u00e2Rr\u00e5\u009c.\u00c2\u0094";
                        var4_3 = "T\u00a9\u00dej\u00c65LZ\u00cax\u0096N\u00a4\u00a1\u00b1\u00fb\u001c\u00db\u00f8+`\u00eb0\u0087o&\u00d7\u00e9ylx\u0001\u00e9Tk\u0095a\u00dd13\u00d3\u00f8\u00eb\u00844\u009b\u00d2N\u00b8\u00a2y\u00e2Rr\u00e5\u009c.\u00c2\u0094".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 104;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 115;
                                break;
                            }
                            case 1: {
                                v15 = 8;
                                break;
                            }
                            case 2: {
                                v15 = 81;
                                break;
                            }
                            case 3: {
                                v15 = 26;
                                break;
                            }
                            case 4: {
                                v15 = 12;
                                break;
                            }
                            case 5: {
                                v15 = 77;
                                break;
                            }
                            default: {
                                v15 = 93;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD336) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 171;
                    case 1 -> 122;
                    case 2 -> 219;
                    case 3 -> 187;
                    case 4 -> 102;
                    case 5 -> 166;
                    case 6 -> 97;
                    case 7 -> 26;
                    case 8 -> 197;
                    case 9 -> 209;
                    case 10 -> 135;
                    case 11 -> 37;
                    case 12 -> 149;
                    case 13 -> 226;
                    case 14 -> 242;
                    case 15 -> 158;
                    case 16 -> 222;
                    case 17 -> 205;
                    case 18 -> 235;
                    case 19 -> 182;
                    case 20 -> 164;
                    case 21 -> 12;
                    case 22 -> 131;
                    case 23 -> 208;
                    case 24 -> 106;
                    case 25 -> 130;
                    case 26 -> 140;
                    case 27 -> 243;
                    case 28 -> 66;
                    case 29 -> 207;
                    case 30 -> 159;
                    case 31 -> 172;
                    case 32 -> 178;
                    case 33 -> 81;
                    case 34 -> 139;
                    case 35 -> 147;
                    case 36 -> 29;
                    case 37 -> 124;
                    case 38 -> 196;
                    case 39 -> 217;
                    case 40 -> 137;
                    case 41 -> 118;
                    case 42 -> 181;
                    case 43 -> 250;
                    case 44 -> 165;
                    case 45 -> 241;
                    case 46 -> 84;
                    case 47 -> 183;
                    case 48 -> 24;
                    case 49 -> 188;
                    case 50 -> 40;
                    case 51 -> 76;
                    case 52 -> 153;
                    case 53 -> 224;
                    case 54 -> 23;
                    case 55 -> 114;
                    case 56 -> 212;
                    case 57 -> 240;
                    case 58 -> 39;
                    case 59 -> 107;
                    case 60 -> 4;
                    case 61 -> 61;
                    case 62 -> 43;
                    case 63 -> 248;
                    case 64 -> 229;
                    case 65 -> 62;
                    case 66 -> 77;
                    case 67 -> 253;
                    case 68 -> 170;
                    case 69 -> 56;
                    case 70 -> 192;
                    case 71 -> 189;
                    case 72 -> 174;
                    case 73 -> 2;
                    case 74 -> 69;
                    case 75 -> 100;
                    case 76 -> 157;
                    case 77 -> 144;
                    case 78 -> 38;
                    case 79 -> 184;
                    case 80 -> 22;
                    case 81 -> 201;
                    case 82 -> 180;
                    case 83 -> 63;
                    case 84 -> 221;
                    case 85 -> 210;
                    case 86 -> 92;
                    case 87 -> 108;
                    case 88 -> 211;
                    case 89 -> 203;
                    case 90 -> 95;
                    case 91 -> 177;
                    case 92 -> 103;
                    case 93 -> 231;
                    case 94 -> 236;
                    case 95 -> 78;
                    case 96 -> 36;
                    case 97 -> 101;
                    case 98 -> 163;
                    case 99 -> 150;
                    case 100 -> 115;
                    case 101 -> 85;
                    case 102 -> 185;
                    case 103 -> 121;
                    case 104 -> 251;
                    case 105 -> 220;
                    case 106 -> 105;
                    case 107 -> 21;
                    case 108 -> 28;
                    case 109 -> 167;
                    case 110 -> 176;
                    case 111 -> 33;
                    case 112 -> 132;
                    case 113 -> 252;
                    case 114 -> 246;
                    case 115 -> 13;
                    case 116 -> 90;
                    case 117 -> 96;
                    case 118 -> 45;
                    case 119 -> 151;
                    case 120 -> 93;
                    case 121 -> 214;
                    case 122 -> 91;
                    case 123 -> 67;
                    case 124 -> 161;
                    case 125 -> 83;
                    case 126 -> 68;
                    case 127 -> 71;
                    case 128 -> 46;
                    case 129 -> 113;
                    case 130 -> 190;
                    case 131 -> 50;
                    case 132 -> 129;
                    case 133 -> 213;
                    case 134 -> 109;
                    case 135 -> 11;
                    case 136 -> 1;
                    case 137 -> 230;
                    case 138 -> 154;
                    case 139 -> 117;
                    case 140 -> 193;
                    case 141 -> 142;
                    case 142 -> 44;
                    case 143 -> 255;
                    case 144 -> 35;
                    case 145 -> 155;
                    case 146 -> 237;
                    case 147 -> 17;
                    case 148 -> 104;
                    case 149 -> 136;
                    case 150 -> 175;
                    case 151 -> 239;
                    case 152 -> 72;
                    case 153 -> 41;
                    case 154 -> 25;
                    case 155 -> 234;
                    case 156 -> 73;
                    case 157 -> 79;
                    case 158 -> 65;
                    case 159 -> 6;
                    case 160 -> 200;
                    case 161 -> 145;
                    case 162 -> 247;
                    case 163 -> 245;
                    case 164 -> 59;
                    case 165 -> 47;
                    case 166 -> 138;
                    case 167 -> 206;
                    case 168 -> 75;
                    case 169 -> 134;
                    case 170 -> 19;
                    case 171 -> 125;
                    case 172 -> 8;
                    case 173 -> 80;
                    case 174 -> 7;
                    case 175 -> 60;
                    case 176 -> 127;
                    case 177 -> 57;
                    case 178 -> 233;
                    case 179 -> 34;
                    case 180 -> 116;
                    case 181 -> 30;
                    case 182 -> 88;
                    case 183 -> 254;
                    case 184 -> 195;
                    case 185 -> 123;
                    case 186 -> 32;
                    case 187 -> 94;
                    case 188 -> 53;
                    case 189 -> 232;
                    case 190 -> 199;
                    case 191 -> 82;
                    case 192 -> 143;
                    case 193 -> 186;
                    case 194 -> 87;
                    case 195 -> 5;
                    case 196 -> 18;
                    case 197 -> 120;
                    case 198 -> 14;
                    case 199 -> 111;
                    case 200 -> 49;
                    case 201 -> 3;
                    case 202 -> 227;
                    case 203 -> 146;
                    case 204 -> 173;
                    case 205 -> 126;
                    case 206 -> 74;
                    case 207 -> 179;
                    case 208 -> 64;
                    case 209 -> 52;
                    case 210 -> 218;
                    case 211 -> 89;
                    case 212 -> 55;
                    case 213 -> 10;
                    case 214 -> 119;
                    case 215 -> 198;
                    case 216 -> 194;
                    case 217 -> 48;
                    case 218 -> 152;
                    case 219 -> 168;
                    case 220 -> 9;
                    case 221 -> 160;
                    case 222 -> 54;
                    case 223 -> 141;
                    case 224 -> 70;
                    case 225 -> 133;
                    case 226 -> 86;
                    case 227 -> 51;
                    case 228 -> 148;
                    case 229 -> 244;
                    case 230 -> 156;
                    case 231 -> 216;
                    case 232 -> 58;
                    case 233 -> 99;
                    case 234 -> 0;
                    case 235 -> 215;
                    case 236 -> 191;
                    case 237 -> 162;
                    case 238 -> 27;
                    case 239 -> 15;
                    case 240 -> 238;
                    case 241 -> 110;
                    case 242 -> 31;
                    case 243 -> 20;
                    case 244 -> 202;
                    case 245 -> 225;
                    case 246 -> 42;
                    case 247 -> 249;
                    case 248 -> 98;
                    case 249 -> 204;
                    case 250 -> 169;
                    case 251 -> 228;
                    case 252 -> 112;
                    case 253 -> 223;
                    case 254 -> 128;
                    default -> 16;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 115144812589661L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "$ol?&v\u001d}\t#e\u007f5k4\u0000a#";
                    var5_4 = "$ol?&v\u001d}\t#e\u007f5k4\u0000a#".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 112;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 63;
                                    break;
                                }
                                case 1: {
                                    v11 = 122;
                                    break;
                                }
                                case 2: {
                                    v11 = 110;
                                    break;
                                }
                                case 3: {
                                    v11 = 33;
                                    break;
                                }
                                case 4: {
                                    v11 = 51;
                                    break;
                                }
                                case 5: {
                                    v11 = 106;
                                    break;
                                }
                                default: {
                                    v11 = 94;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 69077269072808L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "z=3k\n\u0012Z\u0004|#?q\np<4q\u0006\u0010BZ==\tp<4q\u0006\u0010BV7\rw:)|\f\u001dXV0.v\r\u0014";
                    var5_4 = "z=3k\n\u0012Z\u0004|#?q\np<4q\u0006\u0010BZ==\tp<4q\u0006\u0010BV7\rw:)|\f\u001dXV0.v\r\u0014".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 45;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "k$.w\u0011\u0006J\u0006k$.w\u001d\f";
                        var5_4 = "k$.w\u0011\u0006J\u0006k$.w\u001d\f".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 54;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 30;
                                break;
                            }
                            case 1: {
                                v15 = 126;
                                break;
                            }
                            case 2: {
                                v15 = 119;
                                break;
                            }
                            case 3: {
                                v15 = 50;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 94;
                                break;
                            }
                            default: {
                                v15 = 27;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 15360659716490L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1856606550 + (char)-23197, -1856606550 + -((char)-4510), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 33542044655208L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00f9\u00ba\u00a5\u00cb\u00a6\u0003\u0010\u009e,\u0005\u0013\u00bd\u00de\u00ef*\r\u001e\u00c2IJ-iuo\u00db\u00f5'{C\u0010\u0017j\u00af\u00b4\u00ce#\"\u001b\u00f8\u00ff\u00a0wU\u00c1l\u00d2\u0005\u009a\u00ae\u00ef\u008d\f3\u00f9\u00c4\u0092\u00b7\u00bc\u0007\\\u008bJ\u0010}\u00a3(\n\u00ef\u00b4\u0019p\u00d1\u001525M\u00972\r\u0084\u0016\u00c4\u0087C\u00c5X[\u008b\"\u00f4u`C\b\u009aN\u00e4>_8\"\u00b4\u001a\u001a";
                    var4_3 = "\u00f9\u00ba\u00a5\u00cb\u00a6\u0003\u0010\u009e,\u0005\u0013\u00bd\u00de\u00ef*\r\u001e\u00c2IJ-iuo\u00db\u00f5'{C\u0010\u0017j\u00af\u00b4\u00ce#\"\u001b\u00f8\u00ff\u00a0wU\u00c1l\u00d2\u0005\u009a\u00ae\u00ef\u008d\f3\u00f9\u00c4\u0092\u00b7\u00bc\u0007\\\u008bJ\u0010}\u00a3(\n\u00ef\u00b4\u0019p\u00d1\u001525M\u00972\r\u0084\u0016\u00c4\u0087C\u00c5X[\u008b\"\u00f4u`C\b\u009aN\u00e4>_8\"\u00b4\u001a\u001a".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "L\u009a\u00cd\u00a3\u008b\u00c8\u0083o\u00c5x\u000e\u008e\u0089\u00f7\u00fe\u001dL\u00f4\u0096-\u00e8\u00bdi+5Y\u00a01,`-P?\u00e2\u00d9X\u00dfb\u0001d\u00ba=JI1\u008e#\u00ec7\u00b4\u00e2n\u0000s\u00e6\u00a3^O\u00cd`z\u00e7[\u00c1\u0093p\u0011c\u0006Y\u00c0\u00c6\u009f\f\u009e\u00a5\u00e6\u00a8#_\u00f1\u0097!\u00e1b\u0010\u001f\b\u00a9\u00064\u00c9\u00f5";
                        var4_3 = "L\u009a\u00cd\u00a3\u008b\u00c8\u0083o\u00c5x\u000e\u008e\u0089\u00f7\u00fe\u001dL\u00f4\u0096-\u00e8\u00bdi+5Y\u00a01,`-P?\u00e2\u00d9X\u00dfb\u0001d\u00ba=JI1\u008e#\u00ec7\u00b4\u00e2n\u0000s\u00e6\u00a3^O\u00cd`z\u00e7[\u00c1\u0093p\u0011c\u0006Y\u00c0\u00c6\u009f\f\u009e\u00a5\u00e6\u00a8#_\u00f1\u0097!\u00e1b\u0010\u001f\b\u00a9\u00064\u00c9\u00f5".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 109;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 67;
                                break;
                            }
                            case 1: {
                                v15 = 77;
                                break;
                            }
                            case 2: {
                                v15 = 19;
                                break;
                            }
                            case 3: {
                                v15 = 25;
                                break;
                            }
                            case 4: {
                                v15 = 4;
                                break;
                            }
                            case 5: {
                                v15 = 76;
                                break;
                            }
                            default: {
                                v15 = 101;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4F33) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 67;
                    case 1 -> 75;
                    case 2 -> 213;
                    case 3 -> 212;
                    case 4 -> 209;
                    case 5 -> 239;
                    case 6 -> 12;
                    case 7 -> 251;
                    case 8 -> 206;
                    case 9 -> 126;
                    case 10 -> 203;
                    case 11 -> 76;
                    case 12 -> 130;
                    case 13 -> 196;
                    case 14 -> 103;
                    case 15 -> 255;
                    case 16 -> 99;
                    case 17 -> 161;
                    case 18 -> 129;
                    case 19 -> 249;
                    case 20 -> 218;
                    case 21 -> 34;
                    case 22 -> 48;
                    case 23 -> 49;
                    case 24 -> 44;
                    case 25 -> 175;
                    case 26 -> 171;
                    case 27 -> 242;
                    case 28 -> 243;
                    case 29 -> 55;
                    case 30 -> 204;
                    case 31 -> 250;
                    case 32 -> 195;
                    case 33 -> 123;
                    case 34 -> 160;
                    case 35 -> 234;
                    case 36 -> 207;
                    case 37 -> 201;
                    case 38 -> 3;
                    case 39 -> 216;
                    case 40 -> 225;
                    case 41 -> 176;
                    case 42 -> 85;
                    case 43 -> 192;
                    case 44 -> 35;
                    case 45 -> 66;
                    case 46 -> 244;
                    case 47 -> 17;
                    case 48 -> 194;
                    case 49 -> 95;
                    case 50 -> 7;
                    case 51 -> 50;
                    case 52 -> 215;
                    case 53 -> 231;
                    case 54 -> 153;
                    case 55 -> 19;
                    case 56 -> 37;
                    case 57 -> 119;
                    case 58 -> 65;
                    case 59 -> 38;
                    case 60 -> 169;
                    case 61 -> 164;
                    case 62 -> 86;
                    case 63 -> 8;
                    case 64 -> 90;
                    case 65 -> 144;
                    case 66 -> 108;
                    case 67 -> 51;
                    case 68 -> 71;
                    case 69 -> 127;
                    case 70 -> 147;
                    case 71 -> 64;
                    case 72 -> 115;
                    case 73 -> 73;
                    case 74 -> 198;
                    case 75 -> 189;
                    case 76 -> 116;
                    case 77 -> 183;
                    case 78 -> 137;
                    case 79 -> 121;
                    case 80 -> 217;
                    case 81 -> 31;
                    case 82 -> 173;
                    case 83 -> 47;
                    case 84 -> 241;
                    case 85 -> 211;
                    case 86 -> 230;
                    case 87 -> 190;
                    case 88 -> 122;
                    case 89 -> 94;
                    case 90 -> 140;
                    case 91 -> 21;
                    case 92 -> 248;
                    case 93 -> 200;
                    case 94 -> 159;
                    case 95 -> 29;
                    case 96 -> 191;
                    case 97 -> 87;
                    case 98 -> 10;
                    case 99 -> 182;
                    case 100 -> 148;
                    case 101 -> 210;
                    case 102 -> 184;
                    case 103 -> 237;
                    case 104 -> 205;
                    case 105 -> 91;
                    case 106 -> 30;
                    case 107 -> 24;
                    case 108 -> 20;
                    case 109 -> 78;
                    case 110 -> 219;
                    case 111 -> 188;
                    case 112 -> 150;
                    case 113 -> 228;
                    case 114 -> 18;
                    case 115 -> 84;
                    case 116 -> 106;
                    case 117 -> 74;
                    case 118 -> 236;
                    case 119 -> 154;
                    case 120 -> 83;
                    case 121 -> 22;
                    case 122 -> 247;
                    case 123 -> 109;
                    case 124 -> 13;
                    case 125 -> 181;
                    case 126 -> 110;
                    case 127 -> 72;
                    case 128 -> 104;
                    case 129 -> 114;
                    case 130 -> 120;
                    case 131 -> 93;
                    case 132 -> 62;
                    case 133 -> 105;
                    case 134 -> 253;
                    case 135 -> 246;
                    case 136 -> 57;
                    case 137 -> 96;
                    case 138 -> 185;
                    case 139 -> 143;
                    case 140 -> 14;
                    case 141 -> 128;
                    case 142 -> 56;
                    case 143 -> 5;
                    case 144 -> 60;
                    case 145 -> 179;
                    case 146 -> 254;
                    case 147 -> 134;
                    case 148 -> 125;
                    case 149 -> 25;
                    case 150 -> 193;
                    case 151 -> 145;
                    case 152 -> 135;
                    case 153 -> 43;
                    case 154 -> 54;
                    case 155 -> 92;
                    case 156 -> 117;
                    case 157 -> 177;
                    case 158 -> 39;
                    case 159 -> 158;
                    case 160 -> 27;
                    case 161 -> 69;
                    case 162 -> 45;
                    case 163 -> 61;
                    case 164 -> 162;
                    case 165 -> 77;
                    case 166 -> 113;
                    case 167 -> 165;
                    case 168 -> 59;
                    case 169 -> 163;
                    case 170 -> 136;
                    case 171 -> 9;
                    case 172 -> 101;
                    case 173 -> 26;
                    case 174 -> 131;
                    case 175 -> 151;
                    case 176 -> 238;
                    case 177 -> 226;
                    case 178 -> 156;
                    case 179 -> 33;
                    case 180 -> 224;
                    case 181 -> 58;
                    case 182 -> 168;
                    case 183 -> 42;
                    case 184 -> 36;
                    case 185 -> 11;
                    case 186 -> 89;
                    case 187 -> 2;
                    case 188 -> 152;
                    case 189 -> 102;
                    case 190 -> 53;
                    case 191 -> 155;
                    case 192 -> 214;
                    case 193 -> 79;
                    case 194 -> 23;
                    case 195 -> 221;
                    case 196 -> 229;
                    case 197 -> 178;
                    case 198 -> 16;
                    case 199 -> 97;
                    case 200 -> 167;
                    case 201 -> 118;
                    case 202 -> 197;
                    case 203 -> 186;
                    case 204 -> 139;
                    case 205 -> 63;
                    case 206 -> 111;
                    case 207 -> 1;
                    case 208 -> 88;
                    case 209 -> 81;
                    case 210 -> 52;
                    case 211 -> 40;
                    case 212 -> 124;
                    case 213 -> 245;
                    case 214 -> 82;
                    case 215 -> 149;
                    case 216 -> 223;
                    case 217 -> 98;
                    case 218 -> 141;
                    case 219 -> 28;
                    case 220 -> 146;
                    case 221 -> 41;
                    case 222 -> 133;
                    case 223 -> 4;
                    case 224 -> 68;
                    case 225 -> 15;
                    case 226 -> 233;
                    case 227 -> 187;
                    case 228 -> 252;
                    case 229 -> 180;
                    case 230 -> 172;
                    case 231 -> 70;
                    case 232 -> 199;
                    case 233 -> 100;
                    case 234 -> 112;
                    case 235 -> 80;
                    case 236 -> 142;
                    case 237 -> 157;
                    case 238 -> 232;
                    case 239 -> 46;
                    case 240 -> 32;
                    case 241 -> 222;
                    case 242 -> 240;
                    case 243 -> 220;
                    case 244 -> 0;
                    case 245 -> 202;
                    case 246 -> 132;
                    case 247 -> 6;
                    case 248 -> 170;
                    case 249 -> 227;
                    case 250 -> 174;
                    case 251 -> 166;
                    case 252 -> 107;
                    case 253 -> 208;
                    case 254 -> 235;
                    default -> 138;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 111968729230902L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1068220500 - 30936, 1068220500 - 30215, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 134447383602286L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2022279030 + -((char)-21659), 2022279030 + (char)-31964, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 17952537314507L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "t(\u00f1C_\u0003\u00a1'\u001d";
                var4_3 = "t(\u00f1C_\u0003\u00a1'\u001d".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 61;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 55;
                                break;
                            }
                            case 1: {
                                v11 = 58;
                                break;
                            }
                            case 2: {
                                v11 = 43;
                                break;
                            }
                            case 3: {
                                v11 = 126;
                                break;
                            }
                            case 4: {
                                v11 = 35;
                                break;
                            }
                            case 5: {
                                v11 = 70;
                                break;
                            }
                            default: {
                                v11 = 122;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA94A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 79;
                    case 1 -> 74;
                    case 2 -> 115;
                    case 3 -> 8;
                    case 4 -> 35;
                    case 5 -> 213;
                    case 6 -> 203;
                    case 7 -> 182;
                    case 8 -> 81;
                    case 9 -> 163;
                    case 10 -> 61;
                    case 11 -> 206;
                    case 12 -> 221;
                    case 13 -> 161;
                    case 14 -> 224;
                    case 15 -> 40;
                    case 16 -> 191;
                    case 17 -> 43;
                    case 18 -> 99;
                    case 19 -> 72;
                    case 20 -> 150;
                    case 21 -> 244;
                    case 22 -> 165;
                    case 23 -> 176;
                    case 24 -> 145;
                    case 25 -> 100;
                    case 26 -> 250;
                    case 27 -> 149;
                    case 28 -> 243;
                    case 29 -> 228;
                    case 30 -> 255;
                    case 31 -> 24;
                    case 32 -> 240;
                    case 33 -> 47;
                    case 34 -> 109;
                    case 35 -> 202;
                    case 36 -> 4;
                    case 37 -> 186;
                    case 38 -> 129;
                    case 39 -> 39;
                    case 40 -> 223;
                    case 41 -> 141;
                    case 42 -> 133;
                    case 43 -> 3;
                    case 44 -> 70;
                    case 45 -> 9;
                    case 46 -> 11;
                    case 47 -> 197;
                    case 48 -> 235;
                    case 49 -> 33;
                    case 50 -> 112;
                    case 51 -> 45;
                    case 52 -> 125;
                    case 53 -> 7;
                    case 54 -> 14;
                    case 55 -> 164;
                    case 56 -> 84;
                    case 57 -> 139;
                    case 58 -> 69;
                    case 59 -> 105;
                    case 60 -> 162;
                    case 61 -> 227;
                    case 62 -> 113;
                    case 63 -> 42;
                    case 64 -> 218;
                    case 65 -> 155;
                    case 66 -> 153;
                    case 67 -> 158;
                    case 68 -> 234;
                    case 69 -> 87;
                    case 70 -> 170;
                    case 71 -> 118;
                    case 72 -> 239;
                    case 73 -> 46;
                    case 74 -> 128;
                    case 75 -> 246;
                    case 76 -> 225;
                    case 77 -> 171;
                    case 78 -> 91;
                    case 79 -> 175;
                    case 80 -> 135;
                    case 81 -> 199;
                    case 82 -> 58;
                    case 83 -> 64;
                    case 84 -> 98;
                    case 85 -> 210;
                    case 86 -> 219;
                    case 87 -> 93;
                    case 88 -> 101;
                    case 89 -> 27;
                    case 90 -> 66;
                    case 91 -> 82;
                    case 92 -> 56;
                    case 93 -> 114;
                    case 94 -> 67;
                    case 95 -> 120;
                    case 96 -> 217;
                    case 97 -> 71;
                    case 98 -> 216;
                    case 99 -> 138;
                    case 100 -> 144;
                    case 101 -> 180;
                    case 102 -> 188;
                    case 103 -> 80;
                    case 104 -> 121;
                    case 105 -> 116;
                    case 106 -> 193;
                    case 107 -> 59;
                    case 108 -> 245;
                    case 109 -> 25;
                    case 110 -> 179;
                    case 111 -> 0;
                    case 112 -> 34;
                    case 113 -> 195;
                    case 114 -> 102;
                    case 115 -> 2;
                    case 116 -> 12;
                    case 117 -> 6;
                    case 118 -> 51;
                    case 119 -> 181;
                    case 120 -> 83;
                    case 121 -> 104;
                    case 122 -> 236;
                    case 123 -> 152;
                    case 124 -> 88;
                    case 125 -> 194;
                    case 126 -> 92;
                    case 127 -> 127;
                    case 128 -> 198;
                    case 129 -> 247;
                    case 130 -> 89;
                    case 131 -> 76;
                    case 132 -> 220;
                    case 133 -> 251;
                    case 134 -> 15;
                    case 135 -> 26;
                    case 136 -> 192;
                    case 137 -> 178;
                    case 138 -> 254;
                    case 139 -> 18;
                    case 140 -> 16;
                    case 141 -> 63;
                    case 142 -> 189;
                    case 143 -> 108;
                    case 144 -> 185;
                    case 145 -> 44;
                    case 146 -> 126;
                    case 147 -> 209;
                    case 148 -> 229;
                    case 149 -> 156;
                    case 150 -> 95;
                    case 151 -> 37;
                    case 152 -> 90;
                    case 153 -> 49;
                    case 154 -> 207;
                    case 155 -> 201;
                    case 156 -> 62;
                    case 157 -> 169;
                    case 158 -> 117;
                    case 159 -> 110;
                    case 160 -> 196;
                    case 161 -> 94;
                    case 162 -> 106;
                    case 163 -> 159;
                    case 164 -> 230;
                    case 165 -> 168;
                    case 166 -> 183;
                    case 167 -> 143;
                    case 168 -> 208;
                    case 169 -> 160;
                    case 170 -> 132;
                    case 171 -> 28;
                    case 172 -> 119;
                    case 173 -> 111;
                    case 174 -> 31;
                    case 175 -> 5;
                    case 176 -> 211;
                    case 177 -> 19;
                    case 178 -> 23;
                    case 179 -> 147;
                    case 180 -> 157;
                    case 181 -> 142;
                    case 182 -> 78;
                    case 183 -> 146;
                    case 184 -> 50;
                    case 185 -> 172;
                    case 186 -> 36;
                    case 187 -> 238;
                    case 188 -> 241;
                    case 189 -> 103;
                    case 190 -> 232;
                    case 191 -> 130;
                    case 192 -> 166;
                    case 193 -> 48;
                    case 194 -> 123;
                    case 195 -> 154;
                    case 196 -> 122;
                    case 197 -> 73;
                    case 198 -> 38;
                    case 199 -> 97;
                    case 200 -> 248;
                    case 201 -> 107;
                    case 202 -> 173;
                    case 203 -> 53;
                    case 204 -> 86;
                    case 205 -> 134;
                    case 206 -> 249;
                    case 207 -> 22;
                    case 208 -> 137;
                    case 209 -> 13;
                    case 210 -> 75;
                    case 211 -> 10;
                    case 212 -> 242;
                    case 213 -> 1;
                    case 214 -> 52;
                    case 215 -> 253;
                    case 216 -> 17;
                    case 217 -> 222;
                    case 218 -> 151;
                    case 219 -> 148;
                    case 220 -> 60;
                    case 221 -> 174;
                    case 222 -> 231;
                    case 223 -> 212;
                    case 224 -> 55;
                    case 225 -> 205;
                    case 226 -> 237;
                    case 227 -> 57;
                    case 228 -> 190;
                    case 229 -> 131;
                    case 230 -> 184;
                    case 231 -> 29;
                    case 232 -> 136;
                    case 233 -> 204;
                    case 234 -> 54;
                    case 235 -> 252;
                    case 236 -> 167;
                    case 237 -> 187;
                    case 238 -> 177;
                    case 239 -> 124;
                    case 240 -> 30;
                    case 241 -> 214;
                    case 242 -> 41;
                    case 243 -> 68;
                    case 244 -> 96;
                    case 245 -> 20;
                    case 246 -> 32;
                    case 247 -> 21;
                    case 248 -> 226;
                    case 249 -> 65;
                    case 250 -> 215;
                    case 251 -> 200;
                    case 252 -> 85;
                    case 253 -> 233;
                    case 254 -> 77;
                    default -> 140;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

