/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.schema.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookCellSchema;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaBase;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v3.V3JupyterNotebookCellSchema;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/schema/v3/V3JupyterNotebookSchema;", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;", "version", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;)V", "kernelInfoFieldName", "", "languageFieldName", "nameFieldName", "displayNameFieldName", "cellSchema", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "getCellSchema", "()Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "getLanguage", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getJupyterKernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelBase;", "setJupyterKernelSpec", "", "value", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "getCells", "Lcom/fasterxml/jackson/databind/JsonNode;", "createEmptyNotebook", "intellij.jupyter.core"})
public final class V3JupyterNotebookSchema
extends JupyterNotebookSchemaBase
implements JupyterNotebookSchema {
    @NotNull
    private final String kernelInfoFieldName;
    @NotNull
    private final String languageFieldName;
    @NotNull
    private final String nameFieldName;
    @NotNull
    private final String displayNameFieldName;

    public V3JupyterNotebookSchema(@NotNull JupyterNotebookSchemaVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(version);
        this.kernelInfoFieldName = "kernel_info";
        this.languageFieldName = "language";
        this.nameFieldName = "name";
        this.displayNameFieldName = "display_name";
    }

    @Override
    @NotNull
    public JupyterNotebookCellSchema getCellSchema() {
        return V3JupyterNotebookCellSchema.INSTANCE;
    }

    @Override
    @Nullable
    public String getLanguage(@NotNull ObjectNode json) {
        JsonNode jsonNode;
        JsonNode jsonNode2;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode jsonNode3 = json.get("metadata");
        return jsonNode3 != null && (jsonNode2 = jsonNode3.get(this.kernelInfoFieldName)) != null && (jsonNode = jsonNode2.get(this.languageFieldName)) != null ? jsonNode.asText() : null;
    }

    @Override
    @Nullable
    public JupyterKernelBase getJupyterKernelSpec(@NotNull ObjectNode json) {
        JupyterKernelBase jupyterKernelBase;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JupyterMetadata jupyterMetadata = this.getMetadata(json).getObject(this.kernelInfoFieldName);
        if (jupyterMetadata != null) {
            JupyterMetadata it = jupyterMetadata;
            boolean bl = false;
            String string = it.getString(this.languageFieldName);
            if (string == null) {
                return null;
            }
            String language = string;
            String string2 = it.getString(this.nameFieldName);
            if (string2 == null) {
                return null;
            }
            String name = string2;
            String string3 = it.getString(this.displayNameFieldName);
            if (string3 == null) {
                string3 = name;
            }
            String displayName = string3;
            jupyterKernelBase = new JupyterKernelBase(displayName, language, name, null, null, 24, null);
        } else {
            jupyterKernelBase = null;
        }
        return jupyterKernelBase;
    }

    @Override
    public void setJupyterKernelSpec(@NotNull ObjectNode json, @Nullable JupyterKernelSpec value) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JupyterMetadata metadataField = this.getMetadata(json);
        JupyterKernelSpec jupyterKernelSpec = value;
        if (jupyterKernelSpec != null) {
            JupyterKernelSpec $this$setJupyterKernelSpec_u24lambda_u242 = jupyterKernelSpec;
            boolean bl = false;
            metadataField.setObject(this.kernelInfoFieldName, (Function1<? super JupyterMetadata, Unit>)((Function1)arg_0 -> V3JupyterNotebookSchema.setJupyterKernelSpec$lambda$2$lambda$1(this, value, arg_0)));
        } else {
            metadataField.remove(this.kernelInfoFieldName);
        }
    }

    @Override
    @Nullable
    public JsonNode getCells(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode jsonNode = json.get("worksheets");
        return jsonNode != null && (jsonNode = (JsonNode)CollectionsKt.first((Iterable)((Iterable)jsonNode))) != null ? jsonNode.get("cells") : null;
    }

    @Override
    @NotNull
    public ObjectNode createEmptyNotebook() {
        ObjectNode objectNode;
        ObjectNode $this$createEmptyNotebook_u24lambda_u243 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        $this$createEmptyNotebook_u24lambda_u243.putArray("worksheets").addObject().putArray("cells");
        $this$createEmptyNotebook_u24lambda_u243.putObject("metadata");
        $this$createEmptyNotebook_u24lambda_u243.put("nbformat", this.getVersion().getMajor());
        $this$createEmptyNotebook_u24lambda_u243.put("nbformat_minor", this.getVersion().getMinor());
        ObjectNode objectNode2 = objectNode;
        Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"apply(...)");
        return objectNode2;
    }

    private static final Unit setJupyterKernelSpec$lambda$2$lambda$1(V3JupyterNotebookSchema this$0, JupyterKernelSpec $value, JupyterMetadata $this$setObject) {
        Intrinsics.checkNotNullParameter((Object)$this$setObject, (String)"$this$setObject");
        $this$setObject.setString(this$0.nameFieldName, $value.getName());
        $this$setObject.setString(this$0.languageFieldName, $value.getLanguage());
        $this$setObject.setString(this$0.displayNameFieldName, $value.getDisplayName());
        return Unit.INSTANCE;
    }
}

