/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 81611905996826L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1062584490 - 30871, -1062584490 - -29591, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1062584490 - 30872, 1062584490 - 24767, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 126770495933194L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-241168800 + -((char)-3233), -241168800 + -((char)-27270), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-241168800 + -((char)-3232), 241168800 + (char)-19745, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-241168800 + -((char)-3239), -241168800 + -((char)-18558), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 51731518087409L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1362996930 + 571, -1362996930 + -11277, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1362996930 + 572, -1362996930 + -19629, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1362996930 + 573, -1362996930 + -10936, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1362996930 + 558, -1362996930 - -10449, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1362996930 + 559, -1362996930 + -18453, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1362996930 + 560, -1362996930 + -19921, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1362996930 + 558, -1362996930 - -10449, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1362996930 + 561, 1362996930 + 9033, (int)l2));
            if (ActionTimestamp.d() != null) {
                SshAgentIpcService.d(new ActionTimestamp[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 70457511385617L;
                    actionTimestampArray = SshAgentIpcService.d();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 68425937836803L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            actionTimestampArray = SshAgentIpcService.d();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1481091000 + 25422, -1481091000 + -((char)-23371), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25423, 1481091000 + 29106, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25420, -1481091000 + -((char)-27089), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1481091000 + 25422, -1481091000 + -((char)-23371), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25421, 1481091000 + 29284, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1481091000 + 25422, -1481091000 + -((char)-23371), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25442, 1481091000 + (char)-26399, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25443, -1481091000 + -((char)-20643), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25420, -1481091000 + -((char)-27089), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1481091000 + 25422, -1481091000 + -((char)-23371), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1481091000 + 25418, -1481091000 + -((char)-27061), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1481091000 + 25440, 1481091000 + 26923, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 51959959866009L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(554557170 - (char)-1020, -554426100 + -((char)-6928), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 103493953930178L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1872990300 + 23384, -1872990300 + -21319, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00a4\u00e6\r\u0016K[\u009f\u009e\u00b3\u0010w\u0080:\u0094\u00dd\u00b4\u00f5\u0019a\u0014\u0088\u0019\u0088\u00ef\u00e0\u00a6\u0097\u00a40Q\u00c2|N\u00f2\u0092\u00f3\u00f17\u00e6\u00ad";
                        var4_3 = "\u00a4\u00e6\r\u0016K[\u009f\u009e\u00b3\u0010w\u0080:\u0094\u00dd\u00b4\u00f5\u0019a\u0014\u0088\u0019\u0088\u00ef\u00e0\u00a6\u0097\u00a40Q\u00c2|N\u00f2\u0092\u00f3\u00f17\u00e6\u00ad".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 32;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 83;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 9;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 3;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 79;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 89;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 68;
                                        break;
                                    }
                                    default: {
                                        v11 = 47;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFA877) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 248;
                            case 1 -> 202;
                            case 2 -> 198;
                            case 3 -> 86;
                            case 4 -> 154;
                            case 5 -> 81;
                            case 6 -> 34;
                            case 7 -> 33;
                            case 8 -> 233;
                            case 9 -> 136;
                            case 10 -> 50;
                            case 11 -> 144;
                            case 12 -> 231;
                            case 13 -> 104;
                            case 14 -> 224;
                            case 15 -> 196;
                            case 16 -> 64;
                            case 17 -> 225;
                            case 18 -> 128;
                            case 19 -> 55;
                            case 20 -> 105;
                            case 21 -> 46;
                            case 22 -> 75;
                            case 23 -> 251;
                            case 24 -> 17;
                            case 25 -> 176;
                            case 26 -> 177;
                            case 27 -> 121;
                            case 28 -> 163;
                            case 29 -> 247;
                            case 30 -> 2;
                            case 31 -> 203;
                            case 32 -> 97;
                            case 33 -> 179;
                            case 34 -> 133;
                            case 35 -> 77;
                            case 36 -> 140;
                            case 37 -> 118;
                            case 38 -> 191;
                            case 39 -> 21;
                            case 40 -> 226;
                            case 41 -> 110;
                            case 42 -> 142;
                            case 43 -> 57;
                            case 44 -> 18;
                            case 45 -> 92;
                            case 46 -> 66;
                            case 47 -> 234;
                            case 48 -> 153;
                            case 49 -> 199;
                            case 50 -> 94;
                            case 51 -> 14;
                            case 52 -> 138;
                            case 53 -> 171;
                            case 54 -> 220;
                            case 55 -> 208;
                            case 56 -> 141;
                            case 57 -> 149;
                            case 58 -> 90;
                            case 59 -> 114;
                            case 60 -> 89;
                            case 61 -> 165;
                            case 62 -> 242;
                            case 63 -> 30;
                            case 64 -> 132;
                            case 65 -> 252;
                            case 66 -> 187;
                            case 67 -> 253;
                            case 68 -> 134;
                            case 69 -> 148;
                            case 70 -> 51;
                            case 71 -> 43;
                            case 72 -> 101;
                            case 73 -> 23;
                            case 74 -> 20;
                            case 75 -> 52;
                            case 76 -> 143;
                            case 77 -> 175;
                            case 78 -> 250;
                            case 79 -> 185;
                            case 80 -> 216;
                            case 81 -> 215;
                            case 82 -> 68;
                            case 83 -> 218;
                            case 84 -> 172;
                            case 85 -> 156;
                            case 86 -> 243;
                            case 87 -> 5;
                            case 88 -> 56;
                            case 89 -> 38;
                            case 90 -> 103;
                            case 91 -> 186;
                            case 92 -> 44;
                            case 93 -> 15;
                            case 94 -> 125;
                            case 95 -> 41;
                            case 96 -> 106;
                            case 97 -> 213;
                            case 98 -> 229;
                            case 99 -> 200;
                            case 100 -> 98;
                            case 101 -> 188;
                            case 102 -> 74;
                            case 103 -> 236;
                            case 104 -> 189;
                            case 105 -> 83;
                            case 106 -> 167;
                            case 107 -> 241;
                            case 108 -> 137;
                            case 109 -> 3;
                            case 110 -> 238;
                            case 111 -> 45;
                            case 112 -> 184;
                            case 113 -> 130;
                            case 114 -> 157;
                            case 115 -> 246;
                            case 116 -> 70;
                            case 117 -> 223;
                            case 118 -> 235;
                            case 119 -> 228;
                            case 120 -> 227;
                            case 121 -> 59;
                            case 122 -> 67;
                            case 123 -> 126;
                            case 124 -> 210;
                            case 125 -> 48;
                            case 126 -> 40;
                            case 127 -> 255;
                            case 128 -> 219;
                            case 129 -> 0;
                            case 130 -> 111;
                            case 131 -> 170;
                            case 132 -> 237;
                            case 133 -> 6;
                            case 134 -> 190;
                            case 135 -> 107;
                            case 136 -> 16;
                            case 137 -> 155;
                            case 138 -> 1;
                            case 139 -> 214;
                            case 140 -> 76;
                            case 141 -> 181;
                            case 142 -> 151;
                            case 143 -> 221;
                            case 144 -> 135;
                            case 145 -> 99;
                            case 146 -> 131;
                            case 147 -> 87;
                            case 148 -> 159;
                            case 149 -> 207;
                            case 150 -> 13;
                            case 151 -> 180;
                            case 152 -> 119;
                            case 153 -> 240;
                            case 154 -> 211;
                            case 155 -> 122;
                            case 156 -> 12;
                            case 157 -> 72;
                            case 158 -> 7;
                            case 159 -> 117;
                            case 160 -> 58;
                            case 161 -> 80;
                            case 162 -> 35;
                            case 163 -> 31;
                            case 164 -> 9;
                            case 165 -> 47;
                            case 166 -> 169;
                            case 167 -> 53;
                            case 168 -> 62;
                            case 169 -> 212;
                            case 170 -> 27;
                            case 171 -> 232;
                            case 172 -> 249;
                            case 173 -> 150;
                            case 174 -> 36;
                            case 175 -> 4;
                            case 176 -> 205;
                            case 177 -> 182;
                            case 178 -> 195;
                            case 179 -> 69;
                            case 180 -> 123;
                            case 181 -> 158;
                            case 182 -> 192;
                            case 183 -> 145;
                            case 184 -> 54;
                            case 185 -> 193;
                            case 186 -> 26;
                            case 187 -> 32;
                            case 188 -> 201;
                            case 189 -> 109;
                            case 190 -> 79;
                            case 191 -> 160;
                            case 192 -> 217;
                            case 193 -> 82;
                            case 194 -> 29;
                            case 195 -> 162;
                            case 196 -> 19;
                            case 197 -> 245;
                            case 198 -> 116;
                            case 199 -> 166;
                            case 200 -> 11;
                            case 201 -> 88;
                            case 202 -> 178;
                            case 203 -> 147;
                            case 204 -> 139;
                            case 205 -> 84;
                            case 206 -> 206;
                            case 207 -> 42;
                            case 208 -> 173;
                            case 209 -> 124;
                            case 210 -> 168;
                            case 211 -> 100;
                            case 212 -> 39;
                            case 213 -> 25;
                            case 214 -> 127;
                            case 215 -> 204;
                            case 216 -> 197;
                            case 217 -> 73;
                            case 218 -> 85;
                            case 219 -> 183;
                            case 220 -> 102;
                            case 221 -> 115;
                            case 222 -> 63;
                            case 223 -> 96;
                            case 224 -> 22;
                            case 225 -> 78;
                            case 226 -> 161;
                            case 227 -> 28;
                            case 228 -> 209;
                            case 229 -> 65;
                            case 230 -> 120;
                            case 231 -> 239;
                            case 232 -> 24;
                            case 233 -> 254;
                            case 234 -> 194;
                            case 235 -> 164;
                            case 236 -> 108;
                            case 237 -> 71;
                            case 238 -> 230;
                            case 239 -> 146;
                            case 240 -> 244;
                            case 241 -> 49;
                            case 242 -> 129;
                            case 243 -> 37;
                            case 244 -> 95;
                            case 245 -> 113;
                            case 246 -> 222;
                            case 247 -> 112;
                            case 248 -> 174;
                            case 249 -> 61;
                            case 250 -> 60;
                            case 251 -> 10;
                            case 252 -> 91;
                            case 253 -> 152;
                            case 254 -> 8;
                            default -> 93;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray == null) {
                ActionTimestamp.d(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 38829777664564L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1021690650 - 22761, -1021690650 - -((char)-27202), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1021690650 - 22757, -1021690650 - -25572, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021690650 - 22764, 1021690650 - 28595, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1021690650 - 22761, -1021690650 - -((char)-27202), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1021690650 - 22757, -1021690650 - -25572, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021690650 - 22769, 1021690650 - (char)-23204, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 57448623989808L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.d();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(858508500 + (char)-6312, -858508500 + -((char)-8630), (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(858508500 + (char)-6309, -858639570 - -((char)-1112), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 127493596917630L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.d();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1787663730 + -27411, 1787663730 + (char)-19844, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1787663730 + -27407, 1787663730 + (char)-24562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1787663730 + -27438, 1787663730 + (char)-17125, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1787663730 + -27407, 1787663730 + (char)-24562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1787663730 + -27413, 1787663730 + (char)-24334, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1787663730 + -27411, 1787663730 + (char)-19844, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1787663730 + -27407, 1787663730 + (char)-24562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1787663730 + -27423, -1787663730 + -31441, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1787663730 + -27411, 1787663730 + (char)-19844, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1787663730 + -27407, 1787663730 + (char)-24562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1787663730 + -27424, -1787663730 + -((char)-32197), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1787663730 + -27411, 1787663730 + (char)-19844, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1787663730 + -27407, 1787663730 + (char)-24562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1787663730 + -27425, 1787663730 + (char)-25081, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 9101898491465L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.d();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15650), 862833810 - 32185, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15654), 862833810 - (char)-28709, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15635), 862833810 - (char)-29111, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15634), -862833810 - -((char)-29924), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15650), 862833810 - 32185, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15654), 862833810 - (char)-28709, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15633), 862833810 - (char)-17156, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15650), 862833810 - 32185, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15654), 862833810 - (char)-28709, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15632), 862833810 - (char)-30738, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15650), 862833810 - 32185, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15654), 862833810 - (char)-28709, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15631), -862833810 - -30732, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15650), 862833810 - 32185, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15654), 862833810 - (char)-28709, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15630), -862833810 - -32425, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-862833810 - -((char)-15629), 862833810 - 30525, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00bb\u00f0_\u00aa\u00eft#\u000f\u0014\u0018\u000e\u0013\u0092\u0098\u00fbb\u00e4,O\u001f\u00ee\u00a1\u00a4\n\u00cb\u0092<D\u008e\u0006\u00ee\u00eb\u00f5\u00c9\u00d0Y\u0018'Q\u0094I\u00eaE.\u00f3m\u00d08m#+\b\u00b8{;W\u00f3\u00a7\u00b0\u008e\u00c4\t\\\u00bee\u0005\u00bfS\u009cy\u0007\u0005\u00fb^W\u007f\u009e\b\u00c4\u00c5\u00b0}@\u00a8\u00d0v\u0014\u00d3\u008a\u0012\u0099\u00d5\u0092\u00fe^\u00d1\u00c5\u000b\u000bi\u00bb\u00a8\u00c5\u00d4.u\u008e\u00051\u0013\u000e\u00d6\u00b5\u001e\u00e1+\u0001\u00b5\u00c9\u001e\u00e8\u00e2\u0010\u00e6\u00dc,\u00f3#\u00b0\u00dd\u008d\u0006[\u00a0\u008a\u00f5'\u00a1)\u00963q\u008cu\u0010?\u00dd>\u00aeyO\b1q.}\u00c8\u00c1\u00eaY{\t\u00ef\n\u00c5\u0082\u00f8\u0084R\u001c0\u0010\u0081|\u00e9\u009a\u0083\u00c9W\u00e1\u009a4\u0000\u008bn\u0082\u00acv?\u00aa.`\u0015\u00e8\u0003I-U\u00ce1\u00d2\u00f1\n\u00cd\u00c1\u00e7\u00e0k\u00b9\u0002\u0084M\u00e9tw\u0095\u00f9o2L\u0085\u0001f\u0098\be\u00ccJ\u0090OI\u0087\u0088\u00b7\u00a7\u0010\u00aaPj\u00a9E\u00ca\u00fdm\u001f\u00d3\u009f\f\u001a%\u00e2\u0093\b\u00ac\u0092\u00bd\u0097\u00e1\u00f5\u00e4\u00dd\f\u000b\u0094YL`\u00ec:\u00f9\u001e\u007f\u00c2\u00e6F\n6y\u0018df\u00ba\u00a8\u000eY\u00ca\u00e6\u0018\u0084\u00ef6_y|%\u00f2EP\u00e3\u00e1\u001d\u00d4\u00bf\u00f8\u00d3\u0084\u0085$\u00d0\u00fe\u00ffs\u007f#\"\u00f1\n\u00db\u001b\u00e2P\u00ee)h\u00e2\u00c8\u00fe\t\u001c\u00038\u0081\u000f\u00d0\u00b4\u008d^\u00da\u0085\u00972\u00fe\u00ed|l\u001f\u00bd\u0015\u008ar\u00b8\u00e6\u00c6\u00fd\u00d5\u0005dP\u00e4\u00b1Y>\u00cb\u0092\u00ee\u00f8\u00f7~_{G\u001d\u00e9\u00cc\u00ca3\u00c0\u000b4>\u00be\u0019\u009cF\u00a5\u00ac\u00ed\u00d9\u00b6\u0015d\u00b3\u00b4\u00ab\u00dax\u0081\u0016Wn)\u00f6\u00f3\u00c9\u00a6g\u00cf-\u00b3vj)\u00f0\u00a0#\u00c4\u008d0`'\u0001^\u00fe;\u00b3\u00d6-\u00d7\u001a'\u000f\u00e9;$\u0000(\u00c3>\u00ae\u00d0\rD\u00baI\u001d\u00ec\u00bf\u00f5E#n\u0000\u00fb\u0007=\u00be\u0090\u001d\u00dfV\u00b1\u0007b\u00e1\u001f\u009a\u00c9Ie(\u00f3\u0013\u000f\u0093\u00b8\u00b00\u0010{o\u009b+<U\u009e$k\u00f4\u008f\u00d0J=A\u00c0{\u009f\u000f\u009f\u000e\u00cd\u0001a\u0091\u0082\u00b0\u0095\u001eR\u0096\u00dd\u000fBrw\u0096_|iJ%\u00a9\u00f1\u00a2\u00d10\u00bd\"w\u00a0\u00d3\u00c4\u00930\u00a3'y^\u00f1;Q\u00da\u0015\u0098\u00f6\u00e7\u0018\u00b33o\u00a1\u0011dM\u0097`\u000e`x\u00cako\u000e\u00f7\u00a5\u00c1l\u0089#\u00b3\u00a1~\u00d4\u009a\r\u00b0\u00cf\u001b\u00b8\u009d/n\u00af\u00d6\u00e2C\u0003\u000f\u00b8w\u00a4\u00b6\u008d\u0003M>\u00d2\u0014Q\u00af\u009e\u00af\u00c8\u00f7W\n<\"{\u009e1,\u00e26\u00a8\u00c3\u0018i\u001a\u0015\u0093\u00e9\u00d5\u000b} \u0001\u001e)\u00c9.\u00dc1\u0010y\u00ae\u0085\u00a6\u00d6;\u00d3)\u0015\u00a3\u009f\u00a4\u001a<\u0092\u00a6_n5=\u00ce\u001f\u001d\u0095b\u001a\u00df\u008b\u001bxM\u00af\u001f\\\u00a8p\u009e\fs\u00d1\u0001!\u00e9\u00d8Q\u00a2\u00ec0\u00ab\t\u00c6\u0091\u00e0\u00efV\u00e6\u00d1\u000b\u00fd";
                var4_3 = "\u00bb\u00f0_\u00aa\u00eft#\u000f\u0014\u0018\u000e\u0013\u0092\u0098\u00fbb\u00e4,O\u001f\u00ee\u00a1\u00a4\n\u00cb\u0092<D\u008e\u0006\u00ee\u00eb\u00f5\u00c9\u00d0Y\u0018'Q\u0094I\u00eaE.\u00f3m\u00d08m#+\b\u00b8{;W\u00f3\u00a7\u00b0\u008e\u00c4\t\\\u00bee\u0005\u00bfS\u009cy\u0007\u0005\u00fb^W\u007f\u009e\b\u00c4\u00c5\u00b0}@\u00a8\u00d0v\u0014\u00d3\u008a\u0012\u0099\u00d5\u0092\u00fe^\u00d1\u00c5\u000b\u000bi\u00bb\u00a8\u00c5\u00d4.u\u008e\u00051\u0013\u000e\u00d6\u00b5\u001e\u00e1+\u0001\u00b5\u00c9\u001e\u00e8\u00e2\u0010\u00e6\u00dc,\u00f3#\u00b0\u00dd\u008d\u0006[\u00a0\u008a\u00f5'\u00a1)\u00963q\u008cu\u0010?\u00dd>\u00aeyO\b1q.}\u00c8\u00c1\u00eaY{\t\u00ef\n\u00c5\u0082\u00f8\u0084R\u001c0\u0010\u0081|\u00e9\u009a\u0083\u00c9W\u00e1\u009a4\u0000\u008bn\u0082\u00acv?\u00aa.`\u0015\u00e8\u0003I-U\u00ce1\u00d2\u00f1\n\u00cd\u00c1\u00e7\u00e0k\u00b9\u0002\u0084M\u00e9tw\u0095\u00f9o2L\u0085\u0001f\u0098\be\u00ccJ\u0090OI\u0087\u0088\u00b7\u00a7\u0010\u00aaPj\u00a9E\u00ca\u00fdm\u001f\u00d3\u009f\f\u001a%\u00e2\u0093\b\u00ac\u0092\u00bd\u0097\u00e1\u00f5\u00e4\u00dd\f\u000b\u0094YL`\u00ec:\u00f9\u001e\u007f\u00c2\u00e6F\n6y\u0018df\u00ba\u00a8\u000eY\u00ca\u00e6\u0018\u0084\u00ef6_y|%\u00f2EP\u00e3\u00e1\u001d\u00d4\u00bf\u00f8\u00d3\u0084\u0085$\u00d0\u00fe\u00ffs\u007f#\"\u00f1\n\u00db\u001b\u00e2P\u00ee)h\u00e2\u00c8\u00fe\t\u001c\u00038\u0081\u000f\u00d0\u00b4\u008d^\u00da\u0085\u00972\u00fe\u00ed|l\u001f\u00bd\u0015\u008ar\u00b8\u00e6\u00c6\u00fd\u00d5\u0005dP\u00e4\u00b1Y>\u00cb\u0092\u00ee\u00f8\u00f7~_{G\u001d\u00e9\u00cc\u00ca3\u00c0\u000b4>\u00be\u0019\u009cF\u00a5\u00ac\u00ed\u00d9\u00b6\u0015d\u00b3\u00b4\u00ab\u00dax\u0081\u0016Wn)\u00f6\u00f3\u00c9\u00a6g\u00cf-\u00b3vj)\u00f0\u00a0#\u00c4\u008d0`'\u0001^\u00fe;\u00b3\u00d6-\u00d7\u001a'\u000f\u00e9;$\u0000(\u00c3>\u00ae\u00d0\rD\u00baI\u001d\u00ec\u00bf\u00f5E#n\u0000\u00fb\u0007=\u00be\u0090\u001d\u00dfV\u00b1\u0007b\u00e1\u001f\u009a\u00c9Ie(\u00f3\u0013\u000f\u0093\u00b8\u00b00\u0010{o\u009b+<U\u009e$k\u00f4\u008f\u00d0J=A\u00c0{\u009f\u000f\u009f\u000e\u00cd\u0001a\u0091\u0082\u00b0\u0095\u001eR\u0096\u00dd\u000fBrw\u0096_|iJ%\u00a9\u00f1\u00a2\u00d10\u00bd\"w\u00a0\u00d3\u00c4\u00930\u00a3'y^\u00f1;Q\u00da\u0015\u0098\u00f6\u00e7\u0018\u00b33o\u00a1\u0011dM\u0097`\u000e`x\u00cako\u000e\u00f7\u00a5\u00c1l\u0089#\u00b3\u00a1~\u00d4\u009a\r\u00b0\u00cf\u001b\u00b8\u009d/n\u00af\u00d6\u00e2C\u0003\u000f\u00b8w\u00a4\u00b6\u008d\u0003M>\u00d2\u0014Q\u00af\u009e\u00af\u00c8\u00f7W\n<\"{\u009e1,\u00e26\u00a8\u00c3\u0018i\u001a\u0015\u0093\u00e9\u00d5\u000b} \u0001\u001e)\u00c9.\u00dc1\u0010y\u00ae\u0085\u00a6\u00d6;\u00d3)\u0015\u00a3\u009f\u00a4\u001a<\u0092\u00a6_n5=\u00ce\u001f\u001d\u0095b\u001a\u00df\u008b\u001bxM\u00af\u001f\\\u00a8p\u009e\fs\u00d1\u0001!\u00e9\u00d8Q\u00a2\u00ec0\u00ab\t\u00c6\u0091\u00e0\u00efV\u00e6\u00d1\u000b\u00fd".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 36;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u000b\u00fc\u0005\u0016\u00103\u008a\u001e\u0005 '\u00ad\u00d5T'\u00a5|I\u0015<N\u00e8M:\u00ed\u00ab>\u0092\u0085\u0014\u00ac\u00e5\u00dc\u00b68&/\u0006\u00dcJX\u0017\u0010\u00c2e^&\u00d7\u008b\u00aa";
                    var4_3 = "\u000b\u00fc\u0005\u0016\u00103\u008a\u001e\u0005 '\u00ad\u00d5T'\u00a5|I\u0015<N\u00e8M:\u00ed\u00ab>\u0092\u0085\u0014\u00ac\u00e5\u00dc\u00b68&/\u0006\u00dcJX\u0017\u0010\u00c2e^&\u00d7\u008b\u00aa".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 62;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 68;
                            break;
                        }
                        case 1: {
                            v15 = 99;
                            break;
                        }
                        case 2: {
                            v15 = 14;
                            break;
                        }
                        case 3: {
                            v15 = 89;
                            break;
                        }
                        case 4: {
                            v15 = 75;
                            break;
                        }
                        case 5: {
                            v15 = 2;
                            break;
                        }
                        default: {
                            v15 = 57;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFD009) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 82;
                case 1 -> 110;
                case 2 -> 117;
                case 3 -> 212;
                case 4 -> 21;
                case 5 -> 101;
                case 6 -> 113;
                case 7 -> 161;
                case 8 -> 175;
                case 9 -> 172;
                case 10 -> 5;
                case 11 -> 145;
                case 12 -> 197;
                case 13 -> 22;
                case 14 -> 112;
                case 15 -> 40;
                case 16 -> 215;
                case 17 -> 44;
                case 18 -> 225;
                case 19 -> 214;
                case 20 -> 119;
                case 21 -> 235;
                case 22 -> 53;
                case 23 -> 0;
                case 24 -> 193;
                case 25 -> 210;
                case 26 -> 180;
                case 27 -> 86;
                case 28 -> 150;
                case 29 -> 124;
                case 30 -> 56;
                case 31 -> 17;
                case 32 -> 94;
                case 33 -> 244;
                case 34 -> 171;
                case 35 -> 209;
                case 36 -> 107;
                case 37 -> 60;
                case 38 -> 122;
                case 39 -> 63;
                case 40 -> 95;
                case 41 -> 237;
                case 42 -> 179;
                case 43 -> 154;
                case 44 -> 177;
                case 45 -> 242;
                case 46 -> 239;
                case 47 -> 189;
                case 48 -> 184;
                case 49 -> 233;
                case 50 -> 105;
                case 51 -> 144;
                case 52 -> 133;
                case 53 -> 98;
                case 54 -> 157;
                case 55 -> 241;
                case 56 -> 35;
                case 57 -> 231;
                case 58 -> 120;
                case 59 -> 80;
                case 60 -> 196;
                case 61 -> 201;
                case 62 -> 23;
                case 63 -> 78;
                case 64 -> 11;
                case 65 -> 116;
                case 66 -> 62;
                case 67 -> 6;
                case 68 -> 65;
                case 69 -> 68;
                case 70 -> 191;
                case 71 -> 14;
                case 72 -> 130;
                case 73 -> 223;
                case 74 -> 173;
                case 75 -> 28;
                case 76 -> 181;
                case 77 -> 73;
                case 78 -> 12;
                case 79 -> 66;
                case 80 -> 204;
                case 81 -> 221;
                case 82 -> 108;
                case 83 -> 25;
                case 84 -> 114;
                case 85 -> 54;
                case 86 -> 208;
                case 87 -> 126;
                case 88 -> 123;
                case 89 -> 254;
                case 90 -> 152;
                case 91 -> 178;
                case 92 -> 83;
                case 93 -> 165;
                case 94 -> 167;
                case 95 -> 100;
                case 96 -> 104;
                case 97 -> 245;
                case 98 -> 222;
                case 99 -> 169;
                case 100 -> 137;
                case 101 -> 49;
                case 102 -> 72;
                case 103 -> 140;
                case 104 -> 13;
                case 105 -> 219;
                case 106 -> 74;
                case 107 -> 206;
                case 108 -> 198;
                case 109 -> 146;
                case 110 -> 230;
                case 111 -> 77;
                case 112 -> 250;
                case 113 -> 19;
                case 114 -> 41;
                case 115 -> 24;
                case 116 -> 79;
                case 117 -> 158;
                case 118 -> 51;
                case 119 -> 249;
                case 120 -> 192;
                case 121 -> 61;
                case 122 -> 168;
                case 123 -> 155;
                case 124 -> 139;
                case 125 -> 156;
                case 126 -> 218;
                case 127 -> 7;
                case 128 -> 202;
                case 129 -> 29;
                case 130 -> 20;
                case 131 -> 55;
                case 132 -> 4;
                case 133 -> 232;
                case 134 -> 251;
                case 135 -> 236;
                case 136 -> 46;
                case 137 -> 57;
                case 138 -> 9;
                case 139 -> 141;
                case 140 -> 129;
                case 141 -> 188;
                case 142 -> 238;
                case 143 -> 69;
                case 144 -> 224;
                case 145 -> 111;
                case 146 -> 115;
                case 147 -> 64;
                case 148 -> 183;
                case 149 -> 234;
                case 150 -> 84;
                case 151 -> 90;
                case 152 -> 88;
                case 153 -> 205;
                case 154 -> 227;
                case 155 -> 213;
                case 156 -> 131;
                case 157 -> 182;
                case 158 -> 47;
                case 159 -> 195;
                case 160 -> 136;
                case 161 -> 149;
                case 162 -> 26;
                case 163 -> 71;
                case 164 -> 194;
                case 165 -> 162;
                case 166 -> 151;
                case 167 -> 27;
                case 168 -> 185;
                case 169 -> 160;
                case 170 -> 52;
                case 171 -> 211;
                case 172 -> 106;
                case 173 -> 8;
                case 174 -> 199;
                case 175 -> 37;
                case 176 -> 70;
                case 177 -> 153;
                case 178 -> 96;
                case 179 -> 135;
                case 180 -> 190;
                case 181 -> 81;
                case 182 -> 174;
                case 183 -> 200;
                case 184 -> 32;
                case 185 -> 247;
                case 186 -> 58;
                case 187 -> 67;
                case 188 -> 92;
                case 189 -> 89;
                case 190 -> 109;
                case 191 -> 229;
                case 192 -> 138;
                case 193 -> 93;
                case 194 -> 102;
                case 195 -> 253;
                case 196 -> 34;
                case 197 -> 216;
                case 198 -> 97;
                case 199 -> 203;
                case 200 -> 143;
                case 201 -> 170;
                case 202 -> 121;
                case 203 -> 163;
                case 204 -> 36;
                case 205 -> 15;
                case 206 -> 59;
                case 207 -> 186;
                case 208 -> 87;
                case 209 -> 226;
                case 210 -> 18;
                case 211 -> 217;
                case 212 -> 118;
                case 213 -> 91;
                case 214 -> 125;
                case 215 -> 43;
                case 216 -> 30;
                case 217 -> 240;
                case 218 -> 99;
                case 219 -> 76;
                case 220 -> 220;
                case 221 -> 1;
                case 222 -> 38;
                case 223 -> 39;
                case 224 -> 128;
                case 225 -> 10;
                case 226 -> 246;
                case 227 -> 207;
                case 228 -> 50;
                case 229 -> 176;
                case 230 -> 134;
                case 231 -> 127;
                case 232 -> 164;
                case 233 -> 75;
                case 234 -> 2;
                case 235 -> 85;
                case 236 -> 45;
                case 237 -> 132;
                case 238 -> 228;
                case 239 -> 252;
                case 240 -> 16;
                case 241 -> 255;
                case 242 -> 166;
                case 243 -> 142;
                case 244 -> 243;
                case 245 -> 103;
                case 246 -> 33;
                case 247 -> 3;
                case 248 -> 248;
                case 249 -> 48;
                case 250 -> 187;
                case 251 -> 42;
                case 252 -> 159;
                case 253 -> 147;
                case 254 -> 148;
                default -> 31;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 79653114725787L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1348710300 + -((char)-15808), -1348710300 + -((char)-26647), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 55071225007701L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.d();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1154333490 - 13639, -1154333490 - -4680, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1154333490 - 13642, 1154333490 + 2868, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1154333490 - 13641, -1154333490 + -8983, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0096.\u0015\u0098\u00b8\u001bjl\u0010\n\u001cw\u007fN\\M\u00dd\u0096\\h\u0098JC\u00a6\u0001";
                    var4_3 = "\u0096.\u0015\u0098\u00b8\u001bjl\u0010\n\u001cw\u007fN\\M\u00dd\u0096\\h\u0098JC\u00a6\u0001".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 73;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00bd\u00d5\u00a16\u008f5\u0093\u00c8s\u00f9\u0007d\u00ad\u00a0,\u0099|1\u00eeM\u00e6\u009b\u00a2Z\u009b\u0087r\u0099q \u00aa.\u00a9\u008a'\u00f2\u00aa\u00e2\u00ee\u00ce\u0013\u0003O\u00b9s\u009a U\u00a2}x\u00ca\u00d4m\u000e;\u00eft\u007f";
                        var4_3 = "\u00bd\u00d5\u00a16\u008f5\u0093\u00c8s\u00f9\u0007d\u00ad\u00a0,\u0099|1\u00eeM\u00e6\u009b\u00a2Z\u009b\u0087r\u0099q \u00aa.\u00a9\u008a'\u00f2\u00aa\u00e2\u00ee\u00ce\u0013\u0003O\u00b9s\u009a U\u00a2}x\u00ca\u00d4m\u000e;\u00eft\u007f".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 126;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 6;
                                break;
                            }
                            case 1: {
                                v15 = 72;
                                break;
                            }
                            case 2: {
                                v15 = 105;
                                break;
                            }
                            case 3: {
                                v15 = 21;
                                break;
                            }
                            case 4: {
                                v15 = 121;
                                break;
                            }
                            case 5: {
                                v15 = 98;
                                break;
                            }
                            default: {
                                v15 = 28;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4BBF) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 175;
                    case 1 -> 34;
                    case 2 -> 41;
                    case 3 -> 209;
                    case 4 -> 23;
                    case 5 -> 164;
                    case 6 -> 35;
                    case 7 -> 12;
                    case 8 -> 100;
                    case 9 -> 188;
                    case 10 -> 170;
                    case 11 -> 31;
                    case 12 -> 115;
                    case 13 -> 114;
                    case 14 -> 137;
                    case 15 -> 131;
                    case 16 -> 183;
                    case 17 -> 207;
                    case 18 -> 172;
                    case 19 -> 240;
                    case 20 -> 117;
                    case 21 -> 216;
                    case 22 -> 203;
                    case 23 -> 39;
                    case 24 -> 215;
                    case 25 -> 47;
                    case 26 -> 20;
                    case 27 -> 211;
                    case 28 -> 43;
                    case 29 -> 57;
                    case 30 -> 230;
                    case 31 -> 218;
                    case 32 -> 223;
                    case 33 -> 220;
                    case 34 -> 133;
                    case 35 -> 48;
                    case 36 -> 78;
                    case 37 -> 77;
                    case 38 -> 11;
                    case 39 -> 198;
                    case 40 -> 138;
                    case 41 -> 248;
                    case 42 -> 46;
                    case 43 -> 59;
                    case 44 -> 13;
                    case 45 -> 56;
                    case 46 -> 68;
                    case 47 -> 110;
                    case 48 -> 64;
                    case 49 -> 15;
                    case 50 -> 225;
                    case 51 -> 217;
                    case 52 -> 143;
                    case 53 -> 221;
                    case 54 -> 123;
                    case 55 -> 76;
                    case 56 -> 214;
                    case 57 -> 155;
                    case 58 -> 179;
                    case 59 -> 111;
                    case 60 -> 232;
                    case 61 -> 40;
                    case 62 -> 80;
                    case 63 -> 200;
                    case 64 -> 199;
                    case 65 -> 83;
                    case 66 -> 171;
                    case 67 -> 16;
                    case 68 -> 14;
                    case 69 -> 33;
                    case 70 -> 245;
                    case 71 -> 247;
                    case 72 -> 21;
                    case 73 -> 187;
                    case 74 -> 229;
                    case 75 -> 186;
                    case 76 -> 2;
                    case 77 -> 191;
                    case 78 -> 168;
                    case 79 -> 129;
                    case 80 -> 125;
                    case 81 -> 166;
                    case 82 -> 67;
                    case 83 -> 101;
                    case 84 -> 73;
                    case 85 -> 243;
                    case 86 -> 249;
                    case 87 -> 92;
                    case 88 -> 204;
                    case 89 -> 10;
                    case 90 -> 98;
                    case 91 -> 70;
                    case 92 -> 144;
                    case 93 -> 84;
                    case 94 -> 74;
                    case 95 -> 180;
                    case 96 -> 90;
                    case 97 -> 37;
                    case 98 -> 244;
                    case 99 -> 163;
                    case 100 -> 19;
                    case 101 -> 177;
                    case 102 -> 53;
                    case 103 -> 202;
                    case 104 -> 81;
                    case 105 -> 213;
                    case 106 -> 153;
                    case 107 -> 118;
                    case 108 -> 106;
                    case 109 -> 44;
                    case 110 -> 201;
                    case 111 -> 145;
                    case 112 -> 135;
                    case 113 -> 4;
                    case 114 -> 210;
                    case 115 -> 99;
                    case 116 -> 3;
                    case 117 -> 94;
                    case 118 -> 251;
                    case 119 -> 22;
                    case 120 -> 71;
                    case 121 -> 97;
                    case 122 -> 192;
                    case 123 -> 246;
                    case 124 -> 112;
                    case 125 -> 1;
                    case 126 -> 165;
                    case 127 -> 109;
                    case 128 -> 49;
                    case 129 -> 28;
                    case 130 -> 30;
                    case 131 -> 146;
                    case 132 -> 212;
                    case 133 -> 6;
                    case 134 -> 231;
                    case 135 -> 26;
                    case 136 -> 174;
                    case 137 -> 234;
                    case 138 -> 66;
                    case 139 -> 5;
                    case 140 -> 51;
                    case 141 -> 181;
                    case 142 -> 182;
                    case 143 -> 205;
                    case 144 -> 241;
                    case 145 -> 250;
                    case 146 -> 121;
                    case 147 -> 127;
                    case 148 -> 195;
                    case 149 -> 36;
                    case 150 -> 184;
                    case 151 -> 52;
                    case 152 -> 219;
                    case 153 -> 58;
                    case 154 -> 242;
                    case 155 -> 54;
                    case 156 -> 91;
                    case 157 -> 65;
                    case 158 -> 208;
                    case 159 -> 224;
                    case 160 -> 235;
                    case 161 -> 141;
                    case 162 -> 32;
                    case 163 -> 197;
                    case 164 -> 236;
                    case 165 -> 132;
                    case 166 -> 228;
                    case 167 -> 152;
                    case 168 -> 128;
                    case 169 -> 149;
                    case 170 -> 50;
                    case 171 -> 142;
                    case 172 -> 237;
                    case 173 -> 75;
                    case 174 -> 60;
                    case 175 -> 150;
                    case 176 -> 42;
                    case 177 -> 113;
                    case 178 -> 167;
                    case 179 -> 72;
                    case 180 -> 193;
                    case 181 -> 178;
                    case 182 -> 239;
                    case 183 -> 254;
                    case 184 -> 82;
                    case 185 -> 105;
                    case 186 -> 107;
                    case 187 -> 69;
                    case 188 -> 25;
                    case 189 -> 85;
                    case 190 -> 154;
                    case 191 -> 147;
                    case 192 -> 88;
                    case 193 -> 38;
                    case 194 -> 63;
                    case 195 -> 196;
                    case 196 -> 190;
                    case 197 -> 126;
                    case 198 -> 252;
                    case 199 -> 62;
                    case 200 -> 139;
                    case 201 -> 61;
                    case 202 -> 157;
                    case 203 -> 176;
                    case 204 -> 253;
                    case 205 -> 87;
                    case 206 -> 124;
                    case 207 -> 160;
                    case 208 -> 222;
                    case 209 -> 140;
                    case 210 -> 89;
                    case 211 -> 134;
                    case 212 -> 116;
                    case 213 -> 8;
                    case 214 -> 95;
                    case 215 -> 108;
                    case 216 -> 156;
                    case 217 -> 55;
                    case 218 -> 79;
                    case 219 -> 119;
                    case 220 -> 0;
                    case 221 -> 9;
                    case 222 -> 148;
                    case 223 -> 159;
                    case 224 -> 7;
                    case 225 -> 102;
                    case 226 -> 194;
                    case 227 -> 29;
                    case 228 -> 24;
                    case 229 -> 18;
                    case 230 -> 189;
                    case 231 -> 233;
                    case 232 -> 161;
                    case 233 -> 169;
                    case 234 -> 173;
                    case 235 -> 17;
                    case 236 -> 227;
                    case 237 -> 226;
                    case 238 -> 96;
                    case 239 -> 130;
                    case 240 -> 136;
                    case 241 -> 120;
                    case 242 -> 162;
                    case 243 -> 93;
                    case 244 -> 255;
                    case 245 -> 27;
                    case 246 -> 238;
                    case 247 -> 158;
                    case 248 -> 104;
                    case 249 -> 103;
                    case 250 -> 122;
                    case 251 -> 206;
                    case 252 -> 86;
                    case 253 -> 185;
                    case 254 -> 45;
                    default -> 151;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 111658334685332L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "j67 y#\u00033\tm<$*4a\u001e/z";
                    var5_4 = "j67 y#\u00033\tm<$*4a\u001e/z".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 20;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 21;
                                    break;
                                }
                                case 1: {
                                    v11 = 71;
                                    break;
                                }
                                case 2: {
                                    v11 = 81;
                                    break;
                                }
                                case 3: {
                                    v11 = 90;
                                    break;
                                }
                                case 4: {
                                    v11 = 8;
                                    break;
                                }
                                case 5: {
                                    v11 = 91;
                                    break;
                                }
                                default: {
                                    v11 = 36;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 121303158972005L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "i~w`\u0018UH\u0004o`{z\nc\u007fpz\u0014WPI~y\tc\u007fpz\u0014WPEt\rdymw\u001eZJEsj}\u001fS";
                    var5_4 = "i~w`\u0018UH\u0004o`{z\nc\u007fpz\u0014WPI~y\tc\u007fpz\u0014WPEt\rdymw\u001eZJEsj}\u001fS".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "slaw\bJS\u0006slaw\u0004@";
                        var5_4 = "slaw\bJS\u0006slaw\u0004@".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 113;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 65;
                                break;
                            }
                            case 1: {
                                v15 = 113;
                                break;
                            }
                            case 2: {
                                v15 = 127;
                                break;
                            }
                            case 3: {
                                v15 = 117;
                                break;
                            }
                            case 4: {
                                v15 = 16;
                                break;
                            }
                            case 5: {
                                v15 = 85;
                                break;
                            }
                            default: {
                                v15 = 69;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 39550745485101L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1608359970 - -17371, -1608359970 - -28425, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 74908206578148L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00fcc(N\u00ec\u0003\u008dA\u00b2\u0005\u0094\u00b4\u0003pj\r\u00fc\b8\u00ad\u00f8O\u00cc\u00f5\u00bd\u008bUO\u00d7\u00101\tFf\b\u00a3\u00f9U\u00d2\u001b[\u0010\u00f0.\u0086~\u0005\u008b\u0085\u00e0V\u00163*\u0081\u00c5\u00a1\u00ad\u001f}\u00d6?\u0096m\u0088\u00f0l\u00aa)\u009c}\u009anX\u0004Q\u009c\u000f\u0097\u00f9F5\u00dcP\u0010\u00c1;\u00bbp\u00a3\u00124TX{\u001a\u0089\u0099L7\u009aVS\u0017";
                    var4_3 = "\u00fcc(N\u00ec\u0003\u008dA\u00b2\u0005\u0094\u00b4\u0003pj\r\u00fc\b8\u00ad\u00f8O\u00cc\u00f5\u00bd\u008bUO\u00d7\u00101\tFf\b\u00a3\u00f9U\u00d2\u001b[\u0010\u00f0.\u0086~\u0005\u008b\u0085\u00e0V\u00163*\u0081\u00c5\u00a1\u00ad\u001f}\u00d6?\u0096m\u0088\u00f0l\u00aa)\u009c}\u009anX\u0004Q\u009c\u000f\u0097\u00f9F5\u00dcP\u0010\u00c1;\u00bbp\u00a3\u00124TX{\u001a\u0089\u0099L7\u009aVS\u0017".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 76;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ca\u0006D\u00fa5M#\u00f5\u00f4r\u00e2@\u00baY\u00b2\u00edL\u00ea\u00c0\u00b7\u00e8a\u00c7\u00c7\u00ca\u00e1\u0006\u00ecwu1\u00d8\u0099\u00aa\u00c7\u00de\u00b2\u00c5\u0086\u00b5\u0013\u00cd\u00f0\u00f9\u0011\u00b2\u00022\u00d9\u00e0\u0091\u0093D\u00e97:\u00eb\u00d2\f\u00f9g\u008d2\u0003\u0010_K\u00a3\u0014\u008b\r2Q\u00b8bj\u00b3\u00de'\u00e6[\u0085-il\u00af\u00a9\u00d5Z\u00e4\u0080\u001a\u00cd";
                        var4_3 = "\u00ca\u0006D\u00fa5M#\u00f5\u00f4r\u00e2@\u00baY\u00b2\u00edL\u00ea\u00c0\u00b7\u00e8a\u00c7\u00c7\u00ca\u00e1\u0006\u00ecwu1\u00d8\u0099\u00aa\u00c7\u00de\u00b2\u00c5\u0086\u00b5\u0013\u00cd\u00f0\u00f9\u0011\u00b2\u00022\u00d9\u00e0\u0091\u0093D\u00e97:\u00eb\u00d2\f\u00f9g\u008d2\u0003\u0010_K\u00a3\u0014\u008b\r2Q\u00b8bj\u00b3\u00de'\u00e6[\u0085-il\u00af\u00a9\u00d5Z\u00e4\u0080\u001a\u00cd".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 118;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 59;
                                break;
                            }
                            case 1: {
                                v15 = 57;
                                break;
                            }
                            case 2: {
                                v15 = 61;
                                break;
                            }
                            case 3: {
                                v15 = 37;
                                break;
                            }
                            case 4: {
                                v15 = 54;
                                break;
                            }
                            case 5: {
                                v15 = 29;
                                break;
                            }
                            default: {
                                v15 = 44;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3C94) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 97;
                    case 1 -> 86;
                    case 2 -> 177;
                    case 3 -> 92;
                    case 4 -> 220;
                    case 5 -> 243;
                    case 6 -> 122;
                    case 7 -> 249;
                    case 8 -> 208;
                    case 9 -> 135;
                    case 10 -> 73;
                    case 11 -> 30;
                    case 12 -> 153;
                    case 13 -> 111;
                    case 14 -> 255;
                    case 15 -> 211;
                    case 16 -> 0;
                    case 17 -> 33;
                    case 18 -> 198;
                    case 19 -> 163;
                    case 20 -> 210;
                    case 21 -> 245;
                    case 22 -> 232;
                    case 23 -> 24;
                    case 24 -> 44;
                    case 25 -> 5;
                    case 26 -> 121;
                    case 27 -> 182;
                    case 28 -> 130;
                    case 29 -> 235;
                    case 30 -> 61;
                    case 31 -> 168;
                    case 32 -> 169;
                    case 33 -> 225;
                    case 34 -> 39;
                    case 35 -> 94;
                    case 36 -> 116;
                    case 37 -> 250;
                    case 38 -> 110;
                    case 39 -> 60;
                    case 40 -> 81;
                    case 41 -> 221;
                    case 42 -> 22;
                    case 43 -> 165;
                    case 44 -> 147;
                    case 45 -> 45;
                    case 46 -> 240;
                    case 47 -> 184;
                    case 48 -> 164;
                    case 49 -> 247;
                    case 50 -> 118;
                    case 51 -> 226;
                    case 52 -> 138;
                    case 53 -> 74;
                    case 54 -> 125;
                    case 55 -> 2;
                    case 56 -> 223;
                    case 57 -> 191;
                    case 58 -> 11;
                    case 59 -> 197;
                    case 60 -> 231;
                    case 61 -> 156;
                    case 62 -> 158;
                    case 63 -> 187;
                    case 64 -> 85;
                    case 65 -> 14;
                    case 66 -> 178;
                    case 67 -> 234;
                    case 68 -> 222;
                    case 69 -> 242;
                    case 70 -> 248;
                    case 71 -> 7;
                    case 72 -> 175;
                    case 73 -> 51;
                    case 74 -> 17;
                    case 75 -> 237;
                    case 76 -> 203;
                    case 77 -> 167;
                    case 78 -> 66;
                    case 79 -> 15;
                    case 80 -> 56;
                    case 81 -> 131;
                    case 82 -> 195;
                    case 83 -> 238;
                    case 84 -> 99;
                    case 85 -> 91;
                    case 86 -> 149;
                    case 87 -> 90;
                    case 88 -> 108;
                    case 89 -> 136;
                    case 90 -> 41;
                    case 91 -> 13;
                    case 92 -> 37;
                    case 93 -> 172;
                    case 94 -> 88;
                    case 95 -> 189;
                    case 96 -> 104;
                    case 97 -> 188;
                    case 98 -> 3;
                    case 99 -> 209;
                    case 100 -> 67;
                    case 101 -> 180;
                    case 102 -> 142;
                    case 103 -> 132;
                    case 104 -> 148;
                    case 105 -> 106;
                    case 106 -> 48;
                    case 107 -> 144;
                    case 108 -> 47;
                    case 109 -> 59;
                    case 110 -> 251;
                    case 111 -> 162;
                    case 112 -> 26;
                    case 113 -> 38;
                    case 114 -> 145;
                    case 115 -> 141;
                    case 116 -> 101;
                    case 117 -> 68;
                    case 118 -> 137;
                    case 119 -> 171;
                    case 120 -> 173;
                    case 121 -> 29;
                    case 122 -> 190;
                    case 123 -> 10;
                    case 124 -> 28;
                    case 125 -> 179;
                    case 126 -> 71;
                    case 127 -> 35;
                    case 128 -> 212;
                    case 129 -> 69;
                    case 130 -> 253;
                    case 131 -> 200;
                    case 132 -> 87;
                    case 133 -> 139;
                    case 134 -> 1;
                    case 135 -> 217;
                    case 136 -> 192;
                    case 137 -> 120;
                    case 138 -> 228;
                    case 139 -> 224;
                    case 140 -> 239;
                    case 141 -> 31;
                    case 142 -> 213;
                    case 143 -> 160;
                    case 144 -> 119;
                    case 145 -> 140;
                    case 146 -> 202;
                    case 147 -> 25;
                    case 148 -> 123;
                    case 149 -> 109;
                    case 150 -> 186;
                    case 151 -> 150;
                    case 152 -> 146;
                    case 153 -> 8;
                    case 154 -> 241;
                    case 155 -> 55;
                    case 156 -> 16;
                    case 157 -> 50;
                    case 158 -> 170;
                    case 159 -> 96;
                    case 160 -> 252;
                    case 161 -> 155;
                    case 162 -> 218;
                    case 163 -> 227;
                    case 164 -> 42;
                    case 165 -> 21;
                    case 166 -> 95;
                    case 167 -> 57;
                    case 168 -> 105;
                    case 169 -> 154;
                    case 170 -> 82;
                    case 171 -> 63;
                    case 172 -> 254;
                    case 173 -> 107;
                    case 174 -> 206;
                    case 175 -> 151;
                    case 176 -> 129;
                    case 177 -> 183;
                    case 178 -> 27;
                    case 179 -> 43;
                    case 180 -> 114;
                    case 181 -> 20;
                    case 182 -> 102;
                    case 183 -> 75;
                    case 184 -> 98;
                    case 185 -> 72;
                    case 186 -> 9;
                    case 187 -> 205;
                    case 188 -> 18;
                    case 189 -> 128;
                    case 190 -> 4;
                    case 191 -> 127;
                    case 192 -> 78;
                    case 193 -> 166;
                    case 194 -> 207;
                    case 195 -> 34;
                    case 196 -> 143;
                    case 197 -> 12;
                    case 198 -> 176;
                    case 199 -> 49;
                    case 200 -> 161;
                    case 201 -> 77;
                    case 202 -> 115;
                    case 203 -> 23;
                    case 204 -> 6;
                    case 205 -> 215;
                    case 206 -> 89;
                    case 207 -> 103;
                    case 208 -> 40;
                    case 209 -> 126;
                    case 210 -> 230;
                    case 211 -> 93;
                    case 212 -> 185;
                    case 213 -> 53;
                    case 214 -> 100;
                    case 215 -> 193;
                    case 216 -> 83;
                    case 217 -> 229;
                    case 218 -> 233;
                    case 219 -> 194;
                    case 220 -> 124;
                    case 221 -> 159;
                    case 222 -> 134;
                    case 223 -> 219;
                    case 224 -> 80;
                    case 225 -> 244;
                    case 226 -> 236;
                    case 227 -> 117;
                    case 228 -> 112;
                    case 229 -> 76;
                    case 230 -> 36;
                    case 231 -> 65;
                    case 232 -> 216;
                    case 233 -> 79;
                    case 234 -> 174;
                    case 235 -> 52;
                    case 236 -> 62;
                    case 237 -> 152;
                    case 238 -> 157;
                    case 239 -> 58;
                    case 240 -> 204;
                    case 241 -> 196;
                    case 242 -> 214;
                    case 243 -> 199;
                    case 244 -> 133;
                    case 245 -> 84;
                    case 246 -> 201;
                    case 247 -> 70;
                    case 248 -> 46;
                    case 249 -> 113;
                    case 250 -> 19;
                    case 251 -> 64;
                    case 252 -> 246;
                    case 253 -> 181;
                    case 254 -> 32;
                    default -> 54;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 45683185449981L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1913228790 + -((char)-3870), -1913228790 + -((char)-31340), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 101522086410767L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1944423450 + -13067, -1944423450 + -27696, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 26147949750098L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00ac\u00f6\u000b\u00aeB\u0003\u009a\u00c7\u009b";
                var4_3 = "\u00ac\u00f6\u000b\u00aeB\u0003\u009a\u00c7\u009b".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 77;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 8;
                                break;
                            }
                            case 1: {
                                v11 = 72;
                                break;
                            }
                            case 2: {
                                v11 = 83;
                                break;
                            }
                            case 3: {
                                v11 = 120;
                                break;
                            }
                            case 4: {
                                v11 = 16;
                                break;
                            }
                            case 5: {
                                v11 = 62;
                                break;
                            }
                            default: {
                                v11 = 50;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFFAD5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 69;
                    case 1 -> 122;
                    case 2 -> 144;
                    case 3 -> 152;
                    case 4 -> 92;
                    case 5 -> 210;
                    case 6 -> 34;
                    case 7 -> 232;
                    case 8 -> 97;
                    case 9 -> 50;
                    case 10 -> 12;
                    case 11 -> 4;
                    case 12 -> 128;
                    case 13 -> 131;
                    case 14 -> 5;
                    case 15 -> 184;
                    case 16 -> 243;
                    case 17 -> 217;
                    case 18 -> 63;
                    case 19 -> 112;
                    case 20 -> 52;
                    case 21 -> 11;
                    case 22 -> 246;
                    case 23 -> 118;
                    case 24 -> 77;
                    case 25 -> 238;
                    case 26 -> 16;
                    case 27 -> 242;
                    case 28 -> 190;
                    case 29 -> 133;
                    case 30 -> 150;
                    case 31 -> 64;
                    case 32 -> 80;
                    case 33 -> 93;
                    case 34 -> 58;
                    case 35 -> 193;
                    case 36 -> 203;
                    case 37 -> 139;
                    case 38 -> 30;
                    case 39 -> 109;
                    case 40 -> 218;
                    case 41 -> 160;
                    case 42 -> 70;
                    case 43 -> 204;
                    case 44 -> 254;
                    case 45 -> 154;
                    case 46 -> 117;
                    case 47 -> 212;
                    case 48 -> 2;
                    case 49 -> 88;
                    case 50 -> 245;
                    case 51 -> 15;
                    case 52 -> 143;
                    case 53 -> 146;
                    case 54 -> 181;
                    case 55 -> 207;
                    case 56 -> 156;
                    case 57 -> 195;
                    case 58 -> 186;
                    case 59 -> 130;
                    case 60 -> 82;
                    case 61 -> 105;
                    case 62 -> 81;
                    case 63 -> 120;
                    case 64 -> 108;
                    case 65 -> 8;
                    case 66 -> 240;
                    case 67 -> 205;
                    case 68 -> 53;
                    case 69 -> 22;
                    case 70 -> 37;
                    case 71 -> 249;
                    case 72 -> 19;
                    case 73 -> 244;
                    case 74 -> 127;
                    case 75 -> 26;
                    case 76 -> 191;
                    case 77 -> 187;
                    case 78 -> 76;
                    case 79 -> 23;
                    case 80 -> 214;
                    case 81 -> 233;
                    case 82 -> 9;
                    case 83 -> 253;
                    case 84 -> 176;
                    case 85 -> 169;
                    case 86 -> 173;
                    case 87 -> 158;
                    case 88 -> 167;
                    case 89 -> 159;
                    case 90 -> 86;
                    case 91 -> 96;
                    case 92 -> 222;
                    case 93 -> 85;
                    case 94 -> 91;
                    case 95 -> 162;
                    case 96 -> 75;
                    case 97 -> 107;
                    case 98 -> 227;
                    case 99 -> 166;
                    case 100 -> 163;
                    case 101 -> 24;
                    case 102 -> 247;
                    case 103 -> 129;
                    case 104 -> 213;
                    case 105 -> 148;
                    case 106 -> 0;
                    case 107 -> 197;
                    case 108 -> 103;
                    case 109 -> 31;
                    case 110 -> 78;
                    case 111 -> 1;
                    case 112 -> 252;
                    case 113 -> 177;
                    case 114 -> 236;
                    case 115 -> 216;
                    case 116 -> 174;
                    case 117 -> 151;
                    case 118 -> 113;
                    case 119 -> 251;
                    case 120 -> 141;
                    case 121 -> 20;
                    case 122 -> 18;
                    case 123 -> 136;
                    case 124 -> 55;
                    case 125 -> 62;
                    case 126 -> 250;
                    case 127 -> 164;
                    case 128 -> 248;
                    case 129 -> 87;
                    case 130 -> 7;
                    case 131 -> 27;
                    case 132 -> 226;
                    case 133 -> 89;
                    case 134 -> 180;
                    case 135 -> 32;
                    case 136 -> 48;
                    case 137 -> 68;
                    case 138 -> 17;
                    case 139 -> 201;
                    case 140 -> 155;
                    case 141 -> 145;
                    case 142 -> 137;
                    case 143 -> 95;
                    case 144 -> 60;
                    case 145 -> 42;
                    case 146 -> 231;
                    case 147 -> 43;
                    case 148 -> 168;
                    case 149 -> 74;
                    case 150 -> 211;
                    case 151 -> 142;
                    case 152 -> 220;
                    case 153 -> 6;
                    case 154 -> 189;
                    case 155 -> 47;
                    case 156 -> 106;
                    case 157 -> 102;
                    case 158 -> 100;
                    case 159 -> 45;
                    case 160 -> 28;
                    case 161 -> 223;
                    case 162 -> 221;
                    case 163 -> 41;
                    case 164 -> 67;
                    case 165 -> 114;
                    case 166 -> 54;
                    case 167 -> 14;
                    case 168 -> 126;
                    case 169 -> 224;
                    case 170 -> 101;
                    case 171 -> 196;
                    case 172 -> 38;
                    case 173 -> 66;
                    case 174 -> 57;
                    case 175 -> 185;
                    case 176 -> 119;
                    case 177 -> 71;
                    case 178 -> 188;
                    case 179 -> 98;
                    case 180 -> 255;
                    case 181 -> 21;
                    case 182 -> 124;
                    case 183 -> 135;
                    case 184 -> 56;
                    case 185 -> 202;
                    case 186 -> 72;
                    case 187 -> 235;
                    case 188 -> 175;
                    case 189 -> 209;
                    case 190 -> 228;
                    case 191 -> 84;
                    case 192 -> 208;
                    case 193 -> 51;
                    case 194 -> 46;
                    case 195 -> 138;
                    case 196 -> 83;
                    case 197 -> 35;
                    case 198 -> 206;
                    case 199 -> 61;
                    case 200 -> 229;
                    case 201 -> 104;
                    case 202 -> 29;
                    case 203 -> 157;
                    case 204 -> 147;
                    case 205 -> 110;
                    case 206 -> 183;
                    case 207 -> 215;
                    case 208 -> 182;
                    case 209 -> 33;
                    case 210 -> 73;
                    case 211 -> 200;
                    case 212 -> 153;
                    case 213 -> 134;
                    case 214 -> 198;
                    case 215 -> 225;
                    case 216 -> 116;
                    case 217 -> 94;
                    case 218 -> 125;
                    case 219 -> 237;
                    case 220 -> 179;
                    case 221 -> 172;
                    case 222 -> 192;
                    case 223 -> 13;
                    case 224 -> 149;
                    case 225 -> 39;
                    case 226 -> 161;
                    case 227 -> 115;
                    case 228 -> 219;
                    case 229 -> 230;
                    case 230 -> 25;
                    case 231 -> 170;
                    case 232 -> 49;
                    case 233 -> 3;
                    case 234 -> 171;
                    case 235 -> 90;
                    case 236 -> 59;
                    case 237 -> 178;
                    case 238 -> 121;
                    case 239 -> 10;
                    case 240 -> 36;
                    case 241 -> 241;
                    case 242 -> 165;
                    case 243 -> 44;
                    case 244 -> 199;
                    case 245 -> 79;
                    case 246 -> 111;
                    case 247 -> 99;
                    case 248 -> 234;
                    case 249 -> 40;
                    case 250 -> 65;
                    case 251 -> 123;
                    case 252 -> 239;
                    case 253 -> 132;
                    case 254 -> 194;
                    default -> 140;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

