/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 84903972393119L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1058914530 - -23027, 1058914530 - 21823, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1058914530 - -23026, -1058914530 - -((char)-23941), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 126013792404206L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.F();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(548003670 + (char)-21492, -548003670 + -((char)-7014), (int)l2) + string + WindowsNamedPipeAgentIpc.b(548003670 + (char)-21491, 548134740 - (char)-2899, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(548003670 + (char)-21490, -548003670 + -((char)-3068), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 124990779293016L;
                Object object = this.lock;
                n2 = SshAgentIpcService.F();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31277, -1358933760 + -22441, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31280, -1358933760 + -22442, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31279, -1358933760 + -24795, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31266, -1358933760 + -((char)-29345), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31265, -1358933760 + -25531, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31268, 1358933760 + 24620, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31266, -1358933760 + -((char)-29345), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1358933760 + (char)-31267, -1358933760 + -20843, (int)l2));
            if (ActionTimestamp.s() != 0) {
                SshAgentIpcService.s(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 44935205763622L;
                    n3 = SshAgentIpcService.s();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 81585054721246L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            n2 = SshAgentIpcService.s();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2144043060 - 4824, -2144043060 - -26926, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4823, -2144043060 - -13921, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4822, -2144043060 - -28344, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2144043060 - 4824, -2144043060 - -26926, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4821, -2144043060 - -19533, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2144043060 - 4824, -2144043060 - -26926, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4852, 2144043060 - 3842, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4851, 2144043060 - 23307, (int)l2) + ErrorToolsKt.prettyHRESULT(n3)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4822, -2144043060 - -28344, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2144043060 - 4824, -2144043060 - -26926, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2144043060 - 4828, -2144043060 - -6747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2144043060 - 4850, -2144043060 - -12447, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 112794618173658L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-187036890 + -20937, -187036890 + -19744, (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 123469029972743L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1605083220 + -((char)-23253), 1605083220 + (char)-32649, (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "M\u00e1\u0015?vt<\u00ca\u00f5\u00bfvK\u0010\u00e9))Nc(\u0014 \u00a7\u00b8\u00f1\u00d8o\u0094,beA\u00c44\u00e1l\u00a3\u000b\u00f4\u0087\u00df";
                    var4_3 = "M\u00e1\u0015?vt<\u00ca\u00f5\u00bfvK\u0010\u00e9))Nc(\u0014 \u00a7\u00b8\u00f1\u00d8o\u0094,beA\u00c44\u00e1l\u00a3\u000b\u00f4\u0087\u00df".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 66;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 73;
                                    break;
                                }
                                case 1: {
                                    v11 = 52;
                                    break;
                                }
                                case 2: {
                                    v11 = 75;
                                    break;
                                }
                                case 3: {
                                    v11 = 15;
                                    break;
                                }
                                case 4: {
                                    v11 = 64;
                                    break;
                                }
                                case 5: {
                                    v11 = 104;
                                    break;
                                }
                                default: {
                                    v11 = 38;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xFFFFA187) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 85;
                        case 1 -> 167;
                        case 2 -> 234;
                        case 3 -> 50;
                        case 4 -> 185;
                        case 5 -> 206;
                        case 6 -> 110;
                        case 7 -> 250;
                        case 8 -> 115;
                        case 9 -> 43;
                        case 10 -> 225;
                        case 11 -> 113;
                        case 12 -> 33;
                        case 13 -> 39;
                        case 14 -> 89;
                        case 15 -> 107;
                        case 16 -> 237;
                        case 17 -> 220;
                        case 18 -> 64;
                        case 19 -> 224;
                        case 20 -> 136;
                        case 21 -> 195;
                        case 22 -> 231;
                        case 23 -> 150;
                        case 24 -> 71;
                        case 25 -> 146;
                        case 26 -> 2;
                        case 27 -> 226;
                        case 28 -> 35;
                        case 29 -> 249;
                        case 30 -> 238;
                        case 31 -> 17;
                        case 32 -> 147;
                        case 33 -> 56;
                        case 34 -> 241;
                        case 35 -> 96;
                        case 36 -> 233;
                        case 37 -> 156;
                        case 38 -> 4;
                        case 39 -> 172;
                        case 40 -> 230;
                        case 41 -> 161;
                        case 42 -> 204;
                        case 43 -> 135;
                        case 44 -> 49;
                        case 45 -> 79;
                        case 46 -> 244;
                        case 47 -> 134;
                        case 48 -> 70;
                        case 49 -> 88;
                        case 50 -> 31;
                        case 51 -> 202;
                        case 52 -> 92;
                        case 53 -> 215;
                        case 54 -> 108;
                        case 55 -> 109;
                        case 56 -> 117;
                        case 57 -> 122;
                        case 58 -> 187;
                        case 59 -> 126;
                        case 60 -> 32;
                        case 61 -> 223;
                        case 62 -> 210;
                        case 63 -> 41;
                        case 64 -> 222;
                        case 65 -> 175;
                        case 66 -> 217;
                        case 67 -> 60;
                        case 68 -> 213;
                        case 69 -> 142;
                        case 70 -> 180;
                        case 71 -> 34;
                        case 72 -> 205;
                        case 73 -> 148;
                        case 74 -> 169;
                        case 75 -> 95;
                        case 76 -> 211;
                        case 77 -> 232;
                        case 78 -> 42;
                        case 79 -> 63;
                        case 80 -> 139;
                        case 81 -> 168;
                        case 82 -> 82;
                        case 83 -> 7;
                        case 84 -> 162;
                        case 85 -> 137;
                        case 86 -> 62;
                        case 87 -> 236;
                        case 88 -> 103;
                        case 89 -> 120;
                        case 90 -> 57;
                        case 91 -> 16;
                        case 92 -> 197;
                        case 93 -> 19;
                        case 94 -> 200;
                        case 95 -> 184;
                        case 96 -> 74;
                        case 97 -> 131;
                        case 98 -> 22;
                        case 99 -> 47;
                        case 100 -> 247;
                        case 101 -> 29;
                        case 102 -> 208;
                        case 103 -> 245;
                        case 104 -> 127;
                        case 105 -> 130;
                        case 106 -> 94;
                        case 107 -> 160;
                        case 108 -> 52;
                        case 109 -> 125;
                        case 110 -> 40;
                        case 111 -> 78;
                        case 112 -> 90;
                        case 113 -> 177;
                        case 114 -> 157;
                        case 115 -> 158;
                        case 116 -> 133;
                        case 117 -> 198;
                        case 118 -> 55;
                        case 119 -> 75;
                        case 120 -> 183;
                        case 121 -> 100;
                        case 122 -> 105;
                        case 123 -> 227;
                        case 124 -> 24;
                        case 125 -> 69;
                        case 126 -> 54;
                        case 127 -> 201;
                        case 128 -> 72;
                        case 129 -> 251;
                        case 130 -> 76;
                        case 131 -> 174;
                        case 132 -> 99;
                        case 133 -> 15;
                        case 134 -> 188;
                        case 135 -> 170;
                        case 136 -> 248;
                        case 137 -> 104;
                        case 138 -> 112;
                        case 139 -> 59;
                        case 140 -> 97;
                        case 141 -> 111;
                        case 142 -> 102;
                        case 143 -> 155;
                        case 144 -> 6;
                        case 145 -> 159;
                        case 146 -> 199;
                        case 147 -> 253;
                        case 148 -> 171;
                        case 149 -> 190;
                        case 150 -> 219;
                        case 151 -> 151;
                        case 152 -> 87;
                        case 153 -> 189;
                        case 154 -> 73;
                        case 155 -> 68;
                        case 156 -> 186;
                        case 157 -> 252;
                        case 158 -> 36;
                        case 159 -> 93;
                        case 160 -> 193;
                        case 161 -> 91;
                        case 162 -> 46;
                        case 163 -> 143;
                        case 164 -> 179;
                        case 165 -> 246;
                        case 166 -> 8;
                        case 167 -> 218;
                        case 168 -> 1;
                        case 169 -> 128;
                        case 170 -> 164;
                        case 171 -> 235;
                        case 172 -> 3;
                        case 173 -> 144;
                        case 174 -> 83;
                        case 175 -> 221;
                        case 176 -> 77;
                        case 177 -> 152;
                        case 178 -> 25;
                        case 179 -> 239;
                        case 180 -> 28;
                        case 181 -> 124;
                        case 182 -> 165;
                        case 183 -> 5;
                        case 184 -> 10;
                        case 185 -> 181;
                        case 186 -> 14;
                        case 187 -> 13;
                        case 188 -> 242;
                        case 189 -> 129;
                        case 190 -> 194;
                        case 191 -> 121;
                        case 192 -> 214;
                        case 193 -> 65;
                        case 194 -> 53;
                        case 195 -> 23;
                        case 196 -> 67;
                        case 197 -> 255;
                        case 198 -> 163;
                        case 199 -> 48;
                        case 200 -> 44;
                        case 201 -> 138;
                        case 202 -> 254;
                        case 203 -> 192;
                        case 204 -> 26;
                        case 205 -> 114;
                        case 206 -> 20;
                        case 207 -> 116;
                        case 208 -> 196;
                        case 209 -> 154;
                        case 210 -> 98;
                        case 211 -> 80;
                        case 212 -> 51;
                        case 213 -> 38;
                        case 214 -> 176;
                        case 215 -> 0;
                        case 216 -> 153;
                        case 217 -> 145;
                        case 218 -> 11;
                        case 219 -> 27;
                        case 220 -> 84;
                        case 221 -> 203;
                        case 222 -> 81;
                        case 223 -> 229;
                        case 224 -> 243;
                        case 225 -> 212;
                        case 226 -> 30;
                        case 227 -> 123;
                        case 228 -> 240;
                        case 229 -> 228;
                        case 230 -> 132;
                        case 231 -> 216;
                        case 232 -> 207;
                        case 233 -> 45;
                        case 234 -> 119;
                        case 235 -> 140;
                        case 236 -> 61;
                        case 237 -> 209;
                        case 238 -> 9;
                        case 239 -> 86;
                        case 240 -> 18;
                        case 241 -> 58;
                        case 242 -> 182;
                        case 243 -> 21;
                        case 244 -> 106;
                        case 245 -> 191;
                        case 246 -> 141;
                        case 247 -> 173;
                        case 248 -> 101;
                        case 249 -> 37;
                        case 250 -> 12;
                        case 251 -> 66;
                        case 252 -> 166;
                        case 253 -> 118;
                        case 254 -> 178;
                        default -> 149;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (n2 == 0) {
            int n4 = ActionTimestamp.s();
            ActionTimestamp.s(++n4);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 24909594291803L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.F();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1216067460 - (char)-28757, -1216067460 - -23043, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1216067460 - (char)-28761, -1216067460 - -((char)-30682), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1216067460 - (char)-28738, 1216067460 - 29097, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1216067460 - (char)-28757, -1216067460 - -23043, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1216067460 - (char)-28761, -1216067460 - -((char)-30682), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1216067460 - (char)-28733, -1216067460 - -15601, (int)l3) + ErrorToolsKt.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 73290108653324L;
                        int n3 = SshAgentIpcService.F();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-786682140 + -((char)-22451), 786682140 + (char)-29917, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-786682140 + -((char)-22448), -786682140 + -((char)-25287), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 36001147190718L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                n2 = SshAgentIpcService.s();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2214), 731239530 + (char)-8912, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2210), 731239530 + (char)-4387, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2193), 731239530 + (char)-21331, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2210), 731239530 + (char)-4387, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2216), 731239530 + (char)-7302, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2214), 731239530 + (char)-8912, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2210), 731239530 + (char)-4387, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2194), 731370600 - (char)-6831, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2214), 731239530 + (char)-8912, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2210), 731239530 + (char)-4387, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2195), -731239530 + -((char)-6962), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2214), 731239530 + (char)-8912, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2210), 731239530 + (char)-4387, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-731239530 + -((char)-2196), -731370600 - -((char)-7341), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 76008269238613L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.s();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29965), 233042460 - (char)-11093, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29969), 233042460 - (char)-32144, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29988), -233042460 - -((char)-26334), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29981), -233042460 - -((char)-16630), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29965), 233042460 - (char)-11093, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29969), 233042460 - (char)-32144, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29982), -233042460 - -((char)-19101), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29965), 233042460 - (char)-11093, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29969), 233042460 - (char)-32144, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29983), -233042460 - -((char)-24748), (int)l2) + ErrorToolsKt.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29965), 233042460 - (char)-11093, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29969), 233042460 - (char)-32144, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29984), -233042460 - -((char)-11859), (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29965), 233042460 - (char)-11093, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29969), 233042460 - (char)-32144, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29929), -233042460 - -((char)-31309), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-233042460 - -((char)-29930), -233042460 - -31771, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00ae\u00f6\u009cu p\u00da\u0097\u0014\u00c8$h\u00c8@OyjQ\u00ff\u00afOH\u0090/SW0K\u00f0\u0006\u00e0?ULs\u0016\u0018]\u00ed\u00ba\u00c1\u0098\u00ab`6\u00ba\t\u00dd\u00e1`\u00bax\u0094\u0014\u00a1\r_\u00ec=\u00f9\u0014\tRf\u00c5\u0001\u001c,\u00e8\u008e\u0097\u0005\u00a3\u000b=\u00cad\b\u00f5\u00a7\u00f7.\u001f=;\u00dc\u0014\u0082EY\u007f\u000b\u00b1%\"\u00b4+\u00b8a\u00e0\u00f6\u0081r\u0090\u00c7JL\u0005}\u00d9\u00e6\u0090\u001f\u001e\u0002i\u001c\u00e2\u00dd\u000bjX^\u00d0\n]\u00d6\r\f\u0006{b2\u00d3\u00a7\u0083\u009c\u000eA\u00d4\u00c19\u00cab\u0010\u0086@h\u0002\u0004%\u00a7d\u009a\u00e5\u001f\u0006r37^\t\u00e8\u0081D\u00ec\u007f\u00b6\u00a2B0\u0010H\u00d4\u00b1\u0090?w\u00c0.v\u00ac\u0082/\u00c1\u0016A\u00fa?\u00f2\u008d\n~\u0012\u0091\u0016g\u00a0\u00e6\u0090`:\\\u00ac\u0015\u00aaeu\u00f6\u00c1u+\u00b6\u00a7+\u0010r\u00c7]8w8\u00c7\u00bf$\u009f(\n\u00bb\u00b8,a:\n\u00ee\u0010|P\u00a8\u00b7|\u0016m\t\rG\u00c3\u00ff\u008e\u00ec\u008f\u00aa\b\u008e\u00e2\u0098\u0086\u00f2(\u0086~\f\u00cf|\u00a0N\u00e8S+\u0016\"\u00e3Z\u00c2F\u00c9\u00be`\u0016\u00f0X(wB\u00c3\\\u00025\u0018R\u00bb\u0089\u00d7\u0011\u000f_\u0018\u00fb)\u008b\u00f3fb\u00b6v,.\u0086Z\u00aa\u00b6\u00e77\u00ae\u009c\u00bf\u00dd\n\u00ff\u00b9\u00d32\u00a6\u00f3\u000b\u00a5\u00a2\u00bb \u00aa\u00bf\u00ac\u00e1\u0014v\u00a2\u00f9?i5\u00ce\u00b5\u00c5\u00eai\u001f\u00ff\u0015\u00a3m*\u00fa\u0094f\u0081\u0017\u00f1\u00a5\u00a9\u000f\u00e8\u00f7\u009c\u00b4\u00b3\u00c3\\\u00014\u00f55{X\u0000\u00e4\u00b4d\u000bY\u00a4rU\u00b20`zKb}\u0015w~\u00b7\r\rS{k\u0016\u00a0\u001e\u0098\u00ea\u0004\u009d\u00c0\u00c9\u00c6\u00c4\u00f4\u0084)6\u00a7\u009a;\r0p?\u001d<b\u00c0\u00df\u00a9\u00b8&\u00c9\u0006\u00c22\u0082G)%\u00f9(\u0016\u0012\u0002\u0002:\u009e\u00ba\u00e9KM\u00c5Uay\u00e5\u0007vR\u0098\u009fi\u00f9g\u0007\u00ddT\u00893\u00ac\u0083\u00c9(\u0019C3\u0086\u0088\u00ed6\u00a3\u00a5x_~[\u00ffjo\u0094\u0082\u00c7\u00e1C\u0003~f\u0083\u00fc\u00ef\u00f3\n^\u00e0\f\u001a\u00d0\u00c1\u00c7.y\u008f\u000f\u000foD\u00b3Op\u00b8\u008c\u00ca\u0087\u00d8\u00ba;G\u0003w\"\u00ae?\u0089(oR<s\u0094\u00b5S\u00f1\u00fa\u0083x\u00ad:^6{\u00f6n\u0007P\u00af\u00d2\u0011\u0093\u00c6\u0000\u0000\u00d9\u00d3\u00f2\u000em\u0097\u00f35x\u00f7\u008d#\u00a7\u00e5\u00be\u009c\u00cb\u00fd\u001bF\u00e5\u0091~\u00cf+\u00ee\u00e4\u009c\u009aTr\u00c6\u0016\u00d9\t\u00a6`\u0018 \b1\u00ab\u001dq\u0016\u009f\nz\u00d2\u00d2\u009f\u00b3\u00f3\u00b2\u00d5\u00bc\u00de\u0018?\u00e3\u00be\u00b3+.S\u001a5\u008c\u00a3/\u0081\u00ee\u00cd7S\u00a6q\u0081]NZ\u00a1)D\u008f\u00d4>\u00c4\u0090I+:\u00be\u0086\u0090G\u00aa4=&\u0010\u00e05\u00fc\u00b7\u00af7\\\u00f8?\u00e4t\u0080O_1\u000f\u00ef\u0005\u008fx(\u00dc\u00cc\t2\u0010\u001f\u00c0\u001e\u00fc\u00d8P\u00c2";
                var4_3 = "\u00ae\u00f6\u009cu p\u00da\u0097\u0014\u00c8$h\u00c8@OyjQ\u00ff\u00afOH\u0090/SW0K\u00f0\u0006\u00e0?ULs\u0016\u0018]\u00ed\u00ba\u00c1\u0098\u00ab`6\u00ba\t\u00dd\u00e1`\u00bax\u0094\u0014\u00a1\r_\u00ec=\u00f9\u0014\tRf\u00c5\u0001\u001c,\u00e8\u008e\u0097\u0005\u00a3\u000b=\u00cad\b\u00f5\u00a7\u00f7.\u001f=;\u00dc\u0014\u0082EY\u007f\u000b\u00b1%\"\u00b4+\u00b8a\u00e0\u00f6\u0081r\u0090\u00c7JL\u0005}\u00d9\u00e6\u0090\u001f\u001e\u0002i\u001c\u00e2\u00dd\u000bjX^\u00d0\n]\u00d6\r\f\u0006{b2\u00d3\u00a7\u0083\u009c\u000eA\u00d4\u00c19\u00cab\u0010\u0086@h\u0002\u0004%\u00a7d\u009a\u00e5\u001f\u0006r37^\t\u00e8\u0081D\u00ec\u007f\u00b6\u00a2B0\u0010H\u00d4\u00b1\u0090?w\u00c0.v\u00ac\u0082/\u00c1\u0016A\u00fa?\u00f2\u008d\n~\u0012\u0091\u0016g\u00a0\u00e6\u0090`:\\\u00ac\u0015\u00aaeu\u00f6\u00c1u+\u00b6\u00a7+\u0010r\u00c7]8w8\u00c7\u00bf$\u009f(\n\u00bb\u00b8,a:\n\u00ee\u0010|P\u00a8\u00b7|\u0016m\t\rG\u00c3\u00ff\u008e\u00ec\u008f\u00aa\b\u008e\u00e2\u0098\u0086\u00f2(\u0086~\f\u00cf|\u00a0N\u00e8S+\u0016\"\u00e3Z\u00c2F\u00c9\u00be`\u0016\u00f0X(wB\u00c3\\\u00025\u0018R\u00bb\u0089\u00d7\u0011\u000f_\u0018\u00fb)\u008b\u00f3fb\u00b6v,.\u0086Z\u00aa\u00b6\u00e77\u00ae\u009c\u00bf\u00dd\n\u00ff\u00b9\u00d32\u00a6\u00f3\u000b\u00a5\u00a2\u00bb \u00aa\u00bf\u00ac\u00e1\u0014v\u00a2\u00f9?i5\u00ce\u00b5\u00c5\u00eai\u001f\u00ff\u0015\u00a3m*\u00fa\u0094f\u0081\u0017\u00f1\u00a5\u00a9\u000f\u00e8\u00f7\u009c\u00b4\u00b3\u00c3\\\u00014\u00f55{X\u0000\u00e4\u00b4d\u000bY\u00a4rU\u00b20`zKb}\u0015w~\u00b7\r\rS{k\u0016\u00a0\u001e\u0098\u00ea\u0004\u009d\u00c0\u00c9\u00c6\u00c4\u00f4\u0084)6\u00a7\u009a;\r0p?\u001d<b\u00c0\u00df\u00a9\u00b8&\u00c9\u0006\u00c22\u0082G)%\u00f9(\u0016\u0012\u0002\u0002:\u009e\u00ba\u00e9KM\u00c5Uay\u00e5\u0007vR\u0098\u009fi\u00f9g\u0007\u00ddT\u00893\u00ac\u0083\u00c9(\u0019C3\u0086\u0088\u00ed6\u00a3\u00a5x_~[\u00ffjo\u0094\u0082\u00c7\u00e1C\u0003~f\u0083\u00fc\u00ef\u00f3\n^\u00e0\f\u001a\u00d0\u00c1\u00c7.y\u008f\u000f\u000foD\u00b3Op\u00b8\u008c\u00ca\u0087\u00d8\u00ba;G\u0003w\"\u00ae?\u0089(oR<s\u0094\u00b5S\u00f1\u00fa\u0083x\u00ad:^6{\u00f6n\u0007P\u00af\u00d2\u0011\u0093\u00c6\u0000\u0000\u00d9\u00d3\u00f2\u000em\u0097\u00f35x\u00f7\u008d#\u00a7\u00e5\u00be\u009c\u00cb\u00fd\u001bF\u00e5\u0091~\u00cf+\u00ee\u00e4\u009c\u009aTr\u00c6\u0016\u00d9\t\u00a6`\u0018 \b1\u00ab\u001dq\u0016\u009f\nz\u00d2\u00d2\u009f\u00b3\u00f3\u00b2\u00d5\u00bc\u00de\u0018?\u00e3\u00be\u00b3+.S\u001a5\u008c\u00a3/\u0081\u00ee\u00cd7S\u00a6q\u0081]NZ\u00a1)D\u008f\u00d4>\u00c4\u0090I+:\u00be\u0086\u0090G\u00aa4=&\u0010\u00e05\u00fc\u00b7\u00af7\\\u00f8?\u00e4t\u0080O_1\u000f\u00ef\u0005\u008fx(\u00dc\u00cc\t2\u0010\u001f\u00c0\u001e\u00fc\u00d8P\u00c2".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 126;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\fP\u00f6\u00ee\u00ab\u00a1\u008f&\u00c94\u00d3\u00ea\u00c6\u00ce/\u009an\u00c3\u0092\u00e0\u00cc\u0019q\u0017\u0007\u00cb\u00ee\u00ec\u00f5\u0014ER\u00f2-8\u00d8]\u00b3\u00fe\u00efqf\u00b8\u009e\u001a\u00b9\u00daF\u00d1\u0015";
                    var4_3 = "\fP\u00f6\u00ee\u00ab\u00a1\u008f&\u00c94\u00d3\u00ea\u00c6\u00ce/\u009an\u00c3\u0092\u00e0\u00cc\u0019q\u0017\u0007\u00cb\u00ee\u00ec\u00f5\u0014ER\u00f2-8\u00d8]\u00b3\u00fe\u00efqf\u00b8\u009e\u001a\u00b9\u00daF\u00d1\u0015".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 61;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 44;
                            break;
                        }
                        case 1: {
                            v15 = 106;
                            break;
                        }
                        case 2: {
                            v15 = 115;
                            break;
                        }
                        case 3: {
                            v15 = 118;
                            break;
                        }
                        case 4: {
                            v15 = 66;
                            break;
                        }
                        case 5: {
                            v15 = 9;
                            break;
                        }
                        default: {
                            v15 = 9;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFC98E) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 28;
                case 1 -> 138;
                case 2 -> 13;
                case 3 -> 163;
                case 4 -> 122;
                case 5 -> 233;
                case 6 -> 145;
                case 7 -> 83;
                case 8 -> 76;
                case 9 -> 158;
                case 10 -> 43;
                case 11 -> 132;
                case 12 -> 3;
                case 13 -> 47;
                case 14 -> 147;
                case 15 -> 26;
                case 16 -> 185;
                case 17 -> 102;
                case 18 -> 79;
                case 19 -> 70;
                case 20 -> 37;
                case 21 -> 194;
                case 22 -> 65;
                case 23 -> 20;
                case 24 -> 130;
                case 25 -> 192;
                case 26 -> 167;
                case 27 -> 81;
                case 28 -> 82;
                case 29 -> 155;
                case 30 -> 181;
                case 31 -> 114;
                case 32 -> 239;
                case 33 -> 222;
                case 34 -> 211;
                case 35 -> 180;
                case 36 -> 223;
                case 37 -> 97;
                case 38 -> 195;
                case 39 -> 203;
                case 40 -> 183;
                case 41 -> 236;
                case 42 -> 36;
                case 43 -> 98;
                case 44 -> 146;
                case 45 -> 242;
                case 46 -> 2;
                case 47 -> 154;
                case 48 -> 50;
                case 49 -> 244;
                case 50 -> 250;
                case 51 -> 208;
                case 52 -> 71;
                case 53 -> 16;
                case 54 -> 95;
                case 55 -> 153;
                case 56 -> 84;
                case 57 -> 69;
                case 58 -> 87;
                case 59 -> 44;
                case 60 -> 160;
                case 61 -> 162;
                case 62 -> 49;
                case 63 -> 80;
                case 64 -> 34;
                case 65 -> 101;
                case 66 -> 74;
                case 67 -> 68;
                case 68 -> 143;
                case 69 -> 86;
                case 70 -> 109;
                case 71 -> 42;
                case 72 -> 189;
                case 73 -> 52;
                case 74 -> 224;
                case 75 -> 62;
                case 76 -> 107;
                case 77 -> 58;
                case 78 -> 10;
                case 79 -> 205;
                case 80 -> 179;
                case 81 -> 135;
                case 82 -> 33;
                case 83 -> 18;
                case 84 -> 141;
                case 85 -> 241;
                case 86 -> 8;
                case 87 -> 54;
                case 88 -> 94;
                case 89 -> 35;
                case 90 -> 191;
                case 91 -> 198;
                case 92 -> 14;
                case 93 -> 0;
                case 94 -> 197;
                case 95 -> 121;
                case 96 -> 106;
                case 97 -> 136;
                case 98 -> 53;
                case 99 -> 119;
                case 100 -> 216;
                case 101 -> 125;
                case 102 -> 226;
                case 103 -> 124;
                case 104 -> 61;
                case 105 -> 40;
                case 106 -> 24;
                case 107 -> 64;
                case 108 -> 221;
                case 109 -> 187;
                case 110 -> 104;
                case 111 -> 110;
                case 112 -> 131;
                case 113 -> 30;
                case 114 -> 105;
                case 115 -> 217;
                case 116 -> 126;
                case 117 -> 175;
                case 118 -> 245;
                case 119 -> 148;
                case 120 -> 165;
                case 121 -> 63;
                case 122 -> 118;
                case 123 -> 207;
                case 124 -> 103;
                case 125 -> 137;
                case 126 -> 212;
                case 127 -> 190;
                case 128 -> 6;
                case 129 -> 39;
                case 130 -> 227;
                case 131 -> 128;
                case 132 -> 15;
                case 133 -> 177;
                case 134 -> 92;
                case 135 -> 134;
                case 136 -> 229;
                case 137 -> 156;
                case 138 -> 56;
                case 139 -> 173;
                case 140 -> 164;
                case 141 -> 151;
                case 142 -> 129;
                case 143 -> 171;
                case 144 -> 231;
                case 145 -> 255;
                case 146 -> 159;
                case 147 -> 202;
                case 148 -> 168;
                case 149 -> 78;
                case 150 -> 4;
                case 151 -> 200;
                case 152 -> 19;
                case 153 -> 238;
                case 154 -> 51;
                case 155 -> 75;
                case 156 -> 169;
                case 157 -> 32;
                case 158 -> 228;
                case 159 -> 27;
                case 160 -> 89;
                case 161 -> 237;
                case 162 -> 172;
                case 163 -> 73;
                case 164 -> 5;
                case 165 -> 66;
                case 166 -> 174;
                case 167 -> 113;
                case 168 -> 246;
                case 169 -> 127;
                case 170 -> 249;
                case 171 -> 115;
                case 172 -> 210;
                case 173 -> 96;
                case 174 -> 209;
                case 175 -> 111;
                case 176 -> 150;
                case 177 -> 214;
                case 178 -> 60;
                case 179 -> 45;
                case 180 -> 133;
                case 181 -> 99;
                case 182 -> 166;
                case 183 -> 120;
                case 184 -> 139;
                case 185 -> 247;
                case 186 -> 77;
                case 187 -> 213;
                case 188 -> 230;
                case 189 -> 88;
                case 190 -> 182;
                case 191 -> 253;
                case 192 -> 201;
                case 193 -> 243;
                case 194 -> 235;
                case 195 -> 186;
                case 196 -> 22;
                case 197 -> 25;
                case 198 -> 23;
                case 199 -> 29;
                case 200 -> 206;
                case 201 -> 188;
                case 202 -> 232;
                case 203 -> 149;
                case 204 -> 220;
                case 205 -> 38;
                case 206 -> 196;
                case 207 -> 218;
                case 208 -> 234;
                case 209 -> 108;
                case 210 -> 219;
                case 211 -> 112;
                case 212 -> 193;
                case 213 -> 225;
                case 214 -> 7;
                case 215 -> 170;
                case 216 -> 248;
                case 217 -> 72;
                case 218 -> 144;
                case 219 -> 57;
                case 220 -> 116;
                case 221 -> 17;
                case 222 -> 9;
                case 223 -> 252;
                case 224 -> 178;
                case 225 -> 11;
                case 226 -> 48;
                case 227 -> 90;
                case 228 -> 12;
                case 229 -> 152;
                case 230 -> 59;
                case 231 -> 55;
                case 232 -> 204;
                case 233 -> 157;
                case 234 -> 46;
                case 235 -> 21;
                case 236 -> 67;
                case 237 -> 85;
                case 238 -> 41;
                case 239 -> 1;
                case 240 -> 240;
                case 241 -> 142;
                case 242 -> 93;
                case 243 -> 117;
                case 244 -> 254;
                case 245 -> 123;
                case 246 -> 251;
                case 247 -> 199;
                case 248 -> 100;
                case 249 -> 215;
                case 250 -> 140;
                case 251 -> 31;
                case 252 -> 176;
                case 253 -> 184;
                case 254 -> 161;
                default -> 91;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 12341353424659L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1912442370 - (char)-13867, 1912442370 - (char)-25963, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 139884539680264L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.F();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1749784500 + (char)-8829, 1749784500 + (char)-28191, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1749784500 + (char)-8832, 1749784500 + (char)-8236, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1749784500 + (char)-8831, -1749784500 + -((char)-22406), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00dd\u0088\u00cdi\u009db+\u00a1\u0010IW\u00ae3K\u0092\b\u00e6q\u008a\u00b1|6:\u00cba";
                    var4_3 = "\u00dd\u0088\u00cdi\u009db+\u00a1\u0010IW\u00ae3K\u0092\b\u00e6q\u008a\u00b1|6:\u00cba".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 59;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ba\u00a6H\u00c545J\u0003A\u001d\u00c7\u0007\u00e8\u0096sV\nN\u00df\u00ff\u009a:$\u00f3\u00cdM\u00e5\u009atI\u0097\u0085\u00f1\u00a2v\u0000\u0089!\fI\u0012\u00a9\u0098\u00e5\u0014\u00973\u00a9\u009a\u0015vZ\u0093\u0080\u00bb\u00dc\u00ae\u0081\u00ca";
                        var4_3 = "\u00ba\u00a6H\u00c545J\u0003A\u001d\u00c7\u0007\u00e8\u0096sV\nN\u00df\u00ff\u009a:$\u00f3\u00cdM\u00e5\u009atI\u0097\u0085\u00f1\u00a2v\u0000\u0089!\fI\u0012\u00a9\u0098\u00e5\u0014\u00973\u00a9\u009a\u0015vZ\u0093\u0080\u00bb\u00dc\u00ae\u0081\u00ca".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 122;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 123;
                                break;
                            }
                            case 1: {
                                v15 = 25;
                                break;
                            }
                            case 2: {
                                v15 = 75;
                                break;
                            }
                            case 3: {
                                v15 = 38;
                                break;
                            }
                            case 4: {
                                v15 = 63;
                                break;
                            }
                            case 5: {
                                v15 = 127;
                                break;
                            }
                            default: {
                                v15 = 13;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x633E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 35;
                    case 1 -> 97;
                    case 2 -> 125;
                    case 3 -> 159;
                    case 4 -> 193;
                    case 5 -> 83;
                    case 6 -> 100;
                    case 7 -> 46;
                    case 8 -> 154;
                    case 9 -> 47;
                    case 10 -> 104;
                    case 11 -> 38;
                    case 12 -> 112;
                    case 13 -> 218;
                    case 14 -> 111;
                    case 15 -> 79;
                    case 16 -> 37;
                    case 17 -> 63;
                    case 18 -> 45;
                    case 19 -> 122;
                    case 20 -> 225;
                    case 21 -> 204;
                    case 22 -> 50;
                    case 23 -> 130;
                    case 24 -> 133;
                    case 25 -> 20;
                    case 26 -> 175;
                    case 27 -> 56;
                    case 28 -> 30;
                    case 29 -> 238;
                    case 30 -> 123;
                    case 31 -> 202;
                    case 32 -> 162;
                    case 33 -> 12;
                    case 34 -> 17;
                    case 35 -> 75;
                    case 36 -> 211;
                    case 37 -> 43;
                    case 38 -> 217;
                    case 39 -> 60;
                    case 40 -> 209;
                    case 41 -> 205;
                    case 42 -> 149;
                    case 43 -> 3;
                    case 44 -> 189;
                    case 45 -> 88;
                    case 46 -> 31;
                    case 47 -> 199;
                    case 48 -> 185;
                    case 49 -> 108;
                    case 50 -> 5;
                    case 51 -> 23;
                    case 52 -> 39;
                    case 53 -> 234;
                    case 54 -> 2;
                    case 55 -> 138;
                    case 56 -> 230;
                    case 57 -> 156;
                    case 58 -> 139;
                    case 59 -> 102;
                    case 60 -> 115;
                    case 61 -> 21;
                    case 62 -> 25;
                    case 63 -> 243;
                    case 64 -> 116;
                    case 65 -> 153;
                    case 66 -> 32;
                    case 67 -> 172;
                    case 68 -> 0;
                    case 69 -> 81;
                    case 70 -> 191;
                    case 71 -> 251;
                    case 72 -> 22;
                    case 73 -> 99;
                    case 74 -> 13;
                    case 75 -> 105;
                    case 76 -> 41;
                    case 77 -> 250;
                    case 78 -> 95;
                    case 79 -> 76;
                    case 80 -> 173;
                    case 81 -> 163;
                    case 82 -> 206;
                    case 83 -> 53;
                    case 84 -> 237;
                    case 85 -> 196;
                    case 86 -> 186;
                    case 87 -> 16;
                    case 88 -> 214;
                    case 89 -> 232;
                    case 90 -> 57;
                    case 91 -> 33;
                    case 92 -> 157;
                    case 93 -> 82;
                    case 94 -> 14;
                    case 95 -> 146;
                    case 96 -> 200;
                    case 97 -> 36;
                    case 98 -> 249;
                    case 99 -> 93;
                    case 100 -> 4;
                    case 101 -> 224;
                    case 102 -> 245;
                    case 103 -> 222;
                    case 104 -> 87;
                    case 105 -> 147;
                    case 106 -> 155;
                    case 107 -> 161;
                    case 108 -> 68;
                    case 109 -> 91;
                    case 110 -> 78;
                    case 111 -> 18;
                    case 112 -> 126;
                    case 113 -> 210;
                    case 114 -> 94;
                    case 115 -> 166;
                    case 116 -> 113;
                    case 117 -> 28;
                    case 118 -> 221;
                    case 119 -> 114;
                    case 120 -> 170;
                    case 121 -> 171;
                    case 122 -> 7;
                    case 123 -> 165;
                    case 124 -> 201;
                    case 125 -> 151;
                    case 126 -> 103;
                    case 127 -> 1;
                    case 128 -> 69;
                    case 129 -> 179;
                    case 130 -> 227;
                    case 131 -> 127;
                    case 132 -> 58;
                    case 133 -> 141;
                    case 134 -> 49;
                    case 135 -> 228;
                    case 136 -> 72;
                    case 137 -> 106;
                    case 138 -> 208;
                    case 139 -> 66;
                    case 140 -> 239;
                    case 141 -> 223;
                    case 142 -> 188;
                    case 143 -> 89;
                    case 144 -> 73;
                    case 145 -> 255;
                    case 146 -> 220;
                    case 147 -> 67;
                    case 148 -> 11;
                    case 149 -> 226;
                    case 150 -> 213;
                    case 151 -> 121;
                    case 152 -> 26;
                    case 153 -> 136;
                    case 154 -> 55;
                    case 155 -> 71;
                    case 156 -> 235;
                    case 157 -> 145;
                    case 158 -> 216;
                    case 159 -> 241;
                    case 160 -> 148;
                    case 161 -> 74;
                    case 162 -> 244;
                    case 163 -> 85;
                    case 164 -> 247;
                    case 165 -> 253;
                    case 166 -> 124;
                    case 167 -> 54;
                    case 168 -> 131;
                    case 169 -> 184;
                    case 170 -> 109;
                    case 171 -> 242;
                    case 172 -> 168;
                    case 173 -> 164;
                    case 174 -> 240;
                    case 175 -> 158;
                    case 176 -> 198;
                    case 177 -> 174;
                    case 178 -> 215;
                    case 179 -> 182;
                    case 180 -> 10;
                    case 181 -> 110;
                    case 182 -> 34;
                    case 183 -> 195;
                    case 184 -> 176;
                    case 185 -> 62;
                    case 186 -> 120;
                    case 187 -> 181;
                    case 188 -> 150;
                    case 189 -> 19;
                    case 190 -> 207;
                    case 191 -> 137;
                    case 192 -> 152;
                    case 193 -> 167;
                    case 194 -> 160;
                    case 195 -> 48;
                    case 196 -> 84;
                    case 197 -> 254;
                    case 198 -> 129;
                    case 199 -> 178;
                    case 200 -> 212;
                    case 201 -> 15;
                    case 202 -> 8;
                    case 203 -> 24;
                    case 204 -> 64;
                    case 205 -> 51;
                    case 206 -> 80;
                    case 207 -> 219;
                    case 208 -> 101;
                    case 209 -> 203;
                    case 210 -> 183;
                    case 211 -> 233;
                    case 212 -> 134;
                    case 213 -> 180;
                    case 214 -> 132;
                    case 215 -> 236;
                    case 216 -> 128;
                    case 217 -> 98;
                    case 218 -> 90;
                    case 219 -> 92;
                    case 220 -> 59;
                    case 221 -> 52;
                    case 222 -> 197;
                    case 223 -> 29;
                    case 224 -> 65;
                    case 225 -> 61;
                    case 226 -> 142;
                    case 227 -> 248;
                    case 228 -> 143;
                    case 229 -> 42;
                    case 230 -> 118;
                    case 231 -> 192;
                    case 232 -> 252;
                    case 233 -> 44;
                    case 234 -> 9;
                    case 235 -> 231;
                    case 236 -> 27;
                    case 237 -> 40;
                    case 238 -> 119;
                    case 239 -> 144;
                    case 240 -> 194;
                    case 241 -> 117;
                    case 242 -> 77;
                    case 243 -> 246;
                    case 244 -> 187;
                    case 245 -> 190;
                    case 246 -> 169;
                    case 247 -> 135;
                    case 248 -> 96;
                    case 249 -> 177;
                    case 250 -> 140;
                    case 251 -> 86;
                    case 252 -> 229;
                    case 253 -> 107;
                    case 254 -> 6;
                    default -> 70;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 74160162628558L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u001f]\u0006f\u0005n6F\t\u0018W\u0015lH,+Z\u0011";
                    var5_4 = "\u001f]\u0006f\u0005n6F\t\u0018W\u0015lH,+Z\u0011".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 65;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 53;
                                    break;
                                }
                                case 1: {
                                    v11 = 121;
                                    break;
                                }
                                case 2: {
                                    v11 = 53;
                                    break;
                                }
                                case 3: {
                                    v11 = 73;
                                    break;
                                }
                                case 4: {
                                    v11 = 33;
                                    break;
                                }
                                case 5: {
                                    v11 = 67;
                                    break;
                                }
                                default: {
                                    v11 = 68;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 138572643795839L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "i_&X\u0007\u0005]\u0004oA*B\nc^!B\u000b\u0007EI_(\tc^!B\u000b\u0007EEU\rdX<O\u0001\n_ER;E\u0000\u0003";
                    var5_4 = "i_&X\u0007\u0005]\u0004oA*B\nc^!B\u000b\u0007EI_(\tc^!B\u000b\u0007EEU\rdX<O\u0001\n_ER;E\u0000\u0003".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 94;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "tJ7H\u0010\u001dA\u0006tJ7H\u001c\u0017";
                        var5_4 = "tJ7H\u0010\u001dA\u0006tJ7H\u001c\u0017".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 73;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 126;
                                break;
                            }
                            case 1: {
                                v15 = 111;
                                break;
                            }
                            case 2: {
                                v15 = 17;
                                break;
                            }
                            case 3: {
                                v15 = 114;
                                break;
                            }
                            case 4: {
                                v15 = 48;
                                break;
                            }
                            case 5: {
                                v15 = 58;
                                break;
                            }
                            default: {
                                v15 = 111;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 28098008302645L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(332262450 + 1415, -332262450 - -25719, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 125227742513154L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00f1?(\u00f5\u00be\u0003%\u00be\u0006\u0005\u00f44\u00aeP\u008d\r\u00f4\u0012\u0098\u00de\u00be\u001eZ\u007fL{[\u0003)\u0010H\u00f9\u00c8H\u008bY\u00d7\u00aa4E\u00b7\u0089RCr\u00f0\u0005\u00a1\u00c5\u0004n\u00d83`\u0080-\u00b1\u00e2\"\u00ca\u00d1\u00ea\u00d7\u00e7\u00f2\u009e}\u00c7(\u0090mIS|\u0003\u00f6\u00dd\u00cb\u00ed^Wa\u00dd{\u0000\u00f6\u0006\u0003w\u0097S\u0082.\u00b1j\u0087\u0088\u008b\\'\u00a7\nT\u00bf";
                    var4_3 = "\u00f1?(\u00f5\u00be\u0003%\u00be\u0006\u0005\u00f44\u00aeP\u008d\r\u00f4\u0012\u0098\u00de\u00be\u001eZ\u007fL{[\u0003)\u0010H\u00f9\u00c8H\u008bY\u00d7\u00aa4E\u00b7\u0089RCr\u00f0\u0005\u00a1\u00c5\u0004n\u00d83`\u0080-\u00b1\u00e2\"\u00ca\u00d1\u00ea\u00d7\u00e7\u00f2\u009e}\u00c7(\u0090mIS|\u0003\u00f6\u00dd\u00cb\u00ed^Wa\u00dd{\u0000\u00f6\u0006\u0003w\u0097S\u0082.\u00b1j\u0087\u0088\u008b\\'\u00a7\nT\u00bf".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 22;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00dc\u0007\u00e7*\u00d3\u00a8a)_\u0088g\u008d\u00f5~;\u00eaLM\u00ed\"\u00bdA\u0092]\u0000Q>\n\u00e2V\u001d\u00dc\u00ffK\u00fbp\u00ca\u008e\u00e9?\u009fl\u00f32\u00ef\u00ab>p\u00ae:\u0080V\u0006\u00b2\u001e\u00a1\\^d\b\u0089\u00d2\u001fzJ\u00ee`v\u0010\u00c1\u001f\u0084\u008d\u000e\u001a\u00ddL\u00ba'\u00f4;$@\u00adS\u00c8\u00d0Y\u0096\u0014\u00e9\u0096\u001f";
                        var4_3 = "\u00dc\u0007\u00e7*\u00d3\u00a8a)_\u0088g\u008d\u00f5~;\u00eaLM\u00ed\"\u00bdA\u0092]\u0000Q>\n\u00e2V\u001d\u00dc\u00ffK\u00fbp\u00ca\u008e\u00e9?\u009fl\u00f32\u00ef\u00ab>p\u00ae:\u0080V\u0006\u00b2\u001e\u00a1\\^d\b\u0089\u00d2\u001fzJ\u00ee`v\u0010\u00c1\u001f\u0084\u008d\u000e\u001a\u00ddL\u00ba'\u00f4;$@\u00adS\u00c8\u00d0Y\u0096\u0014\u00e9\u0096\u001f".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 65;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 102;
                                break;
                            }
                            case 1: {
                                v15 = 98;
                                break;
                            }
                            case 2: {
                                v15 = 38;
                                break;
                            }
                            case 3: {
                                v15 = 111;
                                break;
                            }
                            case 4: {
                                v15 = 22;
                                break;
                            }
                            case 5: {
                                v15 = 122;
                                break;
                            }
                            default: {
                                v15 = 103;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x358C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 206;
                    case 1 -> 191;
                    case 2 -> 121;
                    case 3 -> 125;
                    case 4 -> 255;
                    case 5 -> 149;
                    case 6 -> 115;
                    case 7 -> 28;
                    case 8 -> 137;
                    case 9 -> 95;
                    case 10 -> 44;
                    case 11 -> 239;
                    case 12 -> 65;
                    case 13 -> 183;
                    case 14 -> 131;
                    case 15 -> 222;
                    case 16 -> 155;
                    case 17 -> 199;
                    case 18 -> 205;
                    case 19 -> 134;
                    case 20 -> 136;
                    case 21 -> 234;
                    case 22 -> 141;
                    case 23 -> 31;
                    case 24 -> 154;
                    case 25 -> 57;
                    case 26 -> 66;
                    case 27 -> 126;
                    case 28 -> 249;
                    case 29 -> 132;
                    case 30 -> 223;
                    case 31 -> 159;
                    case 32 -> 240;
                    case 33 -> 79;
                    case 34 -> 226;
                    case 35 -> 109;
                    case 36 -> 33;
                    case 37 -> 72;
                    case 38 -> 22;
                    case 39 -> 248;
                    case 40 -> 127;
                    case 41 -> 212;
                    case 42 -> 168;
                    case 43 -> 20;
                    case 44 -> 216;
                    case 45 -> 77;
                    case 46 -> 61;
                    case 47 -> 193;
                    case 48 -> 19;
                    case 49 -> 250;
                    case 50 -> 128;
                    case 51 -> 143;
                    case 52 -> 71;
                    case 53 -> 217;
                    case 54 -> 200;
                    case 55 -> 158;
                    case 56 -> 114;
                    case 57 -> 14;
                    case 58 -> 32;
                    case 59 -> 173;
                    case 60 -> 89;
                    case 61 -> 152;
                    case 62 -> 112;
                    case 63 -> 214;
                    case 64 -> 160;
                    case 65 -> 232;
                    case 66 -> 147;
                    case 67 -> 2;
                    case 68 -> 13;
                    case 69 -> 45;
                    case 70 -> 76;
                    case 71 -> 58;
                    case 72 -> 1;
                    case 73 -> 16;
                    case 74 -> 116;
                    case 75 -> 122;
                    case 76 -> 60;
                    case 77 -> 221;
                    case 78 -> 196;
                    case 79 -> 85;
                    case 80 -> 103;
                    case 81 -> 25;
                    case 82 -> 59;
                    case 83 -> 30;
                    case 84 -> 110;
                    case 85 -> 237;
                    case 86 -> 230;
                    case 87 -> 27;
                    case 88 -> 93;
                    case 89 -> 145;
                    case 90 -> 204;
                    case 91 -> 175;
                    case 92 -> 40;
                    case 93 -> 78;
                    case 94 -> 188;
                    case 95 -> 87;
                    case 96 -> 189;
                    case 97 -> 244;
                    case 98 -> 167;
                    case 99 -> 11;
                    case 100 -> 225;
                    case 101 -> 254;
                    case 102 -> 190;
                    case 103 -> 3;
                    case 104 -> 64;
                    case 105 -> 163;
                    case 106 -> 185;
                    case 107 -> 81;
                    case 108 -> 106;
                    case 109 -> 67;
                    case 110 -> 184;
                    case 111 -> 108;
                    case 112 -> 21;
                    case 113 -> 54;
                    case 114 -> 62;
                    case 115 -> 7;
                    case 116 -> 233;
                    case 117 -> 104;
                    case 118 -> 73;
                    case 119 -> 177;
                    case 120 -> 86;
                    case 121 -> 198;
                    case 122 -> 23;
                    case 123 -> 9;
                    case 124 -> 101;
                    case 125 -> 172;
                    case 126 -> 0;
                    case 127 -> 48;
                    case 128 -> 228;
                    case 129 -> 144;
                    case 130 -> 68;
                    case 131 -> 146;
                    case 132 -> 178;
                    case 133 -> 56;
                    case 134 -> 102;
                    case 135 -> 181;
                    case 136 -> 15;
                    case 137 -> 224;
                    case 138 -> 235;
                    case 139 -> 99;
                    case 140 -> 253;
                    case 141 -> 39;
                    case 142 -> 91;
                    case 143 -> 37;
                    case 144 -> 49;
                    case 145 -> 53;
                    case 146 -> 35;
                    case 147 -> 8;
                    case 148 -> 105;
                    case 149 -> 236;
                    case 150 -> 192;
                    case 151 -> 119;
                    case 152 -> 26;
                    case 153 -> 252;
                    case 154 -> 231;
                    case 155 -> 18;
                    case 156 -> 194;
                    case 157 -> 247;
                    case 158 -> 220;
                    case 159 -> 227;
                    case 160 -> 74;
                    case 161 -> 242;
                    case 162 -> 51;
                    case 163 -> 202;
                    case 164 -> 142;
                    case 165 -> 166;
                    case 166 -> 94;
                    case 167 -> 41;
                    case 168 -> 29;
                    case 169 -> 129;
                    case 170 -> 176;
                    case 171 -> 179;
                    case 172 -> 209;
                    case 173 -> 84;
                    case 174 -> 24;
                    case 175 -> 164;
                    case 176 -> 111;
                    case 177 -> 180;
                    case 178 -> 17;
                    case 179 -> 46;
                    case 180 -> 120;
                    case 181 -> 218;
                    case 182 -> 162;
                    case 183 -> 82;
                    case 184 -> 138;
                    case 185 -> 241;
                    case 186 -> 107;
                    case 187 -> 187;
                    case 188 -> 75;
                    case 189 -> 211;
                    case 190 -> 4;
                    case 191 -> 50;
                    case 192 -> 117;
                    case 193 -> 47;
                    case 194 -> 88;
                    case 195 -> 69;
                    case 196 -> 208;
                    case 197 -> 140;
                    case 198 -> 12;
                    case 199 -> 5;
                    case 200 -> 63;
                    case 201 -> 156;
                    case 202 -> 161;
                    case 203 -> 139;
                    case 204 -> 6;
                    case 205 -> 100;
                    case 206 -> 80;
                    case 207 -> 118;
                    case 208 -> 90;
                    case 209 -> 238;
                    case 210 -> 133;
                    case 211 -> 124;
                    case 212 -> 38;
                    case 213 -> 70;
                    case 214 -> 203;
                    case 215 -> 195;
                    case 216 -> 135;
                    case 217 -> 130;
                    case 218 -> 36;
                    case 219 -> 150;
                    case 220 -> 123;
                    case 221 -> 245;
                    case 222 -> 98;
                    case 223 -> 210;
                    case 224 -> 153;
                    case 225 -> 169;
                    case 226 -> 165;
                    case 227 -> 43;
                    case 228 -> 182;
                    case 229 -> 170;
                    case 230 -> 92;
                    case 231 -> 246;
                    case 232 -> 243;
                    case 233 -> 113;
                    case 234 -> 207;
                    case 235 -> 52;
                    case 236 -> 151;
                    case 237 -> 251;
                    case 238 -> 34;
                    case 239 -> 55;
                    case 240 -> 96;
                    case 241 -> 83;
                    case 242 -> 10;
                    case 243 -> 201;
                    case 244 -> 215;
                    case 245 -> 174;
                    case 246 -> 213;
                    case 247 -> 197;
                    case 248 -> 42;
                    case 249 -> 148;
                    case 250 -> 97;
                    case 251 -> 229;
                    case 252 -> 157;
                    case 253 -> 219;
                    case 254 -> 186;
                    default -> 171;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 104045567979383L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(0xE1FF1E - (char)-31173, 0xE1FF1E - (char)-24525, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 132283089489308L;
                    int n3 = SshAgentIpcService.s();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1903267470 - (char)-19323, -1903267470 - -((char)-5565), (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 87032283067490L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "Vd9\u009c\u00b4\u0003?pB";
                var4_3 = "Vd9\u009c\u00b4\u0003?pB".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 50;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 47;
                                break;
                            }
                            case 1: {
                                v11 = 78;
                                break;
                            }
                            case 2: {
                                v11 = 74;
                                break;
                            }
                            case 3: {
                                v11 = 72;
                                break;
                            }
                            case 4: {
                                v11 = 19;
                                break;
                            }
                            case 5: {
                                v11 = 49;
                                break;
                            }
                            default: {
                                v11 = 36;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD794) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 9;
                    case 1 -> 180;
                    case 2 -> 127;
                    case 3 -> 164;
                    case 4 -> 205;
                    case 5 -> 56;
                    case 6 -> 149;
                    case 7 -> 59;
                    case 8 -> 242;
                    case 9 -> 103;
                    case 10 -> 130;
                    case 11 -> 224;
                    case 12 -> 75;
                    case 13 -> 241;
                    case 14 -> 24;
                    case 15 -> 120;
                    case 16 -> 217;
                    case 17 -> 196;
                    case 18 -> 206;
                    case 19 -> 34;
                    case 20 -> 234;
                    case 21 -> 7;
                    case 22 -> 167;
                    case 23 -> 162;
                    case 24 -> 170;
                    case 25 -> 115;
                    case 26 -> 100;
                    case 27 -> 2;
                    case 28 -> 50;
                    case 29 -> 225;
                    case 30 -> 171;
                    case 31 -> 10;
                    case 32 -> 70;
                    case 33 -> 27;
                    case 34 -> 216;
                    case 35 -> 232;
                    case 36 -> 126;
                    case 37 -> 109;
                    case 38 -> 223;
                    case 39 -> 248;
                    case 40 -> 253;
                    case 41 -> 42;
                    case 42 -> 121;
                    case 43 -> 101;
                    case 44 -> 228;
                    case 45 -> 35;
                    case 46 -> 239;
                    case 47 -> 61;
                    case 48 -> 174;
                    case 49 -> 53;
                    case 50 -> 211;
                    case 51 -> 26;
                    case 52 -> 63;
                    case 53 -> 81;
                    case 54 -> 209;
                    case 55 -> 141;
                    case 56 -> 22;
                    case 57 -> 37;
                    case 58 -> 113;
                    case 59 -> 183;
                    case 60 -> 198;
                    case 61 -> 158;
                    case 62 -> 21;
                    case 63 -> 36;
                    case 64 -> 156;
                    case 65 -> 181;
                    case 66 -> 88;
                    case 67 -> 214;
                    case 68 -> 182;
                    case 69 -> 244;
                    case 70 -> 45;
                    case 71 -> 82;
                    case 72 -> 99;
                    case 73 -> 68;
                    case 74 -> 67;
                    case 75 -> 114;
                    case 76 -> 105;
                    case 77 -> 90;
                    case 78 -> 15;
                    case 79 -> 161;
                    case 80 -> 235;
                    case 81 -> 20;
                    case 82 -> 54;
                    case 83 -> 117;
                    case 84 -> 23;
                    case 85 -> 57;
                    case 86 -> 40;
                    case 87 -> 219;
                    case 88 -> 213;
                    case 89 -> 55;
                    case 90 -> 144;
                    case 91 -> 147;
                    case 92 -> 197;
                    case 93 -> 148;
                    case 94 -> 231;
                    case 95 -> 46;
                    case 96 -> 142;
                    case 97 -> 107;
                    case 98 -> 227;
                    case 99 -> 194;
                    case 100 -> 251;
                    case 101 -> 143;
                    case 102 -> 210;
                    case 103 -> 185;
                    case 104 -> 38;
                    case 105 -> 43;
                    case 106 -> 238;
                    case 107 -> 106;
                    case 108 -> 192;
                    case 109 -> 118;
                    case 110 -> 1;
                    case 111 -> 233;
                    case 112 -> 25;
                    case 113 -> 226;
                    case 114 -> 129;
                    case 115 -> 173;
                    case 116 -> 108;
                    case 117 -> 41;
                    case 118 -> 91;
                    case 119 -> 12;
                    case 120 -> 166;
                    case 121 -> 252;
                    case 122 -> 175;
                    case 123 -> 131;
                    case 124 -> 154;
                    case 125 -> 202;
                    case 126 -> 122;
                    case 127 -> 163;
                    case 128 -> 249;
                    case 129 -> 146;
                    case 130 -> 16;
                    case 131 -> 80;
                    case 132 -> 64;
                    case 133 -> 62;
                    case 134 -> 86;
                    case 135 -> 140;
                    case 136 -> 178;
                    case 137 -> 65;
                    case 138 -> 124;
                    case 139 -> 47;
                    case 140 -> 246;
                    case 141 -> 236;
                    case 142 -> 52;
                    case 143 -> 58;
                    case 144 -> 133;
                    case 145 -> 31;
                    case 146 -> 191;
                    case 147 -> 153;
                    case 148 -> 51;
                    case 149 -> 168;
                    case 150 -> 193;
                    case 151 -> 5;
                    case 152 -> 195;
                    case 153 -> 84;
                    case 154 -> 157;
                    case 155 -> 152;
                    case 156 -> 28;
                    case 157 -> 39;
                    case 158 -> 215;
                    case 159 -> 17;
                    case 160 -> 97;
                    case 161 -> 155;
                    case 162 -> 243;
                    case 163 -> 190;
                    case 164 -> 137;
                    case 165 -> 79;
                    case 166 -> 96;
                    case 167 -> 150;
                    case 168 -> 30;
                    case 169 -> 8;
                    case 170 -> 176;
                    case 171 -> 138;
                    case 172 -> 186;
                    case 173 -> 6;
                    case 174 -> 184;
                    case 175 -> 18;
                    case 176 -> 78;
                    case 177 -> 89;
                    case 178 -> 188;
                    case 179 -> 0;
                    case 180 -> 71;
                    case 181 -> 212;
                    case 182 -> 136;
                    case 183 -> 240;
                    case 184 -> 220;
                    case 185 -> 222;
                    case 186 -> 29;
                    case 187 -> 73;
                    case 188 -> 204;
                    case 189 -> 199;
                    case 190 -> 32;
                    case 191 -> 207;
                    case 192 -> 72;
                    case 193 -> 254;
                    case 194 -> 4;
                    case 195 -> 95;
                    case 196 -> 13;
                    case 197 -> 132;
                    case 198 -> 19;
                    case 199 -> 160;
                    case 200 -> 76;
                    case 201 -> 250;
                    case 202 -> 93;
                    case 203 -> 128;
                    case 204 -> 200;
                    case 205 -> 112;
                    case 206 -> 11;
                    case 207 -> 134;
                    case 208 -> 187;
                    case 209 -> 94;
                    case 210 -> 49;
                    case 211 -> 14;
                    case 212 -> 179;
                    case 213 -> 85;
                    case 214 -> 230;
                    case 215 -> 60;
                    case 216 -> 135;
                    case 217 -> 110;
                    case 218 -> 208;
                    case 219 -> 111;
                    case 220 -> 165;
                    case 221 -> 159;
                    case 222 -> 245;
                    case 223 -> 77;
                    case 224 -> 3;
                    case 225 -> 139;
                    case 226 -> 102;
                    case 227 -> 218;
                    case 228 -> 237;
                    case 229 -> 221;
                    case 230 -> 44;
                    case 231 -> 87;
                    case 232 -> 145;
                    case 233 -> 66;
                    case 234 -> 177;
                    case 235 -> 33;
                    case 236 -> 203;
                    case 237 -> 151;
                    case 238 -> 247;
                    case 239 -> 83;
                    case 240 -> 169;
                    case 241 -> 69;
                    case 242 -> 48;
                    case 243 -> 189;
                    case 244 -> 172;
                    case 245 -> 229;
                    case 246 -> 125;
                    case 247 -> 98;
                    case 248 -> 123;
                    case 249 -> 119;
                    case 250 -> 104;
                    case 251 -> 255;
                    case 252 -> 116;
                    case 253 -> 92;
                    case 254 -> 201;
                    default -> 74;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

