/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Arrays;

public final class KeyPressInfo {
    private static final int[] NO_MODIFIERS = new int[0];
    private final int keyCode;
    private int[] modifiers;

    @Nonnull
    public static KeyPressInfo keyCode(int keyCode) {
        return new KeyPressInfo(keyCode, NO_MODIFIERS);
    }

    private KeyPressInfo(int keyCode, @Nonnull int[] modifiers) {
        this.keyCode = keyCode;
        this.modifiers = modifiers;
    }

    public int keyCode() {
        return this.keyCode;
    }

    @Nonnull
    public int[] modifiers() {
        return Arrays.copyOf(this.modifiers);
    }

    @Nonnull
    public KeyPressInfo modifiers(int ... newModifiers) {
        this.modifiers = Arrays.copyOf(newModifiers);
        return this;
    }
}

