/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ssh.X11DisplayNameGetter;
import com.intellij.ssh.X11ForwardingKt;
import java.io.File;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\r\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ssh/X11Forwarding;", "", "trusted", "", "xAuthLocation", "", "displayName", "<init>", "(ZLjava/lang/String;Ljava/lang/String;)V", "getTrusted", "()Z", "getXAuthLocation", "()Ljava/lang/String;", "getDisplayName", "screen", "", "getScreen", "()I", "makeMitMagicCookie", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nX11Forwarding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 X11Forwarding.kt\ncom/intellij/ssh/X11Forwarding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class X11Forwarding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean trusted;
    @NotNull
    private final String xAuthLocation;
    @NotNull
    private final String displayName;
    @NotNull
    public static final String MIT_MAGIC_COOKIE = "MIT-MAGIC-COOKIE-1";

    public X11Forwarding(boolean trusted, @NotNull String xAuthLocation, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)xAuthLocation, (String)"xAuthLocation");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        this.trusted = trusted;
        this.xAuthLocation = xAuthLocation;
        this.displayName = displayName;
    }

    public /* synthetic */ X11Forwarding(boolean bl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = Companion.getDefaultXAuthLocation();
        }
        if ((n & 4) != 0) {
            string2 = X11DisplayNameGetter.Companion.getInstance().getDisplay();
        }
        this(bl, string, string2);
    }

    public final boolean getTrusted() {
        return this.trusted;
    }

    @NotNull
    public final String getXAuthLocation() {
        return this.xAuthLocation;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getScreen() {
        String string;
        String it = string = this.displayName;
        boolean bl = false;
        if (((CharSequence)it).length() <= 0) return 0;
        boolean bl2 = true;
        if (!bl2) return 0;
        String string2 = string;
        String string3 = string2;
        if (string3 == null) return 0;
        Object object = string3;
        Regex regex = new Regex("^.*:[0-9]*[.]([0-9]+)$");
        CharSequence p0 = (CharSequence)object;
        boolean bl3 = false;
        string = Regex.find$default((Regex)regex, (CharSequence)p0, (int)0, (int)2, null);
        if (string == null) return 0;
        object = string.getGroupValues();
        if (object == null) return 0;
        String string4 = (String)CollectionsKt.getOrNull((List)object, (int)1);
        if (string4 == null) return 0;
        int n = Integer.parseInt(string4);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String makeMitMagicCookie() {
        if (((CharSequence)this.xAuthLocation).length() > 0) {
            Sequence it;
            String[] commandLine;
            String[] stringArray;
            File file;
            String fileName = "xauthfile";
            if (this.trusted) {
                file = null;
            } else {
                File file2 = FileUtil.createTempDirectory((String)"ssh-idea-", null, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(...)");
                File dir = file2;
                stringArray = new String[]{this.xAuthLocation, "-f", FilesKt.resolve((File)dir, (String)fileName).getAbsolutePath(), "generate", this.displayName, MIT_MAGIC_COOKIE, "untrusted"};
                commandLine = new GeneralCommandLine(stringArray);
                commandLine.withRedirectErrorStream(true);
                it = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)2000);
                boolean bl = false;
                if (it.getExitCode() == 0) {
                    file = dir;
                } else {
                    X11ForwardingKt.access$getLOG$p().warn("Command " + commandLine.getCommandLineString() + " exited with code " + it.getExitCode() + ", output: " + it.getStdout());
                    FileUtil.delete((File)dir);
                    file = null;
                }
            }
            File xAuthDir = file;
            try {
                String cookie;
                List list;
                Sequence sequence;
                char[] cArray;
                commandLine = new String[]{this.xAuthLocation};
                GeneralCommandLine commandLine2 = new GeneralCommandLine(commandLine);
                if (xAuthDir != null) {
                    commandLine = new String[]{"-f", FilesKt.resolve(xAuthDir, (String)fileName).getAbsolutePath()};
                    commandLine2.addParameters(commandLine);
                }
                commandLine = new String[]{"list", this.displayName};
                commandLine2.addParameters(commandLine);
                stringArray = ExecUtil.execAndReadLine((GeneralCommandLine)commandLine2);
                String string = stringArray != null && (it = StringsKt.splitToSequence$default((CharSequence)((CharSequence)stringArray), (char[])(cArray = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) != null && (sequence = SequencesKt.filter((Sequence)it, X11Forwarding::makeMitMagicCookie$lambda$2)) != null && (list = SequencesKt.toList((Sequence)sequence)) != null ? (String)CollectionsKt.getOrNull((List)list, (int)2) : (cookie = null);
                if (cookie != null) {
                    stringArray = cookie;
                    return stringArray;
                }
            }
            finally {
                File file3 = xAuthDir;
                if (file3 != null) {
                    File file4 = file3;
                    boolean bl = false;
                    FileUtil.delete(file4);
                }
            }
        }
        if (this.trusted) {
            X11ForwardingKt.access$getLOG$p().info("Generating random X11 cookie without `xauth`");
            long it = ThreadLocalRandom.current().nextLong();
            boolean bl = false;
            long l = it & 0x7FFFFFFFFFFFFFFEL;
            int n = 16;
            String string = Long.toString(l, CharsKt.checkRadix((int)n));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return null;
    }

    public final boolean component1() {
        return this.trusted;
    }

    @NotNull
    public final String component2() {
        return this.xAuthLocation;
    }

    @NotNull
    public final String component3() {
        return this.displayName;
    }

    @NotNull
    public final X11Forwarding copy(boolean trusted, @NotNull String xAuthLocation, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)xAuthLocation, (String)"xAuthLocation");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return new X11Forwarding(trusted, xAuthLocation, displayName);
    }

    public static /* synthetic */ X11Forwarding copy$default(X11Forwarding x11Forwarding, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = x11Forwarding.trusted;
        }
        if ((n & 2) != 0) {
            string = x11Forwarding.xAuthLocation;
        }
        if ((n & 4) != 0) {
            string2 = x11Forwarding.displayName;
        }
        return x11Forwarding.copy(bl, string, string2);
    }

    @NotNull
    public String toString() {
        return "X11Forwarding(trusted=" + this.trusted + ", xAuthLocation=" + this.xAuthLocation + ", displayName=" + this.displayName + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.trusted);
        result = result * 31 + this.xAuthLocation.hashCode();
        result = result * 31 + this.displayName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X11Forwarding)) {
            return false;
        }
        X11Forwarding x11Forwarding = (X11Forwarding)other;
        if (this.trusted != x11Forwarding.trusted) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.xAuthLocation, (Object)x11Forwarding.xAuthLocation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.displayName, (Object)x11Forwarding.displayName);
    }

    private static final boolean makeMitMagicCookie$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    @NotNull
    public static final String getDefaultXAuthLocation() {
        return Companion.getDefaultXAuthLocation();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ssh/X11Forwarding$Companion;", "", "<init>", "()V", "MIT_MAGIC_COOKIE", "", "defaultXAuthLocation", "getDefaultXAuthLocation$annotations", "getDefaultXAuthLocation", "()Ljava/lang/String;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultXAuthLocation() {
            Object object;
            if (SystemInfo.isWindows) {
                object = "";
            } else if (SystemInfo.isMac) {
                object = "xauth";
            } else {
                object = PathEnvironmentVariableUtil.findInPath((String)"xauth");
                if (object == null || (object = ((File)object).getAbsolutePath()) == null) {
                    object = "";
                }
            }
            return object;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultXAuthLocation$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

