/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 92239156772883L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(439084500 + (char)-9953, 439084500 + (char)-1291, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(439084500 + (char)-9954, -439084500 + -((char)-5218), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 96673693217200L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.x();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1725667620 - -10358, 1725667620 - 22441, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1725667620 - -10359, -1725667620 - -((char)-32409), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1725667620 - -10360, -1725667620 - -((char)-28022), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 98397136690723L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.x();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-218), -564125280 - -((char)-6041), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-219), -564125280 - -((char)-7684), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-220), 564125280 - (char)-214, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-213), 563994210 + (char)-3890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-214), -563994210 + -((char)-23459), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-215), 564125280 - (char)-6646, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-213), 563994210 + (char)-3890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-564125280 - -((char)-216), 564125280 - (char)-5556, (int)l2));
            if (ActionTimestamp.x() != null) {
                SshAgentIpcService.x(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 140359706461251L;
                    nArray = SshAgentIpcService.x();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 68590259173183L;
                int[] nArray2 = SshAgentIpcService.x();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            nArray = nArray2;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-368568840 - -13275, 368568840 + 148, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13274, 368568840 - 24923, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13273, -368568840 - -18342, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-368568840 - -13275, 368568840 + 148, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13272, 368568840 - 17497, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-368568840 - -13275, 368568840 + 148, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13271, 368568840 + 616, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13270, -368568840 - -21310, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13273, -368568840 - -18342, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-368568840 - -13275, 368568840 + 148, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-368568840 - -13279, 368568840 - 17372, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-368568840 - -13269, -368568840 + -3549, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 17181675645475L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1806406740 + (char)-19371, 1806406740 + (char)-31941, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 64646897802445L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-949864290 + -((char)-1448), 949995360 - (char)-1204, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00b3\u0082\u00dd\u00f0\u0004\u009d\u00da\u009f\u00b3\u0002\u001d\u0097m\u00da\u00ee\u00d5\u00a1_\u00be\u0014\u0016\u0003i\u00c6\u0089\u0099\u0016\u009a\u00a8\u00a4\u00bb\u0097{#\u00eda,\u000f\b\u00b0";
                        var4_3 = "\u00b3\u0082\u00dd\u00f0\u0004\u009d\u00da\u009f\u00b3\u0002\u001d\u0097m\u00da\u00ee\u00d5\u00a1_\u00be\u0014\u0016\u0003i\u00c6\u0089\u0099\u0016\u009a\u00a8\u00a4\u00bb\u0097{#\u00eda,\u000f\b\u00b0".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 21;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 117;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 102;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 39;
                                        break;
                                    }
                                    default: {
                                        v11 = 93;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x228A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 133;
                            case 1 -> 145;
                            case 2 -> 172;
                            case 3 -> 245;
                            case 4 -> 171;
                            case 5 -> 107;
                            case 6 -> 147;
                            case 7 -> 34;
                            case 8 -> 159;
                            case 9 -> 125;
                            case 10 -> 253;
                            case 11 -> 54;
                            case 12 -> 161;
                            case 13 -> 19;
                            case 14 -> 226;
                            case 15 -> 83;
                            case 16 -> 238;
                            case 17 -> 224;
                            case 18 -> 126;
                            case 19 -> 134;
                            case 20 -> 168;
                            case 21 -> 209;
                            case 22 -> 124;
                            case 23 -> 78;
                            case 24 -> 55;
                            case 25 -> 231;
                            case 26 -> 179;
                            case 27 -> 114;
                            case 28 -> 25;
                            case 29 -> 81;
                            case 30 -> 18;
                            case 31 -> 215;
                            case 32 -> 208;
                            case 33 -> 176;
                            case 34 -> 228;
                            case 35 -> 250;
                            case 36 -> 189;
                            case 37 -> 91;
                            case 38 -> 232;
                            case 39 -> 71;
                            case 40 -> 199;
                            case 41 -> 163;
                            case 42 -> 97;
                            case 43 -> 60;
                            case 44 -> 178;
                            case 45 -> 235;
                            case 46 -> 175;
                            case 47 -> 151;
                            case 48 -> 222;
                            case 49 -> 198;
                            case 50 -> 165;
                            case 51 -> 13;
                            case 52 -> 246;
                            case 53 -> 69;
                            case 54 -> 129;
                            case 55 -> 192;
                            case 56 -> 207;
                            case 57 -> 40;
                            case 58 -> 196;
                            case 59 -> 157;
                            case 60 -> 37;
                            case 61 -> 174;
                            case 62 -> 240;
                            case 63 -> 36;
                            case 64 -> 86;
                            case 65 -> 243;
                            case 66 -> 184;
                            case 67 -> 11;
                            case 68 -> 15;
                            case 69 -> 85;
                            case 70 -> 8;
                            case 71 -> 237;
                            case 72 -> 212;
                            case 73 -> 202;
                            case 74 -> 166;
                            case 75 -> 142;
                            case 76 -> 182;
                            case 77 -> 105;
                            case 78 -> 218;
                            case 79 -> 146;
                            case 80 -> 111;
                            case 81 -> 188;
                            case 82 -> 149;
                            case 83 -> 24;
                            case 84 -> 154;
                            case 85 -> 3;
                            case 86 -> 95;
                            case 87 -> 14;
                            case 88 -> 7;
                            case 89 -> 63;
                            case 90 -> 23;
                            case 91 -> 225;
                            case 92 -> 130;
                            case 93 -> 26;
                            case 94 -> 248;
                            case 95 -> 101;
                            case 96 -> 62;
                            case 97 -> 153;
                            case 98 -> 251;
                            case 99 -> 68;
                            case 100 -> 93;
                            case 101 -> 190;
                            case 102 -> 131;
                            case 103 -> 90;
                            case 104 -> 96;
                            case 105 -> 113;
                            case 106 -> 0;
                            case 107 -> 52;
                            case 108 -> 219;
                            case 109 -> 167;
                            case 110 -> 42;
                            case 111 -> 106;
                            case 112 -> 229;
                            case 113 -> 185;
                            case 114 -> 143;
                            case 115 -> 72;
                            case 116 -> 28;
                            case 117 -> 92;
                            case 118 -> 193;
                            case 119 -> 29;
                            case 120 -> 53;
                            case 121 -> 31;
                            case 122 -> 122;
                            case 123 -> 177;
                            case 124 -> 138;
                            case 125 -> 45;
                            case 126 -> 6;
                            case 127 -> 46;
                            case 128 -> 194;
                            case 129 -> 135;
                            case 130 -> 223;
                            case 131 -> 82;
                            case 132 -> 43;
                            case 133 -> 65;
                            case 134 -> 252;
                            case 135 -> 61;
                            case 136 -> 197;
                            case 137 -> 9;
                            case 138 -> 120;
                            case 139 -> 12;
                            case 140 -> 221;
                            case 141 -> 22;
                            case 142 -> 254;
                            case 143 -> 247;
                            case 144 -> 150;
                            case 145 -> 121;
                            case 146 -> 144;
                            case 147 -> 211;
                            case 148 -> 98;
                            case 149 -> 156;
                            case 150 -> 205;
                            case 151 -> 139;
                            case 152 -> 30;
                            case 153 -> 80;
                            case 154 -> 204;
                            case 155 -> 195;
                            case 156 -> 230;
                            case 157 -> 66;
                            case 158 -> 20;
                            case 159 -> 48;
                            case 160 -> 104;
                            case 161 -> 170;
                            case 162 -> 75;
                            case 163 -> 148;
                            case 164 -> 127;
                            case 165 -> 140;
                            case 166 -> 152;
                            case 167 -> 110;
                            case 168 -> 186;
                            case 169 -> 169;
                            case 170 -> 203;
                            case 171 -> 58;
                            case 172 -> 44;
                            case 173 -> 160;
                            case 174 -> 206;
                            case 175 -> 181;
                            case 176 -> 21;
                            case 177 -> 220;
                            case 178 -> 17;
                            case 179 -> 200;
                            case 180 -> 79;
                            case 181 -> 77;
                            case 182 -> 123;
                            case 183 -> 214;
                            case 184 -> 158;
                            case 185 -> 216;
                            case 186 -> 118;
                            case 187 -> 50;
                            case 188 -> 242;
                            case 189 -> 136;
                            case 190 -> 108;
                            case 191 -> 70;
                            case 192 -> 233;
                            case 193 -> 132;
                            case 194 -> 201;
                            case 195 -> 89;
                            case 196 -> 155;
                            case 197 -> 109;
                            case 198 -> 102;
                            case 199 -> 10;
                            case 200 -> 27;
                            case 201 -> 32;
                            case 202 -> 84;
                            case 203 -> 5;
                            case 204 -> 87;
                            case 205 -> 99;
                            case 206 -> 64;
                            case 207 -> 213;
                            case 208 -> 183;
                            case 209 -> 115;
                            case 210 -> 234;
                            case 211 -> 239;
                            case 212 -> 141;
                            case 213 -> 241;
                            case 214 -> 38;
                            case 215 -> 236;
                            case 216 -> 112;
                            case 217 -> 244;
                            case 218 -> 94;
                            case 219 -> 67;
                            case 220 -> 56;
                            case 221 -> 33;
                            case 222 -> 103;
                            case 223 -> 74;
                            case 224 -> 187;
                            case 225 -> 173;
                            case 226 -> 51;
                            case 227 -> 88;
                            case 228 -> 2;
                            case 229 -> 227;
                            case 230 -> 57;
                            case 231 -> 100;
                            case 232 -> 164;
                            case 233 -> 4;
                            case 234 -> 137;
                            case 235 -> 47;
                            case 236 -> 1;
                            case 237 -> 217;
                            case 238 -> 59;
                            case 239 -> 255;
                            case 240 -> 210;
                            case 241 -> 162;
                            case 242 -> 39;
                            case 243 -> 128;
                            case 244 -> 41;
                            case 245 -> 16;
                            case 246 -> 76;
                            case 247 -> 73;
                            case 248 -> 35;
                            case 249 -> 249;
                            case 250 -> 49;
                            case 251 -> 180;
                            case 252 -> 119;
                            case 253 -> 116;
                            case 254 -> 191;
                            default -> 117;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray != null) {
                ActionTimestamp.x(new String[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 131740477128209L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.x();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(945276840 - (char)-31061, -945276840 - -((char)-21670), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(945276840 - (char)-31057, -945276840 - -30378, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(945276840 - (char)-31034, 945276840 - 18482, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(945276840 - (char)-31061, -945276840 - -((char)-21670), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(945276840 - (char)-31057, -945276840 - -30378, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(945276840 - (char)-31037, 945276840 - (char)-31594, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 25778082000131L;
                        int[] nArray2 = SshAgentIpcService.x();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-311684460 + -32414, -311684460 + -30646, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-311684460 + -32415, -311684460 + -32106, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 97101566087764L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = SshAgentIpcService.x();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(945407910 + (char)-6894, -945538980 - -((char)-10341), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(945407910 + (char)-6890, -945407910 + -((char)-2797), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(945407910 + (char)-6915, -945407910 + -((char)-819), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(945407910 + (char)-6890, -945407910 + -((char)-2797), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(945407910 + (char)-6892, 945407910 + (char)-3761, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(945407910 + (char)-6894, -945538980 - -((char)-10341), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(945407910 + (char)-6890, -945407910 + -((char)-2797), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(945407910 + (char)-6906, -945538980 - -((char)-3962), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(945407910 + (char)-6894, -945538980 - -((char)-10341), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(945407910 + (char)-6890, -945407910 + -((char)-2797), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(945407910 + (char)-6905, 945407910 + (char)-15880, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(945407910 + (char)-6894, -945538980 - -((char)-10341), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(945407910 + (char)-6890, -945407910 + -((char)-2797), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(945407910 + (char)-6904, -945407910 + -((char)-7482), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 100857038907866L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.x();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1678089210 + -19664, 1678089210 + 6271, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1678089210 + -19668, 1678089210 + 23759, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1678089210 + -19685, -1678089210 + -23715, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1678089210 + -19680, 1678089210 + 14398, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1678089210 + -19664, 1678089210 + 6271, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1678089210 + -19668, 1678089210 + 23759, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1678089210 + -19679, -1678089210 - -4816, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1678089210 + -19664, 1678089210 + 6271, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1678089210 + -19668, 1678089210 + 23759, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1678089210 + -19682, 1678089210 + 17168, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1678089210 + -19664, 1678089210 + 6271, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1678089210 + -19668, 1678089210 + 23759, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1678089210 + -19681, 1678089210 + 16601, (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1678089210 + -19664, 1678089210 + 6271, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1678089210 + -19668, 1678089210 + 23759, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1678089210 + -19692, 1678089210 - 6226, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1678089210 + -19691, -1678089210 - -1354, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00da6a\u00f9\u00b4\u00b8i\u0080\u0014\u00a9*7\u009d\u0080\u00bc@\u001a\u00af\u0082\u00e4\u00cbx!'\u00bc%Y.\u0084\u0006\u0019\u0096\u0019\u00ed\u00d1{\u0018\u0003\u0081\u0002\u00d8\u00a4\u00d1\u00c6w\u00b7R\u00e8\u00a1\u009f\u0093\u0089hY\u00aa\u008fg\u009d4\u000eF\tI\u00b8\u00d5N5\u009c\u00ec\u0096\u00ce\u0005\u009e\u00e4\u00e9\u00a3\u00d5\b]\u0092\u0091\u001c\u00f8\"\u00e61\u0014c\u00fd\u0016\u00fc\u00c9\u0098\\\tB=\u00f2\u0088\u00f0\u00ea\u008d(b\u0018?\u00ee\u0005\u00aa~o\u00f0\u0005\u001ef\u0000\u00e3[\te\u00d1\u009b\u00f0\u00dbK\u0017\u00a7e,\u00d2\fl\u00f7K>\u009ev\u00de\u0088\u00e5\u00a1>\u00c8[\u0010D\u00a4C\nJ}Oa^6\u0013W\u00aa8\"\u00e6\t'\u00f1\u00cev\u0005\u00bc\u00cc\r$\u0010\u00f2\u0085\u0095.\u0090\u00f9\u0014\u00f15$~\u0015\u0007p\u0097\u00ef?\u00e9}\u001a\u00f4;\u0099\u0012h\u00f9t/\u0019\u0094Rw\r\u00a2\u00f2_]\u00a5\u000e~\u00aa\u0099\u0083\u008eF\u001a\u0002\u00f0\b\nq\u00d8\u00fc\u00aa@8\u009d\u00a7\u00c9\u008c_\u00c4\u00d6\u00e2\"/m\u0081\u00b7D?\u001af+w\u0001\u008c\u0018\u0096\u0015\b\u0004\u00e6\u00ba\u0092\u009d\u00f3J\u000b\f\u00e8C7=1d1\u00fe\u00b8\u008d\u009d$F\u009fB\u00d9\u001d\u00ec`\u008a~\u00cf\u0091yc\u00c8\u0015\u00e3\u00c3\u00ccL\u0092%\u000eS\b3a\u009bbN8*\u008e1\u00f9\u00e0d\u00ef\u00e7o:\u00bct\u00f8}\u0082$\u00e8\u00aa\u0098\u00c1\u00c2:\u00e8\u00dcB\u001f\u00d2\u0014\u0095pl\u0005\u00e3\u00ea$V\u0014M\u00b5\u00acF\u001f%Q\u008bq\u0004 p3\u00c4\u00ce\u00cd\u00b5w,=JU\u0097\u00a1\u00fe?\u00a8\u0081\u00b3\u0017\u0098E]I\u00c6\u00a2\u000b\u00da\u001eq\u0096\u00f9\u0011(P\u009bT\u00f3\u0015|\u00bf\u00a5\u00a1d\u009fw\u00fcN!\u0081\u0083@F\u00c6Q\u00d1`\u00ecy\u00a0)F\u00e9\u00e7f\u0089\u00c2\u00c1o\u00f2E\u000b\u00c4\u00ab\b8\u00cb\u00aa/\u0085NK\u00c6\u00c9fqk^[\u0005\u00f2\u00a9\u0014\u00e3\u00e1AB]\u00c7\u00e6\u0000L\u0007\u009cK\u00b6(\u0087V\u009b\u0007\u0089\u00ebpP\u00b8\u00b6j(\u009bq\u0010T\u00c7\u00ee\u00fe\u00cde\u00c6\u00d3\u0082\u0093A}a\u0005\u00d7\u00de\u0012As\u00e7\u001b$xBB\u00b1\u00b1\u00e4e\u00b1\u00a4\u0095G}\u001aqH\u000f\u008f\u00fa\u00dc\f\u00b6\u0089u\u00e2a\u00ae\u00f2\u00de\u0017\u009es\"\u000b3N=\u00bc\u00a9g\u0002&\u00e8\u0091q\u00fb\u00b2VR\u008c5\u00cbOh\u00e6\r2z\u00b5\u00f2^\u00b4`=A_\u00b8\u000e\u0095\u00f3\u009f-\u00de\u00adxf\u00c0>\u00c6\u00cc\u009d\u00d6\u001b_\u00bb\u00c1!\u00ee\u0099\u00eb\u00bc\u00e5\u00e2\u00efV\u00e8\u00b3\u0012d\u00acYr^d\u00f0\u00ffVoT\u0005\n)q\u00cb\u007f\u00bb\u00b6\u0092say\u0018\u0085\u00bf\u009a\u00ac\u0084\u0094\u0087Cv\u00d4_\u000fG\u00cb\u001bJ\u00fa\u009do\u00bf\u00bf\u0087\u00df\u00eb)\t\u0006\u000e\u009b\u00b4}f\u0098\u0006\u00bb\u0095\u001b|\u00fa]\u00eex\u00fe\u0000\u00b1\u00c1)\u00d1\u0097\u0007\u00c7\r\"<\u00815\u00ebU\u00c0B\u00f2\u00e3\u00f51F\u00b6\t\u0006[\u00ea=\u008b\u001aK\u0082i";
                var4_3 = "\u00da6a\u00f9\u00b4\u00b8i\u0080\u0014\u00a9*7\u009d\u0080\u00bc@\u001a\u00af\u0082\u00e4\u00cbx!'\u00bc%Y.\u0084\u0006\u0019\u0096\u0019\u00ed\u00d1{\u0018\u0003\u0081\u0002\u00d8\u00a4\u00d1\u00c6w\u00b7R\u00e8\u00a1\u009f\u0093\u0089hY\u00aa\u008fg\u009d4\u000eF\tI\u00b8\u00d5N5\u009c\u00ec\u0096\u00ce\u0005\u009e\u00e4\u00e9\u00a3\u00d5\b]\u0092\u0091\u001c\u00f8\"\u00e61\u0014c\u00fd\u0016\u00fc\u00c9\u0098\\\tB=\u00f2\u0088\u00f0\u00ea\u008d(b\u0018?\u00ee\u0005\u00aa~o\u00f0\u0005\u001ef\u0000\u00e3[\te\u00d1\u009b\u00f0\u00dbK\u0017\u00a7e,\u00d2\fl\u00f7K>\u009ev\u00de\u0088\u00e5\u00a1>\u00c8[\u0010D\u00a4C\nJ}Oa^6\u0013W\u00aa8\"\u00e6\t'\u00f1\u00cev\u0005\u00bc\u00cc\r$\u0010\u00f2\u0085\u0095.\u0090\u00f9\u0014\u00f15$~\u0015\u0007p\u0097\u00ef?\u00e9}\u001a\u00f4;\u0099\u0012h\u00f9t/\u0019\u0094Rw\r\u00a2\u00f2_]\u00a5\u000e~\u00aa\u0099\u0083\u008eF\u001a\u0002\u00f0\b\nq\u00d8\u00fc\u00aa@8\u009d\u00a7\u00c9\u008c_\u00c4\u00d6\u00e2\"/m\u0081\u00b7D?\u001af+w\u0001\u008c\u0018\u0096\u0015\b\u0004\u00e6\u00ba\u0092\u009d\u00f3J\u000b\f\u00e8C7=1d1\u00fe\u00b8\u008d\u009d$F\u009fB\u00d9\u001d\u00ec`\u008a~\u00cf\u0091yc\u00c8\u0015\u00e3\u00c3\u00ccL\u0092%\u000eS\b3a\u009bbN8*\u008e1\u00f9\u00e0d\u00ef\u00e7o:\u00bct\u00f8}\u0082$\u00e8\u00aa\u0098\u00c1\u00c2:\u00e8\u00dcB\u001f\u00d2\u0014\u0095pl\u0005\u00e3\u00ea$V\u0014M\u00b5\u00acF\u001f%Q\u008bq\u0004 p3\u00c4\u00ce\u00cd\u00b5w,=JU\u0097\u00a1\u00fe?\u00a8\u0081\u00b3\u0017\u0098E]I\u00c6\u00a2\u000b\u00da\u001eq\u0096\u00f9\u0011(P\u009bT\u00f3\u0015|\u00bf\u00a5\u00a1d\u009fw\u00fcN!\u0081\u0083@F\u00c6Q\u00d1`\u00ecy\u00a0)F\u00e9\u00e7f\u0089\u00c2\u00c1o\u00f2E\u000b\u00c4\u00ab\b8\u00cb\u00aa/\u0085NK\u00c6\u00c9fqk^[\u0005\u00f2\u00a9\u0014\u00e3\u00e1AB]\u00c7\u00e6\u0000L\u0007\u009cK\u00b6(\u0087V\u009b\u0007\u0089\u00ebpP\u00b8\u00b6j(\u009bq\u0010T\u00c7\u00ee\u00fe\u00cde\u00c6\u00d3\u0082\u0093A}a\u0005\u00d7\u00de\u0012As\u00e7\u001b$xBB\u00b1\u00b1\u00e4e\u00b1\u00a4\u0095G}\u001aqH\u000f\u008f\u00fa\u00dc\f\u00b6\u0089u\u00e2a\u00ae\u00f2\u00de\u0017\u009es\"\u000b3N=\u00bc\u00a9g\u0002&\u00e8\u0091q\u00fb\u00b2VR\u008c5\u00cbOh\u00e6\r2z\u00b5\u00f2^\u00b4`=A_\u00b8\u000e\u0095\u00f3\u009f-\u00de\u00adxf\u00c0>\u00c6\u00cc\u009d\u00d6\u001b_\u00bb\u00c1!\u00ee\u0099\u00eb\u00bc\u00e5\u00e2\u00efV\u00e8\u00b3\u0012d\u00acYr^d\u00f0\u00ffVoT\u0005\n)q\u00cb\u007f\u00bb\u00b6\u0092say\u0018\u0085\u00bf\u009a\u00ac\u0084\u0094\u0087Cv\u00d4_\u000fG\u00cb\u001bJ\u00fa\u009do\u00bf\u00bf\u0087\u00df\u00eb)\t\u0006\u000e\u009b\u00b4}f\u0098\u0006\u00bb\u0095\u001b|\u00fa]\u00eex\u00fe\u0000\u00b1\u00c1)\u00d1\u0097\u0007\u00c7\r\"<\u00815\u00ebU\u00c0B\u00f2\u00e3\u00f51F\u00b6\t\u0006[\u00ea=\u008b\u001aK\u0082i".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 31;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "Bc\u0083\u00d3\u00e1\u0090(\u00c1+t\u00d4\u0006\u00b0\u00bd \u00e23\u0097\u00dd\u00fc\u00cb[\u0087\u00e3\u0082\u00b1\u00c8M\u00f0\u0014\u0003\u00b9\u0086\u000bR\u008a\u00fe8\u009c\"f;\u00cc\u00dbU\u0007\u008f\u00ca\u009f\u0012";
                    var4_3 = "Bc\u0083\u00d3\u00e1\u0090(\u00c1+t\u00d4\u0006\u00b0\u00bd \u00e23\u0097\u00dd\u00fc\u00cb[\u0087\u00e3\u0082\u00b1\u00c8M\u00f0\u0014\u0003\u00b9\u0086\u000bR\u008a\u00fe8\u009c\"f;\u00cc\u00dbU\u0007\u008f\u00ca\u009f\u0012".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 82;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 4;
                            break;
                        }
                        case 1: {
                            v15 = 119;
                            break;
                        }
                        case 2: {
                            v15 = 72;
                            break;
                        }
                        case 3: {
                            v15 = 12;
                            break;
                        }
                        case 4: {
                            v15 = 67;
                            break;
                        }
                        case 5: {
                            v15 = 82;
                            break;
                        }
                        default: {
                            v15 = 69;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3EE0) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 150;
                case 1 -> 42;
                case 2 -> 89;
                case 3 -> 74;
                case 4 -> 98;
                case 5 -> 55;
                case 6 -> 22;
                case 7 -> 87;
                case 8 -> 229;
                case 9 -> 152;
                case 10 -> 69;
                case 11 -> 40;
                case 12 -> 155;
                case 13 -> 90;
                case 14 -> 4;
                case 15 -> 241;
                case 16 -> 160;
                case 17 -> 76;
                case 18 -> 168;
                case 19 -> 60;
                case 20 -> 68;
                case 21 -> 7;
                case 22 -> 232;
                case 23 -> 183;
                case 24 -> 187;
                case 25 -> 83;
                case 26 -> 108;
                case 27 -> 154;
                case 28 -> 221;
                case 29 -> 226;
                case 30 -> 77;
                case 31 -> 124;
                case 32 -> 136;
                case 33 -> 81;
                case 34 -> 250;
                case 35 -> 25;
                case 36 -> 166;
                case 37 -> 38;
                case 38 -> 102;
                case 39 -> 246;
                case 40 -> 192;
                case 41 -> 227;
                case 42 -> 167;
                case 43 -> 117;
                case 44 -> 233;
                case 45 -> 15;
                case 46 -> 20;
                case 47 -> 44;
                case 48 -> 86;
                case 49 -> 148;
                case 50 -> 196;
                case 51 -> 97;
                case 52 -> 146;
                case 53 -> 99;
                case 54 -> 101;
                case 55 -> 184;
                case 56 -> 71;
                case 57 -> 34;
                case 58 -> 134;
                case 59 -> 73;
                case 60 -> 49;
                case 61 -> 115;
                case 62 -> 5;
                case 63 -> 251;
                case 64 -> 78;
                case 65 -> 123;
                case 66 -> 48;
                case 67 -> 127;
                case 68 -> 59;
                case 69 -> 46;
                case 70 -> 67;
                case 71 -> 225;
                case 72 -> 92;
                case 73 -> 153;
                case 74 -> 178;
                case 75 -> 140;
                case 76 -> 118;
                case 77 -> 106;
                case 78 -> 112;
                case 79 -> 171;
                case 80 -> 135;
                case 81 -> 234;
                case 82 -> 88;
                case 83 -> 35;
                case 84 -> 254;
                case 85 -> 110;
                case 86 -> 211;
                case 87 -> 224;
                case 88 -> 223;
                case 89 -> 161;
                case 90 -> 141;
                case 91 -> 247;
                case 92 -> 195;
                case 93 -> 156;
                case 94 -> 243;
                case 95 -> 61;
                case 96 -> 70;
                case 97 -> 119;
                case 98 -> 143;
                case 99 -> 253;
                case 100 -> 217;
                case 101 -> 29;
                case 102 -> 216;
                case 103 -> 10;
                case 104 -> 17;
                case 105 -> 249;
                case 106 -> 28;
                case 107 -> 248;
                case 108 -> 37;
                case 109 -> 32;
                case 110 -> 0;
                case 111 -> 139;
                case 112 -> 114;
                case 113 -> 239;
                case 114 -> 33;
                case 115 -> 149;
                case 116 -> 151;
                case 117 -> 194;
                case 118 -> 214;
                case 119 -> 111;
                case 120 -> 218;
                case 121 -> 64;
                case 122 -> 107;
                case 123 -> 228;
                case 124 -> 220;
                case 125 -> 27;
                case 126 -> 96;
                case 127 -> 122;
                case 128 -> 57;
                case 129 -> 65;
                case 130 -> 198;
                case 131 -> 164;
                case 132 -> 145;
                case 133 -> 47;
                case 134 -> 113;
                case 135 -> 230;
                case 136 -> 180;
                case 137 -> 131;
                case 138 -> 132;
                case 139 -> 58;
                case 140 -> 66;
                case 141 -> 208;
                case 142 -> 12;
                case 143 -> 190;
                case 144 -> 193;
                case 145 -> 11;
                case 146 -> 72;
                case 147 -> 170;
                case 148 -> 8;
                case 149 -> 207;
                case 150 -> 159;
                case 151 -> 188;
                case 152 -> 120;
                case 153 -> 213;
                case 154 -> 43;
                case 155 -> 91;
                case 156 -> 177;
                case 157 -> 245;
                case 158 -> 104;
                case 159 -> 181;
                case 160 -> 13;
                case 161 -> 109;
                case 162 -> 6;
                case 163 -> 16;
                case 164 -> 36;
                case 165 -> 200;
                case 166 -> 242;
                case 167 -> 138;
                case 168 -> 169;
                case 169 -> 9;
                case 170 -> 197;
                case 171 -> 179;
                case 172 -> 172;
                case 173 -> 23;
                case 174 -> 30;
                case 175 -> 128;
                case 176 -> 163;
                case 177 -> 82;
                case 178 -> 162;
                case 179 -> 18;
                case 180 -> 53;
                case 181 -> 100;
                case 182 -> 236;
                case 183 -> 121;
                case 184 -> 191;
                case 185 -> 95;
                case 186 -> 93;
                case 187 -> 205;
                case 188 -> 62;
                case 189 -> 31;
                case 190 -> 80;
                case 191 -> 1;
                case 192 -> 45;
                case 193 -> 41;
                case 194 -> 84;
                case 195 -> 252;
                case 196 -> 126;
                case 197 -> 203;
                case 198 -> 125;
                case 199 -> 209;
                case 200 -> 116;
                case 201 -> 26;
                case 202 -> 204;
                case 203 -> 51;
                case 204 -> 185;
                case 205 -> 24;
                case 206 -> 133;
                case 207 -> 182;
                case 208 -> 210;
                case 209 -> 219;
                case 210 -> 176;
                case 211 -> 129;
                case 212 -> 174;
                case 213 -> 39;
                case 214 -> 186;
                case 215 -> 173;
                case 216 -> 147;
                case 217 -> 3;
                case 218 -> 85;
                case 219 -> 56;
                case 220 -> 137;
                case 221 -> 2;
                case 222 -> 63;
                case 223 -> 238;
                case 224 -> 201;
                case 225 -> 158;
                case 226 -> 175;
                case 227 -> 240;
                case 228 -> 235;
                case 229 -> 105;
                case 230 -> 103;
                case 231 -> 165;
                case 232 -> 222;
                case 233 -> 21;
                case 234 -> 79;
                case 235 -> 144;
                case 236 -> 237;
                case 237 -> 215;
                case 238 -> 75;
                case 239 -> 14;
                case 240 -> 157;
                case 241 -> 231;
                case 242 -> 202;
                case 243 -> 199;
                case 244 -> 206;
                case 245 -> 130;
                case 246 -> 52;
                case 247 -> 142;
                case 248 -> 94;
                case 249 -> 50;
                case 250 -> 244;
                case 251 -> 189;
                case 252 -> 212;
                case 253 -> 54;
                case 254 -> 19;
                default -> 255;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 32240437240986L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1882296270 - -((char)-10427), 1882296270 - (char)-1360, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 109156764637017L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.x();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(170784210 + 16099, -170784210 + -14618, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(170784210 + 16100, -170784210 + -19707, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(170784210 + 16101, -170784210 + -24769, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "Q@\u0094\u00b9\u0018\u00d3D<\u0010\u00e1\u00a1s$^\u00dbud\u00a2\u0012\u0002\u00c1\u00ebR\u00db\u0010";
                    var4_3 = "Q@\u0094\u00b9\u0018\u00d3D<\u0010\u00e1\u00a1s$^\u00dbud\u00a2\u0012\u0002\u00c1\u00ebR\u00db\u0010".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 27;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "9\u009b?d\u00bb5K\u0090fiB\u00edH\u00af\u00d4v\u00f8+\u00e5C\u00b9\u001eGq\u00c0yTx\u00f1\u0012!\u008fC\u00f3D\u0099\u00c8\u0014E\u008b+\u0095\fe\u0080\u00e6\u00c5\u0097 a&\u00d2\u00f8\u00f5\u00c6\u0016\u00b2\u00dfO";
                        var4_3 = "9\u009b?d\u00bb5K\u0090fiB\u00edH\u00af\u00d4v\u00f8+\u00e5C\u00b9\u001eGq\u00c0yTx\u00f1\u0012!\u008fC\u00f3D\u0099\u00c8\u0014E\u008b+\u0095\fe\u0080\u00e6\u00c5\u0097 a&\u00d2\u00f8\u00f5\u00c6\u0016\u00b2\u00dfO".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 84;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 61;
                                break;
                            }
                            case 1: {
                                v15 = 6;
                                break;
                            }
                            case 2: {
                                v15 = 111;
                                break;
                            }
                            case 3: {
                                v15 = 40;
                                break;
                            }
                            case 4: {
                                v15 = 49;
                                break;
                            }
                            case 5: {
                                v15 = 49;
                                break;
                            }
                            default: {
                                v15 = 55;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x63ED) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 228;
                    case 1 -> 195;
                    case 2 -> 121;
                    case 3 -> 224;
                    case 4 -> 10;
                    case 5 -> 241;
                    case 6 -> 137;
                    case 7 -> 61;
                    case 8 -> 1;
                    case 9 -> 187;
                    case 10 -> 183;
                    case 11 -> 236;
                    case 12 -> 177;
                    case 13 -> 153;
                    case 14 -> 193;
                    case 15 -> 168;
                    case 16 -> 91;
                    case 17 -> 129;
                    case 18 -> 96;
                    case 19 -> 113;
                    case 20 -> 108;
                    case 21 -> 169;
                    case 22 -> 90;
                    case 23 -> 80;
                    case 24 -> 48;
                    case 25 -> 172;
                    case 26 -> 24;
                    case 27 -> 232;
                    case 28 -> 149;
                    case 29 -> 141;
                    case 30 -> 244;
                    case 31 -> 134;
                    case 32 -> 223;
                    case 33 -> 50;
                    case 34 -> 28;
                    case 35 -> 44;
                    case 36 -> 88;
                    case 37 -> 54;
                    case 38 -> 243;
                    case 39 -> 37;
                    case 40 -> 27;
                    case 41 -> 231;
                    case 42 -> 150;
                    case 43 -> 145;
                    case 44 -> 25;
                    case 45 -> 97;
                    case 46 -> 23;
                    case 47 -> 116;
                    case 48 -> 42;
                    case 49 -> 33;
                    case 50 -> 127;
                    case 51 -> 164;
                    case 52 -> 58;
                    case 53 -> 162;
                    case 54 -> 211;
                    case 55 -> 72;
                    case 56 -> 26;
                    case 57 -> 47;
                    case 58 -> 198;
                    case 59 -> 254;
                    case 60 -> 147;
                    case 61 -> 196;
                    case 62 -> 217;
                    case 63 -> 131;
                    case 64 -> 123;
                    case 65 -> 82;
                    case 66 -> 15;
                    case 67 -> 206;
                    case 68 -> 70;
                    case 69 -> 35;
                    case 70 -> 233;
                    case 71 -> 4;
                    case 72 -> 19;
                    case 73 -> 83;
                    case 74 -> 238;
                    case 75 -> 11;
                    case 76 -> 181;
                    case 77 -> 106;
                    case 78 -> 154;
                    case 79 -> 92;
                    case 80 -> 74;
                    case 81 -> 71;
                    case 82 -> 56;
                    case 83 -> 51;
                    case 84 -> 194;
                    case 85 -> 52;
                    case 86 -> 205;
                    case 87 -> 124;
                    case 88 -> 201;
                    case 89 -> 31;
                    case 90 -> 77;
                    case 91 -> 89;
                    case 92 -> 99;
                    case 93 -> 81;
                    case 94 -> 79;
                    case 95 -> 95;
                    case 96 -> 142;
                    case 97 -> 152;
                    case 98 -> 115;
                    case 99 -> 136;
                    case 100 -> 94;
                    case 101 -> 175;
                    case 102 -> 185;
                    case 103 -> 53;
                    case 104 -> 112;
                    case 105 -> 20;
                    case 106 -> 119;
                    case 107 -> 239;
                    case 108 -> 98;
                    case 109 -> 179;
                    case 110 -> 55;
                    case 111 -> 43;
                    case 112 -> 16;
                    case 113 -> 78;
                    case 114 -> 144;
                    case 115 -> 130;
                    case 116 -> 126;
                    case 117 -> 39;
                    case 118 -> 38;
                    case 119 -> 125;
                    case 120 -> 40;
                    case 121 -> 6;
                    case 122 -> 200;
                    case 123 -> 110;
                    case 124 -> 240;
                    case 125 -> 104;
                    case 126 -> 140;
                    case 127 -> 7;
                    case 128 -> 8;
                    case 129 -> 229;
                    case 130 -> 86;
                    case 131 -> 46;
                    case 132 -> 188;
                    case 133 -> 148;
                    case 134 -> 161;
                    case 135 -> 209;
                    case 136 -> 170;
                    case 137 -> 225;
                    case 138 -> 2;
                    case 139 -> 49;
                    case 140 -> 221;
                    case 141 -> 213;
                    case 142 -> 122;
                    case 143 -> 133;
                    case 144 -> 156;
                    case 145 -> 191;
                    case 146 -> 163;
                    case 147 -> 235;
                    case 148 -> 207;
                    case 149 -> 128;
                    case 150 -> 220;
                    case 151 -> 186;
                    case 152 -> 189;
                    case 153 -> 248;
                    case 154 -> 87;
                    case 155 -> 66;
                    case 156 -> 159;
                    case 157 -> 32;
                    case 158 -> 100;
                    case 159 -> 135;
                    case 160 -> 76;
                    case 161 -> 3;
                    case 162 -> 73;
                    case 163 -> 245;
                    case 164 -> 22;
                    case 165 -> 184;
                    case 166 -> 219;
                    case 167 -> 171;
                    case 168 -> 117;
                    case 169 -> 107;
                    case 170 -> 139;
                    case 171 -> 62;
                    case 172 -> 14;
                    case 173 -> 36;
                    case 174 -> 216;
                    case 175 -> 157;
                    case 176 -> 230;
                    case 177 -> 101;
                    case 178 -> 237;
                    case 179 -> 132;
                    case 180 -> 176;
                    case 181 -> 214;
                    case 182 -> 242;
                    case 183 -> 102;
                    case 184 -> 0;
                    case 185 -> 21;
                    case 186 -> 252;
                    case 187 -> 138;
                    case 188 -> 251;
                    case 189 -> 64;
                    case 190 -> 190;
                    case 191 -> 34;
                    case 192 -> 118;
                    case 193 -> 29;
                    case 194 -> 67;
                    case 195 -> 215;
                    case 196 -> 255;
                    case 197 -> 210;
                    case 198 -> 202;
                    case 199 -> 173;
                    case 200 -> 114;
                    case 201 -> 68;
                    case 202 -> 178;
                    case 203 -> 253;
                    case 204 -> 182;
                    case 205 -> 165;
                    case 206 -> 160;
                    case 207 -> 30;
                    case 208 -> 155;
                    case 209 -> 227;
                    case 210 -> 120;
                    case 211 -> 199;
                    case 212 -> 85;
                    case 213 -> 208;
                    case 214 -> 5;
                    case 215 -> 13;
                    case 216 -> 143;
                    case 217 -> 146;
                    case 218 -> 249;
                    case 219 -> 45;
                    case 220 -> 226;
                    case 221 -> 166;
                    case 222 -> 111;
                    case 223 -> 60;
                    case 224 -> 247;
                    case 225 -> 57;
                    case 226 -> 103;
                    case 227 -> 12;
                    case 228 -> 63;
                    case 229 -> 65;
                    case 230 -> 158;
                    case 231 -> 151;
                    case 232 -> 109;
                    case 233 -> 105;
                    case 234 -> 203;
                    case 235 -> 222;
                    case 236 -> 93;
                    case 237 -> 69;
                    case 238 -> 250;
                    case 239 -> 180;
                    case 240 -> 17;
                    case 241 -> 59;
                    case 242 -> 167;
                    case 243 -> 192;
                    case 244 -> 218;
                    case 245 -> 234;
                    case 246 -> 84;
                    case 247 -> 212;
                    case 248 -> 246;
                    case 249 -> 9;
                    case 250 -> 204;
                    case 251 -> 197;
                    case 252 -> 75;
                    case 253 -> 174;
                    case 254 -> 41;
                    default -> 18;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 111791563281220L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "&KE6H6\u0001\u007f\t!AV<\u0005t\u001cc\u0007";
                    var5_4 = "&KE6H6\u0001\u007f\t!AV<\u0005t\u001cc\u0007".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 94;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 19;
                                    break;
                                }
                                case 1: {
                                    v11 = 112;
                                    break;
                                }
                                case 2: {
                                    v11 = 105;
                                    break;
                                }
                                case 3: {
                                    v11 = 6;
                                    break;
                                }
                                case 4: {
                                    v11 = 115;
                                    break;
                                }
                                case 5: {
                                    v11 = 4;
                                    break;
                                }
                                default: {
                                    v11 = 108;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 69930201870329L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "vs-?bf\u001b\u0004pm!%\n|r*%nd\u0003Vs#\t|r*%nd\u0003Zy\r{t7(di\u0019Z~0\"e`";
                    var5_4 = "vs-?bf\u001b\u0004pm!%\n|r*%nd\u0003Vs#\t|r*%nd\u0003Zy\r{t7(di\u0019Z~0\"e`".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 14;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "zw->do\u0016\u0006zw->he";
                        var5_4 = "zw->do\u0016\u0006zw->he".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 8;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 49;
                                break;
                            }
                            case 1: {
                                v15 = 19;
                                break;
                            }
                            case 2: {
                                v15 = 74;
                                break;
                            }
                            case 3: {
                                v15 = 69;
                                break;
                            }
                            case 4: {
                                v15 = 5;
                                break;
                            }
                            case 5: {
                                v15 = 9;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 32126629451200L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(274067370 + 13851, -274067370 + -26699, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 8640332273604L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00b5\u00c8G\u00dc\u0088\u0003.t\u0080\u0005\u00d6K\rh\"\r+\u00eb\u00846\u00e6\u008al\u00af\u0007\u0086\u00e5gw\u0010\u00e2&zd\u0006U[i(\u00da\u00e3\u00a1Q{Pz\u0005/\u00802\u0011\u00c53\u001a\u00e5\u0085\u00ca,\u00c4.O\u00fb\u00e3\u0012\u00af\u00a9\u00ebcw\u00e3Q\u00fc]\u00f7\u0080\nJ\u0083\u00c4\u00deO3S\u00d6\u0006\u0098O\u00f3\u001c\u0004\u00d9'\u00a4\u008c\u0006b\u0088\u00d0\u008b\u0097\u00d4!xW";
                    var4_3 = "\u00b5\u00c8G\u00dc\u0088\u0003.t\u0080\u0005\u00d6K\rh\"\r+\u00eb\u00846\u00e6\u008al\u00af\u0007\u0086\u00e5gw\u0010\u00e2&zd\u0006U[i(\u00da\u00e3\u00a1Q{Pz\u0005/\u00802\u0011\u00c53\u001a\u00e5\u0085\u00ca,\u00c4.O\u00fb\u00e3\u0012\u00af\u00a9\u00ebcw\u00e3Q\u00fc]\u00f7\u0080\nJ\u0083\u00c4\u00deO3S\u00d6\u0006\u0098O\u00f3\u001c\u0004\u00d9'\u00a4\u008c\u0006b\u0088\u00d0\u008b\u0097\u00d4!xW".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 40;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0083E+uQ\n\u00cc\u00ff\u00a7uo)\u00bd\u0017\u00b0\u008aL$\u00cd(\u00ae\u001b\u00b9\u00eb\u00e7\u00ca\u00e5n\u0082\u0093\u00ec\u00e6\u008c+\u0082g\u00ac\u0091\u00a7\u0091q\u00ae5#\u00ca\u000b\u00d7C\u0084G\u008c\u0004\u0005\u00b5YV\u00af\u00e9\u00e7|\u00b4{\u00afT\u0015\u00d6\t<\u001a\u009fE\u0006;\u00dc\u0081\u00a0(\u000e\u00e2\u009f\u0001\u0004 \u00beD\u00e3\u00cf\u00be8\u00cf+\u00f6\u000e";
                        var4_3 = "\u0083E+uQ\n\u00cc\u00ff\u00a7uo)\u00bd\u0017\u00b0\u008aL$\u00cd(\u00ae\u001b\u00b9\u00eb\u00e7\u00ca\u00e5n\u0082\u0093\u00ec\u00e6\u008c+\u0082g\u00ac\u0091\u00a7\u0091q\u00ae5#\u00ca\u000b\u00d7C\u0084G\u008c\u0004\u0005\u00b5YV\u00af\u00e9\u00e7|\u00b4{\u00afT\u0015\u00d6\t<\u001a\u009fE\u0006;\u00dc\u0081\u00a0(\u000e\u00e2\u009f\u0001\u0004 \u00beD\u00e3\u00cf\u00be8\u00cf+\u00f6\u000e".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 18;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 87;
                                break;
                            }
                            case 1: {
                                v15 = 26;
                                break;
                            }
                            case 2: {
                                v15 = 30;
                                break;
                            }
                            case 3: {
                                v15 = 78;
                                break;
                            }
                            case 4: {
                                v15 = 51;
                                break;
                            }
                            case 5: {
                                v15 = 46;
                                break;
                            }
                            default: {
                                v15 = 7;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3005) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 249;
                    case 1 -> 211;
                    case 2 -> 155;
                    case 3 -> 88;
                    case 4 -> 253;
                    case 5 -> 80;
                    case 6 -> 68;
                    case 7 -> 150;
                    case 8 -> 149;
                    case 9 -> 139;
                    case 10 -> 74;
                    case 11 -> 66;
                    case 12 -> 112;
                    case 13 -> 52;
                    case 14 -> 86;
                    case 15 -> 197;
                    case 16 -> 218;
                    case 17 -> 191;
                    case 18 -> 134;
                    case 19 -> 154;
                    case 20 -> 12;
                    case 21 -> 34;
                    case 22 -> 54;
                    case 23 -> 246;
                    case 24 -> 94;
                    case 25 -> 237;
                    case 26 -> 78;
                    case 27 -> 142;
                    case 28 -> 165;
                    case 29 -> 204;
                    case 30 -> 102;
                    case 31 -> 146;
                    case 32 -> 207;
                    case 33 -> 226;
                    case 34 -> 120;
                    case 35 -> 110;
                    case 36 -> 230;
                    case 37 -> 166;
                    case 38 -> 168;
                    case 39 -> 163;
                    case 40 -> 90;
                    case 41 -> 114;
                    case 42 -> 152;
                    case 43 -> 162;
                    case 44 -> 156;
                    case 45 -> 77;
                    case 46 -> 17;
                    case 47 -> 91;
                    case 48 -> 20;
                    case 49 -> 193;
                    case 50 -> 182;
                    case 51 -> 119;
                    case 52 -> 89;
                    case 53 -> 225;
                    case 54 -> 137;
                    case 55 -> 176;
                    case 56 -> 231;
                    case 57 -> 195;
                    case 58 -> 71;
                    case 59 -> 216;
                    case 60 -> 73;
                    case 61 -> 251;
                    case 62 -> 104;
                    case 63 -> 109;
                    case 64 -> 113;
                    case 65 -> 215;
                    case 66 -> 198;
                    case 67 -> 27;
                    case 68 -> 95;
                    case 69 -> 239;
                    case 70 -> 160;
                    case 71 -> 129;
                    case 72 -> 14;
                    case 73 -> 174;
                    case 74 -> 16;
                    case 75 -> 147;
                    case 76 -> 42;
                    case 77 -> 97;
                    case 78 -> 234;
                    case 79 -> 208;
                    case 80 -> 72;
                    case 81 -> 118;
                    case 82 -> 75;
                    case 83 -> 45;
                    case 84 -> 98;
                    case 85 -> 228;
                    case 86 -> 213;
                    case 87 -> 111;
                    case 88 -> 36;
                    case 89 -> 240;
                    case 90 -> 41;
                    case 91 -> 164;
                    case 92 -> 206;
                    case 93 -> 209;
                    case 94 -> 5;
                    case 95 -> 158;
                    case 96 -> 178;
                    case 97 -> 7;
                    case 98 -> 101;
                    case 99 -> 144;
                    case 100 -> 23;
                    case 101 -> 51;
                    case 102 -> 29;
                    case 103 -> 170;
                    case 104 -> 245;
                    case 105 -> 108;
                    case 106 -> 183;
                    case 107 -> 39;
                    case 108 -> 106;
                    case 109 -> 200;
                    case 110 -> 105;
                    case 111 -> 140;
                    case 112 -> 130;
                    case 113 -> 50;
                    case 114 -> 121;
                    case 115 -> 131;
                    case 116 -> 40;
                    case 117 -> 4;
                    case 118 -> 47;
                    case 119 -> 83;
                    case 120 -> 187;
                    case 121 -> 0;
                    case 122 -> 31;
                    case 123 -> 141;
                    case 124 -> 201;
                    case 125 -> 92;
                    case 126 -> 227;
                    case 127 -> 214;
                    case 128 -> 9;
                    case 129 -> 161;
                    case 130 -> 127;
                    case 131 -> 115;
                    case 132 -> 136;
                    case 133 -> 177;
                    case 134 -> 192;
                    case 135 -> 171;
                    case 136 -> 173;
                    case 137 -> 81;
                    case 138 -> 241;
                    case 139 -> 250;
                    case 140 -> 212;
                    case 141 -> 26;
                    case 142 -> 37;
                    case 143 -> 1;
                    case 144 -> 167;
                    case 145 -> 53;
                    case 146 -> 232;
                    case 147 -> 24;
                    case 148 -> 35;
                    case 149 -> 85;
                    case 150 -> 205;
                    case 151 -> 25;
                    case 152 -> 33;
                    case 153 -> 57;
                    case 154 -> 38;
                    case 155 -> 148;
                    case 156 -> 210;
                    case 157 -> 6;
                    case 158 -> 138;
                    case 159 -> 157;
                    case 160 -> 13;
                    case 161 -> 3;
                    case 162 -> 8;
                    case 163 -> 56;
                    case 164 -> 151;
                    case 165 -> 59;
                    case 166 -> 202;
                    case 167 -> 21;
                    case 168 -> 189;
                    case 169 -> 11;
                    case 170 -> 221;
                    case 171 -> 203;
                    case 172 -> 117;
                    case 173 -> 180;
                    case 174 -> 30;
                    case 175 -> 252;
                    case 176 -> 172;
                    case 177 -> 242;
                    case 178 -> 247;
                    case 179 -> 82;
                    case 180 -> 65;
                    case 181 -> 135;
                    case 182 -> 124;
                    case 183 -> 103;
                    case 184 -> 61;
                    case 185 -> 186;
                    case 186 -> 62;
                    case 187 -> 126;
                    case 188 -> 122;
                    case 189 -> 10;
                    case 190 -> 60;
                    case 191 -> 219;
                    case 192 -> 159;
                    case 193 -> 63;
                    case 194 -> 28;
                    case 195 -> 58;
                    case 196 -> 96;
                    case 197 -> 76;
                    case 198 -> 199;
                    case 199 -> 44;
                    case 200 -> 190;
                    case 201 -> 49;
                    case 202 -> 32;
                    case 203 -> 184;
                    case 204 -> 87;
                    case 205 -> 254;
                    case 206 -> 248;
                    case 207 -> 220;
                    case 208 -> 22;
                    case 209 -> 222;
                    case 210 -> 243;
                    case 211 -> 194;
                    case 212 -> 15;
                    case 213 -> 188;
                    case 214 -> 143;
                    case 215 -> 145;
                    case 216 -> 223;
                    case 217 -> 235;
                    case 218 -> 244;
                    case 219 -> 133;
                    case 220 -> 125;
                    case 221 -> 69;
                    case 222 -> 43;
                    case 223 -> 181;
                    case 224 -> 46;
                    case 225 -> 93;
                    case 226 -> 2;
                    case 227 -> 175;
                    case 228 -> 116;
                    case 229 -> 19;
                    case 230 -> 84;
                    case 231 -> 236;
                    case 232 -> 229;
                    case 233 -> 233;
                    case 234 -> 224;
                    case 235 -> 79;
                    case 236 -> 67;
                    case 237 -> 99;
                    case 238 -> 132;
                    case 239 -> 128;
                    case 240 -> 179;
                    case 241 -> 196;
                    case 242 -> 123;
                    case 243 -> 100;
                    case 244 -> 255;
                    case 245 -> 169;
                    case 246 -> 153;
                    case 247 -> 217;
                    case 248 -> 185;
                    case 249 -> 64;
                    case 250 -> 48;
                    case 251 -> 70;
                    case 252 -> 55;
                    case 253 -> 238;
                    case 254 -> 18;
                    default -> 107;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 101966911834366L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(93321840 - (char)-22226, -93321840 - -((char)-9619), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 69237578209779L;
                    int[] nArray = SshAgentIpcService.x();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1589616960 - -((char)-7794), -1589485890 + -((char)-6079), (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 40702649471939L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0095A\u00cew\u00b8\u0003\u00d1\u00f9\u0010";
                var4_3 = "\u0095A\u00cew\u00b8\u0003\u00d1\u00f9\u0010".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 94;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 15;
                                break;
                            }
                            case 1: {
                                v11 = 1;
                                break;
                            }
                            case 2: {
                                v11 = 32;
                                break;
                            }
                            case 3: {
                                v11 = 15;
                                break;
                            }
                            case 4: {
                                v11 = 77;
                                break;
                            }
                            case 5: {
                                v11 = 64;
                                break;
                            }
                            default: {
                                v11 = 86;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x59BC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 247;
                    case 1 -> 72;
                    case 2 -> 190;
                    case 3 -> 161;
                    case 4 -> 16;
                    case 5 -> 218;
                    case 6 -> 181;
                    case 7 -> 46;
                    case 8 -> 57;
                    case 9 -> 176;
                    case 10 -> 34;
                    case 11 -> 139;
                    case 12 -> 183;
                    case 13 -> 207;
                    case 14 -> 234;
                    case 15 -> 188;
                    case 16 -> 69;
                    case 17 -> 88;
                    case 18 -> 170;
                    case 19 -> 215;
                    case 20 -> 164;
                    case 21 -> 193;
                    case 22 -> 184;
                    case 23 -> 44;
                    case 24 -> 231;
                    case 25 -> 113;
                    case 26 -> 226;
                    case 27 -> 221;
                    case 28 -> 99;
                    case 29 -> 29;
                    case 30 -> 204;
                    case 31 -> 121;
                    case 32 -> 63;
                    case 33 -> 148;
                    case 34 -> 96;
                    case 35 -> 43;
                    case 36 -> 216;
                    case 37 -> 253;
                    case 38 -> 35;
                    case 39 -> 86;
                    case 40 -> 254;
                    case 41 -> 115;
                    case 42 -> 67;
                    case 43 -> 9;
                    case 44 -> 76;
                    case 45 -> 122;
                    case 46 -> 243;
                    case 47 -> 102;
                    case 48 -> 198;
                    case 49 -> 114;
                    case 50 -> 38;
                    case 51 -> 251;
                    case 52 -> 143;
                    case 53 -> 123;
                    case 54 -> 111;
                    case 55 -> 8;
                    case 56 -> 13;
                    case 57 -> 125;
                    case 58 -> 127;
                    case 59 -> 219;
                    case 60 -> 195;
                    case 61 -> 225;
                    case 62 -> 91;
                    case 63 -> 75;
                    case 64 -> 15;
                    case 65 -> 250;
                    case 66 -> 100;
                    case 67 -> 81;
                    case 68 -> 128;
                    case 69 -> 90;
                    case 70 -> 95;
                    case 71 -> 235;
                    case 72 -> 200;
                    case 73 -> 168;
                    case 74 -> 133;
                    case 75 -> 220;
                    case 76 -> 36;
                    case 77 -> 10;
                    case 78 -> 77;
                    case 79 -> 212;
                    case 80 -> 163;
                    case 81 -> 61;
                    case 82 -> 119;
                    case 83 -> 20;
                    case 84 -> 64;
                    case 85 -> 151;
                    case 86 -> 129;
                    case 87 -> 227;
                    case 88 -> 203;
                    case 89 -> 11;
                    case 90 -> 112;
                    case 91 -> 241;
                    case 92 -> 246;
                    case 93 -> 145;
                    case 94 -> 68;
                    case 95 -> 209;
                    case 96 -> 141;
                    case 97 -> 105;
                    case 98 -> 18;
                    case 99 -> 50;
                    case 100 -> 21;
                    case 101 -> 167;
                    case 102 -> 49;
                    case 103 -> 157;
                    case 104 -> 78;
                    case 105 -> 116;
                    case 106 -> 31;
                    case 107 -> 103;
                    case 108 -> 48;
                    case 109 -> 192;
                    case 110 -> 194;
                    case 111 -> 211;
                    case 112 -> 202;
                    case 113 -> 56;
                    case 114 -> 27;
                    case 115 -> 182;
                    case 116 -> 160;
                    case 117 -> 58;
                    case 118 -> 25;
                    case 119 -> 180;
                    case 120 -> 233;
                    case 121 -> 106;
                    case 122 -> 80;
                    case 123 -> 210;
                    case 124 -> 101;
                    case 125 -> 165;
                    case 126 -> 4;
                    case 127 -> 17;
                    case 128 -> 155;
                    case 129 -> 55;
                    case 130 -> 229;
                    case 131 -> 177;
                    case 132 -> 146;
                    case 133 -> 137;
                    case 134 -> 71;
                    case 135 -> 110;
                    case 136 -> 171;
                    case 137 -> 134;
                    case 138 -> 124;
                    case 139 -> 97;
                    case 140 -> 85;
                    case 141 -> 214;
                    case 142 -> 173;
                    case 143 -> 224;
                    case 144 -> 40;
                    case 145 -> 201;
                    case 146 -> 232;
                    case 147 -> 41;
                    case 148 -> 175;
                    case 149 -> 149;
                    case 150 -> 2;
                    case 151 -> 174;
                    case 152 -> 37;
                    case 153 -> 178;
                    case 154 -> 22;
                    case 155 -> 189;
                    case 156 -> 19;
                    case 157 -> 83;
                    case 158 -> 236;
                    case 159 -> 98;
                    case 160 -> 248;
                    case 161 -> 206;
                    case 162 -> 228;
                    case 163 -> 73;
                    case 164 -> 205;
                    case 165 -> 14;
                    case 166 -> 62;
                    case 167 -> 1;
                    case 168 -> 33;
                    case 169 -> 237;
                    case 170 -> 223;
                    case 171 -> 152;
                    case 172 -> 39;
                    case 173 -> 156;
                    case 174 -> 54;
                    case 175 -> 239;
                    case 176 -> 191;
                    case 177 -> 65;
                    case 178 -> 109;
                    case 179 -> 140;
                    case 180 -> 12;
                    case 181 -> 7;
                    case 182 -> 118;
                    case 183 -> 84;
                    case 184 -> 87;
                    case 185 -> 197;
                    case 186 -> 26;
                    case 187 -> 142;
                    case 188 -> 53;
                    case 189 -> 147;
                    case 190 -> 70;
                    case 191 -> 24;
                    case 192 -> 186;
                    case 193 -> 244;
                    case 194 -> 242;
                    case 195 -> 47;
                    case 196 -> 94;
                    case 197 -> 104;
                    case 198 -> 230;
                    case 199 -> 150;
                    case 200 -> 172;
                    case 201 -> 60;
                    case 202 -> 196;
                    case 203 -> 245;
                    case 204 -> 153;
                    case 205 -> 23;
                    case 206 -> 166;
                    case 207 -> 158;
                    case 208 -> 144;
                    case 209 -> 108;
                    case 210 -> 74;
                    case 211 -> 252;
                    case 212 -> 213;
                    case 213 -> 154;
                    case 214 -> 32;
                    case 215 -> 131;
                    case 216 -> 222;
                    case 217 -> 185;
                    case 218 -> 136;
                    case 219 -> 107;
                    case 220 -> 159;
                    case 221 -> 52;
                    case 222 -> 5;
                    case 223 -> 82;
                    case 224 -> 6;
                    case 225 -> 130;
                    case 226 -> 92;
                    case 227 -> 93;
                    case 228 -> 179;
                    case 229 -> 45;
                    case 230 -> 79;
                    case 231 -> 162;
                    case 232 -> 138;
                    case 233 -> 120;
                    case 234 -> 30;
                    case 235 -> 217;
                    case 236 -> 249;
                    case 237 -> 169;
                    case 238 -> 238;
                    case 239 -> 3;
                    case 240 -> 0;
                    case 241 -> 208;
                    case 242 -> 117;
                    case 243 -> 89;
                    case 244 -> 240;
                    case 245 -> 255;
                    case 246 -> 42;
                    case 247 -> 199;
                    case 248 -> 66;
                    case 249 -> 28;
                    case 250 -> 132;
                    case 251 -> 51;
                    case 252 -> 59;
                    case 253 -> 135;
                    case 254 -> 187;
                    default -> 126;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

