/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import ai.grazie.nlp.langs.Language;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.grazie.GrazieSpellCheckerEngine;
import com.intellij.spellchecker.grazie.NaturalLanguagesProvider;
import com.intellij.spellchecker.grazie.diacritic.Diacritics;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.tokenizer.LanguageSpellchecking;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpellCheckingInspection
extends LocalInspectionTool
implements DumbAware {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        SpellcheckingStrategy strategy;
        if (element != null && (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element)) instanceof SuppressibleSpellcheckingStrategy) {
            SuppressQuickFix[] suppressQuickFixArray = ((SuppressibleSpellcheckingStrategy)strategy).getSuppressActions(element, this.getShortName());
            if (suppressQuickFixArray == null) {
                SpellCheckingInspection.$$$reportNull$$$0(0);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element);
        if (suppressQuickFixArray == null) {
            SpellCheckingInspection.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    public static SpellcheckingStrategy getSpellcheckingStrategy(@NotNull PsiElement element) {
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(2);
        }
        DumbService dumbService = DumbService.getInstance((Project)element.getProject());
        for (SpellcheckingStrategy strategy : LanguageSpellchecking.INSTANCE.allForLanguage(element.getLanguage())) {
            if (!dumbService.isUsableInCurrentContext((Object)strategy) || !strategy.isMyContext(element)) continue;
            return strategy;
        }
        return null;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        SpellcheckingStrategy strategy;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(3);
        }
        if ((strategy = SpellCheckingInspection.getSpellcheckingStrategy(element)) instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).isSuppressedFor(element, this.getShortName());
        }
        return super.isSuppressedFor(element);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SPELL_CHECKING_INSPECTION_TOOL_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(4);
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            SpellCheckingInspection.$$$reportNull$$$0(5);
        }
        return psiElementVisitor;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(6);
        }
        if (session == null) {
            SpellCheckingInspection.$$$reportNull$$$0(7);
        }
        if (!Registry.is((String)"spellchecker.inspection.enabled", (boolean)true) || InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)this)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpellCheckingInspection.$$$reportNull$$$0(8);
            }
            return psiElementVisitor;
        }
        SpellCheckerManager manager = SpellCheckerManager.getInstance(holder.getProject());
        final Set<SpellCheckingScope> scope = this.buildAllowedScopes();
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (holder.getResultCount() > 1000) {
                    return;
                }
                ASTNode node = element.getNode();
                if (node == null) {
                    return;
                }
                SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element);
                if (strategy == null) {
                    return;
                }
                if (!strategy.elementFitsScope(element, scope)) {
                    return;
                }
                PsiFile containingFile = holder.getFile();
                if (InjectedLanguageManager.getInstance((Project)containingFile.getProject()).isFrankensteinInjection((PsiElement)containingFile)) {
                    return;
                }
                SpellCheckingInspection.this.inspect(element, strategy, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection$1", "visitElement"));
            }
        };
    }

    private void inspect(@NotNull PsiElement element, @NotNull SpellcheckingStrategy strategy, @NotNull ProblemsHolder holder) {
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(9);
        }
        if (strategy == null) {
            SpellCheckingInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(11);
        }
        SpellCheckerManager manager = SpellCheckerManager.getInstance(holder.getProject());
        Set<SpellCheckingScope> scopes = this.buildAllowedScopes();
        SpellCheckingInspection.tokenize(element, new MyTokenConsumer(manager, strategy, holder, LanguageNamesValidation.INSTANCE.forLanguage(element.getLanguage())), scopes);
    }

    private Set<SpellCheckingScope> buildAllowedScopes() {
        HashSet<SpellCheckingScope> result = new HashSet<SpellCheckingScope>();
        if (this.processLiterals) {
            result.add(SpellCheckingScope.Literals);
        }
        if (this.processComments) {
            result.add(SpellCheckingScope.Comments);
        }
        if (this.processCode) {
            result.add(SpellCheckingScope.Code);
        }
        return result;
    }

    public static void tokenize(@NotNull PsiElement element, TokenConsumer consumer, Set<SpellCheckingScope> allowedScopes) {
        SpellcheckingStrategy factoryByLanguage;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(12);
        }
        if ((factoryByLanguage = SpellCheckingInspection.getSpellcheckingStrategy(element)) == null) {
            return;
        }
        SpellCheckingInspection.tokenize(factoryByLanguage, element, consumer, allowedScopes);
    }

    private static void tokenize(SpellcheckingStrategy strategy, PsiElement element, TokenConsumer consumer, Set<SpellCheckingScope> allowedScopes) {
        Tokenizer tokenizer = strategy.getTokenizer(element, allowedScopes);
        tokenizer.tokenize(element, consumer);
    }

    private static void addBatchDescriptor(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull String word, @NotNull ProblemsHolder holder) {
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(13);
        }
        if (textRange == null) {
            SpellCheckingInspection.$$$reportNull$$$0(14);
        }
        if (word == null) {
            SpellCheckingInspection.$$$reportNull$$$0(15);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(16);
        }
        LocalQuickFix[] fixes = SpellcheckingStrategy.getDefaultBatchFixes(element, textRange, word);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, textRange, fixes, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void addRegularDescriptor(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull ProblemsHolder holder, boolean useRename, String wordWithTypo) {
        SpellcheckingStrategy strategy;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(17);
        }
        if (textRange == null) {
            SpellCheckingInspection.$$$reportNull$$$0(18);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(19);
        }
        LocalQuickFix[] fixes = (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element)) != null ? strategy.getRegularFixes(element, textRange, useRename, wordWithTypo) : SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo, element, textRange);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, textRange, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(PsiElement element, TextRange textRange, LocalQuickFix[] fixes, boolean onTheFly) {
        String description = SpellCheckerBundle.message("typo.in.word.ref", new Object[0]);
        return new ProblemDescriptorBase(element, element, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, textRange, onTheFly, onTheFly);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"processCode", (String)SpellCheckerBundle.message("process.code", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processLiterals", (String)SpellCheckerBundle.message("process.literals", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processComments", (String)SpellCheckerBundle.message("process.comments", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SpellCheckingInspection.$$$reportNull$$$0(20);
        }
        return optPane;
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement element, @NotNull TextRange range, boolean useRename, String word) {
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(21);
        }
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(22);
        }
        if (range == null) {
            SpellCheckingInspection.$$$reportNull$$$0(23);
        }
        if (holder.isOnTheFly()) {
            SpellCheckingInspection.addRegularDescriptor(element, range, holder, useRename, word);
        } else {
            SpellCheckingInspection.addBatchDescriptor(element, range, word, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/SpellCheckingInspection";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/SpellCheckingInspection";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpellcheckingStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addBatchDescriptor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRegularDescriptor";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyTokenConsumer
    extends TokenConsumer
    implements Consumer<TextRange> {
        private static final Pattern NON_ENGLISH_LETTERS = Pattern.compile(".*[^a-zA-Z].*");
        private final Set<String> myAlreadyChecked = CollectionFactory.createSmallMemoryFootprintSet();
        private final SpellCheckerManager myManager;
        private final ProblemsHolder myHolder;
        private final NamesValidator myNamesValidator;
        private final SpellcheckingStrategy myStrategy;
        private boolean myCodeLike;
        private PsiElement myElement;
        private String myText;
        private boolean myUseRename;
        private int myOffset;

        MyTokenConsumer(SpellCheckerManager manager, SpellcheckingStrategy strategy, ProblemsHolder holder, NamesValidator namesValidator) {
            this.myManager = manager;
            this.myStrategy = strategy;
            this.myHolder = holder;
            this.myNamesValidator = namesValidator;
        }

        @Override
        public void consumeToken(PsiElement element, String text, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
            this.myElement = element;
            this.myText = text;
            this.myUseRename = useRename;
            this.myOffset = offset;
            this.myCodeLike = this.myStrategy.elementFitsScope(this.myElement, Set.of(SpellCheckingScope.Code));
            splitter.split(text, rangeToCheck, this);
        }

        public void consume(TextRange range) {
            ProgressManager.checkCanceled();
            String word = range.substring(this.myText);
            if (!this.myHolder.isOnTheFly() && this.myAlreadyChecked.contains(word)) {
                return;
            }
            boolean keyword = this.myNamesValidator.isKeyword(word, this.myElement.getProject());
            if (keyword || !this.hasProblem(word) || this.hasSameNamedReferenceInFile(word)) {
                return;
            }
            range = this.myStrategy.getTokenizer(this.myElement).getHighlightingRange(this.myElement, this.myOffset, range);
            assert (range.getStartOffset() >= 0);
            if (!this.myHolder.isOnTheFly()) {
                this.myAlreadyChecked.add(word);
            }
            SpellCheckingInspection.registerProblem(this.myHolder, this.myElement, range, this.myUseRename, word);
        }

        private boolean hasSameNamedReferenceInFile(String word) {
            if (!this.myStrategy.elementFitsScope(this.myElement, Set.of(SpellCheckingScope.Comments))) {
                return false;
            }
            PsiFile file = this.myElement.getContainingFile();
            Map references = (Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)file, psi -> new ConcurrentHashMap());
            return references.computeIfAbsent(word, key -> MyTokenConsumer.hasSameNamedReferencesInFile(file, key));
        }

        private static boolean hasSameNamedReferencesInFile(PsiFile file, String word) {
            int[] occurrences = new StringSearcher(word, true, true).findAllOccurrences((CharSequence)file.getText());
            if (occurrences.length <= 1) {
                return false;
            }
            for (int occurrence : occurrences) {
                PsiElement resolvedReference;
                PsiReference reference = file.findReferenceAt(occurrence);
                PsiElement psiElement = resolvedReference = reference != null ? reference.resolve() : null;
                if (reference == null || resolvedReference == null || reference.getElement() == resolvedReference) continue;
                return true;
            }
            return false;
        }

        private boolean hasProblem(String word) {
            if (!this.myManager.hasProblem(word)) {
                return false;
            }
            if (!this.myCodeLike || NON_ENGLISH_LETTERS.matcher(word).matches() || MyTokenConsumer.isOnlyEnglishDictionaryEnabled(this.myElement.getProject())) {
                return true;
            }
            Project project = this.myElement.getProject();
            return SpellCheckerManager.getInstance(project).getSuggestions(word).stream().filter(suggestion -> RenameUtil.isValidName((Project)project, (PsiElement)this.myElement, (String)suggestion)).noneMatch(suggestion -> Diacritics.equalsIgnoringDiacritics(word, suggestion));
        }

        private static boolean isOnlyEnglishDictionaryEnabled(Project project) {
            Set<Language> languages = NaturalLanguagesProvider.Companion.getEnabledLanguages();
            if (languages.size() != 1 || !languages.contains(Language.ENGLISH)) {
                return false;
            }
            SpellCheckerSettings settings = SpellCheckerSettings.getInstance(project);
            List<String> paths = settings.getCustomDictionariesPaths();
            if (paths != null && !paths.isEmpty()) {
                GrazieSpellCheckerEngine engine = (GrazieSpellCheckerEngine)project.getService(GrazieSpellCheckerEngine.class);
                return !ContainerUtil.exists(paths, dictionaryName -> engine.isDictionaryLoad((String)dictionaryName));
            }
            return true;
        }
    }

    public static enum SpellCheckingScope {
        Comments,
        Literals,
        Code;

    }
}

