/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Vector;

public final class Matrix {
    private final int width;
    private final int height;
    private final Vector vector;

    public static Matrix create(int height, double ... values2) {
        if (values2.length == 0) {
            throw new IllegalArgumentException("no values");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("unexpected height");
        }
        int width = values2.length / height;
        if (width * height != values2.length) {
            throw new IllegalArgumentException("unexpected amount of values");
        }
        return new Matrix(width, height, (double[])values2.clone());
    }

    public static Matrix createIdentity(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("unexpected size");
        }
        double[] array = new double[size * size];
        int index = 0;
        int i = 0;
        while (i < size) {
            array[index] = 1.0;
            ++i;
            index += size + 1;
        }
        return new Matrix(size, size, array);
    }

    public static Matrix createColumn(Vector vector) {
        return new Matrix(1, vector.getSize(), vector);
    }

    public static Matrix createRow(Vector vector) {
        return new Matrix(vector.getSize(), 1, vector);
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            return this.width == matrix.width && this.height == matrix.height && this.vector.equals(matrix.vector);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Matrix ").append(this.height).append("x").append(this.width).append(" { ");
        int i = 0;
        for (int h = 0; h < this.height; ++h) {
            if (h != 0) {
                sb.append(", ");
            }
            sb.append("{");
            int w = 0;
            while (w < this.width) {
                if (w != 0) {
                    sb.append(", ");
                }
                sb.append(this.vector.get(i));
                ++w;
                ++i;
            }
            sb.append("}");
        }
        return sb.append(" }").toString();
    }

    public double get(int column, int row) {
        Matrix.validate(column, this.width);
        Matrix.validate(row, this.height);
        return this.vector.get(column + row * this.width);
    }

    public int getColumns() {
        return this.width;
    }

    public Vector getColumn(final int column) {
        Matrix.validate(column, this.width);
        return new Vector.Modified(this.vector){

            @Override
            public double get(int row) {
                Matrix.validate(row, Matrix.this.height);
                return super.get(column + row * Matrix.this.width);
            }

            @Override
            public int getSize() {
                return Matrix.this.height;
            }
        };
    }

    public int getRows() {
        return this.height;
    }

    public Vector getRow(final int row) {
        Matrix.validate(row, this.height);
        return new Vector.Modified(this.vector){

            @Override
            public double get(int column) {
                Matrix.validate(column, Matrix.this.width);
                return super.get(column + row * Matrix.this.width);
            }

            @Override
            public int getSize() {
                return Matrix.this.width;
            }
        };
    }

    public Matrix plus(Matrix matrix) {
        if (this.getColumns() != matrix.getColumns()) {
            throw new IllegalArgumentException("columns mismatch");
        }
        if (this.getRows() != matrix.getRows()) {
            throw new IllegalArgumentException("rows mismatch");
        }
        return new Matrix(this.width, this.height, this.vector.plus(matrix.vector));
    }

    public Matrix minus(Matrix matrix) {
        if (this.getColumns() != matrix.getColumns()) {
            throw new IllegalArgumentException("columns mismatch");
        }
        if (this.getRows() != matrix.getRows()) {
            throw new IllegalArgumentException("rows mismatch");
        }
        return new Matrix(this.width, this.height, this.vector.minus(matrix.vector));
    }

    public Matrix multiply(double value) {
        return new Matrix(this.width, this.height, this.vector.multiply(value));
    }

    public Matrix multiply(Matrix matrix) {
        if (this.getColumns() != matrix.getRows()) {
            throw new IllegalArgumentException("columns mismatch rows");
        }
        int width = matrix.getColumns();
        int height = this.getRows();
        double[] result = new double[width * height];
        int i = 0;
        for (int h = 0; h < height; ++h) {
            Vector row = this.getRow(h);
            int w = 0;
            while (w < width) {
                result[i] = row.multiply(matrix.getColumn(w));
                ++w;
                ++i;
            }
        }
        return new Matrix(width, height, result);
    }

    public Vector multiply(Vector vector) {
        if (this.getColumns() != vector.getSize()) {
            throw new IllegalArgumentException("columns mismatch length");
        }
        double[] result = new double[this.getRows()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getRow(i).multiply(vector);
        }
        return new Vector(result);
    }

    public double determinant() {
        if (this.width != this.height) {
            throw new IllegalArgumentException("not a square");
        }
        if (this.width == 1) {
            return this.vector.get(0);
        }
        if (this.width == 2) {
            return this.vector.get(0) * this.vector.get(3) - this.vector.get(1) * this.vector.get(2);
        }
        double result = 0.0;
        for (int i = 0; i < this.width; ++i) {
            double value = this.vector.get(i) * this.exclude(i, 0).determinant();
            result -= Matrix.isEven(i) ? -value : value;
        }
        return result;
    }

    public Matrix transpose() {
        double[] result = new double[this.vector.getSize()];
        int i = 0;
        for (int w = 0; w < this.width; ++w) {
            int h = 0;
            while (h < this.height) {
                result[i] = this.get(w, h);
                ++h;
                ++i;
            }
        }
        return new Matrix(this.height, this.width, result);
    }

    public Matrix inverse() {
        double value = this.determinant();
        if (value == 0.0) {
            throw new IllegalArgumentException("determinant is 0");
        }
        return this.cofactor().transpose().multiply(1.0 / value);
    }

    private Matrix exclude(int column, int row) {
        Matrix.validate(column, this.width);
        Matrix.validate(row, this.height);
        int width = this.getColumns() - 1;
        if (width == 0) {
            throw new IllegalArgumentException("cannot exclude last column");
        }
        int height = this.getRows() - 1;
        if (height == 0) {
            throw new IllegalArgumentException("cannot exclude last row");
        }
        double[] result = new double[width * height];
        int index = 0;
        int i = 0;
        for (int h = 0; h <= height; ++h) {
            int w = 0;
            while (w <= width) {
                if (w != column && h != row) {
                    result[index++] = this.vector.get(i);
                }
                ++w;
                ++i;
            }
        }
        return new Matrix(width, height, result);
    }

    private Matrix cofactor() {
        if (this.width != this.height) {
            throw new IllegalArgumentException("not a square");
        }
        double[] result = new double[this.vector.getSize()];
        int i = 0;
        for (int h = 0; h < this.height; ++h) {
            int w = 0;
            while (w < this.width) {
                double value = this.exclude(w, h).determinant();
                result[i] = Matrix.isEven(w) != Matrix.isEven(h) ? -value : value;
                ++w;
                ++i;
            }
        }
        return new Matrix(this.width, this.height, result);
    }

    private Matrix(int width, int height, double ... values2) {
        this(width, height, new Vector(values2));
    }

    private Matrix(int width, int height, Vector vector) {
        this.width = width;
        this.height = height;
        this.vector = vector;
    }

    private static boolean isEven(int i) {
        return i % 2 == 0;
    }

    private static void validate(int index, int max) {
        if (index < 0 || max <= index) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }
}

