/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 101402116478617L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-2061337890 + -((char)-24283), 2061337890 + (char)-29514, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2061337890 + -((char)-24282), 2061337890 + (char)-9597, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 139637413714506L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.D();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-563076720 - -((char)-3112), -562945650 + -((char)-22023), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-563076720 - -((char)-3111), -563076720 - -((char)-7723), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-563076720 - -((char)-3106), 562945650 + (char)-20982, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 44410856666305L;
                Object object = this.lock;
                String[] stringArray = SshAgentIpcService.D();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(894814890 + 12602, -894814890 + -5424, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(894814890 + 12605, -894814890 + -3160, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(894814890 + 12604, -894814890 - -12146, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(894814890 + 12607, -894814890 + -166, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(894814890 + 12606, 894814890 + 4815, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(894814890 + 12609, -894814890 - -6225, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(894814890 + 12607, -894814890 + -166, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(894814890 + 12608, 894814890 + 6467, (int)l2));
            if (ActionTimestamp.D() != null) {
                SshAgentIpcService.D(new String[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 112851589007553L;
                    stringArray = SshAgentIpcService.D();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 26972943452953L;
                String[] stringArray2 = SshAgentIpcService.D();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(548790090 + (char)-23317, -548790090 + -((char)-1758), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23318, -548790090 + -((char)-501), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23315, 548790090 + (char)-17577, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(548790090 + (char)-23317, -548790090 + -((char)-1758), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23316, 548921160 - (char)-8005, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(548790090 + (char)-23317, -548790090 + -((char)-1758), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23329, 548921160 - (char)-2173, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23330, 548790090 + (char)-18769, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23315, 548790090 + (char)-17577, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(548790090 + (char)-23317, -548790090 + -((char)-1758), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(548790090 + (char)-23321, -548790090 + -((char)-10930), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(548790090 + (char)-23327, -548790090 + -((char)-15161), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 130416952840424L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(270921690 + 2135, -270921690 + -28, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 108951194361399L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(758895300 + (char)-7125, -758895300 + -((char)-20718), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "@\u00a8\u00ec\u00be\u000f\u00ac\u008aS{\u00d4\u000f`\u00d7\u0015S\u00eeY3\u008c\u0014\\\u00d3o\u00d7dC\u009a+\u00fb\u00dd\u00da\u0095\u00afR\u009d\u008dm\u0099\r\u009a";
                        var4_3 = "@\u00a8\u00ec\u00be\u000f\u00ac\u008aS{\u00d4\u000f`\u00d7\u0015S\u00eeY3\u008c\u0014\\\u00d3o\u00d7dC\u009a+\u00fb\u00dd\u00da\u0095\u00afR\u009d\u008dm\u0099\r\u009a".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 41;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 32;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 56;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 3;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 110;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 7;
                                        break;
                                    }
                                    default: {
                                        v11 = 124;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x68D9) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 173;
                            case 1 -> 240;
                            case 2 -> 28;
                            case 3 -> 249;
                            case 4 -> 194;
                            case 5 -> 10;
                            case 6 -> 137;
                            case 7 -> 190;
                            case 8 -> 61;
                            case 9 -> 94;
                            case 10 -> 246;
                            case 11 -> 24;
                            case 12 -> 43;
                            case 13 -> 40;
                            case 14 -> 39;
                            case 15 -> 89;
                            case 16 -> 116;
                            case 17 -> 72;
                            case 18 -> 218;
                            case 19 -> 217;
                            case 20 -> 53;
                            case 21 -> 99;
                            case 22 -> 171;
                            case 23 -> 195;
                            case 24 -> 166;
                            case 25 -> 216;
                            case 26 -> 122;
                            case 27 -> 18;
                            case 28 -> 140;
                            case 29 -> 0;
                            case 30 -> 180;
                            case 31 -> 124;
                            case 32 -> 67;
                            case 33 -> 251;
                            case 34 -> 102;
                            case 35 -> 81;
                            case 36 -> 213;
                            case 37 -> 197;
                            case 38 -> 48;
                            case 39 -> 36;
                            case 40 -> 238;
                            case 41 -> 162;
                            case 42 -> 231;
                            case 43 -> 83;
                            case 44 -> 146;
                            case 45 -> 128;
                            case 46 -> 13;
                            case 47 -> 133;
                            case 48 -> 205;
                            case 49 -> 123;
                            case 50 -> 114;
                            case 51 -> 233;
                            case 52 -> 211;
                            case 53 -> 178;
                            case 54 -> 134;
                            case 55 -> 250;
                            case 56 -> 155;
                            case 57 -> 3;
                            case 58 -> 209;
                            case 59 -> 117;
                            case 60 -> 228;
                            case 61 -> 244;
                            case 62 -> 7;
                            case 63 -> 98;
                            case 64 -> 230;
                            case 65 -> 65;
                            case 66 -> 108;
                            case 67 -> 60;
                            case 68 -> 247;
                            case 69 -> 46;
                            case 70 -> 191;
                            case 71 -> 138;
                            case 72 -> 136;
                            case 73 -> 187;
                            case 74 -> 115;
                            case 75 -> 147;
                            case 76 -> 77;
                            case 77 -> 177;
                            case 78 -> 68;
                            case 79 -> 192;
                            case 80 -> 225;
                            case 81 -> 82;
                            case 82 -> 75;
                            case 83 -> 57;
                            case 84 -> 167;
                            case 85 -> 226;
                            case 86 -> 188;
                            case 87 -> 198;
                            case 88 -> 210;
                            case 89 -> 242;
                            case 90 -> 152;
                            case 91 -> 170;
                            case 92 -> 199;
                            case 93 -> 126;
                            case 94 -> 31;
                            case 95 -> 64;
                            case 96 -> 21;
                            case 97 -> 139;
                            case 98 -> 201;
                            case 99 -> 183;
                            case 100 -> 202;
                            case 101 -> 196;
                            case 102 -> 243;
                            case 103 -> 44;
                            case 104 -> 49;
                            case 105 -> 14;
                            case 106 -> 130;
                            case 107 -> 203;
                            case 108 -> 179;
                            case 109 -> 76;
                            case 110 -> 153;
                            case 111 -> 15;
                            case 112 -> 69;
                            case 113 -> 112;
                            case 114 -> 127;
                            case 115 -> 12;
                            case 116 -> 174;
                            case 117 -> 66;
                            case 118 -> 219;
                            case 119 -> 222;
                            case 120 -> 54;
                            case 121 -> 79;
                            case 122 -> 6;
                            case 123 -> 149;
                            case 124 -> 103;
                            case 125 -> 1;
                            case 126 -> 70;
                            case 127 -> 182;
                            case 128 -> 92;
                            case 129 -> 163;
                            case 130 -> 207;
                            case 131 -> 186;
                            case 132 -> 208;
                            case 133 -> 132;
                            case 134 -> 212;
                            case 135 -> 169;
                            case 136 -> 141;
                            case 137 -> 221;
                            case 138 -> 144;
                            case 139 -> 125;
                            case 140 -> 8;
                            case 141 -> 90;
                            case 142 -> 19;
                            case 143 -> 161;
                            case 144 -> 252;
                            case 145 -> 22;
                            case 146 -> 29;
                            case 147 -> 32;
                            case 148 -> 220;
                            case 149 -> 248;
                            case 150 -> 119;
                            case 151 -> 86;
                            case 152 -> 88;
                            case 153 -> 154;
                            case 154 -> 45;
                            case 155 -> 224;
                            case 156 -> 110;
                            case 157 -> 131;
                            case 158 -> 105;
                            case 159 -> 97;
                            case 160 -> 100;
                            case 161 -> 93;
                            case 162 -> 239;
                            case 163 -> 4;
                            case 164 -> 151;
                            case 165 -> 253;
                            case 166 -> 118;
                            case 167 -> 74;
                            case 168 -> 234;
                            case 169 -> 20;
                            case 170 -> 215;
                            case 171 -> 109;
                            case 172 -> 143;
                            case 173 -> 80;
                            case 174 -> 84;
                            case 175 -> 78;
                            case 176 -> 26;
                            case 177 -> 56;
                            case 178 -> 236;
                            case 179 -> 35;
                            case 180 -> 168;
                            case 181 -> 200;
                            case 182 -> 34;
                            case 183 -> 232;
                            case 184 -> 73;
                            case 185 -> 2;
                            case 186 -> 145;
                            case 187 -> 181;
                            case 188 -> 62;
                            case 189 -> 58;
                            case 190 -> 63;
                            case 191 -> 135;
                            case 192 -> 59;
                            case 193 -> 172;
                            case 194 -> 206;
                            case 195 -> 120;
                            case 196 -> 185;
                            case 197 -> 42;
                            case 198 -> 30;
                            case 199 -> 33;
                            case 200 -> 193;
                            case 201 -> 95;
                            case 202 -> 129;
                            case 203 -> 106;
                            case 204 -> 111;
                            case 205 -> 176;
                            case 206 -> 229;
                            case 207 -> 96;
                            case 208 -> 121;
                            case 209 -> 5;
                            case 210 -> 25;
                            case 211 -> 11;
                            case 212 -> 150;
                            case 213 -> 159;
                            case 214 -> 245;
                            case 215 -> 91;
                            case 216 -> 164;
                            case 217 -> 113;
                            case 218 -> 227;
                            case 219 -> 17;
                            case 220 -> 23;
                            case 221 -> 104;
                            case 222 -> 189;
                            case 223 -> 204;
                            case 224 -> 165;
                            case 225 -> 175;
                            case 226 -> 87;
                            case 227 -> 27;
                            case 228 -> 50;
                            case 229 -> 37;
                            case 230 -> 158;
                            case 231 -> 214;
                            case 232 -> 101;
                            case 233 -> 41;
                            case 234 -> 184;
                            case 235 -> 254;
                            case 236 -> 55;
                            case 237 -> 38;
                            case 238 -> 235;
                            case 239 -> 223;
                            case 240 -> 157;
                            case 241 -> 241;
                            case 242 -> 85;
                            case 243 -> 51;
                            case 244 -> 9;
                            case 245 -> 71;
                            case 246 -> 52;
                            case 247 -> 142;
                            case 248 -> 156;
                            case 249 -> 47;
                            case 250 -> 237;
                            case 251 -> 16;
                            case 252 -> 107;
                            case 253 -> 148;
                            case 254 -> 255;
                            default -> 160;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray != null) {
                ActionTimestamp.D(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 75814983995813L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.D();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(221246160 + (char)-21575, -221246160 + -((char)-12280), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(221246160 + (char)-21571, -221246160 + -((char)-17572), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(221246160 + (char)-21562, 221377230 - (char)-141, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(221246160 + (char)-21575, -221246160 + -((char)-12280), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(221246160 + (char)-21571, -221246160 + -((char)-17572), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(221246160 + (char)-21567, 221246160 + (char)-22823, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 21292969867272L;
                        String[] stringArray2 = SshAgentIpcService.D();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1477945320 + -((char)-24357), 1477945320 + 25748, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1477945320 + -((char)-24358), 1477945320 + 27804, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 81701938898584L;
                String[] stringArray2 = SshAgentIpcService.D();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    stringArray = stringArray2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24768), 1223931660 + 21257, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24764), 1223931660 + (char)-20515, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24763), -1223931660 + -((char)-22454), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24764), 1223931660 + (char)-20515, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24770), -1223931660 + -((char)-28204), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24768), 1223931660 + 21257, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24764), 1223931660 + (char)-20515, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24748), -1223931660 + -((char)-25076), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24768), 1223931660 + 21257, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24764), 1223931660 + (char)-20515, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24749), 1223931660 + (char)-15872, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24768), 1223931660 + 21257, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24764), 1223931660 + (char)-20515, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1223931660 + -((char)-24750), 1223931660 + (char)-16113, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 134525483492424L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                stringArray = SshAgentIpcService.D();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482139560 + -11508, 1482139560 - 7907, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1482139560 + -11512, 1482139560 + 15505, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482139560 + -11493, -1482139560 - -7473, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1482139560 + -11492, 1482139560 - 579, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482139560 + -11508, 1482139560 - 7907, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1482139560 + -11512, 1482139560 + 15505, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482139560 + -11491, -1482139560 - -6513, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482139560 + -11508, 1482139560 - 7907, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1482139560 + -11512, 1482139560 + 15505, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482139560 + -11490, -1482139560 - -29, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482139560 + -11508, 1482139560 - 7907, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1482139560 + -11512, 1482139560 + 15505, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482139560 + -11489, 1482139560 + 9352, (int)l2));
                    if (stringArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482139560 + -11508, 1482139560 - 7907, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1482139560 + -11512, 1482139560 + 15505, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482139560 + -11536, 1482139560 + 21527, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1482139560 + -11535, -1482139560 + -13998, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00e2W{Z\u00ed\u00a6r\u00c1\u0014\u0085\u0003\u00af7\u0089\u0083Q\u007fl3\u0013\u00e7\u00ec\u00947\u00eb:<\u00d7B\u00060\u00e1!\u008c\u00cc=\u0018p+q\u0002\u00d0\u00e0x\u00d3\u0081\u00db\u00a1\u008a\u00dc\u00c6c#\u0019L\u009d\u00d1\u00ef`\u00a1\u00d1\t\r\u00d7@,\u009d\u00ba\u00c9\u00d0\u008b\u0005{yH\u009f\u00fb\b\u0013\u0082E\u0091x\u00f9\u00c6\u00c8\u00141\u00afA99Jr\u00d1f;\u00f9R\u00fb\u0081n\u00a4\u0003\u0006\tG\u0005C\u00bfOG\u001b\u001et\u00c7\u00bc,\u00f8\u00e1\u00df\u0089\u00d0\u0084\u00c0\u00e6\u00bck\u00cd\u00f2-\u00e7\u00c9P\u00c9\u007fi\u00ff\u00e4\u00dbF\u00c9\u00b6D\u0010\u00a18\u00e2\u0016d\u0094\u00ba\u00de\u0001\u00dcw\u0010L\u00e0|\u001c\t\u00a7\u00a0\u00c3\u00d3\u00beb\u008bT-\u0010g\u00b2:G\u007f\u00be\u00d9\u009bmt\u00fa\u0005\u00fdBJH?\u00fd\u00da\u0085\u008f\u00d2\u009c\u001fJ\u00b9-\u00a8(\u000eD\u00a6.\u0085\u0019\u00a1JJnb\u00bb\u0095\u00bbeq\u00e5\u0005\u0012gL\u00f6 \u008eT\u0013h\u00ed\u00c7\u00f7\u0002y\b\u009da!o\u008fh\u00f6\u00f6\r&\u0010.X\u00bc\u00e6\u00b5\u00b1\u0090\bi\u00ec\n\\\u0091@\u00fb\u00ff\f:5p|\u00c3&_4\u0094\u00c9\u0097\u00b6F\u008d1\u0086\u00fc\u001d6\u00846\u00ef\u0085\u00f2\u00fb\u00d36\u0002F\u00eds\u00ac\u00a8\u00f9`\u0017H\r\u00ee\u0085\u00d0F\u0018\\\u00f8\u00b9\u00b3\\\u0007\u0001oi\u00a6t\u008b\u00ff\ri\u0096\u0019=\u0087\u00f4\u00133v# \u00ceq\u00f7\u00c1\u00af)\u00f1_\u00e4\u0001\u0011(\u000fj!\u001f\u00b6\\\u00e4_\u00f3\u008f\u00beD\u00fc=E\u00d1\f\u0090\u00d0<\u00f5\u00d6\u00af\u00bc\u00ceb^\u00f7c\n\u00a1?Wk|\u000bnh\u00fa\u00d7\u0092Su\u009a\u00d1\u00105\u0015\u00cf\u009f\u00ce*\u0013\u0084\u00a9\u001dt\u0000I\u00bd3\u00b1*NQ\f\u00e6\u009e\u00d1)\u00e7\u00cf\u00ce-\u00b6\u00c1\u0016\u008d\u00e9\u0004\u00e7\u00f6\\~D\u00e48E\u00cdir\u00a0\u000f\u00b7&K\u00deo\u0097\u0095\u00e6w\u0010\u00e7\u000f\u0000u\u0092l\u00b0w\u0007V\u00a2\u00f2\u009a\u0015j\u00f9\u0007>h\u009b\u00af\u00df#\u00b6(\r\u000e\u00df4$\u0088\u00b2\u0083\r\u0012Q\u0002\u00a9a\u00b8\u0084\u00a0\u00e4p\u001e\u00a4p\u00baf\u0000\u00cd\u00ac\u00c4\u00ee\u0080\u0012\u00ccu\u00fb=.\u0089*`T\u000f\u0088\b!\u00dd\u0013\u00d9\u00f1j\u0010\u00a2SEI\u00dd:\":\u00abu\u00a1\u00c1P\u00f8\u00bf4B\\>(k\u00ae\u0088\u008e\u00e1\u0091\u00bf\u0013z\u0083\u00bc$~S\u0017\u0002\u00a8\u00f6\u00d7<\u0000\u000eL\u0005\u00b9|\u0000\u00ed\u0093\u00ec\\r\u00da_t\u0094\u001b\u00ab\u0017B;\u0084\u00b0\u0096\u001b\u00ab\u000b\u00a9qJg\u00c4\u001fk\u00b9\u0090(\b\u00bc\u0093\u00c2m\u00dc/\n\u00da\u008c\u00a8O\u00cd\u00dal|_\u0085\u0018}}\u0098{\u00de\u0004\u00fc\u00d3\u00f8\u00db\u0001\u00f4\u00e6\u0084\u00adB1\u0013\f\u0004\u00e3r\u00b5H)\u0015\u00fa\u0090\u008b}\u0015o\u0017\u00c6W\u0002\u009c\u00e4:\u00cc\u0017WN\u00ff\u00cd\u000e$\u00c9+\u008bJ\u00f6\u00a3\u00c1P\u0097^\u001b\u001c\u00bb\u00eb=\u00cbe\u009bV\t\u00e4x\u00ab\u00d6\u00b9\r=\u00e2F";
                var4_3 = "\u00e2W{Z\u00ed\u00a6r\u00c1\u0014\u0085\u0003\u00af7\u0089\u0083Q\u007fl3\u0013\u00e7\u00ec\u00947\u00eb:<\u00d7B\u00060\u00e1!\u008c\u00cc=\u0018p+q\u0002\u00d0\u00e0x\u00d3\u0081\u00db\u00a1\u008a\u00dc\u00c6c#\u0019L\u009d\u00d1\u00ef`\u00a1\u00d1\t\r\u00d7@,\u009d\u00ba\u00c9\u00d0\u008b\u0005{yH\u009f\u00fb\b\u0013\u0082E\u0091x\u00f9\u00c6\u00c8\u00141\u00afA99Jr\u00d1f;\u00f9R\u00fb\u0081n\u00a4\u0003\u0006\tG\u0005C\u00bfOG\u001b\u001et\u00c7\u00bc,\u00f8\u00e1\u00df\u0089\u00d0\u0084\u00c0\u00e6\u00bck\u00cd\u00f2-\u00e7\u00c9P\u00c9\u007fi\u00ff\u00e4\u00dbF\u00c9\u00b6D\u0010\u00a18\u00e2\u0016d\u0094\u00ba\u00de\u0001\u00dcw\u0010L\u00e0|\u001c\t\u00a7\u00a0\u00c3\u00d3\u00beb\u008bT-\u0010g\u00b2:G\u007f\u00be\u00d9\u009bmt\u00fa\u0005\u00fdBJH?\u00fd\u00da\u0085\u008f\u00d2\u009c\u001fJ\u00b9-\u00a8(\u000eD\u00a6.\u0085\u0019\u00a1JJnb\u00bb\u0095\u00bbeq\u00e5\u0005\u0012gL\u00f6 \u008eT\u0013h\u00ed\u00c7\u00f7\u0002y\b\u009da!o\u008fh\u00f6\u00f6\r&\u0010.X\u00bc\u00e6\u00b5\u00b1\u0090\bi\u00ec\n\\\u0091@\u00fb\u00ff\f:5p|\u00c3&_4\u0094\u00c9\u0097\u00b6F\u008d1\u0086\u00fc\u001d6\u00846\u00ef\u0085\u00f2\u00fb\u00d36\u0002F\u00eds\u00ac\u00a8\u00f9`\u0017H\r\u00ee\u0085\u00d0F\u0018\\\u00f8\u00b9\u00b3\\\u0007\u0001oi\u00a6t\u008b\u00ff\ri\u0096\u0019=\u0087\u00f4\u00133v# \u00ceq\u00f7\u00c1\u00af)\u00f1_\u00e4\u0001\u0011(\u000fj!\u001f\u00b6\\\u00e4_\u00f3\u008f\u00beD\u00fc=E\u00d1\f\u0090\u00d0<\u00f5\u00d6\u00af\u00bc\u00ceb^\u00f7c\n\u00a1?Wk|\u000bnh\u00fa\u00d7\u0092Su\u009a\u00d1\u00105\u0015\u00cf\u009f\u00ce*\u0013\u0084\u00a9\u001dt\u0000I\u00bd3\u00b1*NQ\f\u00e6\u009e\u00d1)\u00e7\u00cf\u00ce-\u00b6\u00c1\u0016\u008d\u00e9\u0004\u00e7\u00f6\\~D\u00e48E\u00cdir\u00a0\u000f\u00b7&K\u00deo\u0097\u0095\u00e6w\u0010\u00e7\u000f\u0000u\u0092l\u00b0w\u0007V\u00a2\u00f2\u009a\u0015j\u00f9\u0007>h\u009b\u00af\u00df#\u00b6(\r\u000e\u00df4$\u0088\u00b2\u0083\r\u0012Q\u0002\u00a9a\u00b8\u0084\u00a0\u00e4p\u001e\u00a4p\u00baf\u0000\u00cd\u00ac\u00c4\u00ee\u0080\u0012\u00ccu\u00fb=.\u0089*`T\u000f\u0088\b!\u00dd\u0013\u00d9\u00f1j\u0010\u00a2SEI\u00dd:\":\u00abu\u00a1\u00c1P\u00f8\u00bf4B\\>(k\u00ae\u0088\u008e\u00e1\u0091\u00bf\u0013z\u0083\u00bc$~S\u0017\u0002\u00a8\u00f6\u00d7<\u0000\u000eL\u0005\u00b9|\u0000\u00ed\u0093\u00ec\\r\u00da_t\u0094\u001b\u00ab\u0017B;\u0084\u00b0\u0096\u001b\u00ab\u000b\u00a9qJg\u00c4\u001fk\u00b9\u0090(\b\u00bc\u0093\u00c2m\u00dc/\n\u00da\u008c\u00a8O\u00cd\u00dal|_\u0085\u0018}}\u0098{\u00de\u0004\u00fc\u00d3\u00f8\u00db\u0001\u00f4\u00e6\u0084\u00adB1\u0013\f\u0004\u00e3r\u00b5H)\u0015\u00fa\u0090\u008b}\u0015o\u0017\u00c6W\u0002\u009c\u00e4:\u00cc\u0017WN\u00ff\u00cd\u000e$\u00c9+\u008bJ\u00f6\u00a3\u00c1P\u0097^\u001b\u001c\u00bb\u00eb=\u00cbe\u009bV\t\u00e4x\u00ab\u00d6\u00b9\r=\u00e2F".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 73;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00d6\u00d2Z<\u0096Q\u00a0-\u008d\u00a2\u00d9\u0090-\tG\u00c3\u0094je\u007f\u00ba\u00ff\u001e<h\u0006\u00a9\u00dd\b\u0014\u0083\u009f\u00dd\u0016u\u0015|\u001f{\u008dC\u0082T\u008a\u0092\u009a<\u00a0\u00a5c";
                    var4_3 = "\u00d6\u00d2Z<\u0096Q\u00a0-\u008d\u00a2\u00d9\u0090-\tG\u00c3\u0094je\u007f\u00ba\u00ff\u001e<h\u0006\u00a9\u00dd\b\u0014\u0083\u009f\u00dd\u0016u\u0015|\u001f{\u008dC\u0082T\u008a\u0092\u009a<\u00a0\u00a5c".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 48;
                            break;
                        }
                        case 1: {
                            v15 = 6;
                            break;
                        }
                        case 2: {
                            v15 = 79;
                            break;
                        }
                        case 3: {
                            v15 = 49;
                            break;
                        }
                        case 4: {
                            v15 = 37;
                            break;
                        }
                        case 5: {
                            v15 = 3;
                            break;
                        }
                        default: {
                            v15 = 37;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xF20) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 185;
                case 1 -> 13;
                case 2 -> 117;
                case 3 -> 218;
                case 4 -> 67;
                case 5 -> 85;
                case 6 -> 45;
                case 7 -> 181;
                case 8 -> 8;
                case 9 -> 6;
                case 10 -> 255;
                case 11 -> 23;
                case 12 -> 237;
                case 13 -> 129;
                case 14 -> 51;
                case 15 -> 101;
                case 16 -> 142;
                case 17 -> 186;
                case 18 -> 170;
                case 19 -> 159;
                case 20 -> 207;
                case 21 -> 11;
                case 22 -> 57;
                case 23 -> 201;
                case 24 -> 120;
                case 25 -> 212;
                case 26 -> 144;
                case 27 -> 16;
                case 28 -> 53;
                case 29 -> 31;
                case 30 -> 20;
                case 31 -> 188;
                case 32 -> 198;
                case 33 -> 219;
                case 34 -> 206;
                case 35 -> 50;
                case 36 -> 10;
                case 37 -> 47;
                case 38 -> 29;
                case 39 -> 59;
                case 40 -> 234;
                case 41 -> 26;
                case 42 -> 113;
                case 43 -> 136;
                case 44 -> 133;
                case 45 -> 155;
                case 46 -> 169;
                case 47 -> 21;
                case 48 -> 192;
                case 49 -> 33;
                case 50 -> 143;
                case 51 -> 242;
                case 52 -> 68;
                case 53 -> 116;
                case 54 -> 139;
                case 55 -> 123;
                case 56 -> 216;
                case 57 -> 247;
                case 58 -> 39;
                case 59 -> 5;
                case 60 -> 90;
                case 61 -> 40;
                case 62 -> 233;
                case 63 -> 77;
                case 64 -> 223;
                case 65 -> 174;
                case 66 -> 17;
                case 67 -> 27;
                case 68 -> 119;
                case 69 -> 221;
                case 70 -> 194;
                case 71 -> 88;
                case 72 -> 254;
                case 73 -> 166;
                case 74 -> 149;
                case 75 -> 196;
                case 76 -> 0;
                case 77 -> 172;
                case 78 -> 162;
                case 79 -> 148;
                case 80 -> 153;
                case 81 -> 32;
                case 82 -> 191;
                case 83 -> 195;
                case 84 -> 180;
                case 85 -> 89;
                case 86 -> 124;
                case 87 -> 42;
                case 88 -> 46;
                case 89 -> 9;
                case 90 -> 108;
                case 91 -> 58;
                case 92 -> 87;
                case 93 -> 121;
                case 94 -> 56;
                case 95 -> 145;
                case 96 -> 61;
                case 97 -> 230;
                case 98 -> 214;
                case 99 -> 118;
                case 100 -> 226;
                case 101 -> 7;
                case 102 -> 160;
                case 103 -> 187;
                case 104 -> 243;
                case 105 -> 112;
                case 106 -> 239;
                case 107 -> 183;
                case 108 -> 231;
                case 109 -> 210;
                case 110 -> 229;
                case 111 -> 134;
                case 112 -> 228;
                case 113 -> 193;
                case 114 -> 98;
                case 115 -> 225;
                case 116 -> 222;
                case 117 -> 208;
                case 118 -> 97;
                case 119 -> 115;
                case 120 -> 152;
                case 121 -> 102;
                case 122 -> 43;
                case 123 -> 105;
                case 124 -> 184;
                case 125 -> 54;
                case 126 -> 63;
                case 127 -> 55;
                case 128 -> 37;
                case 129 -> 80;
                case 130 -> 202;
                case 131 -> 109;
                case 132 -> 244;
                case 133 -> 154;
                case 134 -> 71;
                case 135 -> 66;
                case 136 -> 249;
                case 137 -> 106;
                case 138 -> 178;
                case 139 -> 248;
                case 140 -> 92;
                case 141 -> 15;
                case 142 -> 215;
                case 143 -> 3;
                case 144 -> 147;
                case 145 -> 182;
                case 146 -> 171;
                case 147 -> 107;
                case 148 -> 65;
                case 149 -> 25;
                case 150 -> 110;
                case 151 -> 100;
                case 152 -> 93;
                case 153 -> 203;
                case 154 -> 138;
                case 155 -> 86;
                case 156 -> 164;
                case 157 -> 209;
                case 158 -> 104;
                case 159 -> 151;
                case 160 -> 94;
                case 161 -> 177;
                case 162 -> 140;
                case 163 -> 158;
                case 164 -> 211;
                case 165 -> 245;
                case 166 -> 126;
                case 167 -> 28;
                case 168 -> 238;
                case 169 -> 241;
                case 170 -> 49;
                case 171 -> 220;
                case 172 -> 48;
                case 173 -> 44;
                case 174 -> 70;
                case 175 -> 81;
                case 176 -> 99;
                case 177 -> 163;
                case 178 -> 200;
                case 179 -> 18;
                case 180 -> 52;
                case 181 -> 95;
                case 182 -> 114;
                case 183 -> 35;
                case 184 -> 251;
                case 185 -> 227;
                case 186 -> 30;
                case 187 -> 62;
                case 188 -> 190;
                case 189 -> 2;
                case 190 -> 128;
                case 191 -> 204;
                case 192 -> 38;
                case 193 -> 232;
                case 194 -> 24;
                case 195 -> 41;
                case 196 -> 253;
                case 197 -> 224;
                case 198 -> 213;
                case 199 -> 74;
                case 200 -> 76;
                case 201 -> 34;
                case 202 -> 73;
                case 203 -> 103;
                case 204 -> 75;
                case 205 -> 1;
                case 206 -> 91;
                case 207 -> 235;
                case 208 -> 150;
                case 209 -> 111;
                case 210 -> 217;
                case 211 -> 176;
                case 212 -> 82;
                case 213 -> 22;
                case 214 -> 12;
                case 215 -> 19;
                case 216 -> 167;
                case 217 -> 130;
                case 218 -> 122;
                case 219 -> 173;
                case 220 -> 157;
                case 221 -> 84;
                case 222 -> 72;
                case 223 -> 131;
                case 224 -> 199;
                case 225 -> 240;
                case 226 -> 156;
                case 227 -> 69;
                case 228 -> 60;
                case 229 -> 141;
                case 230 -> 79;
                case 231 -> 127;
                case 232 -> 125;
                case 233 -> 137;
                case 234 -> 179;
                case 235 -> 78;
                case 236 -> 168;
                case 237 -> 250;
                case 238 -> 205;
                case 239 -> 4;
                case 240 -> 236;
                case 241 -> 165;
                case 242 -> 132;
                case 243 -> 146;
                case 244 -> 14;
                case 245 -> 83;
                case 246 -> 175;
                case 247 -> 64;
                case 248 -> 36;
                case 249 -> 246;
                case 250 -> 96;
                case 251 -> 252;
                case 252 -> 135;
                case 253 -> 161;
                case 254 -> 189;
                default -> 197;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 47438010232771L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(96467520 - 8594, -96467520 - -21220, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 131952796010075L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.D();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1484236680 - -((char)-26433), -1484236680 - -((char)-22691), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1484236680 - -((char)-26436), -1484236680 - -14190, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1484236680 - -((char)-26435), -1484236680 - -11605, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b5\u00e7T^\u00b2\u000e\u001e\u00f4\u0010\u00f7\u00e5\u00ed\u00bf?\u0089V]\u00f0i[\u001c\u00e1\u00e6\u00e9\u00b0";
                    var4_3 = "\u00b5\u00e7T^\u00b2\u000e\u001e\u00f4\u0010\u00f7\u00e5\u00ed\u00bf?\u0089V]\u00f0i[\u001c\u00e1\u00e6\u00e9\u00b0".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 58;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "<B\u001b\u0094U5\b\u00bc\u008a'\u00b5\u00dda\u0002\u001fGJgJ\u001d\u00e7;\b\u001eCm\u00f3Q\u00eb\u00b3\u00a9\u00d1\u00ab\u00ef\u00f2\u00f4\u009are\u00be\u00f8\u0098\u0098@\u00d9(\u0017\u0099\u00d1N\u009c\u00fc\u00c5\u00c9\u00b6:R\u00de\u0098";
                        var4_3 = "<B\u001b\u0094U5\b\u00bc\u008a'\u00b5\u00dda\u0002\u001fGJgJ\u001d\u00e7;\b\u001eCm\u00f3Q\u00eb\u00b3\u00a9\u00d1\u00ab\u00ef\u00f2\u00f4\u009are\u00be\u00f8\u0098\u0098@\u00d9(\u0017\u0099\u00d1N\u009c\u00fc\u00c5\u00c9\u00b6:R\u00de\u0098".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 74;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 14;
                                break;
                            }
                            case 1: {
                                v15 = 53;
                                break;
                            }
                            case 2: {
                                v15 = 80;
                                break;
                            }
                            case 3: {
                                v15 = 88;
                                break;
                            }
                            case 4: {
                                v15 = 97;
                                break;
                            }
                            case 5: {
                                v15 = 27;
                                break;
                            }
                            default: {
                                v15 = 55;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x776D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 166;
                    case 1 -> 56;
                    case 2 -> 245;
                    case 3 -> 17;
                    case 4 -> 194;
                    case 5 -> 229;
                    case 6 -> 80;
                    case 7 -> 191;
                    case 8 -> 239;
                    case 9 -> 233;
                    case 10 -> 88;
                    case 11 -> 221;
                    case 12 -> 92;
                    case 13 -> 115;
                    case 14 -> 184;
                    case 15 -> 20;
                    case 16 -> 29;
                    case 17 -> 122;
                    case 18 -> 138;
                    case 19 -> 228;
                    case 20 -> 8;
                    case 21 -> 111;
                    case 22 -> 102;
                    case 23 -> 172;
                    case 24 -> 59;
                    case 25 -> 24;
                    case 26 -> 174;
                    case 27 -> 141;
                    case 28 -> 149;
                    case 29 -> 120;
                    case 30 -> 151;
                    case 31 -> 156;
                    case 32 -> 244;
                    case 33 -> 45;
                    case 34 -> 108;
                    case 35 -> 136;
                    case 36 -> 41;
                    case 37 -> 23;
                    case 38 -> 30;
                    case 39 -> 83;
                    case 40 -> 1;
                    case 41 -> 90;
                    case 42 -> 142;
                    case 43 -> 243;
                    case 44 -> 240;
                    case 45 -> 13;
                    case 46 -> 223;
                    case 47 -> 101;
                    case 48 -> 251;
                    case 49 -> 224;
                    case 50 -> 146;
                    case 51 -> 247;
                    case 52 -> 110;
                    case 53 -> 222;
                    case 54 -> 134;
                    case 55 -> 63;
                    case 56 -> 220;
                    case 57 -> 105;
                    case 58 -> 21;
                    case 59 -> 2;
                    case 60 -> 161;
                    case 61 -> 175;
                    case 62 -> 128;
                    case 63 -> 6;
                    case 64 -> 64;
                    case 65 -> 241;
                    case 66 -> 208;
                    case 67 -> 154;
                    case 68 -> 81;
                    case 69 -> 95;
                    case 70 -> 198;
                    case 71 -> 246;
                    case 72 -> 57;
                    case 73 -> 159;
                    case 74 -> 5;
                    case 75 -> 66;
                    case 76 -> 32;
                    case 77 -> 249;
                    case 78 -> 209;
                    case 79 -> 210;
                    case 80 -> 104;
                    case 81 -> 65;
                    case 82 -> 38;
                    case 83 -> 216;
                    case 84 -> 231;
                    case 85 -> 177;
                    case 86 -> 204;
                    case 87 -> 188;
                    case 88 -> 162;
                    case 89 -> 70;
                    case 90 -> 235;
                    case 91 -> 157;
                    case 92 -> 87;
                    case 93 -> 160;
                    case 94 -> 153;
                    case 95 -> 53;
                    case 96 -> 214;
                    case 97 -> 89;
                    case 98 -> 50;
                    case 99 -> 227;
                    case 100 -> 68;
                    case 101 -> 135;
                    case 102 -> 27;
                    case 103 -> 82;
                    case 104 -> 127;
                    case 105 -> 238;
                    case 106 -> 58;
                    case 107 -> 98;
                    case 108 -> 197;
                    case 109 -> 178;
                    case 110 -> 100;
                    case 111 -> 226;
                    case 112 -> 126;
                    case 113 -> 186;
                    case 114 -> 179;
                    case 115 -> 91;
                    case 116 -> 236;
                    case 117 -> 103;
                    case 118 -> 213;
                    case 119 -> 26;
                    case 120 -> 181;
                    case 121 -> 55;
                    case 122 -> 33;
                    case 123 -> 69;
                    case 124 -> 200;
                    case 125 -> 85;
                    case 126 -> 133;
                    case 127 -> 150;
                    case 128 -> 106;
                    case 129 -> 118;
                    case 130 -> 152;
                    case 131 -> 205;
                    case 132 -> 237;
                    case 133 -> 109;
                    case 134 -> 84;
                    case 135 -> 148;
                    case 136 -> 195;
                    case 137 -> 170;
                    case 138 -> 219;
                    case 139 -> 171;
                    case 140 -> 34;
                    case 141 -> 185;
                    case 142 -> 73;
                    case 143 -> 167;
                    case 144 -> 253;
                    case 145 -> 22;
                    case 146 -> 94;
                    case 147 -> 168;
                    case 148 -> 107;
                    case 149 -> 52;
                    case 150 -> 217;
                    case 151 -> 139;
                    case 152 -> 193;
                    case 153 -> 202;
                    case 154 -> 116;
                    case 155 -> 25;
                    case 156 -> 67;
                    case 157 -> 212;
                    case 158 -> 78;
                    case 159 -> 40;
                    case 160 -> 36;
                    case 161 -> 18;
                    case 162 -> 7;
                    case 163 -> 187;
                    case 164 -> 117;
                    case 165 -> 113;
                    case 166 -> 114;
                    case 167 -> 169;
                    case 168 -> 218;
                    case 169 -> 112;
                    case 170 -> 4;
                    case 171 -> 189;
                    case 172 -> 158;
                    case 173 -> 39;
                    case 174 -> 131;
                    case 175 -> 75;
                    case 176 -> 42;
                    case 177 -> 35;
                    case 178 -> 12;
                    case 179 -> 211;
                    case 180 -> 54;
                    case 181 -> 230;
                    case 182 -> 46;
                    case 183 -> 119;
                    case 184 -> 49;
                    case 185 -> 140;
                    case 186 -> 76;
                    case 187 -> 37;
                    case 188 -> 47;
                    case 189 -> 252;
                    case 190 -> 62;
                    case 191 -> 79;
                    case 192 -> 190;
                    case 193 -> 71;
                    case 194 -> 77;
                    case 195 -> 234;
                    case 196 -> 201;
                    case 197 -> 124;
                    case 198 -> 0;
                    case 199 -> 182;
                    case 200 -> 51;
                    case 201 -> 199;
                    case 202 -> 43;
                    case 203 -> 3;
                    case 204 -> 206;
                    case 205 -> 72;
                    case 206 -> 242;
                    case 207 -> 248;
                    case 208 -> 165;
                    case 209 -> 232;
                    case 210 -> 137;
                    case 211 -> 225;
                    case 212 -> 10;
                    case 213 -> 203;
                    case 214 -> 19;
                    case 215 -> 97;
                    case 216 -> 145;
                    case 217 -> 9;
                    case 218 -> 164;
                    case 219 -> 196;
                    case 220 -> 183;
                    case 221 -> 48;
                    case 222 -> 254;
                    case 223 -> 207;
                    case 224 -> 130;
                    case 225 -> 163;
                    case 226 -> 60;
                    case 227 -> 99;
                    case 228 -> 147;
                    case 229 -> 155;
                    case 230 -> 180;
                    case 231 -> 144;
                    case 232 -> 143;
                    case 233 -> 11;
                    case 234 -> 61;
                    case 235 -> 15;
                    case 236 -> 93;
                    case 237 -> 123;
                    case 238 -> 28;
                    case 239 -> 215;
                    case 240 -> 16;
                    case 241 -> 125;
                    case 242 -> 14;
                    case 243 -> 31;
                    case 244 -> 250;
                    case 245 -> 192;
                    case 246 -> 176;
                    case 247 -> 86;
                    case 248 -> 121;
                    case 249 -> 255;
                    case 250 -> 74;
                    case 251 -> 96;
                    case 252 -> 129;
                    case 253 -> 132;
                    case 254 -> 173;
                    default -> 44;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 20620000400227L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u000fK\u0013M+coV\t\bA\u0000Gf!rJ\u0007";
                    var5_4 = "\u000fK\u0013M+coV\t\bA\u0000Gf!rJ\u0007".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 83;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 55;
                                    break;
                                }
                                case 1: {
                                    v11 = 125;
                                    break;
                                }
                                case 2: {
                                    v11 = 50;
                                    break;
                                }
                                case 3: {
                                    v11 = 112;
                                    break;
                                }
                                case 4: {
                                    v11 = 29;
                                    break;
                                }
                                case 5: {
                                    v11 = 92;
                                    break;
                                }
                                default: {
                                    v11 = 15;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 35305474825821L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "&axg)w\u0010\u0004 \u007ft}\n,`\u007f}%u\b\u0006av\t,`\u007f}%u\b\nk\r+fbp/x\u0012\nlez.q";
                    var5_4 = "&axg)w\u0010\u0004 \u007ft}\n,`\u007f}%u\b\u0006av\t,`\u007f}%u\b\nk\r+fbp/x\u0012\nlez.q".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 118;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0003LQO\u0006W4\u0006\u0003LQO\n]";
                        var5_4 = "\u0003LQO\u0006W4\u0006\u0003LQO\n]".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 89;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 25;
                                break;
                            }
                            case 1: {
                                v15 = 121;
                                break;
                            }
                            case 2: {
                                v15 = 103;
                                break;
                            }
                            case 3: {
                                v15 = 101;
                                break;
                            }
                            case 4: {
                                v15 = 54;
                                break;
                            }
                            case 5: {
                                v15 = 96;
                                break;
                            }
                            default: {
                                v15 = 10;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 101071642189188L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1823183700 + -12612, 1823183700 + 19455, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 94934207703274L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00d45\u00d5\u000e\"\u0003E\u00e1S\u0005s\u00d4\u0007\u00f6\u009b\r\u00b8\u00beH\u00f1\u0087\u00d1`\u0001\u00fc\u00ed\u00f7\u00f2\u0096\u00103\u00ff\u00fe2n<v\u0081\u00f7yu- \u00ca\u00bb6\u0005\u009f\u00f6\u009a\u00b2(3\u0004\u00b6\u00f8\u00cd{\u0087\u00e4\u00e2\u00d8\u00e8\u001b6+\u00f8\u00f6o\u00ef?\u00853\u00f8\u0088\u0091\u00f5\u009d\u00cb\u00be\u008e\u00fa\u0011Q#\u0090H\u00d29Z\u00c3\u0081\u001f\u00fbQI\u0018\u000b\u00f4\u0014\u0098q4'";
                    var4_3 = "\u00d45\u00d5\u000e\"\u0003E\u00e1S\u0005s\u00d4\u0007\u00f6\u009b\r\u00b8\u00beH\u00f1\u0087\u00d1`\u0001\u00fc\u00ed\u00f7\u00f2\u0096\u00103\u00ff\u00fe2n<v\u0081\u00f7yu- \u00ca\u00bb6\u0005\u009f\u00f6\u009a\u00b2(3\u0004\u00b6\u00f8\u00cd{\u0087\u00e4\u00e2\u00d8\u00e8\u001b6+\u00f8\u00f6o\u00ef?\u00853\u00f8\u0088\u0091\u00f5\u009d\u00cb\u00be\u008e\u00fa\u0011Q#\u0090H\u00d29Z\u00c3\u0081\u001f\u00fbQI\u0018\u000b\u00f4\u0014\u0098q4'".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 76;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0091\u00b6x\u00c9l\u0091\u00e4\u00e6wG\u00b78\u00aa\u00ba8\u00eaL\u00ce[d\u00be\u00c5\u00b7\u00bfL\u0095\u0081GY\u00ba\u0018\u00a9\u00c7\u00d3)/\u00d5\u0017\u00e2\u0094\u00c8\u00ccUcIir\u001e\u00f2\u00bbN\u00147b\u000en\u0012\u00e2\u00dfwf\u000b7\r\nr\u0080}:u\u0016W\u00de\u009c\u00e8\u00b9\u00c7z\u0013\u009eU\u00f1\u00bb\u00c2``\u00c4\u00a4\u008c\u009d\u007f\u00eb\u0088";
                        var4_3 = "\u0091\u00b6x\u00c9l\u0091\u00e4\u00e6wG\u00b78\u00aa\u00ba8\u00eaL\u00ce[d\u00be\u00c5\u00b7\u00bfL\u0095\u0081GY\u00ba\u0018\u00a9\u00c7\u00d3)/\u00d5\u0017\u00e2\u0094\u00c8\u00ccUcIir\u001e\u00f2\u00bbN\u00147b\u000en\u0012\u00e2\u00dfwf\u000b7\r\nr\u0080}:u\u0016W\u00de\u009c\u00e8\u00b9\u00c7z\u0013\u009eU\u00f1\u00bb\u00c2``\u00c4\u00a4\u008c\u009d\u007f\u00eb\u0088".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 49;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 62;
                                break;
                            }
                            case 1: {
                                v15 = 108;
                                break;
                            }
                            case 2: {
                                v15 = 101;
                                break;
                            }
                            case 3: {
                                v15 = 5;
                                break;
                            }
                            case 4: {
                                v15 = 76;
                                break;
                            }
                            case 5: {
                                v15 = 12;
                                break;
                            }
                            default: {
                                v15 = 32;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x66EC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 22;
                    case 1 -> 118;
                    case 2 -> 174;
                    case 3 -> 57;
                    case 4 -> 8;
                    case 5 -> 212;
                    case 6 -> 235;
                    case 7 -> 1;
                    case 8 -> 64;
                    case 9 -> 6;
                    case 10 -> 241;
                    case 11 -> 65;
                    case 12 -> 99;
                    case 13 -> 85;
                    case 14 -> 210;
                    case 15 -> 21;
                    case 16 -> 114;
                    case 17 -> 119;
                    case 18 -> 177;
                    case 19 -> 243;
                    case 20 -> 144;
                    case 21 -> 182;
                    case 22 -> 153;
                    case 23 -> 78;
                    case 24 -> 89;
                    case 25 -> 101;
                    case 26 -> 71;
                    case 27 -> 239;
                    case 28 -> 103;
                    case 29 -> 90;
                    case 30 -> 163;
                    case 31 -> 102;
                    case 32 -> 244;
                    case 33 -> 133;
                    case 34 -> 125;
                    case 35 -> 15;
                    case 36 -> 139;
                    case 37 -> 211;
                    case 38 -> 206;
                    case 39 -> 146;
                    case 40 -> 231;
                    case 41 -> 198;
                    case 42 -> 158;
                    case 43 -> 140;
                    case 44 -> 10;
                    case 45 -> 18;
                    case 46 -> 31;
                    case 47 -> 134;
                    case 48 -> 178;
                    case 49 -> 164;
                    case 50 -> 167;
                    case 51 -> 35;
                    case 52 -> 132;
                    case 53 -> 52;
                    case 54 -> 50;
                    case 55 -> 26;
                    case 56 -> 185;
                    case 57 -> 143;
                    case 58 -> 141;
                    case 59 -> 13;
                    case 60 -> 187;
                    case 61 -> 201;
                    case 62 -> 100;
                    case 63 -> 155;
                    case 64 -> 58;
                    case 65 -> 24;
                    case 66 -> 62;
                    case 67 -> 225;
                    case 68 -> 88;
                    case 69 -> 110;
                    case 70 -> 157;
                    case 71 -> 218;
                    case 72 -> 29;
                    case 73 -> 245;
                    case 74 -> 188;
                    case 75 -> 173;
                    case 76 -> 229;
                    case 77 -> 248;
                    case 78 -> 228;
                    case 79 -> 233;
                    case 80 -> 172;
                    case 81 -> 67;
                    case 82 -> 97;
                    case 83 -> 38;
                    case 84 -> 27;
                    case 85 -> 138;
                    case 86 -> 179;
                    case 87 -> 242;
                    case 88 -> 252;
                    case 89 -> 41;
                    case 90 -> 46;
                    case 91 -> 223;
                    case 92 -> 33;
                    case 93 -> 226;
                    case 94 -> 91;
                    case 95 -> 131;
                    case 96 -> 69;
                    case 97 -> 5;
                    case 98 -> 249;
                    case 99 -> 32;
                    case 100 -> 3;
                    case 101 -> 184;
                    case 102 -> 60;
                    case 103 -> 121;
                    case 104 -> 11;
                    case 105 -> 63;
                    case 106 -> 79;
                    case 107 -> 238;
                    case 108 -> 0;
                    case 109 -> 232;
                    case 110 -> 220;
                    case 111 -> 230;
                    case 112 -> 203;
                    case 113 -> 36;
                    case 114 -> 113;
                    case 115 -> 115;
                    case 116 -> 224;
                    case 117 -> 51;
                    case 118 -> 250;
                    case 119 -> 246;
                    case 120 -> 156;
                    case 121 -> 216;
                    case 122 -> 194;
                    case 123 -> 129;
                    case 124 -> 75;
                    case 125 -> 219;
                    case 126 -> 122;
                    case 127 -> 154;
                    case 128 -> 145;
                    case 129 -> 192;
                    case 130 -> 149;
                    case 131 -> 186;
                    case 132 -> 37;
                    case 133 -> 94;
                    case 134 -> 142;
                    case 135 -> 175;
                    case 136 -> 168;
                    case 137 -> 12;
                    case 138 -> 197;
                    case 139 -> 61;
                    case 140 -> 247;
                    case 141 -> 54;
                    case 142 -> 28;
                    case 143 -> 40;
                    case 144 -> 205;
                    case 145 -> 199;
                    case 146 -> 81;
                    case 147 -> 30;
                    case 148 -> 148;
                    case 149 -> 128;
                    case 150 -> 43;
                    case 151 -> 14;
                    case 152 -> 202;
                    case 153 -> 108;
                    case 154 -> 240;
                    case 155 -> 255;
                    case 156 -> 159;
                    case 157 -> 20;
                    case 158 -> 209;
                    case 159 -> 45;
                    case 160 -> 190;
                    case 161 -> 59;
                    case 162 -> 56;
                    case 163 -> 171;
                    case 164 -> 170;
                    case 165 -> 77;
                    case 166 -> 16;
                    case 167 -> 107;
                    case 168 -> 49;
                    case 169 -> 166;
                    case 170 -> 83;
                    case 171 -> 93;
                    case 172 -> 55;
                    case 173 -> 135;
                    case 174 -> 222;
                    case 175 -> 136;
                    case 176 -> 165;
                    case 177 -> 76;
                    case 178 -> 73;
                    case 179 -> 47;
                    case 180 -> 120;
                    case 181 -> 160;
                    case 182 -> 82;
                    case 183 -> 68;
                    case 184 -> 87;
                    case 185 -> 176;
                    case 186 -> 236;
                    case 187 -> 213;
                    case 188 -> 123;
                    case 189 -> 117;
                    case 190 -> 181;
                    case 191 -> 74;
                    case 192 -> 221;
                    case 193 -> 111;
                    case 194 -> 152;
                    case 195 -> 254;
                    case 196 -> 95;
                    case 197 -> 86;
                    case 198 -> 127;
                    case 199 -> 80;
                    case 200 -> 116;
                    case 201 -> 84;
                    case 202 -> 7;
                    case 203 -> 189;
                    case 204 -> 104;
                    case 205 -> 48;
                    case 206 -> 126;
                    case 207 -> 4;
                    case 208 -> 42;
                    case 209 -> 162;
                    case 210 -> 208;
                    case 211 -> 227;
                    case 212 -> 237;
                    case 213 -> 207;
                    case 214 -> 147;
                    case 215 -> 234;
                    case 216 -> 44;
                    case 217 -> 66;
                    case 218 -> 9;
                    case 219 -> 112;
                    case 220 -> 109;
                    case 221 -> 200;
                    case 222 -> 53;
                    case 223 -> 169;
                    case 224 -> 215;
                    case 225 -> 19;
                    case 226 -> 214;
                    case 227 -> 253;
                    case 228 -> 39;
                    case 229 -> 105;
                    case 230 -> 25;
                    case 231 -> 98;
                    case 232 -> 196;
                    case 233 -> 151;
                    case 234 -> 161;
                    case 235 -> 72;
                    case 236 -> 137;
                    case 237 -> 70;
                    case 238 -> 150;
                    case 239 -> 106;
                    case 240 -> 191;
                    case 241 -> 183;
                    case 242 -> 193;
                    case 243 -> 180;
                    case 244 -> 92;
                    case 245 -> 251;
                    case 246 -> 124;
                    case 247 -> 34;
                    case 248 -> 217;
                    case 249 -> 204;
                    case 250 -> 2;
                    case 251 -> 17;
                    case 252 -> 96;
                    case 253 -> 23;
                    case 254 -> 130;
                    default -> 195;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 114512864330342L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(446293350 - 24986, 446293350 - 14677, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 63308373668797L;
                    String[] stringArray = SshAgentIpcService.D();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(555736800 + 4918, -555736800 - -19613, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 140194688086901L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00f8\u00db\u00ea\u00a3\u00c1\u0003/,F";
                var4_3 = "\u00f8\u00db\u00ea\u00a3\u00c1\u0003/,F".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 82;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 38;
                                break;
                            }
                            case 1: {
                                v11 = 10;
                                break;
                            }
                            case 2: {
                                v11 = 1;
                                break;
                            }
                            case 3: {
                                v11 = 100;
                                break;
                            }
                            case 4: {
                                v11 = 25;
                                break;
                            }
                            case 5: {
                                v11 = 127;
                                break;
                            }
                            default: {
                                v11 = 22;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x41AA) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 212;
                    case 1 -> 158;
                    case 2 -> 154;
                    case 3 -> 211;
                    case 4 -> 115;
                    case 5 -> 106;
                    case 6 -> 108;
                    case 7 -> 86;
                    case 8 -> 95;
                    case 9 -> 204;
                    case 10 -> 240;
                    case 11 -> 244;
                    case 12 -> 39;
                    case 13 -> 136;
                    case 14 -> 237;
                    case 15 -> 164;
                    case 16 -> 139;
                    case 17 -> 130;
                    case 18 -> 197;
                    case 19 -> 218;
                    case 20 -> 183;
                    case 21 -> 62;
                    case 22 -> 60;
                    case 23 -> 97;
                    case 24 -> 19;
                    case 25 -> 251;
                    case 26 -> 99;
                    case 27 -> 36;
                    case 28 -> 120;
                    case 29 -> 219;
                    case 30 -> 156;
                    case 31 -> 52;
                    case 32 -> 125;
                    case 33 -> 2;
                    case 34 -> 190;
                    case 35 -> 128;
                    case 36 -> 68;
                    case 37 -> 231;
                    case 38 -> 162;
                    case 39 -> 82;
                    case 40 -> 195;
                    case 41 -> 227;
                    case 42 -> 15;
                    case 43 -> 29;
                    case 44 -> 46;
                    case 45 -> 104;
                    case 46 -> 169;
                    case 47 -> 202;
                    case 48 -> 76;
                    case 49 -> 233;
                    case 50 -> 111;
                    case 51 -> 226;
                    case 52 -> 238;
                    case 53 -> 180;
                    case 54 -> 147;
                    case 55 -> 31;
                    case 56 -> 92;
                    case 57 -> 179;
                    case 58 -> 45;
                    case 59 -> 8;
                    case 60 -> 1;
                    case 61 -> 255;
                    case 62 -> 254;
                    case 63 -> 121;
                    case 64 -> 25;
                    case 65 -> 49;
                    case 66 -> 249;
                    case 67 -> 246;
                    case 68 -> 18;
                    case 69 -> 142;
                    case 70 -> 210;
                    case 71 -> 26;
                    case 72 -> 230;
                    case 73 -> 102;
                    case 74 -> 225;
                    case 75 -> 17;
                    case 76 -> 141;
                    case 77 -> 186;
                    case 78 -> 174;
                    case 79 -> 34;
                    case 80 -> 101;
                    case 81 -> 54;
                    case 82 -> 105;
                    case 83 -> 74;
                    case 84 -> 163;
                    case 85 -> 193;
                    case 86 -> 206;
                    case 87 -> 94;
                    case 88 -> 175;
                    case 89 -> 112;
                    case 90 -> 144;
                    case 91 -> 216;
                    case 92 -> 3;
                    case 93 -> 20;
                    case 94 -> 152;
                    case 95 -> 166;
                    case 96 -> 236;
                    case 97 -> 185;
                    case 98 -> 98;
                    case 99 -> 58;
                    case 100 -> 64;
                    case 101 -> 229;
                    case 102 -> 103;
                    case 103 -> 84;
                    case 104 -> 40;
                    case 105 -> 88;
                    case 106 -> 253;
                    case 107 -> 192;
                    case 108 -> 72;
                    case 109 -> 133;
                    case 110 -> 146;
                    case 111 -> 182;
                    case 112 -> 109;
                    case 113 -> 123;
                    case 114 -> 201;
                    case 115 -> 80;
                    case 116 -> 208;
                    case 117 -> 33;
                    case 118 -> 172;
                    case 119 -> 140;
                    case 120 -> 0;
                    case 121 -> 114;
                    case 122 -> 5;
                    case 123 -> 24;
                    case 124 -> 215;
                    case 125 -> 93;
                    case 126 -> 116;
                    case 127 -> 77;
                    case 128 -> 198;
                    case 129 -> 148;
                    case 130 -> 100;
                    case 131 -> 16;
                    case 132 -> 239;
                    case 133 -> 75;
                    case 134 -> 189;
                    case 135 -> 252;
                    case 136 -> 194;
                    case 137 -> 69;
                    case 138 -> 248;
                    case 139 -> 35;
                    case 140 -> 138;
                    case 141 -> 41;
                    case 142 -> 234;
                    case 143 -> 11;
                    case 144 -> 149;
                    case 145 -> 232;
                    case 146 -> 53;
                    case 147 -> 207;
                    case 148 -> 65;
                    case 149 -> 119;
                    case 150 -> 7;
                    case 151 -> 178;
                    case 152 -> 131;
                    case 153 -> 167;
                    case 154 -> 43;
                    case 155 -> 70;
                    case 156 -> 135;
                    case 157 -> 63;
                    case 158 -> 129;
                    case 159 -> 32;
                    case 160 -> 217;
                    case 161 -> 59;
                    case 162 -> 12;
                    case 163 -> 48;
                    case 164 -> 22;
                    case 165 -> 184;
                    case 166 -> 6;
                    case 167 -> 61;
                    case 168 -> 177;
                    case 169 -> 30;
                    case 170 -> 223;
                    case 171 -> 9;
                    case 172 -> 90;
                    case 173 -> 113;
                    case 174 -> 38;
                    case 175 -> 153;
                    case 176 -> 37;
                    case 177 -> 66;
                    case 178 -> 85;
                    case 179 -> 188;
                    case 180 -> 78;
                    case 181 -> 157;
                    case 182 -> 150;
                    case 183 -> 122;
                    case 184 -> 73;
                    case 185 -> 132;
                    case 186 -> 243;
                    case 187 -> 23;
                    case 188 -> 134;
                    case 189 -> 224;
                    case 190 -> 55;
                    case 191 -> 143;
                    case 192 -> 214;
                    case 193 -> 126;
                    case 194 -> 67;
                    case 195 -> 250;
                    case 196 -> 96;
                    case 197 -> 168;
                    case 198 -> 56;
                    case 199 -> 181;
                    case 200 -> 159;
                    case 201 -> 222;
                    case 202 -> 160;
                    case 203 -> 87;
                    case 204 -> 13;
                    case 205 -> 50;
                    case 206 -> 127;
                    case 207 -> 173;
                    case 208 -> 28;
                    case 209 -> 200;
                    case 210 -> 191;
                    case 211 -> 199;
                    case 212 -> 161;
                    case 213 -> 205;
                    case 214 -> 110;
                    case 215 -> 151;
                    case 216 -> 81;
                    case 217 -> 14;
                    case 218 -> 220;
                    case 219 -> 107;
                    case 220 -> 117;
                    case 221 -> 247;
                    case 222 -> 47;
                    case 223 -> 187;
                    case 224 -> 137;
                    case 225 -> 176;
                    case 226 -> 209;
                    case 227 -> 124;
                    case 228 -> 235;
                    case 229 -> 171;
                    case 230 -> 242;
                    case 231 -> 203;
                    case 232 -> 79;
                    case 233 -> 165;
                    case 234 -> 196;
                    case 235 -> 118;
                    case 236 -> 71;
                    case 237 -> 155;
                    case 238 -> 42;
                    case 239 -> 83;
                    case 240 -> 4;
                    case 241 -> 241;
                    case 242 -> 245;
                    case 243 -> 27;
                    case 244 -> 44;
                    case 245 -> 21;
                    case 246 -> 213;
                    case 247 -> 10;
                    case 248 -> 228;
                    case 249 -> 51;
                    case 250 -> 89;
                    case 251 -> 145;
                    case 252 -> 57;
                    case 253 -> 91;
                    case 254 -> 221;
                    default -> 170;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

