/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlDeprecationOwnerDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeprecatedElementInspection
extends XmlSuppressableInspectionTool {
    @Language(value="RegExp")
    public String regexp = "(?i)deprecated.*";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlDeprecatedElementInspection.$$$reportNull$$$0(0);
        }
        final Pattern pattern = Pattern.compile(this.regexp);
        return new XmlElementVisitor(){

            public void visitXmlTag(@NotNull XmlTag tag) {
                ASTNode nameNode;
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (XmlDeprecatedElementInspection.checkDeprecated((PsiMetaData)tag.getDescriptor(), pattern) && (nameNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode())) != null) {
                    holder.registerProblem(nameNode.getPsi(), XmlAnalysisBundle.message("xml.inspections.the.tag.is.marked.as.deprecated", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                if (attribute == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (XmlDeprecatedElementInspection.checkDeprecated((PsiMetaData)attribute.getDescriptor(), pattern)) {
                    holder.registerProblem((PsiElement)attribute.getNameElement(), XmlAnalysisBundle.message("xml.inspections.the.attribute.is.marked.as.deprecated", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDeprecatedElementInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"regexp", (String)XmlAnalysisBundle.message("xml.options.label.regexp", new Object[0]), (int)30, (StringValidator)new RegexValidator())});
        if (optPane == null) {
            XmlDeprecatedElementInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static boolean checkDeprecated(@Nullable PsiMetaData metaData, Pattern pattern) {
        if (metaData == null) {
            return false;
        }
        if (metaData instanceof XmlDeprecationOwnerDescriptor) {
            return ((XmlDeprecationOwnerDescriptor)metaData).isDeprecated();
        }
        PsiElement declaration = metaData.getDeclaration();
        if (!(declaration instanceof XmlTag)) {
            return false;
        }
        XmlTag tag = (XmlTag)declaration;
        XmlComment comment = XmlUtil.findPreviousComment(declaration);
        if (comment != null && pattern.matcher(comment.getCommentText().trim()).matches()) {
            return true;
        }
        return XmlDeprecatedElementInspection.checkTag((XmlTag)ArrayUtil.getFirstElement((Object[])tag.findSubTags("annotation", tag.getNamespace())), pattern);
    }

    private static boolean checkTag(XmlTag tag, Pattern pattern) {
        if (tag == null) {
            return false;
        }
        if ("documentation".equals(tag.getLocalName())) {
            String text = tag.getValue().getTrimmedText();
            return pattern.matcher(text).matches();
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!XmlDeprecatedElementInspection.checkTag(subTag, pattern)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDeprecatedElementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDeprecatedElementInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

