# Full Line

## [Latest]

### Added
- New 100M (previously it was 20M) model for Python with better quality and performance
- Add new inline completion mode (experimental)

### Changed
- Tuned generation for a bigger python model
- Improve local generation for all models
- Simplify settings panel and make it clearer
- Changed maximum shown proposals to 2 (by default, was 3)
- Feedback form is now know about most popular language
- Replaced icon in Full Line diagnostics tab
- Enhance insertion handler by matching brackets and quotes after caret
- Updated plugin description

### Removed
- JS/TS are temporary hidden to improve speed, quality and support more dialects

### Fixed
- Fix cases with incorrect brackets and quotes balance in string with curly brackets
- Fix showing Full Line in string interpolation
- Fix issue with downloading all models, even for disabled languages
- Fix updating language settings in preferences (case when settings keep rollback to default one)

## 233.5200

### Added
- New cosmetics (logo and completion lookup icons)
- Smart shutdown based on user machine
- Optional feedback form
- New smart insertion matching
- Model now working via native server, not jvm
- Highly accelerated generation of variants
- Updated local models for all languages
- Improved lookup showtime and cases with long suggestion generation
### Changed
- Suggestions now will show only in specific places
- Disabled first token insertion (tab)
- Turned off string walking by default

## 233.2912

### Added
- Use minimal formatting for context so proposals are formatted appropriately

### Fixed
- Fix prefix calculation for cases where the last token in context exists in the vocabulary.
- Fix cancellation when typing a new code

## 232.469

### Added
- Introduce dynamic Beam Search iterations based on the probability of terminated sequences
- Increase the number of Beam Search iterations in Python to 10

### Fixed
- Fix broken completion setting panel

## 232.3487

### Added
- [IDEA-309987] Filter out profanity words and phrases
- New UI for incorrect code on new IDEs

### Fixed
- [IDEA-311177] Do not suggest calling Python objects that cannot be called
- [IDEA-312668] Do not suggest nonexistent arguments when calling a Python function

## 232.2374

### Fixed
- Fix asking for anonymously logs in old IDE versions
- Fix loading models only when specific tool window open

## 232.2142

### Fixed
- Put the file path in context instead of the file name
- Fix broken completion in tsx files
- Fix completion working in one-mode in all languages except python
- Fixed auto-import bug in JavaScript and TypeScript

### Added
- Filter out sensitive data, e.g. secret tokens, passwords, etc., from the proposals

## 232.1515

### Fixed
- Fix Javascript and Typescript auto-import exception because of not running under the write action

### Changed
- Update python model with better quality, but more weight
- [IDEA-311791] Do not show FLCC completions in Javascript and Typescript import statements

## 232.1058

### Fixed
- Fix showing extended settings panel, which might fail in some cases
- Fix model not downloading on the project open
- Fix OOM issue while storing huge diagnostics content

### Changed
- Do not hide duplicate suggestions from basic completion

### Added
- Filter out dangerous, short and single token suggestions
- Filter out suggestions with $x=$x pattern
- Add plugin's changelog

## 231.6375

### Added
- Make different levels for red code errors (hide only critical red code)
- Add semantic correctness check
- Check access fields in current fields and mark them as red code
- Add prefix matching for corner cases and fix inconvenient cases
- [IDEA-311473], [IDEA-310979] Trimming last commas, dots, and other symbols
- [IDEA-304742] Add smarter deduplication between full line suggestions and with Basic completion
- Improve semantic red code analysis
- Add smart checks for Python syntax correctness
- [IDEA-304666] Add a better UI settings panel

### Changed
- [IDEA-312239] Remove unused apache library and reduce plugin weight
- Remove auto-imports without popups
- Restrict auto-import to library modules
- Do not trim underscore for double underscores
- Do not import too short references

### Fixed
- Fix completion after typing Cyrillic letters
- Fix a bug when all completions are red because there is an identifier right after the caret
- [IDEA-310853], [IDEA-310802], [IDEA-310775], [IDEA-310462] UI and plugin description fixes
- [IDEA-304510] Fix invalid syntax suggestions in type annotations
- [IDEA-304747] Fix freeze while inserting suggestions if applying completion in a bigger Python file
- [IDEA-304658] Fix completing the code with quotation marks
- [IDEA-304773] Fix some cases with only partial Python completion
- [IDEA-304746], [IDEA-304512] Fix cases with incorrect red code detection 

## 231.3775

### Added
- Add support for JavaScript and TypeScript
- Add auto import for JavaScript and TypeScript
- Support v2 models and Python tokenizer
- [IDEA-303336] Add fuzzy search in completions
- Make settings and actions searchable
- Bundle plugin into PyCharm EAP

### Changed
- Improv the quality of generated beam search suggestions
- Evaluate only in supported js dialects
- Improve red code verification for Python
- Disable the plugin by default when bundled, enable it otherwise
- Make plugin fully dynamic
- Make topk1d much faster
- Freeze model versions for all languages
- Update K-Inference version up to 0.2.2
- Reduce plugin's jar file size
- Sort non-full line items with ML and keep full line items on the top

### Fixed
- Don't load model again if it's already there
- Fix in-place prefix masking and logSoftmax in cached output
- Fix bug with Unicode symbols in the tokenizer
- Fix cases with spawning new threads on each tokenization
- Fix cases with a reading model twice

## 0.2.69

- [IDEA-292412] Fix conflicts with entering space and other special characters

## 0.2.69

- [IDEA-292412] Fix conflicts with entering space and other special characters
- [ML-50] Improve char filter impression
- [ML-337] Log if local models weren't loaded

## 0.2.67

- [ML-294] Prepare plugin for EAP
- [ML-294] Improve full line settings panel
- [ML-294] Made multiple renames (most of them ML Completion Server -> Full Line)
- [ML-296] Add more local model management
