/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.sort.bek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.impl.facade.sort.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.sort.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BekBranchMerger {
    private static final Logger LOG = Logger.getInstance(BekBranchMerger.class);
    @NotNull
    private final List<? extends BekBranch> myBekBranches;
    @NotNull
    private final BekEdgeRestrictions myEdgeRestrictions;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<Integer> myInverseResultList;

    BekBranchMerger(@NotNull List<? extends BekBranch> bekBranches, @NotNull BekEdgeRestrictions edgeRestrictions, @NotNull TimestampGetter timestampGetter) {
        if (bekBranches == null) {
            BekBranchMerger.$$$reportNull$$$0(0);
        }
        if (edgeRestrictions == null) {
            BekBranchMerger.$$$reportNull$$$0(1);
        }
        if (timestampGetter == null) {
            BekBranchMerger.$$$reportNull$$$0(2);
        }
        this.myInverseResultList = new ArrayList<Integer>();
        this.myBekBranches = bekBranches;
        this.myEdgeRestrictions = edgeRestrictions;
        this.myTimestampGetter = timestampGetter;
    }

    private boolean prepareLastPartsForBranches() {
        boolean hasUndoneBranches = false;
        for (BekBranch bekBranch : this.myBekBranches) {
            if (bekBranch.isDone()) continue;
            hasUndoneBranches = true;
            if (bekBranch.getPrepareForInsertPart() != null) continue;
            bekBranch.updatePrepareForInsertPart(this.myTimestampGetter, this.myEdgeRestrictions);
        }
        return hasUndoneBranches;
    }

    private long getBranchLastPartTimestamp(BekBranch bekBranch) {
        List<Integer> prepareForInsertPart = bekBranch.getPrepareForInsertPart();
        if (prepareForInsertPart == null) {
            return Long.MAX_VALUE;
        }
        LOG.assertTrue(!prepareForInsertPart.isEmpty());
        int nodeIndex = prepareForInsertPart.get(0);
        return this.myTimestampGetter.getTimestamp(nodeIndex);
    }

    private void step() {
        BekBranch selectBranch = this.myBekBranches.get(0);
        for (BekBranch bekBranch : this.myBekBranches) {
            if (this.getBranchLastPartTimestamp(selectBranch) <= this.getBranchLastPartTimestamp(bekBranch)) continue;
            selectBranch = bekBranch;
        }
        List<Integer> prepareForInsertPart = selectBranch.getPrepareForInsertPart();
        LOG.assertTrue(prepareForInsertPart != null);
        for (int insertedNode : prepareForInsertPart) {
            this.myEdgeRestrictions.removeRestriction(insertedNode);
        }
        this.myInverseResultList.addAll(ContainerUtil.reverse(prepareForInsertPart));
        selectBranch.doneInsertPreparedPart();
    }

    @NotNull
    public List<Integer> getResult() {
        while (this.prepareLastPartsForBranches()) {
            this.step();
        }
        List list = ContainerUtil.reverse(this.myInverseResultList);
        if (list == null) {
            BekBranchMerger.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bekBranches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeRestrictions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/sort/bek/BekBranchMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/sort/bek/BekBranchMerger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

