/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.util.HeadingCollectingVisitor;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.SimTocOption;
import com.vladsch.flexmark.ext.toc.SimTocOptionList;
import com.vladsch.flexmark.ext.toc.TocUtils;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Paired;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SimTocNodeRenderer
implements NodeRenderer {
    private final TocOptions options;

    public SimTocNodeRenderer(DataHolder options) {
        this.options = new TocOptions(options, true);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<SimTocBlock>(SimTocBlock.class, this::render), new NodeRenderingHandler<SimTocContent>(SimTocContent.class, this::render), new NodeRenderingHandler<SimTocOptionList>(SimTocOptionList.class, this::render), new NodeRenderingHandler<SimTocOption>(SimTocOption.class, this::render)));
    }

    private void render(SimTocContent node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SimTocOptionList node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SimTocOption node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SimTocBlock node, NodeRendererContext context, HtmlWriter html) {
        HeadingCollectingVisitor visitor = new HeadingCollectingVisitor();
        ArrayList<Heading> headings = visitor.collectAndGetHeadings(context.getDocument());
        if (headings != null) {
            SimTocOptionsParser optionsParser = new SimTocOptionsParser();
            TocOptions options = optionsParser.parseOption(node.getStyle(), this.options, null).getFirst();
            if (node.getTitle().isNotNull()) {
                options = options.withTitle(node.getTitle().unescape());
            }
            this.renderTocHeaders(context, html, node, headings, options);
        }
    }

    private void renderTocHeaders(NodeRendererContext context, HtmlWriter html, Node node, List<Heading> headings, TocOptions options) {
        List<Heading> filteredHeadings = TocUtils.filteredHeadings(headings, options);
        Paired<List<Heading>, List<String>> paired = TocUtils.htmlHeadingTexts(context, filteredHeadings, options);
        List<Integer> headingLevels = paired.getFirst().stream().map(Heading::getLevel).collect(Collectors.toList());
        List<String> headingRefIds = paired.getFirst().stream().map(Heading::getAnchorRefId).collect(Collectors.toList());
        TocUtils.renderHtmlToc(html, context.getHtmlOptions().sourcePositionAttribute.isEmpty() ? BasedSequence.NULL : node.getChars(), headingLevels, paired.getSecond(), headingRefIds, options);
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new SimTocNodeRenderer(options);
        }
    }
}

