/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.providers.scroll;

import com.intellij.notebooks.visualization.NotebookVisualizationCoroutine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/scroll/NotebookEditorScrollEndDetector;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "scrollFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getScrollFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "debouncedScrollFlow", "Lkotlinx/coroutines/flow/Flow;", "getDebouncedScrollFlow", "()Lkotlinx/coroutines/flow/Flow;", "adjustmentListener", "Ljava/awt/event/AdjustmentListener;", "dispose", "Companion", "intellij.notebooks.visualization"})
public final class NotebookEditorScrollEndDetector
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableSharedFlow<Unit> scrollFlow;
    @NotNull
    private final Flow<Unit> debouncedScrollFlow;
    @NotNull
    private final AdjustmentListener adjustmentListener;
    @NotNull
    private static final Key<NotebookEditorScrollEndDetector> SCROLL_END_DETECTOR_KEY;
    private static final long AFTER_SCROLL_DELAY_MS = 150L;

    /*
     * WARNING - void declaration
     */
    private NotebookEditorScrollEndDetector(EditorImpl editor) {
        void it;
        CoroutineScope coroutineScope;
        this.editor = editor;
        CoroutineScope coroutineScope2 = NotebookVisualizationCoroutine.Utils.INSTANCE.getScope();
        String string = Reflection.getOrCreateKotlinClass(NotebookEditorScrollEndDetector.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        CoroutineScope coroutineScope3 = coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope2, (String)string, null, (boolean)false, (int)6, null);
        NotebookEditorScrollEndDetector notebookEditorScrollEndDetector = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)com.intellij.util.CoroutineScopeKt.asDisposable((CoroutineScope)it));
        notebookEditorScrollEndDetector.scope = coroutineScope;
        this.scrollFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.debouncedScrollFlow = FlowKt.debounce((Flow)((Flow)this.scrollFlow), (long)150L);
        this.adjustmentListener = arg_0 -> NotebookEditorScrollEndDetector.adjustmentListener$lambda$1(this, arg_0);
        this.editor.getScrollPane().getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
    }

    @NotNull
    public final MutableSharedFlow<Unit> getScrollFlow() {
        return this.scrollFlow;
    }

    @NotNull
    public final Flow<Unit> getDebouncedScrollFlow() {
        return this.debouncedScrollFlow;
    }

    public void dispose() {
        this.editor.getScrollPane().getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.editor.putUserData(SCROLL_END_DETECTOR_KEY, null);
    }

    private static final void adjustmentListener$lambda$1(NotebookEditorScrollEndDetector this$0, AdjustmentEvent e) {
        this$0.scrollFlow.tryEmit((Object)Unit.INSTANCE);
    }

    public /* synthetic */ NotebookEditorScrollEndDetector(EditorImpl editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    static {
        Key key = Key.create((String)"SCROLL_END_DETECTOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SCROLL_END_DETECTOR_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/scroll/NotebookEditorScrollEndDetector$Companion;", "", "<init>", "()V", "SCROLL_END_DETECTOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/visualization/ui/providers/scroll/NotebookEditorScrollEndDetector;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "AFTER_SCROLL_DELAY_MS", "", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "get", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NotebookEditorScrollEndDetector manager = new NotebookEditorScrollEndDetector(editor, null);
            editor.putUserData(SCROLL_END_DETECTOR_KEY, (Object)manager);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)manager);
        }

        @Nullable
        public final NotebookEditorScrollEndDetector get(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookEditorScrollEndDetector)editor.getUserData(SCROLL_END_DETECTOR_KEY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

