/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineFileEditor;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPREditorProviderService;", "", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cs", "createTimelineEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "file", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "intellij.vcs.github"})
final class GHPREditorProviderService {
    @NotNull
    private final CoroutineScope cs;

    public GHPREditorProviderService(@NotNull CoroutineScope parentCs) {
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (boolean)false, (int)2, null);
    }

    @NotNull
    public final FileEditor createTimelineEditor(@NotNull GHPRTimelineVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel = file.findProjectVm();
        if (gHPRConnectedProjectViewModel == null) {
            throw new ProcessCanceledException();
        }
        GHPRConnectedProjectViewModel projectVm = gHPRConnectedProjectViewModel;
        return (FileEditor)new GHPRTimelineFileEditor(this.cs, projectVm, file);
    }
}

