/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 125904004406422L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1333112970 - (char)-21751, 1333112970 - 14770, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1333112970 - (char)-21750, -1333112970 - -((char)-24397), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 81026068732603L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.v();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1510712820 - (char)-23994, -1510712820 - -((char)-29129), (int)l2) + string + WindowsNamedPipeAgentIpc.b(1510712820 - (char)-23995, 1510712820 - (char)-29402, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1510712820 - (char)-23988, -1510712820 - -24189, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 125780890515212L;
                Object object = this.lock;
                String string = SshAgentIpcService.v();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-1521722700 + -11414, -1521722700 + -3700, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1521722700 + -11415, -1521722700 + -17144, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1521722700 + -11416, 1521722700 + 18470, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1521722700 + -11425, -1521722700 - -3864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1521722700 + -11426, -1521722700 - -3383, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1521722700 + -11427, 1521722700 - 660, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1521722700 + -11425, -1521722700 - -3864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1521722700 + -11428, 1521722700 - 3158, (int)l2));
            if (ActionTimestamp.v() == null) {
                SshAgentIpcService.v("vdqoGb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 116160732065756L;
                    string = SshAgentIpcService.v();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 1100459958069L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                string = SshAgentIpcService.v();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(948291450 + 16052, 948291450 + 19483, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16053, -948291450 + -29019, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16050, -948291450 + -((char)-21451), (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(948291450 + 16052, 948291450 + 19483, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16051, -948291450 + -14923, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(948291450 + 16052, 948291450 + 19483, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16056, 948291450 + (char)-23358, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16057, -948291450 + -((char)-25844), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16050, -948291450 + -((char)-21451), (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(948291450 + 16052, 948291450 + 19483, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(948291450 + 16048, 948291450 + 31355, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(948291450 + 16054, -948291450 + -16792, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 48392455470920L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1058914530 + -21526, 1058914530 + 26998, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 21778469258000L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1309913580 - 23195, 1309913580 - 24399, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00aei\u00b0\u001e~\u00ba\u00ae\u0084\u00d0\u00af\u00e2\u00f5h\u00ad\u00b1\u00d6\u0084\u00ac\u00cd\u0014\u00a6R\u00b1\u007fET\u00b4\u00dc\u0011\u00a2\u001f\u0080\u0015\u00fa\u00df\u00b7\u00a4F\u00cec";
                        var4_3 = "\u00aei\u00b0\u001e~\u00ba\u00ae\u0084\u00d0\u00af\u00e2\u00f5h\u00ad\u00b1\u00d6\u0084\u00ac\u00cd\u0014\u00a6R\u00b1\u007fET\u00b4\u00dc\u0011\u00a2\u001f\u0080\u0015\u00fa\u00df\u00b7\u00a4F\u00cec".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 18;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 47;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 28;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 4;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 96;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 79;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 53;
                                        break;
                                    }
                                    default: {
                                        v11 = 14;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFD440) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 202;
                            case 1 -> 9;
                            case 2 -> 140;
                            case 3 -> 48;
                            case 4 -> 242;
                            case 5 -> 192;
                            case 6 -> 136;
                            case 7 -> 116;
                            case 8 -> 62;
                            case 9 -> 67;
                            case 10 -> 130;
                            case 11 -> 127;
                            case 12 -> 52;
                            case 13 -> 11;
                            case 14 -> 160;
                            case 15 -> 249;
                            case 16 -> 209;
                            case 17 -> 180;
                            case 18 -> 76;
                            case 19 -> 220;
                            case 20 -> 221;
                            case 21 -> 30;
                            case 22 -> 206;
                            case 23 -> 154;
                            case 24 -> 199;
                            case 25 -> 185;
                            case 26 -> 71;
                            case 27 -> 115;
                            case 28 -> 88;
                            case 29 -> 8;
                            case 30 -> 149;
                            case 31 -> 237;
                            case 32 -> 153;
                            case 33 -> 108;
                            case 34 -> 32;
                            case 35 -> 109;
                            case 36 -> 99;
                            case 37 -> 23;
                            case 38 -> 179;
                            case 39 -> 200;
                            case 40 -> 92;
                            case 41 -> 197;
                            case 42 -> 187;
                            case 43 -> 122;
                            case 44 -> 106;
                            case 45 -> 194;
                            case 46 -> 45;
                            case 47 -> 64;
                            case 48 -> 85;
                            case 49 -> 169;
                            case 50 -> 141;
                            case 51 -> 193;
                            case 52 -> 217;
                            case 53 -> 47;
                            case 54 -> 145;
                            case 55 -> 95;
                            case 56 -> 69;
                            case 57 -> 41;
                            case 58 -> 104;
                            case 59 -> 111;
                            case 60 -> 17;
                            case 61 -> 31;
                            case 62 -> 57;
                            case 63 -> 1;
                            case 64 -> 124;
                            case 65 -> 14;
                            case 66 -> 114;
                            case 67 -> 59;
                            case 68 -> 77;
                            case 69 -> 24;
                            case 70 -> 255;
                            case 71 -> 128;
                            case 72 -> 250;
                            case 73 -> 22;
                            case 74 -> 102;
                            case 75 -> 170;
                            case 76 -> 155;
                            case 77 -> 133;
                            case 78 -> 43;
                            case 79 -> 58;
                            case 80 -> 25;
                            case 81 -> 230;
                            case 82 -> 162;
                            case 83 -> 225;
                            case 84 -> 253;
                            case 85 -> 101;
                            case 86 -> 134;
                            case 87 -> 211;
                            case 88 -> 44;
                            case 89 -> 156;
                            case 90 -> 79;
                            case 91 -> 21;
                            case 92 -> 55;
                            case 93 -> 119;
                            case 94 -> 210;
                            case 95 -> 229;
                            case 96 -> 66;
                            case 97 -> 234;
                            case 98 -> 168;
                            case 99 -> 147;
                            case 100 -> 178;
                            case 101 -> 98;
                            case 102 -> 16;
                            case 103 -> 227;
                            case 104 -> 72;
                            case 105 -> 75;
                            case 106 -> 15;
                            case 107 -> 181;
                            case 108 -> 105;
                            case 109 -> 146;
                            case 110 -> 51;
                            case 111 -> 184;
                            case 112 -> 231;
                            case 113 -> 36;
                            case 114 -> 247;
                            case 115 -> 73;
                            case 116 -> 204;
                            case 117 -> 110;
                            case 118 -> 251;
                            case 119 -> 240;
                            case 120 -> 118;
                            case 121 -> 223;
                            case 122 -> 94;
                            case 123 -> 245;
                            case 124 -> 214;
                            case 125 -> 157;
                            case 126 -> 54;
                            case 127 -> 100;
                            case 128 -> 238;
                            case 129 -> 174;
                            case 130 -> 63;
                            case 131 -> 80;
                            case 132 -> 87;
                            case 133 -> 126;
                            case 134 -> 131;
                            case 135 -> 135;
                            case 136 -> 49;
                            case 137 -> 29;
                            case 138 -> 82;
                            case 139 -> 201;
                            case 140 -> 163;
                            case 141 -> 195;
                            case 142 -> 235;
                            case 143 -> 39;
                            case 144 -> 78;
                            case 145 -> 161;
                            case 146 -> 177;
                            case 147 -> 19;
                            case 148 -> 232;
                            case 149 -> 10;
                            case 150 -> 60;
                            case 151 -> 103;
                            case 152 -> 244;
                            case 153 -> 205;
                            case 154 -> 123;
                            case 155 -> 152;
                            case 156 -> 226;
                            case 157 -> 42;
                            case 158 -> 91;
                            case 159 -> 165;
                            case 160 -> 236;
                            case 161 -> 159;
                            case 162 -> 34;
                            case 163 -> 143;
                            case 164 -> 18;
                            case 165 -> 198;
                            case 166 -> 233;
                            case 167 -> 68;
                            case 168 -> 28;
                            case 169 -> 70;
                            case 170 -> 107;
                            case 171 -> 186;
                            case 172 -> 224;
                            case 173 -> 50;
                            case 174 -> 252;
                            case 175 -> 219;
                            case 176 -> 61;
                            case 177 -> 216;
                            case 178 -> 38;
                            case 179 -> 6;
                            case 180 -> 26;
                            case 181 -> 89;
                            case 182 -> 182;
                            case 183 -> 215;
                            case 184 -> 188;
                            case 185 -> 97;
                            case 186 -> 65;
                            case 187 -> 173;
                            case 188 -> 203;
                            case 189 -> 84;
                            case 190 -> 4;
                            case 191 -> 158;
                            case 192 -> 120;
                            case 193 -> 2;
                            case 194 -> 83;
                            case 195 -> 12;
                            case 196 -> 20;
                            case 197 -> 246;
                            case 198 -> 125;
                            case 199 -> 213;
                            case 200 -> 144;
                            case 201 -> 96;
                            case 202 -> 212;
                            case 203 -> 190;
                            case 204 -> 218;
                            case 205 -> 254;
                            case 206 -> 3;
                            case 207 -> 189;
                            case 208 -> 121;
                            case 209 -> 191;
                            case 210 -> 239;
                            case 211 -> 208;
                            case 212 -> 35;
                            case 213 -> 137;
                            case 214 -> 176;
                            case 215 -> 90;
                            case 216 -> 86;
                            case 217 -> 150;
                            case 218 -> 243;
                            case 219 -> 129;
                            case 220 -> 142;
                            case 221 -> 117;
                            case 222 -> 93;
                            case 223 -> 40;
                            case 224 -> 27;
                            case 225 -> 175;
                            case 226 -> 148;
                            case 227 -> 166;
                            case 228 -> 171;
                            case 229 -> 139;
                            case 230 -> 132;
                            case 231 -> 112;
                            case 232 -> 241;
                            case 233 -> 222;
                            case 234 -> 33;
                            case 235 -> 228;
                            case 236 -> 113;
                            case 237 -> 5;
                            case 238 -> 164;
                            case 239 -> 183;
                            case 240 -> 167;
                            case 241 -> 138;
                            case 242 -> 46;
                            case 243 -> 74;
                            case 244 -> 0;
                            case 245 -> 13;
                            case 246 -> 207;
                            case 247 -> 196;
                            case 248 -> 56;
                            case 249 -> 53;
                            case 250 -> 172;
                            case 251 -> 151;
                            case 252 -> 81;
                            case 253 -> 248;
                            case 254 -> 37;
                            default -> 7;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string == null) {
                ActionTimestamp.v(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 77285088536912L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.v();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1447012800 + 18059, 1447012800 + 15408, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1447012800 + 18063, 1447012800 + 3536, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1447012800 + 18068, 1447012800 - 9766, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1447012800 + 18059, 1447012800 + 15408, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1447012800 + 18063, 1447012800 + 3536, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1447012800 + 18067, 1447012800 + 19839, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 32471567968484L;
                        String string3 = SshAgentIpcService.v();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1615175610 + (char)-11732, -1615175610 + -27462, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1615175610 + (char)-11733, -1615175610 + -((char)-8222), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 113935637387014L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = SshAgentIpcService.v();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1254995250 + -31921, -1254995250 + -28456, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1254995250 + -31925, -1254995250 + -((char)-16120), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1254995250 + -31944, -1254995250 + -((char)-13850), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-1254995250 + -31925, -1254995250 + -((char)-16120), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1254995250 + -31919, 1254995250 + (char)-28880, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1254995250 + -31921, -1254995250 + -28456, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1254995250 + -31925, -1254995250 + -((char)-16120), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1254995250 + -31941, 1254995250 + (char)-25513, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1254995250 + -31921, -1254995250 + -28456, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1254995250 + -31925, -1254995250 + -((char)-16120), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1254995250 + -31942, 1254995250 + (char)-26281, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1254995250 + -31921, -1254995250 + -28456, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1254995250 + -31925, -1254995250 + -((char)-16120), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1254995250 + -31939, 1254995250 + 20049, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 96428800746488L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.v();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1804964970 - -3917, -1804964970 - -962, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1804964970 - -3921, -1804964970 + -11870, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1804964970 - -3934, -1804964970 + -22527, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1804964970 - -3933, 1804964970 + 16759, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1804964970 - -3917, -1804964970 - -962, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1804964970 - -3921, -1804964970 + -11870, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1804964970 - -3932, -1804964970 + -5319, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1804964970 - -3917, -1804964970 - -962, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1804964970 - -3921, -1804964970 + -11870, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1804964970 - -3931, 1804964970 - 583, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1804964970 - -3917, -1804964970 - -962, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1804964970 - -3921, -1804964970 + -11870, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1804964970 - -3930, -1804964970 - -4084, (int)l2));
                    if (string == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1804964970 - -3917, -1804964970 - -962, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1804964970 - -3921, -1804964970 + -11870, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1804964970 - -3897, -1804964970 + -963, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1804964970 - -3896, 1804964970 - 2659, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u000fB\u0085\u007fK\u0081\u0013\u00b1\u0014\u00a5\u00e7\u00e8,\u0018c\u00d6\u00f7,a\u009c\u00d4\u009eG\u00ed!\"\u00e2\u00ad\u001a\u0006\u00a5\u00c6\u00d0\u00ef\u008b\u00d2\u0018\u00d4\u00c6\u00a68S$\u00bd\u00df\u0089\u0019'\u00ab\u008fW\u009d\u00a1\u0085\u009bw\u00a8\u0007\u00db\f\u00e5\t\u0087\u000bR0\u00a6\u00ba\u001bDa\u0005\u00a3\u009b\u0010D\u0089\b\u0010\u008af\u0017e\u00aa\u00d06\u0014\u00e5\u00c0\u0098S{\u0084\u008f\u009ci\u00d1\u009fv\u00b4\u00b0\u00132\u00efS\u00edn\u0005E\n\u00ccv\u0012\u001e\u00e5\u0018\u00cdP\u00af\u00ed\u0080\u009c\u008be,\u00a3\u00a2v\u009a\u00e1\u0084\u0002\u0085o\u00f5\f^\u00d2\u0085\u0007\u00e9\u00e7\u00d71\u0010)\u00fa\u00b0\u00c9W\u00eciE\u00cb\u00ec\u00a9o\u0014\u00ba\u00e3\u00e7\tEt\u00dc\u00ce$Bm\u00c4A\u0010V\u00b8_\u0081\u00aa\u00e5\u00d6d<\u00c8W\u00eb\u00cb*\u0018\u00f5?\u00be\u001e\u00ae\u0090\u00ce\u00fc)\u00d2\u00cf}\u00e1[\u00a4\u009fg\u00e5\u00fe\u00e7\u00b7\u0016=q<\u001b\u00d9\u00d6oi0\u00b6\u00eb\u0096\nK]\u00adK4\fp\u00c8\u00f1w\t\u00e5\u0014\u00a5\u0093BM}\u00ed\u00d3\u0017\u0001\u00e6^6\u00f1\u00ace{?\b\u0005\u00be\u00c4\u00911zZ,\fS\u00ec\u001e\u00c0w2|\"@H\u008a\u00ffF\u0004x\u00f4R*`\u00d7h5\r.\u0093\u00cb\u008e\u0095\u00e1\\\u0000\u00e3E\u00a5I,.\u00ed[\u001a\u00d3!\u00c8\u00f3e5\u0083x\u00955~h\u00fd\u00d7U\u001ff6|\u008b\u00e3`\u00bb_\u0099x\u000fb\u00fe\u00adA\u0019\u00feKX\u00a6E\u008ef^\u0098'f\u001f\u001c\u00b9\u00f2dHk|L\u0014\u007f\u00df\u00e0\u00dc\u0003^\u00feg\t\u0084\u00c4\u001e\u00f9\u00f4\u00c7\u00b1uxe\u00f8\u0090\u00ca\u000b\u00dd\u00a5\u00cf\u00e9M\u0017;\u0086\u00a8\u00d0\u009d\u0015\u0099\u00d3G$[\u00c6\u0015\u00c1S\u00d8*\u00df\u00dcHC\u00c1?zR\u00d3\u00f2)\u00f0\u00e9on\u00fb*\nd\u00daz\u0006@\u00e3\u001d'8\u0017YQiT4{f/\b|\u00b2W\u009e\u00bd\u0091\u0002\u00b8\u00f8\u007f;>\"\\=\u0007\u00cd\u00e4\u00c2\u00d5j\u0000\u00a3\u0007\u0014\u001c\u009d\u00a6f\u00814(\u00e6f\u00e1\u00be\u009aZ\u00d0M\u00f1\u0088I()\u0091<*s\u00b6s\u00d7q\u00dd\u00b0\u0090\u00c6j\u00f7\u0085\u0011\u0018\u00aeX\u009b\u00eaU\u00984\u00bfP\u009f\u000f@\u00b1{m!L\u0002L\u00de%\r\u00cc\u0001Y\u00a7\"\u00fb\u000b\u000e2\u00d7\u00a1\u008f\u0015jT\u0010\u0085\"\u00a9{`w{\u00d7on\u00f4\u009c.@U\\\u00c7w\u0002\u001b\u0005\u00f8\u00d9\u000esH\u001dR\u00ed\u00ab\u009b\u00b0\u00ed\u00bak?\u00c1-\u001b\u00afF\u0081\u0096\u0085\u0086\u0003I\u00a9\u0002n)1\u00d9?xW\u00d2n\u00c6b\u00f5n\u00a8U\u00e8\u00ab\n\u00c5\u00a6\b\u008d\u00a0\u0001t\u0093\u00ec;\u0018X\u00b0\u007fE[@\u00f9\u00cf\u00e8\u001b\u0084\u0095\u00d5\u001d_\u00c1,\u00e4\u00d6y\rI\u00d8l)\u00dd\u009d\u00ca\u00e0O\u00fb\u009c^\b=\\\u00a8\u00ac\tQ\u00c1\u00a7\u0013\u0098\u00e5W\u00b5RZ\u007f\u001d\u00eb\u00fc\u00f6\u000b2\u00b2\u00d6\u0002\u00b7\u00bc\fb\u00c4\u00d7\u00e1\t\u0017\u00d3\u0096$g\u00d0S\u00cd;";
                var4_3 = "\u000fB\u0085\u007fK\u0081\u0013\u00b1\u0014\u00a5\u00e7\u00e8,\u0018c\u00d6\u00f7,a\u009c\u00d4\u009eG\u00ed!\"\u00e2\u00ad\u001a\u0006\u00a5\u00c6\u00d0\u00ef\u008b\u00d2\u0018\u00d4\u00c6\u00a68S$\u00bd\u00df\u0089\u0019'\u00ab\u008fW\u009d\u00a1\u0085\u009bw\u00a8\u0007\u00db\f\u00e5\t\u0087\u000bR0\u00a6\u00ba\u001bDa\u0005\u00a3\u009b\u0010D\u0089\b\u0010\u008af\u0017e\u00aa\u00d06\u0014\u00e5\u00c0\u0098S{\u0084\u008f\u009ci\u00d1\u009fv\u00b4\u00b0\u00132\u00efS\u00edn\u0005E\n\u00ccv\u0012\u001e\u00e5\u0018\u00cdP\u00af\u00ed\u0080\u009c\u008be,\u00a3\u00a2v\u009a\u00e1\u0084\u0002\u0085o\u00f5\f^\u00d2\u0085\u0007\u00e9\u00e7\u00d71\u0010)\u00fa\u00b0\u00c9W\u00eciE\u00cb\u00ec\u00a9o\u0014\u00ba\u00e3\u00e7\tEt\u00dc\u00ce$Bm\u00c4A\u0010V\u00b8_\u0081\u00aa\u00e5\u00d6d<\u00c8W\u00eb\u00cb*\u0018\u00f5?\u00be\u001e\u00ae\u0090\u00ce\u00fc)\u00d2\u00cf}\u00e1[\u00a4\u009fg\u00e5\u00fe\u00e7\u00b7\u0016=q<\u001b\u00d9\u00d6oi0\u00b6\u00eb\u0096\nK]\u00adK4\fp\u00c8\u00f1w\t\u00e5\u0014\u00a5\u0093BM}\u00ed\u00d3\u0017\u0001\u00e6^6\u00f1\u00ace{?\b\u0005\u00be\u00c4\u00911zZ,\fS\u00ec\u001e\u00c0w2|\"@H\u008a\u00ffF\u0004x\u00f4R*`\u00d7h5\r.\u0093\u00cb\u008e\u0095\u00e1\\\u0000\u00e3E\u00a5I,.\u00ed[\u001a\u00d3!\u00c8\u00f3e5\u0083x\u00955~h\u00fd\u00d7U\u001ff6|\u008b\u00e3`\u00bb_\u0099x\u000fb\u00fe\u00adA\u0019\u00feKX\u00a6E\u008ef^\u0098'f\u001f\u001c\u00b9\u00f2dHk|L\u0014\u007f\u00df\u00e0\u00dc\u0003^\u00feg\t\u0084\u00c4\u001e\u00f9\u00f4\u00c7\u00b1uxe\u00f8\u0090\u00ca\u000b\u00dd\u00a5\u00cf\u00e9M\u0017;\u0086\u00a8\u00d0\u009d\u0015\u0099\u00d3G$[\u00c6\u0015\u00c1S\u00d8*\u00df\u00dcHC\u00c1?zR\u00d3\u00f2)\u00f0\u00e9on\u00fb*\nd\u00daz\u0006@\u00e3\u001d'8\u0017YQiT4{f/\b|\u00b2W\u009e\u00bd\u0091\u0002\u00b8\u00f8\u007f;>\"\\=\u0007\u00cd\u00e4\u00c2\u00d5j\u0000\u00a3\u0007\u0014\u001c\u009d\u00a6f\u00814(\u00e6f\u00e1\u00be\u009aZ\u00d0M\u00f1\u0088I()\u0091<*s\u00b6s\u00d7q\u00dd\u00b0\u0090\u00c6j\u00f7\u0085\u0011\u0018\u00aeX\u009b\u00eaU\u00984\u00bfP\u009f\u000f@\u00b1{m!L\u0002L\u00de%\r\u00cc\u0001Y\u00a7\"\u00fb\u000b\u000e2\u00d7\u00a1\u008f\u0015jT\u0010\u0085\"\u00a9{`w{\u00d7on\u00f4\u009c.@U\\\u00c7w\u0002\u001b\u0005\u00f8\u00d9\u000esH\u001dR\u00ed\u00ab\u009b\u00b0\u00ed\u00bak?\u00c1-\u001b\u00afF\u0081\u0096\u0085\u0086\u0003I\u00a9\u0002n)1\u00d9?xW\u00d2n\u00c6b\u00f5n\u00a8U\u00e8\u00ab\n\u00c5\u00a6\b\u008d\u00a0\u0001t\u0093\u00ec;\u0018X\u00b0\u007fE[@\u00f9\u00cf\u00e8\u001b\u0084\u0095\u00d5\u001d_\u00c1,\u00e4\u00d6y\rI\u00d8l)\u00dd\u009d\u00ca\u00e0O\u00fb\u009c^\b=\\\u00a8\u00ac\tQ\u00c1\u00a7\u0013\u0098\u00e5W\u00b5RZ\u007f\u001d\u00eb\u00fc\u00f6\u000b2\u00b2\u00d6\u0002\u00b7\u00bc\fb\u00c4\u00d7\u00e1\t\u0017\u00d3\u0096$g\u00d0S\u00cd;".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 89;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00bcq\u008f\u0014\u008e\f\u00cd\u00c9K\u00a6]\u00b2\u00e5#\u0011\u00ed\u00c6\u00f3\u008d\u0014\u00c9\u00dd\u001b\u00e0\u0094?n\u0094\u00bf\u0014\u0012\u00cbw\u00c0\u0082\u0097\u00ec\u0000\u0002\u00f60Ob]\u001b\u000b\u0095\u00ce2\u00f6";
                    var4_3 = "\u00bcq\u008f\u0014\u008e\f\u00cd\u00c9K\u00a6]\u00b2\u00e5#\u0011\u00ed\u00c6\u00f3\u008d\u0014\u00c9\u00dd\u001b\u00e0\u0094?n\u0094\u00bf\u0014\u0012\u00cbw\u00c0\u0082\u0097\u00ec\u0000\u0002\u00f60Ob]\u001b\u000b\u0095\u00ce2\u00f6".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 113;
                            break;
                        }
                        case 1: {
                            v15 = 65;
                            break;
                        }
                        case 2: {
                            v15 = 54;
                            break;
                        }
                        case 3: {
                            v15 = 76;
                            break;
                        }
                        case 4: {
                            v15 = 97;
                            break;
                        }
                        case 5: {
                            v15 = 61;
                            break;
                        }
                        default: {
                            v15 = 10;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5917) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 231;
                case 1 -> 78;
                case 2 -> 198;
                case 3 -> 39;
                case 4 -> 151;
                case 5 -> 252;
                case 6 -> 253;
                case 7 -> 152;
                case 8 -> 9;
                case 9 -> 211;
                case 10 -> 217;
                case 11 -> 254;
                case 12 -> 87;
                case 13 -> 154;
                case 14 -> 165;
                case 15 -> 200;
                case 16 -> 38;
                case 17 -> 136;
                case 18 -> 67;
                case 19 -> 56;
                case 20 -> 72;
                case 21 -> 21;
                case 22 -> 125;
                case 23 -> 144;
                case 24 -> 145;
                case 25 -> 16;
                case 26 -> 177;
                case 27 -> 13;
                case 28 -> 41;
                case 29 -> 62;
                case 30 -> 90;
                case 31 -> 147;
                case 32 -> 137;
                case 33 -> 130;
                case 34 -> 188;
                case 35 -> 168;
                case 36 -> 192;
                case 37 -> 29;
                case 38 -> 7;
                case 39 -> 247;
                case 40 -> 169;
                case 41 -> 225;
                case 42 -> 202;
                case 43 -> 199;
                case 44 -> 243;
                case 45 -> 77;
                case 46 -> 150;
                case 47 -> 20;
                case 48 -> 59;
                case 49 -> 45;
                case 50 -> 35;
                case 51 -> 28;
                case 52 -> 65;
                case 53 -> 203;
                case 54 -> 107;
                case 55 -> 1;
                case 56 -> 174;
                case 57 -> 167;
                case 58 -> 74;
                case 59 -> 86;
                case 60 -> 49;
                case 61 -> 234;
                case 62 -> 131;
                case 63 -> 109;
                case 64 -> 233;
                case 65 -> 244;
                case 66 -> 215;
                case 67 -> 99;
                case 68 -> 82;
                case 69 -> 30;
                case 70 -> 51;
                case 71 -> 206;
                case 72 -> 255;
                case 73 -> 164;
                case 74 -> 214;
                case 75 -> 191;
                case 76 -> 140;
                case 77 -> 159;
                case 78 -> 210;
                case 79 -> 102;
                case 80 -> 25;
                case 81 -> 179;
                case 82 -> 115;
                case 83 -> 58;
                case 84 -> 37;
                case 85 -> 185;
                case 86 -> 98;
                case 87 -> 4;
                case 88 -> 182;
                case 89 -> 196;
                case 90 -> 219;
                case 91 -> 36;
                case 92 -> 57;
                case 93 -> 236;
                case 94 -> 176;
                case 95 -> 172;
                case 96 -> 226;
                case 97 -> 129;
                case 98 -> 224;
                case 99 -> 2;
                case 100 -> 84;
                case 101 -> 32;
                case 102 -> 105;
                case 103 -> 23;
                case 104 -> 61;
                case 105 -> 223;
                case 106 -> 170;
                case 107 -> 207;
                case 108 -> 73;
                case 109 -> 163;
                case 110 -> 245;
                case 111 -> 89;
                case 112 -> 237;
                case 113 -> 118;
                case 114 -> 95;
                case 115 -> 15;
                case 116 -> 68;
                case 117 -> 94;
                case 118 -> 238;
                case 119 -> 110;
                case 120 -> 64;
                case 121 -> 195;
                case 122 -> 155;
                case 123 -> 205;
                case 124 -> 146;
                case 125 -> 194;
                case 126 -> 135;
                case 127 -> 10;
                case 128 -> 11;
                case 129 -> 103;
                case 130 -> 222;
                case 131 -> 190;
                case 132 -> 83;
                case 133 -> 242;
                case 134 -> 221;
                case 135 -> 178;
                case 136 -> 228;
                case 137 -> 181;
                case 138 -> 117;
                case 139 -> 81;
                case 140 -> 171;
                case 141 -> 251;
                case 142 -> 121;
                case 143 -> 52;
                case 144 -> 134;
                case 145 -> 148;
                case 146 -> 24;
                case 147 -> 80;
                case 148 -> 208;
                case 149 -> 230;
                case 150 -> 114;
                case 151 -> 193;
                case 152 -> 160;
                case 153 -> 92;
                case 154 -> 229;
                case 155 -> 246;
                case 156 -> 127;
                case 157 -> 75;
                case 158 -> 14;
                case 159 -> 96;
                case 160 -> 55;
                case 161 -> 156;
                case 162 -> 201;
                case 163 -> 47;
                case 164 -> 124;
                case 165 -> 143;
                case 166 -> 85;
                case 167 -> 173;
                case 168 -> 216;
                case 169 -> 113;
                case 170 -> 139;
                case 171 -> 197;
                case 172 -> 27;
                case 173 -> 241;
                case 174 -> 204;
                case 175 -> 175;
                case 176 -> 142;
                case 177 -> 63;
                case 178 -> 3;
                case 179 -> 5;
                case 180 -> 18;
                case 181 -> 149;
                case 182 -> 239;
                case 183 -> 48;
                case 184 -> 183;
                case 185 -> 17;
                case 186 -> 34;
                case 187 -> 6;
                case 188 -> 116;
                case 189 -> 93;
                case 190 -> 212;
                case 191 -> 186;
                case 192 -> 250;
                case 193 -> 100;
                case 194 -> 133;
                case 195 -> 157;
                case 196 -> 162;
                case 197 -> 19;
                case 198 -> 189;
                case 199 -> 187;
                case 200 -> 232;
                case 201 -> 138;
                case 202 -> 128;
                case 203 -> 50;
                case 204 -> 26;
                case 205 -> 240;
                case 206 -> 0;
                case 207 -> 71;
                case 208 -> 70;
                case 209 -> 209;
                case 210 -> 184;
                case 211 -> 166;
                case 212 -> 44;
                case 213 -> 60;
                case 214 -> 218;
                case 215 -> 40;
                case 216 -> 141;
                case 217 -> 43;
                case 218 -> 119;
                case 219 -> 8;
                case 220 -> 33;
                case 221 -> 227;
                case 222 -> 161;
                case 223 -> 126;
                case 224 -> 180;
                case 225 -> 97;
                case 226 -> 46;
                case 227 -> 220;
                case 228 -> 53;
                case 229 -> 79;
                case 230 -> 112;
                case 231 -> 31;
                case 232 -> 91;
                case 233 -> 132;
                case 234 -> 76;
                case 235 -> 66;
                case 236 -> 69;
                case 237 -> 88;
                case 238 -> 213;
                case 239 -> 54;
                case 240 -> 42;
                case 241 -> 120;
                case 242 -> 248;
                case 243 -> 249;
                case 244 -> 235;
                case 245 -> 12;
                case 246 -> 123;
                case 247 -> 111;
                case 248 -> 158;
                case 249 -> 122;
                case 250 -> 108;
                case 251 -> 101;
                case 252 -> 153;
                case 253 -> 106;
                case 254 -> 104;
                default -> 22;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 41729204752856L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(697423470 + (char)-560, -697423470 + -((char)-8848), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 89866491033676L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.v();
                            try {
                                hANDLE2 = hANDLE;
                                if (string == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1404677190 + 4453, -1404677190 - -153, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1404677190 + 4450, 1404677190 - 9867, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1404677190 + 4451, 1404677190 - 5524, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "(\u00a1\b&\u0011\u00e6\u00f1\u00c9\u0010\u00cc\u00ceej\u0006\u00d4\u00ea\u00d6\u00e5\u00f7I\u00e7D\u0002}\u00ae";
                    var4_3 = "(\u00a1\b&\u0011\u00e6\u00f1\u00c9\u0010\u00cc\u00ceej\u0006\u00d4\u00ea\u00d6\u00e5\u00f7I\u00e7D\u0002}\u00ae".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 88;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00c5\u00a9u\u00e7\u000e5\u00b9\u00c0\u00ed\u00a6\u00cf\u00b4\u000b\u00b1n`j\u0015\u0017v\u00d2j\u00ff:+\u00b0\u00dbt\u00d2F\u0080\u00f9\u00d7\u00cf\u00e3\u00cc\u00e9{\u009d\u00c6\u00c2\t\u00e3#\u00b8\u00d2b\u00e3\u00e1=\u00cb\u009c\u00b9\u009c\u001c\u000e;\t\u00bb";
                        var4_3 = "\u00c5\u00a9u\u00e7\u000e5\u00b9\u00c0\u00ed\u00a6\u00cf\u00b4\u000b\u00b1n`j\u0015\u0017v\u00d2j\u00ff:+\u00b0\u00dbt\u00d2F\u0080\u00f9\u00d7\u00cf\u00e3\u00cc\u00e9{\u009d\u00c6\u00c2\t\u00e3#\u00b8\u00d2b\u00e3\u00e1=\u00cb\u009c\u00b9\u009c\u001c\u000e;\t\u00bb".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 53;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 64;
                                break;
                            }
                            case 1: {
                                v15 = 51;
                                break;
                            }
                            case 2: {
                                v15 = 88;
                                break;
                            }
                            case 3: {
                                v15 = 6;
                                break;
                            }
                            case 4: {
                                v15 = 102;
                                break;
                            }
                            case 5: {
                                v15 = 25;
                                break;
                            }
                            default: {
                                v15 = 98;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC5E6) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 255;
                    case 1 -> 26;
                    case 2 -> 84;
                    case 3 -> 155;
                    case 4 -> 235;
                    case 5 -> 82;
                    case 6 -> 99;
                    case 7 -> 248;
                    case 8 -> 127;
                    case 9 -> 5;
                    case 10 -> 67;
                    case 11 -> 72;
                    case 12 -> 113;
                    case 13 -> 172;
                    case 14 -> 114;
                    case 15 -> 188;
                    case 16 -> 253;
                    case 17 -> 12;
                    case 18 -> 242;
                    case 19 -> 6;
                    case 20 -> 142;
                    case 21 -> 43;
                    case 22 -> 140;
                    case 23 -> 4;
                    case 24 -> 138;
                    case 25 -> 153;
                    case 26 -> 137;
                    case 27 -> 222;
                    case 28 -> 209;
                    case 29 -> 139;
                    case 30 -> 25;
                    case 31 -> 64;
                    case 32 -> 111;
                    case 33 -> 90;
                    case 34 -> 162;
                    case 35 -> 181;
                    case 36 -> 184;
                    case 37 -> 70;
                    case 38 -> 28;
                    case 39 -> 228;
                    case 40 -> 147;
                    case 41 -> 33;
                    case 42 -> 32;
                    case 43 -> 14;
                    case 44 -> 19;
                    case 45 -> 18;
                    case 46 -> 119;
                    case 47 -> 225;
                    case 48 -> 186;
                    case 49 -> 146;
                    case 50 -> 200;
                    case 51 -> 201;
                    case 52 -> 135;
                    case 53 -> 231;
                    case 54 -> 221;
                    case 55 -> 244;
                    case 56 -> 22;
                    case 57 -> 45;
                    case 58 -> 189;
                    case 59 -> 182;
                    case 60 -> 2;
                    case 61 -> 78;
                    case 62 -> 60;
                    case 63 -> 69;
                    case 64 -> 129;
                    case 65 -> 251;
                    case 66 -> 227;
                    case 67 -> 252;
                    case 68 -> 42;
                    case 69 -> 205;
                    case 70 -> 112;
                    case 71 -> 110;
                    case 72 -> 116;
                    case 73 -> 177;
                    case 74 -> 193;
                    case 75 -> 169;
                    case 76 -> 17;
                    case 77 -> 131;
                    case 78 -> 102;
                    case 79 -> 149;
                    case 80 -> 191;
                    case 81 -> 107;
                    case 82 -> 133;
                    case 83 -> 24;
                    case 84 -> 123;
                    case 85 -> 230;
                    case 86 -> 136;
                    case 87 -> 41;
                    case 88 -> 158;
                    case 89 -> 198;
                    case 90 -> 208;
                    case 91 -> 246;
                    case 92 -> 192;
                    case 93 -> 48;
                    case 94 -> 214;
                    case 95 -> 85;
                    case 96 -> 49;
                    case 97 -> 11;
                    case 98 -> 104;
                    case 99 -> 77;
                    case 100 -> 167;
                    case 101 -> 3;
                    case 102 -> 216;
                    case 103 -> 79;
                    case 104 -> 87;
                    case 105 -> 57;
                    case 106 -> 89;
                    case 107 -> 103;
                    case 108 -> 115;
                    case 109 -> 66;
                    case 110 -> 143;
                    case 111 -> 0;
                    case 112 -> 27;
                    case 113 -> 254;
                    case 114 -> 71;
                    case 115 -> 165;
                    case 116 -> 204;
                    case 117 -> 179;
                    case 118 -> 76;
                    case 119 -> 109;
                    case 120 -> 206;
                    case 121 -> 194;
                    case 122 -> 178;
                    case 123 -> 39;
                    case 124 -> 92;
                    case 125 -> 23;
                    case 126 -> 196;
                    case 127 -> 168;
                    case 128 -> 75;
                    case 129 -> 13;
                    case 130 -> 98;
                    case 131 -> 141;
                    case 132 -> 207;
                    case 133 -> 173;
                    case 134 -> 15;
                    case 135 -> 121;
                    case 136 -> 239;
                    case 137 -> 212;
                    case 138 -> 20;
                    case 139 -> 122;
                    case 140 -> 247;
                    case 141 -> 128;
                    case 142 -> 105;
                    case 143 -> 151;
                    case 144 -> 126;
                    case 145 -> 197;
                    case 146 -> 224;
                    case 147 -> 170;
                    case 148 -> 40;
                    case 149 -> 36;
                    case 150 -> 9;
                    case 151 -> 148;
                    case 152 -> 185;
                    case 153 -> 44;
                    case 154 -> 195;
                    case 155 -> 86;
                    case 156 -> 238;
                    case 157 -> 134;
                    case 158 -> 218;
                    case 159 -> 74;
                    case 160 -> 38;
                    case 161 -> 190;
                    case 162 -> 124;
                    case 163 -> 63;
                    case 164 -> 81;
                    case 165 -> 161;
                    case 166 -> 202;
                    case 167 -> 106;
                    case 168 -> 95;
                    case 169 -> 97;
                    case 170 -> 94;
                    case 171 -> 171;
                    case 172 -> 226;
                    case 173 -> 101;
                    case 174 -> 174;
                    case 175 -> 37;
                    case 176 -> 55;
                    case 177 -> 30;
                    case 178 -> 100;
                    case 179 -> 16;
                    case 180 -> 88;
                    case 181 -> 243;
                    case 182 -> 250;
                    case 183 -> 199;
                    case 184 -> 219;
                    case 185 -> 215;
                    case 186 -> 53;
                    case 187 -> 10;
                    case 188 -> 245;
                    case 189 -> 51;
                    case 190 -> 187;
                    case 191 -> 125;
                    case 192 -> 157;
                    case 193 -> 73;
                    case 194 -> 58;
                    case 195 -> 7;
                    case 196 -> 50;
                    case 197 -> 144;
                    case 198 -> 130;
                    case 199 -> 31;
                    case 200 -> 203;
                    case 201 -> 59;
                    case 202 -> 240;
                    case 203 -> 80;
                    case 204 -> 8;
                    case 205 -> 213;
                    case 206 -> 91;
                    case 207 -> 150;
                    case 208 -> 34;
                    case 209 -> 152;
                    case 210 -> 54;
                    case 211 -> 120;
                    case 212 -> 108;
                    case 213 -> 220;
                    case 214 -> 229;
                    case 215 -> 217;
                    case 216 -> 46;
                    case 217 -> 61;
                    case 218 -> 154;
                    case 219 -> 211;
                    case 220 -> 65;
                    case 221 -> 56;
                    case 222 -> 233;
                    case 223 -> 145;
                    case 224 -> 160;
                    case 225 -> 96;
                    case 226 -> 118;
                    case 227 -> 35;
                    case 228 -> 236;
                    case 229 -> 237;
                    case 230 -> 183;
                    case 231 -> 132;
                    case 232 -> 234;
                    case 233 -> 163;
                    case 234 -> 210;
                    case 235 -> 232;
                    case 236 -> 1;
                    case 237 -> 176;
                    case 238 -> 83;
                    case 239 -> 52;
                    case 240 -> 159;
                    case 241 -> 166;
                    case 242 -> 21;
                    case 243 -> 249;
                    case 244 -> 223;
                    case 245 -> 117;
                    case 246 -> 175;
                    case 247 -> 47;
                    case 248 -> 241;
                    case 249 -> 62;
                    case 250 -> 156;
                    case 251 -> 93;
                    case 252 -> 29;
                    case 253 -> 180;
                    case 254 -> 68;
                    default -> 164;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 133131921891739L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "z+\u0011Tf,##\t}!\u0002^+n>?g";
                    var5_4 = "z+\u0011Tf,##\t}!\u0002^+n>?g".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 116;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 101;
                                    break;
                                }
                                case 1: {
                                    v11 = 58;
                                    break;
                                }
                                case 2: {
                                    v11 = 23;
                                    break;
                                }
                                case 3: {
                                    v11 = 78;
                                    break;
                                }
                                case 4: {
                                    v11 = 119;
                                    break;
                                }
                                case 5: {
                                    v11 = 52;
                                    break;
                                }
                                default: {
                                    v11 = 100;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 120482791259059L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "/E:\u001fmH\u0014\u0004)[6\u0005\n%D=\u0005aJ\f\u000fE4\t%D=\u0005aJ\f\u0003O\r\"B \bkG\u0016\u0003H'\u0002jN";
                    var5_4 = "/E:\u001fmH\u0014\u0004)[6\u0005\n%D=\u0005aJ\f\u000fE4\t%D=\u0005aJ\f\u0003O\r\"B \bkG\u0016\u0003H'\u0002jN".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 110;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "7U.\n\u007fU\r\u00067U.\ns_";
                        var5_4 = "7U.\n\u007fU\r\u00067U.\ns_".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 124;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 8;
                                break;
                            }
                            case 1: {
                                v15 = 69;
                                break;
                            }
                            case 2: {
                                v15 = 61;
                                break;
                            }
                            case 3: {
                                v15 = 5;
                                break;
                            }
                            case 4: {
                                v15 = 106;
                                break;
                            }
                            case 5: {
                                v15 = 71;
                                break;
                            }
                            default: {
                                v15 = 22;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 125443509357282L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(399501360 + (char)-26626, -399501360 + -((char)-8679), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 7819480875350L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00cd$>\u00e6\u00aa\u0003B\\{\u0005\u00b7\u00f7WXd\r\u0092y\u00c5\u00c3\u00c3G\u00cd\u00c7\t\u00fd\u0083\u0005\u00c8\u0010s\u0092>U\u0083\u0000\u00ee\u0012\u00a4\u00c3\u00d5\u008f\u00e4\u00bb7X\u0005/\u00c0D\u00be\u00063Z\b\u00fb\u00d0\u00ee\u00f4s\u0098jo\u00873h}\u008a\u009f\u00a8\u00eb\u0098y~\u00d5\u0001\u0096ERu\u0098\u0097\u00934\u00b9\u00c9\u00cb\u00dc]\u00db\u0087{bt\u00db\u00ac\t\u007f\u001coU;\u0099.";
                    var4_3 = "\u00cd$>\u00e6\u00aa\u0003B\\{\u0005\u00b7\u00f7WXd\r\u0092y\u00c5\u00c3\u00c3G\u00cd\u00c7\t\u00fd\u0083\u0005\u00c8\u0010s\u0092>U\u0083\u0000\u00ee\u0012\u00a4\u00c3\u00d5\u008f\u00e4\u00bb7X\u0005/\u00c0D\u00be\u00063Z\b\u00fb\u00d0\u00ee\u00f4s\u0098jo\u00873h}\u008a\u009f\u00a8\u00eb\u0098y~\u00d5\u0001\u0096ERu\u0098\u0097\u00934\u00b9\u00c9\u00cb\u00dc]\u00db\u0087{bt\u00db\u00ac\t\u007f\u001coU;\u0099.".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "&x\u00c7[\u00ef\u00920\u0013,\u00b0\u0097\u00b2\u00ffO\u0007\u0095L>U34[\u00b7\u00c8\u00d9\u00baz\u00e9R>\u00dd\u00ac\u00be:Mf\b\u009a\u00cc\u00e4D\u0089\u00b0\u009aQ\u00c3\u00b0\u0002\u00e1L}N\u00c4\u00e89t\u0080\u00f0)\u00a0y\u00b8\u009f\u000fN\u0096\u009d \u00d0\u0095?\u001a_\u00a0\u0019w\u00b2\u00d7\u00ec\u008f?\u0012\u00bf\u00f5\u0094\u00d7\u00fe\u00c7\n\u00b8\u00e4;\u00aa";
                        var4_3 = "&x\u00c7[\u00ef\u00920\u0013,\u00b0\u0097\u00b2\u00ffO\u0007\u0095L>U34[\u00b7\u00c8\u00d9\u00baz\u00e9R>\u00dd\u00ac\u00be:Mf\b\u009a\u00cc\u00e4D\u0089\u00b0\u009aQ\u00c3\u00b0\u0002\u00e1L}N\u00c4\u00e89t\u0080\u00f0)\u00a0y\u00b8\u009f\u000fN\u0096\u009d \u00d0\u0095?\u001a_\u00a0\u0019w\u00b2\u00d7\u00ec\u008f?\u0012\u00bf\u00f5\u0094\u00d7\u00fe\u00c7\n\u00b8\u00e4;\u00aa".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 26;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 7;
                                break;
                            }
                            case 1: {
                                v15 = 70;
                                break;
                            }
                            case 2: {
                                v15 = 69;
                                break;
                            }
                            case 3: {
                                v15 = 69;
                                break;
                            }
                            case 4: {
                                v15 = 114;
                                break;
                            }
                            case 5: {
                                v15 = 27;
                                break;
                            }
                            default: {
                                v15 = 13;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xACC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 229;
                    case 1 -> 49;
                    case 2 -> 96;
                    case 3 -> 187;
                    case 4 -> 157;
                    case 5 -> 132;
                    case 6 -> 117;
                    case 7 -> 212;
                    case 8 -> 151;
                    case 9 -> 250;
                    case 10 -> 7;
                    case 11 -> 242;
                    case 12 -> 11;
                    case 13 -> 182;
                    case 14 -> 201;
                    case 15 -> 57;
                    case 16 -> 37;
                    case 17 -> 185;
                    case 18 -> 169;
                    case 19 -> 27;
                    case 20 -> 41;
                    case 21 -> 56;
                    case 22 -> 22;
                    case 23 -> 220;
                    case 24 -> 122;
                    case 25 -> 118;
                    case 26 -> 67;
                    case 27 -> 255;
                    case 28 -> 222;
                    case 29 -> 15;
                    case 30 -> 100;
                    case 31 -> 248;
                    case 32 -> 214;
                    case 33 -> 238;
                    case 34 -> 144;
                    case 35 -> 80;
                    case 36 -> 190;
                    case 37 -> 47;
                    case 38 -> 181;
                    case 39 -> 216;
                    case 40 -> 52;
                    case 41 -> 14;
                    case 42 -> 218;
                    case 43 -> 34;
                    case 44 -> 124;
                    case 45 -> 105;
                    case 46 -> 84;
                    case 47 -> 50;
                    case 48 -> 145;
                    case 49 -> 166;
                    case 50 -> 223;
                    case 51 -> 87;
                    case 52 -> 251;
                    case 53 -> 30;
                    case 54 -> 228;
                    case 55 -> 245;
                    case 56 -> 94;
                    case 57 -> 28;
                    case 58 -> 188;
                    case 59 -> 149;
                    case 60 -> 25;
                    case 61 -> 46;
                    case 62 -> 60;
                    case 63 -> 130;
                    case 64 -> 234;
                    case 65 -> 140;
                    case 66 -> 194;
                    case 67 -> 81;
                    case 68 -> 93;
                    case 69 -> 3;
                    case 70 -> 142;
                    case 71 -> 70;
                    case 72 -> 147;
                    case 73 -> 236;
                    case 74 -> 75;
                    case 75 -> 74;
                    case 76 -> 12;
                    case 77 -> 204;
                    case 78 -> 239;
                    case 79 -> 252;
                    case 80 -> 202;
                    case 81 -> 10;
                    case 82 -> 24;
                    case 83 -> 39;
                    case 84 -> 175;
                    case 85 -> 5;
                    case 86 -> 68;
                    case 87 -> 85;
                    case 88 -> 21;
                    case 89 -> 131;
                    case 90 -> 31;
                    case 91 -> 71;
                    case 92 -> 53;
                    case 93 -> 112;
                    case 94 -> 69;
                    case 95 -> 221;
                    case 96 -> 6;
                    case 97 -> 128;
                    case 98 -> 125;
                    case 99 -> 197;
                    case 100 -> 55;
                    case 101 -> 120;
                    case 102 -> 155;
                    case 103 -> 109;
                    case 104 -> 208;
                    case 105 -> 210;
                    case 106 -> 115;
                    case 107 -> 213;
                    case 108 -> 72;
                    case 109 -> 174;
                    case 110 -> 4;
                    case 111 -> 191;
                    case 112 -> 106;
                    case 113 -> 65;
                    case 114 -> 193;
                    case 115 -> 180;
                    case 116 -> 98;
                    case 117 -> 195;
                    case 118 -> 138;
                    case 119 -> 44;
                    case 120 -> 170;
                    case 121 -> 183;
                    case 122 -> 32;
                    case 123 -> 33;
                    case 124 -> 235;
                    case 125 -> 243;
                    case 126 -> 54;
                    case 127 -> 215;
                    case 128 -> 36;
                    case 129 -> 159;
                    case 130 -> 123;
                    case 131 -> 73;
                    case 132 -> 97;
                    case 133 -> 168;
                    case 134 -> 240;
                    case 135 -> 227;
                    case 136 -> 108;
                    case 137 -> 244;
                    case 138 -> 38;
                    case 139 -> 1;
                    case 140 -> 146;
                    case 141 -> 241;
                    case 142 -> 172;
                    case 143 -> 154;
                    case 144 -> 111;
                    case 145 -> 89;
                    case 146 -> 129;
                    case 147 -> 139;
                    case 148 -> 253;
                    case 149 -> 91;
                    case 150 -> 76;
                    case 151 -> 63;
                    case 152 -> 83;
                    case 153 -> 156;
                    case 154 -> 102;
                    case 155 -> 205;
                    case 156 -> 136;
                    case 157 -> 232;
                    case 158 -> 179;
                    case 159 -> 161;
                    case 160 -> 206;
                    case 161 -> 26;
                    case 162 -> 137;
                    case 163 -> 58;
                    case 164 -> 141;
                    case 165 -> 20;
                    case 166 -> 177;
                    case 167 -> 135;
                    case 168 -> 167;
                    case 169 -> 176;
                    case 170 -> 43;
                    case 171 -> 29;
                    case 172 -> 16;
                    case 173 -> 99;
                    case 174 -> 249;
                    case 175 -> 217;
                    case 176 -> 237;
                    case 177 -> 119;
                    case 178 -> 189;
                    case 179 -> 200;
                    case 180 -> 77;
                    case 181 -> 226;
                    case 182 -> 171;
                    case 183 -> 42;
                    case 184 -> 143;
                    case 185 -> 247;
                    case 186 -> 19;
                    case 187 -> 48;
                    case 188 -> 211;
                    case 189 -> 186;
                    case 190 -> 61;
                    case 191 -> 198;
                    case 192 -> 64;
                    case 193 -> 13;
                    case 194 -> 163;
                    case 195 -> 207;
                    case 196 -> 18;
                    case 197 -> 101;
                    case 198 -> 199;
                    case 199 -> 88;
                    case 200 -> 178;
                    case 201 -> 86;
                    case 202 -> 103;
                    case 203 -> 78;
                    case 204 -> 230;
                    case 205 -> 35;
                    case 206 -> 92;
                    case 207 -> 2;
                    case 208 -> 203;
                    case 209 -> 126;
                    case 210 -> 231;
                    case 211 -> 173;
                    case 212 -> 17;
                    case 213 -> 23;
                    case 214 -> 107;
                    case 215 -> 40;
                    case 216 -> 110;
                    case 217 -> 134;
                    case 218 -> 133;
                    case 219 -> 0;
                    case 220 -> 196;
                    case 221 -> 225;
                    case 222 -> 148;
                    case 223 -> 209;
                    case 224 -> 254;
                    case 225 -> 62;
                    case 226 -> 158;
                    case 227 -> 51;
                    case 228 -> 233;
                    case 229 -> 8;
                    case 230 -> 192;
                    case 231 -> 219;
                    case 232 -> 153;
                    case 233 -> 114;
                    case 234 -> 184;
                    case 235 -> 45;
                    case 236 -> 162;
                    case 237 -> 127;
                    case 238 -> 246;
                    case 239 -> 150;
                    case 240 -> 121;
                    case 241 -> 9;
                    case 242 -> 224;
                    case 243 -> 160;
                    case 244 -> 66;
                    case 245 -> 116;
                    case 246 -> 113;
                    case 247 -> 79;
                    case 248 -> 59;
                    case 249 -> 82;
                    case 250 -> 152;
                    case 251 -> 164;
                    case 252 -> 95;
                    case 253 -> 165;
                    case 254 -> 104;
                    default -> 90;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 18447021711180L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(137230290 - (char)-32572, -137230290 - -((char)-19894), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 96847116677555L;
                    String string = SshAgentIpcService.v();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-100923900 - -((char)-11284), -100923900 - -((char)-28256), (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 111357065118418L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0083\u00f2\u0016\u00f3W\u0003wg\u00de";
                var4_3 = "\u0083\u00f2\u0016\u00f3W\u0003wg\u00de".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 25;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 112;
                                break;
                            }
                            case 1: {
                                v11 = 112;
                                break;
                            }
                            case 2: {
                                v11 = 122;
                                break;
                            }
                            case 3: {
                                v11 = 124;
                                break;
                            }
                            case 4: {
                                v11 = 93;
                                break;
                            }
                            case 5: {
                                v11 = 4;
                                break;
                            }
                            default: {
                                v11 = 76;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6842) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 116;
                    case 1 -> 126;
                    case 2 -> 165;
                    case 3 -> 137;
                    case 4 -> 42;
                    case 5 -> 20;
                    case 6 -> 171;
                    case 7 -> 236;
                    case 8 -> 148;
                    case 9 -> 232;
                    case 10 -> 9;
                    case 11 -> 63;
                    case 12 -> 179;
                    case 13 -> 79;
                    case 14 -> 24;
                    case 15 -> 178;
                    case 16 -> 222;
                    case 17 -> 158;
                    case 18 -> 188;
                    case 19 -> 56;
                    case 20 -> 40;
                    case 21 -> 120;
                    case 22 -> 26;
                    case 23 -> 162;
                    case 24 -> 49;
                    case 25 -> 28;
                    case 26 -> 23;
                    case 27 -> 0;
                    case 28 -> 33;
                    case 29 -> 197;
                    case 30 -> 170;
                    case 31 -> 237;
                    case 32 -> 25;
                    case 33 -> 209;
                    case 34 -> 149;
                    case 35 -> 204;
                    case 36 -> 175;
                    case 37 -> 239;
                    case 38 -> 78;
                    case 39 -> 230;
                    case 40 -> 91;
                    case 41 -> 156;
                    case 42 -> 235;
                    case 43 -> 44;
                    case 44 -> 147;
                    case 45 -> 37;
                    case 46 -> 172;
                    case 47 -> 243;
                    case 48 -> 194;
                    case 49 -> 119;
                    case 50 -> 103;
                    case 51 -> 36;
                    case 52 -> 216;
                    case 53 -> 87;
                    case 54 -> 183;
                    case 55 -> 92;
                    case 56 -> 123;
                    case 57 -> 130;
                    case 58 -> 168;
                    case 59 -> 185;
                    case 60 -> 215;
                    case 61 -> 65;
                    case 62 -> 190;
                    case 63 -> 127;
                    case 64 -> 174;
                    case 65 -> 205;
                    case 66 -> 100;
                    case 67 -> 206;
                    case 68 -> 5;
                    case 69 -> 143;
                    case 70 -> 101;
                    case 71 -> 224;
                    case 72 -> 218;
                    case 73 -> 114;
                    case 74 -> 89;
                    case 75 -> 229;
                    case 76 -> 68;
                    case 77 -> 226;
                    case 78 -> 85;
                    case 79 -> 66;
                    case 80 -> 47;
                    case 81 -> 110;
                    case 82 -> 146;
                    case 83 -> 192;
                    case 84 -> 1;
                    case 85 -> 180;
                    case 86 -> 2;
                    case 87 -> 117;
                    case 88 -> 213;
                    case 89 -> 196;
                    case 90 -> 105;
                    case 91 -> 141;
                    case 92 -> 189;
                    case 93 -> 54;
                    case 94 -> 140;
                    case 95 -> 144;
                    case 96 -> 249;
                    case 97 -> 176;
                    case 98 -> 223;
                    case 99 -> 59;
                    case 100 -> 51;
                    case 101 -> 160;
                    case 102 -> 90;
                    case 103 -> 136;
                    case 104 -> 150;
                    case 105 -> 102;
                    case 106 -> 11;
                    case 107 -> 138;
                    case 108 -> 71;
                    case 109 -> 88;
                    case 110 -> 135;
                    case 111 -> 45;
                    case 112 -> 163;
                    case 113 -> 18;
                    case 114 -> 251;
                    case 115 -> 115;
                    case 116 -> 121;
                    case 117 -> 131;
                    case 118 -> 238;
                    case 119 -> 233;
                    case 120 -> 157;
                    case 121 -> 242;
                    case 122 -> 8;
                    case 123 -> 125;
                    case 124 -> 76;
                    case 125 -> 151;
                    case 126 -> 203;
                    case 127 -> 62;
                    case 128 -> 139;
                    case 129 -> 193;
                    case 130 -> 81;
                    case 131 -> 77;
                    case 132 -> 106;
                    case 133 -> 35;
                    case 134 -> 111;
                    case 135 -> 13;
                    case 136 -> 145;
                    case 137 -> 152;
                    case 138 -> 93;
                    case 139 -> 211;
                    case 140 -> 98;
                    case 141 -> 181;
                    case 142 -> 30;
                    case 143 -> 246;
                    case 144 -> 201;
                    case 145 -> 10;
                    case 146 -> 50;
                    case 147 -> 250;
                    case 148 -> 134;
                    case 149 -> 248;
                    case 150 -> 70;
                    case 151 -> 186;
                    case 152 -> 95;
                    case 153 -> 187;
                    case 154 -> 159;
                    case 155 -> 240;
                    case 156 -> 53;
                    case 157 -> 118;
                    case 158 -> 234;
                    case 159 -> 247;
                    case 160 -> 94;
                    case 161 -> 113;
                    case 162 -> 43;
                    case 163 -> 108;
                    case 164 -> 84;
                    case 165 -> 154;
                    case 166 -> 48;
                    case 167 -> 212;
                    case 168 -> 254;
                    case 169 -> 217;
                    case 170 -> 199;
                    case 171 -> 57;
                    case 172 -> 97;
                    case 173 -> 52;
                    case 174 -> 122;
                    case 175 -> 177;
                    case 176 -> 155;
                    case 177 -> 21;
                    case 178 -> 128;
                    case 179 -> 61;
                    case 180 -> 241;
                    case 181 -> 6;
                    case 182 -> 164;
                    case 183 -> 17;
                    case 184 -> 195;
                    case 185 -> 46;
                    case 186 -> 208;
                    case 187 -> 133;
                    case 188 -> 191;
                    case 189 -> 15;
                    case 190 -> 73;
                    case 191 -> 75;
                    case 192 -> 86;
                    case 193 -> 38;
                    case 194 -> 19;
                    case 195 -> 252;
                    case 196 -> 80;
                    case 197 -> 14;
                    case 198 -> 39;
                    case 199 -> 74;
                    case 200 -> 67;
                    case 201 -> 96;
                    case 202 -> 22;
                    case 203 -> 228;
                    case 204 -> 107;
                    case 205 -> 244;
                    case 206 -> 27;
                    case 207 -> 210;
                    case 208 -> 58;
                    case 209 -> 16;
                    case 210 -> 153;
                    case 211 -> 253;
                    case 212 -> 221;
                    case 213 -> 32;
                    case 214 -> 161;
                    case 215 -> 220;
                    case 216 -> 225;
                    case 217 -> 245;
                    case 218 -> 182;
                    case 219 -> 231;
                    case 220 -> 60;
                    case 221 -> 184;
                    case 222 -> 72;
                    case 223 -> 255;
                    case 224 -> 173;
                    case 225 -> 3;
                    case 226 -> 7;
                    case 227 -> 64;
                    case 228 -> 82;
                    case 229 -> 202;
                    case 230 -> 55;
                    case 231 -> 29;
                    case 232 -> 83;
                    case 233 -> 34;
                    case 234 -> 169;
                    case 235 -> 99;
                    case 236 -> 167;
                    case 237 -> 31;
                    case 238 -> 219;
                    case 239 -> 142;
                    case 240 -> 4;
                    case 241 -> 227;
                    case 242 -> 112;
                    case 243 -> 198;
                    case 244 -> 200;
                    case 245 -> 207;
                    case 246 -> 69;
                    case 247 -> 166;
                    case 248 -> 132;
                    case 249 -> 214;
                    case 250 -> 124;
                    case 251 -> 12;
                    case 252 -> 129;
                    case 253 -> 109;
                    case 254 -> 41;
                    default -> 104;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

