/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.dialogs.WCInfo;

public class SvnFormatWorker
extends Task.Backgroundable {
    private final List<Throwable> myExceptions;
    @NotNull
    private final WorkingCopyFormat myNewFormat;
    private final List<? extends WCInfo> myWcInfos;
    private List<LocalChangeList> myBeforeChangeLists;
    private final SvnVcs myVcs;

    public SvnFormatWorker(Project project, @NotNull WorkingCopyFormat newFormat, List<? extends WCInfo> wcInfos) {
        if (newFormat == null) {
            SvnFormatWorker.$$$reportNull$$$0(0);
        }
        super(project, SvnBundle.message("progress.title.convert.working.copy.format", new Object[0]), false, DEAF);
        this.myNewFormat = newFormat;
        this.myExceptions = new ArrayList<Throwable>();
        this.myWcInfos = wcInfos;
        this.myVcs = SvnVcs.getInstance(this.myProject);
    }

    public SvnFormatWorker(Project project, @NotNull WorkingCopyFormat newFormat, WCInfo wcInfo) {
        if (newFormat == null) {
            SvnFormatWorker.$$$reportNull$$$0(1);
        }
        this(project, newFormat, Collections.singletonList(wcInfo));
    }

    public boolean haveStuffToConvert() {
        return !this.myWcInfos.isEmpty();
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myExceptions.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable exception : this.myExceptions) {
                messages.add(exception.getMessage());
            }
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(Collections.singletonList(new VcsException(messages)), SvnBundle.message("dialog.title.convert.working.copy.format", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SvnFormatWorker.$$$reportNull$$$0(2);
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).startBackgroundVcsOperation();
        indicator.setIndeterminate(true);
        boolean supportsChangelists = this.myNewFormat.supportsChangelists();
        if (supportsChangelists) {
            this.myBeforeChangeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        }
        try {
            for (WCInfo wCInfo : this.myWcInfos) {
                File path = new File(wCInfo.getPath());
                if (!wCInfo.isIsWcRoot()) {
                    path = SvnUtil.getWorkingCopyRoot(path);
                }
                try {
                    ProgressTracker handler = this.createUpgradeHandler(indicator, path, wCInfo.getFormat());
                    this.myVcs.getFactory(path).createUpgradeClient().upgrade(path, this.myNewFormat, handler);
                }
                catch (Throwable e) {
                    this.myExceptions.add(e);
                }
            }
        }
        finally {
            ProjectLevelVcsManager.getInstance((Project)this.myProject).stopBackgroundVcsOperation();
            if (supportsChangelists) {
                ExclusiveBackgroundVcsAction.run(this.myProject, () -> SvnVcs.getInstance(this.myProject).synchronizeToNativeChangeLists(this.myBeforeChangeLists));
            }
            ((Runnable)BackgroundTaskUtil.syncPublisher(SvnVcs.WC_CONVERTED)).run();
        }
    }

    @NotNull
    private ProgressTracker createUpgradeHandler(final @NotNull ProgressIndicator indicator, final @NotNull File path, final @NotNull WorkingCopyFormat format) {
        if (indicator == null) {
            SvnFormatWorker.$$$reportNull$$$0(3);
        }
        if (path == null) {
            SvnFormatWorker.$$$reportNull$$$0(4);
        }
        if (format == null) {
            SvnFormatWorker.$$$reportNull$$$0(5);
        }
        return new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getFile() != null) {
                    if (EventAction.UPGRADED_PATH.equals((Object)event.getAction())) {
                        indicator.setText2(SvnBundle.message("progress.details.upgraded.path", VcsUtil.getPathForProgressPresentation((File)event.getFile())));
                    }
                    if (EventAction.UPDATE_STARTED.equals((Object)event.getAction())) {
                        indicator.setText(SvnBundle.message("progress.text.performing.path.cleanup", path.getAbsolutePath()));
                    }
                    if (EventAction.UPDATE_COMPLETED.equals((Object)event.getAction())) {
                        indicator.setText(SvnBundle.message("progress.text.converting.working.copy.format", new Object[]{path.getAbsolutePath(), format, SvnFormatWorker.this.myNewFormat}));
                    }
                }
            }

            @Override
            public void checkCancelled() throws ProcessCanceledException {
                indicator.checkCanceled();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFormat";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/dialogs/SvnFormatWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createUpgradeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

