/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.GpgAgentPathsLocator;
import git4idea.commit.signing.GpgAgentPathsLocatorKt;
import git4idea.config.GitExecutable;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/commit/signing/EelAgentPathsLocator;", "Lgit4idea/commit/signing/GpgAgentPathsLocator;", "gitExecutable", "Lgit4idea/config/GitExecutable$Eel;", "<init>", "(Lgit4idea/config/GitExecutable$Eel;)V", "getGitExecutable", "()Lgit4idea/config/GitExecutable$Eel;", "resolvePaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "intellij.vcs.git"})
final class EelAgentPathsLocator
implements GpgAgentPathsLocator {
    @NotNull
    private final GitExecutable.Eel gitExecutable;

    public EelAgentPathsLocator(@NotNull GitExecutable.Eel gitExecutable) {
        Intrinsics.checkNotNullParameter((Object)gitExecutable, (String)"gitExecutable");
        this.gitExecutable = gitExecutable;
    }

    @NotNull
    public final GitExecutable.Eel getGitExecutable() {
        return this.gitExecutable;
    }

    @Override
    @Nullable
    public GpgAgentPaths resolvePaths() {
        try {
            Path gpgAgentHome = EelNioBridgeServiceKt.asNioPath((EelPath)this.gitExecutable.getEel().getUserInfo().getHome()).resolve(".gnupg");
            Path gpgPinentryAppLauncher = gpgAgentHome.resolve("pinentry-ide.sh");
            Intrinsics.checkNotNull((Object)gpgAgentHome);
            Intrinsics.checkNotNull((Object)gpgPinentryAppLauncher);
            return GpgAgentPaths.Companion.create(gpgAgentHome, EelNioBridgeServiceKt.asEelPath((Path)gpgPinentryAppLauncher).toString());
        }
        catch (InvalidPathException e) {
            GpgAgentPathsLocatorKt.access$getLOG$p().warn("Cannot resolve path", (Throwable)e);
            return null;
        }
    }
}

