/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add.v2.hatch;

import com.intellij.icons.AllIcons;
import com.intellij.python.hatch.HatchVirtualEnvironment;
import com.intellij.python.hatch.PythonVirtualEnvironment;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.icons.PythonIcons;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012.\u0010\u0003\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005j\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0018\u0001`\b0\u0004\u00a2\u0006\u0004\b\t\u0010\nJ<\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R9\u0010\u0003\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005j\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0018\u0001`\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/add/v2/hatch/HatchEnvComboBoxListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/python/hatch/HatchVirtualEnvironment;", "contentFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/jetbrains/python/Result;", "", "Lcom/jetbrains/python/errorProcessing/PyError;", "Lcom/jetbrains/python/errorProcessing/PyResult;", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;)V", "getContentFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.python.community.impl"})
final class HatchEnvComboBoxListCellRenderer
extends ColoredListCellRenderer<HatchVirtualEnvironment> {
    @NotNull
    private final StateFlow<Result<List<?>, PyError>> contentFlow;

    public HatchEnvComboBoxListCellRenderer(@NotNull StateFlow<? extends Result<? extends List<?>, ? extends PyError>> contentFlow) {
        Intrinsics.checkNotNullParameter(contentFlow, (String)"contentFlow");
        this.contentFlow = contentFlow;
    }

    @NotNull
    public final StateFlow<Result<List<?>, PyError>> getContentFlow() {
        return this.contentFlow;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends HatchVirtualEnvironment> list, @Nullable HatchVirtualEnvironment value, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Result result2 = (Result)this.contentFlow.getValue();
        if (result2 == null) {
            this.setIcon(AllIcons.Process.Step_1);
            this.append(PyBundle.message("sdk.create.custom.hatch.environment.loading", new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        } else if (result2 instanceof Result.Failure) {
            this.append(PyBundle.message("sdk.create.custom.hatch.error.no.environments.to.select", new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        } else if (result2 instanceof Result.Success) {
            if (((List)((Result.Success)result2).getResult()).isEmpty() || value == null) {
                this.append(PyBundle.message("sdk.create.custom.hatch.error.no.environments.to.select", new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            } else {
                Icon icon;
                PythonVirtualEnvironment pythonVirtualEnvironment = value.getPythonVirtualEnvironment();
                if (pythonVirtualEnvironment == null) {
                    icon = AllIcons.Nodes.Folder;
                } else if (pythonVirtualEnvironment instanceof PythonVirtualEnvironment.Existing) {
                    icon = PythonIcons.Python.PythonClosed;
                } else if (pythonVirtualEnvironment instanceof PythonVirtualEnvironment.NotExisting) {
                    icon = AllIcons.Nodes.Folder;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.setIcon(icon);
                this.append(value.getHatchEnvironment().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                Object object = value.getPythonVirtualEnvironment();
                if (object != null && (object = object.getPythonHomePath()) != null) {
                    Object pythonHomePath = object;
                    boolean bl = false;
                    this.append("\t", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append(pythonHomePath.toString(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

