/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskApiBundle;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.jql.JqlLanguage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public final class JiraRepositoryEditor
extends BaseRepositoryEditor<JiraRepository> {
    private EditorTextField mySearchQueryField;
    private JBLabel mySearchLabel;
    private JBLabel myNoteLabel;
    private JCheckBox myUseBearerTokenAuthenticationCheckBox;

    public JiraRepositoryEditor(Project project, JiraRepository repository, Consumer<? super JiraRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
    }

    public void apply() {
        ((JiraRepository)this.myRepository).setSearchQuery(this.mySearchQueryField.getText());
        ((JiraRepository)this.myRepository).setUseBearerTokenAuthentication(this.myUseBearerTokenAuthenticationCheckBox.isSelected());
        super.apply();
        this.adjustSettingsForServerProperties();
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            this.adjustSettingsForServerProperties();
        }
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.mySearchQueryField = new LanguageTextField((Language)JqlLanguage.INSTANCE, this.myProject, ((JiraRepository)this.myRepository).getSearchQuery());
        this.installListener(this.mySearchQueryField);
        this.mySearchLabel = new JBLabel(TaskBundle.message((String)"label.search", (Object[])new Object[0]), 4);
        this.myNoteLabel = new JBLabel();
        this.myNoteLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.myUseBearerTokenAuthenticationCheckBox = new JCheckBox(TaskApiBundle.message((String)"use.personal.access.token", (Object[])new Object[0]));
        this.myUseBearerTokenAuthenticationCheckBox.setSelected(((JiraRepository)this.myRepository).isUseBearerTokenAuthentication());
        this.myUseBearerTokenAuthenticationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JiraRepositoryEditor.this.useBearerTokenChanged();
            }
        });
        this.adjustSettingsForServerProperties();
        return FormBuilder.createFormBuilder().addComponentToRightColumn((JComponent)this.myUseBearerTokenAuthenticationCheckBox).addLabeledComponent((JComponent)this.mySearchLabel, (JComponent)this.mySearchQueryField).addComponentToRightColumn((JComponent)this.myNoteLabel).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.mySearchLabel.setAnchor(anchor);
    }

    private void adjustSettingsForServerProperties() {
        if (((JiraRepository)this.myRepository).isJqlSupported()) {
            this.mySearchQueryField.setEnabled(true);
            this.myNoteLabel.setVisible(false);
        } else {
            this.mySearchQueryField.setEnabled(false);
            this.myNoteLabel.setText(TaskBundle.message((String)"label.jql.search.cannot.be.used.in.jira.versions.prior.your.version", (Object[])new Object[]{((JiraRepository)this.myRepository).getPresentableVersion()}));
            this.myNoteLabel.setVisible(true);
        }
        if (((JiraRepository)this.myRepository).isInCloud()) {
            this.myUsernameLabel.setVisible(true);
            this.myUserNameText.setVisible(true);
            this.myUsernameLabel.setText(TaskBundle.message((String)"label.email", (Object[])new Object[0]));
            this.myPasswordLabel.setText(TaskBundle.message((String)"label.api.token", (Object[])new Object[0]));
            this.myUseBearerTokenAuthenticationCheckBox.setVisible(false);
        } else if (this.myUseBearerTokenAuthenticationCheckBox.isSelected()) {
            this.myUsernameLabel.setVisible(false);
            this.myUserNameText.setVisible(false);
            this.myPasswordLabel.setText(TaskBundle.message((String)"label.api.token", (Object[])new Object[0]));
            this.myUseBearerTokenAuthenticationCheckBox.setVisible(true);
        } else {
            this.myUsernameLabel.setVisible(true);
            this.myUserNameText.setVisible(true);
            this.myUsernameLabel.setText(TaskBundle.message((String)"label.username", (Object[])new Object[0]));
            this.myPasswordLabel.setText(TaskBundle.message((String)"label.password", (Object[])new Object[0]));
            this.myUseBearerTokenAuthenticationCheckBox.setVisible(true);
        }
    }

    private void useBearerTokenChanged() {
        ((JiraRepository)this.myRepository).setUseBearerTokenAuthentication(this.myUseBearerTokenAuthenticationCheckBox.isSelected());
        this.adjustSettingsForServerProperties();
    }
}

