/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.transport.sasl;

import com.jetbrains.cef.remote.thrift.EncodingUtils;
import com.jetbrains.cef.remote.thrift.transport.sasl.FrameWriter;
import com.jetbrains.cef.remote.thrift.utils.StringUtils;
import java.nio.ByteBuffer;

public class SaslNegotiationFrameWriter
extends FrameWriter {
    public static final int HEADER_BYTES = 5;

    @Override
    public void withOnlyPayload(byte[] payload, int offset, int length) {
        throw new UnsupportedOperationException("Status byte is expected for sasl frame header.");
    }

    @Override
    protected ByteBuffer buildFrame(byte[] header, int headerOffset, int headerLength, byte[] payload, int payloadOffset, int payloadLength) {
        if (header == null || headerLength != 1) {
            throw new IllegalArgumentException("Header " + StringUtils.bytesToHexString(header) + " does not have expected length 1");
        }
        byte[] bytes = new byte[5 + payloadLength];
        System.arraycopy(header, headerOffset, bytes, 0, 1);
        EncodingUtils.encodeBigEndian(payloadLength, bytes, 1);
        System.arraycopy(payload, payloadOffset, bytes, 5, payloadLength);
        return ByteBuffer.wrap(bytes);
    }
}

