/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.LookupPresentation;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.terminal.frontend.view.completion.TerminalLookupListener;
import com.intellij.terminal.frontend.view.completion.TerminalLookupOutputModelListener;
import com.intellij.terminal.frontend.view.completion.TerminalLookupPrefixUpdater;
import com.intellij.terminal.frontend.view.completion.TerminalSelectedItemIconUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupManagerListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "<init>", "()V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "installLookupPrefixUpdater", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "MaxVisibleItemsProperty", "intellij.terminal.frontend"})
public final class TerminalLookupManagerListener
implements LookupManagerListener {
    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        block5: {
            block4: {
                if (newLookup == null || !(newLookup instanceof LookupImpl)) break block4;
                Editor editor = ((LookupImpl)newLookup).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                if (TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor)) break block5;
            }
            return;
        }
        ((LookupImpl)newLookup).setPresentation(new LookupPresentation.Builder().withMaxVisibleItemsCount((ReadWriteProperty)new MaxVisibleItemsProperty()).build());
        ((LookupImpl)newLookup).addLookupListener((LookupListener)new TerminalLookupListener());
        ((LookupImpl)newLookup).addPrefixChangeListener((PrefixChangeListener)new TerminalSelectedItemIconUpdater(newLookup), (Disposable)newLookup);
        this.installLookupPrefixUpdater((LookupImpl)newLookup);
        TerminalOutputModel terminalOutputModel = (TerminalOutputModel)((LookupImpl)newLookup).getEditor().getUserData(TerminalOutputModel.Companion.getKEY());
        if (terminalOutputModel == null) {
            throw new IllegalStateException("Output model is not set in the terminal editor".toString());
        }
        TerminalOutputModel outputModel = terminalOutputModel;
        outputModel.addListener((Disposable)newLookup, new TerminalLookupOutputModelListener((LookupEx)newLookup, outputModel));
    }

    private final void installLookupPrefixUpdater(LookupImpl lookup) {
        TerminalOutputModel terminalOutputModel = (TerminalOutputModel)lookup.getEditor().getUserData(TerminalOutputModel.Companion.getKEY());
        if (terminalOutputModel == null) {
            throw new IllegalStateException("Output model is not set in the terminal editor".toString());
        }
        TerminalOutputModel outputModel = terminalOutputModel;
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CoroutineScope coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)TerminalCoroutineKt.terminalProjectScope(project), (String)"TerminalLookupPrefixUpdater", null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)((Disposable)lookup), () -> TerminalLookupManagerListener.installLookupPrefixUpdater$lambda$0(coroutineScope));
        TerminalLookupPrefixUpdater.Companion.install(outputModel, lookup, coroutineScope);
    }

    private static final void installLookupPrefixUpdater$lambda$0(CoroutineScope $coroutineScope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$coroutineScope, null, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupManagerListener$MaxVisibleItemsProperty;", "Lkotlin/properties/ReadWriteProperty;", "Lcom/intellij/codeInsight/lookup/LookupPresentation;", "", "<init>", "()V", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Lcom/intellij/codeInsight/lookup/LookupPresentation;Lkotlin/reflect/KProperty;)Ljava/lang/Integer;", "setValue", "", "value", "intellij.terminal.frontend"})
    private static final class MaxVisibleItemsProperty
    implements ReadWriteProperty<LookupPresentation, Integer> {
        @NotNull
        public Integer getValue(@NotNull LookupPresentation thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return TerminalUiSettingsManager.Companion.getInstance().getMaxVisibleCompletionItemsCount();
        }

        public void setValue(@NotNull LookupPresentation thisRef, @NotNull KProperty<?> property, int value) {
            Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            TerminalUiSettingsManager.Companion.getInstance().setMaxVisibleCompletionItemsCount(Math.max(5, value));
        }
    }
}

