/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.Condition;

@Beta
public final class VerboseCondition<T>
extends Condition<T> {
    private Function<T, String> objectUnderTestDescriptor;
    private String description;

    public static <T> VerboseCondition<T> verboseCondition(Predicate<T> predicate, String description, Function<T, String> objectUnderTestDescriptor) {
        return new VerboseCondition<T>(predicate, description, objectUnderTestDescriptor);
    }

    private VerboseCondition(Predicate<T> predicate, String description, Function<T, String> objectUnderTestDescriptor) {
        super(predicate, description, new Object[0]);
        this.description = description;
        this.objectUnderTestDescriptor = Objects.requireNonNull(objectUnderTestDescriptor, "The objectUnderTest descriptor function must not be null, if you don't need one, consider using the basic Condition(Predicate<T> predicate, String description, Object... args) constructor");
    }

    @Override
    public boolean matches(T objectUnderTest) {
        boolean matches = super.matches(objectUnderTest);
        this.describedAs(this.buildVerboseDescription(objectUnderTest, matches), new Object[0]);
        return matches;
    }

    protected String buildVerboseDescription(T objectUnderTest, boolean matches) {
        StringBuilder sb = new StringBuilder("%s".formatted(this.description));
        if (!matches) {
            sb.append(this.objectUnderTestDescriptor.apply(objectUnderTest));
        }
        return sb.toString();
    }
}

