/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IntersectionScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UnionScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class GlobalSearchScopeUtil {
    @NotNull
    public static GlobalSearchScope toGlobalSearchScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(1);
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope;
            if (globalSearchScope == null) {
                GlobalSearchScopeUtil.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> GlobalSearchScope.filesScope(project, GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)scope)));
        if (globalSearchScope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public static @Unmodifiable Set<VirtualFile> getLocalScopeFiles(@NotNull LocalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(4);
        }
        Set set = (Set)ReadAction.compute(() -> {
            LinkedHashSet files = new LinkedHashSet();
            for (PsiElement element : scope.getScope()) {
                PsiFile file = element.getContainingFile();
                if (file == null) continue;
                ContainerUtil.addIfNotNull(files, file.getVirtualFile());
                ContainerUtil.addIfNotNull(files, file.getNavigationElement().getContainingFile().getVirtualFile());
            }
            return files;
        });
        if (set == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static List<GlobalSearchScope> flattenUnionScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(6);
        }
        if (scope instanceof UnionScope) {
            UnionScope unionScope = (UnionScope)scope;
            List<GlobalSearchScope> list = Arrays.stream(unionScope.getMyScopes()).flatMap(s -> GlobalSearchScopeUtil.flattenUnionScope(s).stream()).collect(Collectors.toList());
            if (list == null) {
                GlobalSearchScopeUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<GlobalSearchScope> list = Collections.singletonList(scope);
        if (list == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static boolean isIntersectionScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(9);
        }
        return scope instanceof IntersectionScope;
    }

    @NotNull
    public static List<GlobalSearchScope> flattenIntersectionScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(10);
        }
        if (scope instanceof IntersectionScope) {
            ArrayList<GlobalSearchScope> result = new ArrayList<GlobalSearchScope>();
            GlobalSearchScopeUtil.flattenIntersectionScopeInto(scope, result);
            ArrayList<GlobalSearchScope> arrayList = result;
            if (arrayList == null) {
                GlobalSearchScopeUtil.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        List<GlobalSearchScope> list = Collections.singletonList(scope);
        if (list == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static void flattenIntersectionScopeInto(@NotNull GlobalSearchScope scope, @NotNull List<GlobalSearchScope> result) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(13);
        }
        if (result == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(14);
        }
        if (scope instanceof IntersectionScope) {
            IntersectionScope intersectionScope = (IntersectionScope)scope;
            GlobalSearchScopeUtil.flattenIntersectionScopeInto(intersectionScope.myScope1, result);
            GlobalSearchScopeUtil.flattenIntersectionScopeInto(intersectionScope.myScope2, result);
        } else {
            result.add(scope);
        }
    }

    public static GlobalSearchScope includeContainingFile(@NotNull GlobalSearchScope scope, @NotNull PsiElement element) {
        VirtualFile vFile;
        PsiFile file;
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(15);
        }
        if (element == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(16);
        }
        if ((file = element.getContainingFile()) != null && (vFile = file.getVirtualFile()) != null && !scope.contains(vFile)) {
            return scope.union(GlobalSearchScope.fileScope(file));
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopeUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toGlobalSearchScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalScopeFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenUnionScope";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIntersectionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toGlobalSearchScope";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalScopeFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flattenUnionScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIntersectionScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "flattenIntersectionScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "flattenIntersectionScopeInto";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "includeContainingFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

