/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.edt;

import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.assertj.swing.dependency.fest_reflect.core.Reflection;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.CheckThreadViolationRepaintManager;
import org.assertj.swing.exception.EdtViolationException;

public class FailOnThreadViolationRepaintManager
extends CheckThreadViolationRepaintManager {
    private static RepaintManager previousRepaintManager;

    @Nonnull
    public static FailOnThreadViolationRepaintManager install() {
        RepaintManager m = FailOnThreadViolationRepaintManager.currentRepaintManager();
        if (m instanceof FailOnThreadViolationRepaintManager) {
            return (FailOnThreadViolationRepaintManager)m;
        }
        return FailOnThreadViolationRepaintManager.installNew();
    }

    @Nonnull
    public static RepaintManager uninstall() {
        RepaintManager restored = previousRepaintManager;
        FailOnThreadViolationRepaintManager.setCurrentManager(restored);
        previousRepaintManager = null;
        return restored;
    }

    @Nullable
    private static RepaintManager currentRepaintManager() {
        try {
            Object repaintManager = Reflection.method("appContextGet").withReturnType(Object.class).withParameterTypes(Object.class).in(SwingUtilities.class).invoke(RepaintManager.class);
            if (repaintManager instanceof RepaintManager) {
                return (RepaintManager)repaintManager;
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return null;
    }

    @Nonnull
    private static FailOnThreadViolationRepaintManager installNew() {
        FailOnThreadViolationRepaintManager m = new FailOnThreadViolationRepaintManager();
        previousRepaintManager = FailOnThreadViolationRepaintManager.currentRepaintManager();
        FailOnThreadViolationRepaintManager.setCurrentManager(m);
        return m;
    }

    public FailOnThreadViolationRepaintManager() {
    }

    public FailOnThreadViolationRepaintManager(boolean completeCheck) {
        super(completeCheck);
    }

    @Override
    void violationFound(@Nonnull JComponent c, @Nonnull StackTraceElement[] stackTraceElements) {
        EdtViolationException e = new EdtViolationException("EDT violation detected");
        e.setStackTrace(stackTraceElements);
        throw e;
    }
}

