/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.terminal.completion.spec.ShellArgumentSpec;
import com.intellij.terminal.completion.spec.ShellCommandSpec;
import com.intellij.terminal.completion.spec.ShellCompletionSuggestion;
import com.intellij.terminal.completion.spec.ShellName;
import com.intellij.terminal.completion.spec.ShellOptionSpec;
import com.intellij.terminal.completion.spec.ShellSuggestionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalIcons;
import org.jetbrains.plugins.terminal.util.ShellType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0005J\u0011\u0010\u0019\u001a\u00020\u001a*\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/TerminalCompletionUtil;", "", "<init>", "()V", "getNextSuggestionsString", "", "suggestion", "Lcom/intellij/terminal/completion/spec/ShellCompletionSuggestion;", "getNextOptionsAndArgumentsString", "spec", "Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "getNextArgumentsString", "args", "", "Lcom/intellij/terminal/completion/spec/ShellArgumentSpec;", "asSuggestionString", "index", "", "findIconForSuggestion", "Ljavax/swing/Icon;", "name", "type", "Lcom/intellij/terminal/completion/spec/ShellSuggestionType;", "getFileIcon", "fileName", "toShellName", "Lcom/intellij/terminal/completion/spec/ShellName;", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "toShellName-b9zvSdw", "(Lorg/jetbrains/plugins/terminal/util/ShellType;)Ljava/lang/String;", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalCompletionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCompletionUtil.kt\norg/jetbrains/plugins/terminal/block/completion/TerminalCompletionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n774#2:78\n865#2,2:79\n1573#2:81\n1604#2,4:82\n*S KotlinDebug\n*F\n+ 1 TerminalCompletionUtil.kt\norg/jetbrains/plugins/terminal/block/completion/TerminalCompletionUtil\n*L\n34#1:78\n34#1:79,2\n48#1:81\n48#1:82,4\n*E\n"})
public final class TerminalCompletionUtil {
    @NotNull
    public static final TerminalCompletionUtil INSTANCE = new TerminalCompletionUtil();

    private TerminalCompletionUtil() {
    }

    @NotNull
    public final String getNextSuggestionsString(@NotNull ShellCompletionSuggestion suggestion) {
        Object object;
        String result2;
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        String separator = null;
        ShellCompletionSuggestion shellCompletionSuggestion = suggestion;
        if (shellCompletionSuggestion instanceof ShellCommandSpec) {
            v0 = this.getNextOptionsAndArgumentsString((ShellCommandSpec)suggestion);
        } else if (shellCompletionSuggestion instanceof ShellOptionSpec) {
            separator = ((ShellOptionSpec)suggestion).getSeparator();
            v0 = this.getNextArgumentsString(((ShellOptionSpec)suggestion).getArguments());
        } else {
            v0 = result2 = "";
        }
        if (((CharSequence)result2).length() > 0) {
            String string = separator;
            if (string == null) {
                string = " ";
            }
            object = string + result2;
        } else {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String getNextOptionsAndArgumentsString(ShellCommandSpec spec) {
        void $this$filterTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$getNextOptionsAndArgumentsString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$filter$iv = spec.getOptions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShellOptionSpec it = (ShellOptionSpec)element$iv$iv;
            boolean bl2 = false;
            if (!it.isRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ShellOptionSpec option : (List)destination$iv$iv) {
            $this$getNextOptionsAndArgumentsString_u24lambda_u240.append(option.getName());
            String arguments = INSTANCE.getNextArgumentsString(option.getArguments());
            if (((CharSequence)arguments).length() > 0) {
                $this$getNextOptionsAndArgumentsString_u24lambda_u240.append(' ');
                $this$getNextOptionsAndArgumentsString_u24lambda_u240.append(arguments);
            }
            $this$getNextOptionsAndArgumentsString_u24lambda_u240.append(' ');
        }
        $this$getNextOptionsAndArgumentsString_u24lambda_u240.append(INSTANCE.getNextArgumentsString(spec.getArguments()));
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getNextArgumentsString(List<? extends ShellArgumentSpec> args) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = args;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void arg;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShellArgumentSpec shellArgumentSpec = (ShellArgumentSpec)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.asSuggestionString((ShellArgumentSpec)arg, (int)index));
        }
        List argStrings = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)argStrings, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String asSuggestionString(ShellArgumentSpec $this$asSuggestionString, int index) {
        Object object = $this$asSuggestionString.getDisplayName();
        if (object == null) {
            object = "arg" + (index + 1);
        }
        String name = object;
        return $this$asSuggestionString.isOptional() ? "[" + name + "]" : "<" + name + ">";
    }

    @NotNull
    public final Icon findIconForSuggestion(@NotNull String name, @NotNull ShellSuggestionType type) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Icon icon2 = TerminalIcons.Command;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Command");
                break;
            }
            case 2: {
                Icon icon3 = TerminalIcons.Option;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Option");
                break;
            }
            case 3: {
                Icon icon4 = AllIcons.Nodes.Folder;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Folder");
                break;
            }
            case 4: {
                icon = this.getFileIcon(name);
                break;
            }
            case 5: {
                Icon icon5 = TerminalIcons.Other;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Other");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public final Icon getFileIcon(@NotNull String fileName) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        Icon icon2 = fileType2.getIcon();
        if (icon2 == null) {
            Icon icon3 = TerminalIcons.OtherFile;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"OtherFile");
        }
        Icon fileIcon = icon2;
        if (fileType2 instanceof UnknownFileType) {
            Icon icon4 = TerminalIcons.OtherFile;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"OtherFile");
        } else {
            icon = fileIcon;
        }
        return icon;
    }

    @NotNull
    public final String toShellName-b9zvSdw(@NotNull ShellType $this$toShellName_u2db9zvSdw) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toShellName_u2db9zvSdw), (String)"$this$toShellName");
        String string = $this$toShellName_u2db9zvSdw.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return ShellName.constructor-impl(string);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShellSuggestionType.values().length];
            try {
                nArray[ShellSuggestionType.COMMAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShellSuggestionType.OPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShellSuggestionType.FOLDER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShellSuggestionType.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShellSuggestionType.ARGUMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

