/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyLanguageFacadeKt;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.FlowContext;
import com.jetbrains.python.codeInsight.controlflow.PyControlFlow;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eJ\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018JF\u0010\u0019\u001a:\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u000e0\u000e \u001b*\u001c\u0012\u000e\b\u0001\u0012\n \u001b*\u0004\u0018\u00010\u000e0\u000e0\u001a\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001d0\u001a\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001dH\u0096\u0001\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/codeInsight/controlflow/PyDataFlow;", "Lcom/intellij/codeInsight/controlflow/ControlFlow;", "scopeOwner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "controlFlow", "Lcom/jetbrains/python/codeInsight/controlflow/PyControlFlow;", "context", "Lcom/jetbrains/python/codeInsight/controlflow/FlowContext;", "<init>", "(Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;Lcom/jetbrains/python/codeInsight/controlflow/PyControlFlow;Lcom/jetbrains/python/codeInsight/controlflow/FlowContext;)V", "reachability", "", "getReachableSuccessors", "", "Lcom/intellij/codeInsight/controlflow/Instruction;", "instruction", "languageVersion", "Lcom/intellij/openapi/util/Version;", "isUnreachable", "", "isReachableWithVersionChecks", "getInstruction", "", "element", "Lcom/intellij/psi/PsiElement;", "getInstructions", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "()[Lcom/intellij/codeInsight/controlflow/Instruction;", "intellij.python.psi.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyDataFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataFlow.kt\ncom/jetbrains/python/codeInsight/controlflow/PyDataFlow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n774#2:168\n865#2,2:169\n774#2:171\n865#2,2:172\n*S KotlinDebug\n*F\n+ 1 PyDataFlow.kt\ncom/jetbrains/python/codeInsight/controlflow/PyDataFlow\n*L\n57#1:168\n57#1:169,2\n58#1:171\n58#1:172,2\n*E\n"})
public final class PyDataFlow
implements ControlFlow {
    @NotNull
    private final PyControlFlow controlFlow;
    @NotNull
    private final boolean[] reachability;

    public PyDataFlow(@NotNull ScopeOwner scopeOwner, @NotNull PyControlFlow controlFlow, @NotNull FlowContext context) {
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        Intrinsics.checkNotNullParameter((Object)controlFlow, (String)"controlFlow");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.controlFlow = controlFlow;
        this.reachability = new boolean[this.getInstructions().length];
        PsiFile psiFile = scopeOwner.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        LanguageLevel languageLevel = PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)psiFile);
        Version languageVersion = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
        ArrayDeque<Instruction> stack = new ArrayDeque<Instruction>();
        stack.push(this.getInstructions()[0]);
        while (!((Collection)stack).isEmpty()) {
            Instruction instruction = (Instruction)stack.pop();
            int instructionNum = instruction.num();
            if (this.reachability[instructionNum]) continue;
            this.reachability[instructionNum] = true;
            Intrinsics.checkNotNull((Object)instruction);
            for (Instruction successor : this.getReachableSuccessors(instruction, languageVersion, context)) {
                if (this.reachability[successor.num()]) continue;
                stack.push(successor);
            }
        }
    }

    private final Collection<Instruction> getReachableSuccessors(Instruction instruction, Version languageVersion, FlowContext context) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (context.getCheckNoReturnCalls() && instruction instanceof CallInstruction && ((CallInstruction)instruction).isNoReturnCall(context.getTypeEvalContext())) {
            return CollectionsKt.emptyList();
        }
        if (instruction instanceof PyWithContextExitInstruction && !((PyWithContextExitInstruction)instruction).isSuppressingExceptions(context.getTypeEvalContext())) {
            return CollectionsKt.emptyList();
        }
        Collection collection = instruction.allSucc();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"allSucc(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Instruction it = (Instruction)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isReachableWithVersionChecks(it, languageVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ref<PyType> type;
            Instruction next = (Instruction)element$iv$iv;
            boolean bl = false;
            boolean bl2 = next instanceof ReadWriteInstruction && ((ReadWriteInstruction)next).getAccess().isAssertTypeAccess() ? (type = ((ReadWriteInstruction)next).getType(context.getTypeEvalContext(), null)) == null || !(type.get() instanceof PyNeverType) : true;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isUnreachable(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (instruction.num() >= this.reachability.length) {
            return false;
        }
        return !this.reachability[instruction.num()];
    }

    private final boolean isReachableWithVersionChecks(Instruction $this$isReachableWithVersionChecks, Version languageVersion) {
        PsiElement psiElement = $this$isReachableWithVersionChecks.getElement();
        if (psiElement == null) {
            return true;
        }
        return PyVersionSpecificStubBaseKt.evaluateVersionsForElement(psiElement).contains((Comparable)languageVersion);
    }

    public final int getInstruction(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.controlFlow.getInstruction(element);
    }

    @NotNull
    public Instruction[] getInstructions() {
        Instruction[] instructionArray = this.controlFlow.getInstructions();
        Intrinsics.checkNotNullExpressionValue((Object)instructionArray, (String)"getInstructions(...)");
        return instructionArray;
    }
}

