/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode.mappings;

import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/mappings/ThemesMappings;", "", "<init>", "()V", "themeMap", "Lcom/intellij/ide/startup/importSettings/models/BundledLookAndFeel;", "theme", "", "otherThemeConverter", "intellij.ide.startup.importSettings"})
public final class ThemesMappings {
    @NotNull
    public static final ThemesMappings INSTANCE = new ThemesMappings();

    private ThemesMappings() {
    }

    @NotNull
    public final BundledLookAndFeel themeMap(@NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        return switch (theme) {
            case "vs" -> KnownLafs.INSTANCE.getLight();
            case "vs-dark" -> KnownLafs.INSTANCE.getDarcula();
            case "hc-black" -> KnownLafs.INSTANCE.getHighContrast();
            case "Monokai" -> KnownLafs.INSTANCE.getDarcula();
            case "Solarized Dark" -> KnownLafs.INSTANCE.getDarcula();
            case "Solarized Light" -> KnownLafs.INSTANCE.getLight();
            default -> this.otherThemeConverter(theme);
        };
    }

    private final BundledLookAndFeel otherThemeConverter(String theme) {
        String string = theme.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"light", (boolean)false, (int)2, null) ? KnownLafs.INSTANCE.getLight() : KnownLafs.INSTANCE.getDarcula();
    }
}

