/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.Tagger;

public class CheckPostagsInSuggestionFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        RuleMatch ruleMatch = match;
        Language language = ((PatternRule)match.getRule()).getLanguage();
        Tagger tagger = language.getTagger();
        if (tagger == null) {
            throw new IOException("Language tagger not available in rule " + match.getRule().getFullId());
        }
        List<String> replacements = match.getSuggestedReplacements();
        ArrayList<String> newReplacements = new ArrayList<String>();
        String postagsListStr = this.getRequired("PostagsList", arguments);
        String[] postagsList = postagsListStr.split(",");
        for (String replacement : replacements) {
            String[] tokensInSuggestion = replacement.split("\\s+");
            if (tokensInSuggestion.length != postagsList.length || postagsList.length == 0) {
                throw new IOException("Mismatch between number of tokens and number of tags in rule " + match.getRule().getFullId() + " " + String.valueOf(List.of(tokensInSuggestion)) + " " + String.valueOf(List.of(postagsList)));
            }
            boolean postagsMatch = true;
            List<AnalyzedTokenReadings> atrs = tagger.tag(List.of(tokensInSuggestion));
            for (int i = 0; i < postagsList.length && (postagsMatch &= atrs.get(i).matchesPosTagRegex(postagsList[i])); ++i) {
            }
            if (!postagsMatch) continue;
            newReplacements.add(replacement);
        }
        if (newReplacements.isEmpty()) {
            return null;
        }
        ruleMatch.setSuggestedReplacements(newReplacements);
        return ruleMatch;
    }
}

