/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.actions;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.CompletionStatistics;
import com.intellij.featureStatistics.CumulativeStatistics;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.ui.text.StyledTextPane;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

final class ShowFeatureUsageStatisticsDialog
extends DialogWrapper {
    private static final Comparator<FeatureDescriptor> DISPLAY_NAME_COMPARATOR = Comparator.comparing(FeatureDescriptor::getDisplayName);
    private static final Comparator<FeatureDescriptor> GROUP_NAME_COMPARATOR = Comparator.comparing(ShowFeatureUsageStatisticsDialog::getGroupName);
    private static final Comparator<FeatureDescriptor> USAGE_COUNT_COMPARATOR = Comparator.comparingInt(FeatureDescriptor::getUsageCount);
    private static final Comparator<FeatureDescriptor> LAST_USED_COMPARATOR = (fd1, fd2) -> new Date(fd2.getLastTimeUsed()).compareTo(new Date(fd1.getLastTimeUsed()));
    private static final ColumnInfo<FeatureDescriptor, String> DISPLAY_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.feature", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return featureDescriptor.getDisplayName();
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return DISPLAY_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> GROUP_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.group", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return ShowFeatureUsageStatisticsDialog.getGroupName(featureDescriptor);
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return GROUP_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> USED_TOTAL = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.usage.count", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            int count = featureDescriptor.getUsageCount();
            return FeatureStatisticsBundle.message((String)"feature.statistics.usage.count", (Object[])new Object[]{count});
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return USAGE_COUNT_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> LAST_USED = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.last.used", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            long tm = featureDescriptor.getLastTimeUsed();
            if (tm <= 0L) {
                return FeatureStatisticsBundle.message((String)"feature.statistics.not.applicable", (Object[])new Object[0]);
            }
            return DateFormatUtil.formatBetweenDates((long)tm, (long)System.currentTimeMillis());
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return LAST_USED_COMPARATOR;
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{DISPLAY_NAME, GROUP_NAME, USED_TOTAL, LAST_USED};
    @NotNull
    private final Project myProject;

    public ShowFeatureUsageStatisticsDialog(@NotNull Project project) {
        if (project == null) {
            ShowFeatureUsageStatisticsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myProject = project;
        this.setTitle(FeatureStatisticsBundle.message((String)"feature.statistics.dialog.title", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.setModal(false);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.featureStatistics.actions.ShowFeatureUsageStatisticsDialog";
    }

    public Dimension getInitialSize() {
        return new JBDimension(800, 600);
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            ShowFeatureUsageStatisticsDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "editing.productivityGuide";
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerControls(true);
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        ArrayList<FeatureDescriptor> features = new ArrayList<FeatureDescriptor>();
        for (String id : registry.getFeatureIds()) {
            TipAndTrickBean tip;
            FeatureDescriptor feature = registry.getFeatureDescriptor(id);
            if (!feature.isNeedToBeShownInGuide() || (tip = TipUtils.INSTANCE.getTip(feature)) == null || !TipUtils.INSTANCE.checkTipFileExist(tip)) continue;
            features.add(feature);
        }
        final TableView table = new TableView(new ListTableModel(COLUMNS, features, 0));
        TableViewSpeedSearch<FeatureDescriptor> search = new TableViewSpeedSearch<FeatureDescriptor>(this, table, null){

            protected String getItemText(@NotNull FeatureDescriptor element) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                return element.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/featureStatistics/actions/ShowFeatureUsageStatisticsDialog$5", "getItemText"));
            }
        };
        search.setupListeners();
        JPanel controlsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        Application app = ApplicationManager.getApplication();
        long uptime = System.currentTimeMillis() - app.getStartTime();
        long idleTime = app.getIdleTime();
        String uptimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.uptime", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), NlsMessages.formatDurationApproximate((long)uptime)});
        String idleTimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.idle.time", (Object[])new Object[]{NlsMessages.formatDurationApproximate((long)idleTime)});
        String labelText = uptimeS + ", " + idleTimeS;
        CompletionStatistics stats = ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getCompletionStatistics();
        if (stats.dayCount > 0 && stats.sparedCharacters > 0) {
            String total = ShowFeatureUsageStatisticsDialog.formatCharacterCount(stats.sparedCharacters, true);
            String perDay = ShowFeatureUsageStatisticsDialog.formatCharacterCount(stats.sparedCharacters / stats.dayCount, false);
            labelText = labelText + "<br>" + IdeBundle.message((String)"label.text.code.completion.saved", (Object[])new Object[]{total, DateFormatUtil.formatDate((long)stats.startDate), perDay});
        }
        CumulativeStatistics fstats = ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats();
        if (fstats.dayCount > 0 && fstats.invocations > 0) {
            labelText = labelText + "<br>" + IdeBundle.message((String)"label.text.quick.fixes.saved", (Object[])new Object[]{fstats.invocations, DateFormatUtil.formatDate((long)fstats.startDate), fstats.invocations / fstats.dayCount});
        }
        controlsPanel.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)labelText)), "North");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)controlsPanel, "North");
        topPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)table), "Center");
        splitter.setFirstComponent((JComponent)topPanel);
        final StyledTextPane textPane = new StyledTextPane();
        textPane.setBackground(UIUtil.getTextFieldBackground());
        Disposer.register((Disposable)this.getDisposable(), (Disposable)textPane);
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)textPane));
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Collection selection = table.getSelection();
                if (selection.isEmpty()) {
                    textPane.clear();
                } else {
                    TipAndTrickBean tip = TipUtils.INSTANCE.getTip((FeatureDescriptor)selection.iterator().next());
                    TableView contextComponent = table.isShowing() ? table : WindowManager.getInstance().getFrame(ShowFeatureUsageStatisticsDialog.this.myProject);
                    List<TextParagraph> paragraphs = TipUtils.loadAndParseTip(tip, (Component)contextComponent);
                    textPane.setParagraphs(paragraphs);
                }
            }
        });
        ScrollingUtil.ensureSelectionExists((JTable)table);
        return splitter;
    }

    private static String formatCharacterCount(int count, boolean full) {
        String result;
        DecimalFormat oneDigit = new DecimalFormat("0.0");
        Object object = count > 0x100000 ? oneDigit.format((double)count / 1024.0 / 1024.0) + "M" : (result = count > 1024 ? oneDigit.format((double)count / 1024.0) + "K" : String.valueOf(count));
        if (full) {
            return IdeBundle.message((String)"label.text.character.count", (Object[])new Object[]{result});
        }
        return result;
    }

    private static String getGroupName(@NotNull FeatureDescriptor featureDescriptor) {
        if (featureDescriptor == null) {
            ShowFeatureUsageStatisticsDialog.$$$reportNull$$$0(2);
        }
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        String groupId = featureDescriptor.getGroupId();
        if (registry != null && groupId != null) {
            GroupDescriptor groupDescriptor = registry.getGroupDescriptor(groupId);
            return groupDescriptor != null ? groupDescriptor.getDisplayName() : "";
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/actions/ShowFeatureUsageStatisticsDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/actions/ShowFeatureUsageStatisticsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

