/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.html.embedding.HtmlEmbeddedContentProvider;
import com.intellij.html.embedding.HtmlEmbeddedContentSupport;
import com.intellij.html.embedding.HtmlEmbedment;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.HtmlDefaultEmbeddedContentSupport;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.RestartableLexer;
import com.intellij.lexer.TokenIterator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHtmlLexer
extends DelegateLexer
implements RestartableLexer {
    protected static final int BASE_STATE_MASK = 63;
    private static final int CONTENT_PROVIDER_HAS_STATE = 64;
    private static final int IS_WITHIN_TAG_STATE = 128;
    protected static final int BASE_STATE_SHIFT = 9;
    protected static final TokenSet ATTRIBUTE_EMBEDMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ENTITY_REF_TOKEN, XmlTokenType.XML_CHAR_ENTITY_REF});
    protected static final TokenSet TAG_EMBEDMENT_START_TOKENS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_CDATA_START, XmlTokenType.XML_COMMENT_START, XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_END_TAG_START, TokenType.WHITE_SPACE, XmlTokenType.XML_ENTITY_REF_TOKEN, XmlTokenType.XML_CHAR_ENTITY_REF});
    private boolean isWithinTag;
    protected final boolean caseInsensitive;
    private final List<HtmlEmbeddedContentProvider> myEmbeddedContentProviders;
    private final TokenSet myTagEmbedmentStartTokens;
    private final TokenSet myAttributeEmbedmentTokens;
    private HtmlEmbedment myHtmlEmbedmentInfo;
    static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_TAG_CHARACTERS});

    protected BaseHtmlLexer(@NotNull Lexer _baseLexer, boolean _caseInsensitive) {
        if (_baseLexer == null) {
            BaseHtmlLexer.$$$reportNull$$$0(0);
        }
        super(_baseLexer);
        this.isWithinTag = false;
        this.caseInsensitive = _caseInsensitive;
        List<HtmlEmbeddedContentSupport> supports = this.getEmbeddedContentSupportList();
        this.myEmbeddedContentProviders = supports.stream().map(factory -> factory.createEmbeddedContentProviders(this)).flatMap(Collection::stream).filter(this::acceptEmbeddedContentProvider).toList();
        this.myTagEmbedmentStartTokens = this.createTagEmbedmentStartTokenSet();
        this.myAttributeEmbedmentTokens = this.createAttributeEmbedmentTokenSet();
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BaseHtmlLexer.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState & 0x3F);
        if ((initialState & 0x40) != 0) {
            throw new IllegalStateException("Cannot restore HTML Lexer to a position, in which an embedded content provider has state. Use restoreLocation() method.");
        }
        this.isWithinTag = (initialState & 0x80) != 0;
        this.myHtmlEmbedmentInfo = null;
        this.myEmbeddedContentProviders.forEach(provider -> provider.restoreState(null));
        this.broadcastToken();
    }

    public boolean isRestartableState(int state) {
        return (state & 0x40) == 0;
    }

    public int getStartState() {
        return 0;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState, TokenIterator tokenIterator) {
        if (buffer == null) {
            BaseHtmlLexer.$$$reportNull$$$0(2);
        }
        this.start(buffer, startOffset, endOffset, initialState);
    }

    public void advance() {
        if (this.myHtmlEmbedmentInfo != null) {
            this.restartAfterEmbedment(this.myHtmlEmbedmentInfo.getRange().getEndOffset(), this.myHtmlEmbedmentInfo.getBaseLexerState());
        } else {
            super.advance();
        }
        this.broadcastToken();
        this.myHtmlEmbedmentInfo = null;
    }

    protected void restartAfterEmbedment(int offset, int baseLexerState) {
        this.myDelegate.start(this.myDelegate.getBufferSequence(), offset, this.myDelegate.getBufferEnd(), baseLexerState);
    }

    @NotNull
    protected TokenSet createTagEmbedmentStartTokenSet() {
        TokenSet tokenSet = TAG_EMBEDMENT_START_TOKENS;
        if (tokenSet == null) {
            BaseHtmlLexer.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    protected TokenSet createAttributeEmbedmentTokenSet() {
        TokenSet tokenSet = ATTRIBUTE_EMBEDMENT_TOKENS;
        if (tokenSet == null) {
            BaseHtmlLexer.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    public int getStateForRestartDuringEmbedmentScan() {
        return 0;
    }

    private void broadcastToken() {
        IElementType type = this.myDelegate.getTokenType();
        if (type != null) {
            TextRange textRange = new TextRange(this.myDelegate.getTokenStart(), this.myDelegate.getTokenEnd());
            this.myEmbeddedContentProviders.forEach(provider -> provider.handleToken(type, textRange));
            if (type == XmlTokenType.XML_NAME && this.isHtmlTagState(super.getState())) {
                this.isWithinTag = true;
            } else if (type == XmlTokenType.XML_TAG_END || type == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                this.isWithinTag = false;
            }
        }
    }

    public int getState() {
        int state = super.getState();
        if (this.myHtmlEmbedmentInfo != null || ContainerUtil.find(this.myEmbeddedContentProviders, provider -> provider.hasState()) != null) {
            state |= 0x40;
        }
        if (this.isWithinTag) {
            state |= 0x80;
        }
        return state;
    }

    @Nullable
    protected HtmlEmbedment acquireHtmlEmbedmentInfo() {
        IElementType type = this.myDelegate.getTokenType();
        if (type != null) {
            for (HtmlEmbeddedContentProvider provider : this.myEmbeddedContentProviders) {
                HtmlEmbedment embedment = provider.createEmbedment(type);
                if (embedment == null) continue;
                this.myEmbeddedContentProviders.forEach(HtmlEmbeddedContentProvider::clearEmbedment);
                return embedment;
            }
        }
        return null;
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return new HtmlLexerPosition(this.getTokenStart(), this.getState() & 0xFFFFFFBF, this.myDelegate.getCurrentPosition(), this.myEmbeddedContentProviders.stream().map(provider -> new Pair(provider, provider.getState())).filter(pair -> pair.second != null).collect(Collectors.toMap(p -> (HtmlEmbeddedContentProvider)p.first, p -> p.second)));
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            BaseHtmlLexer.$$$reportNull$$$0(5);
        }
        super.restore(position);
        this.myDelegate.restore(((HtmlLexerPosition)position).myDelegateLexerPosition);
        Map<HtmlEmbeddedContentProvider, Object> providersState = ((HtmlLexerPosition)position).myProvidersState;
        this.myEmbeddedContentProviders.forEach(provider -> provider.restoreState(providersState.get(provider)));
    }

    protected void skipEmbedment(@NotNull HtmlEmbedment embedment) {
        if (embedment == null) {
            BaseHtmlLexer.$$$reportNull$$$0(6);
        }
        this.myHtmlEmbedmentInfo = embedment;
    }

    protected int getBaseStateShift() {
        return 9;
    }

    protected boolean isWithinTag() {
        return this.isWithinTag;
    }

    protected boolean isAttributeEmbedmentToken(@NotNull IElementType tokenType, @NotNull CharSequence attributeName) {
        if (tokenType == null) {
            BaseHtmlLexer.$$$reportNull$$$0(7);
        }
        if (attributeName == null) {
            BaseHtmlLexer.$$$reportNull$$$0(8);
        }
        return this.myAttributeEmbedmentTokens.contains(tokenType);
    }

    protected boolean isTagEmbedmentStartToken(@NotNull IElementType tokenType, @NotNull CharSequence tagName) {
        if (tokenType == null) {
            BaseHtmlLexer.$$$reportNull$$$0(9);
        }
        if (tagName == null) {
            BaseHtmlLexer.$$$reportNull$$$0(10);
        }
        return this.myTagEmbedmentStartTokens.contains(tokenType);
    }

    @NotNull
    protected List<HtmlEmbeddedContentSupport> getEmbeddedContentSupportList() {
        ArrayList<HtmlEmbeddedContentSupport> supports = new ArrayList<HtmlEmbeddedContentSupport>();
        try {
            HtmlEmbeddedContentSupport.Companion.getContentSupports().filter(support -> support.isEnabled(this)).forEach(supports::add);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        supports.add(new HtmlDefaultEmbeddedContentSupport());
        ArrayList<HtmlEmbeddedContentSupport> arrayList = supports;
        if (arrayList == null) {
            BaseHtmlLexer.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    protected boolean acceptEmbeddedContentProvider(@NotNull HtmlEmbeddedContentProvider provider) {
        if (provider == null) {
            BaseHtmlLexer.$$$reportNull$$$0(12);
        }
        return true;
    }

    public boolean isPossiblyCustomTagName(@NotNull CharSequence tagName) {
        if (tagName == null) {
            BaseHtmlLexer.$$$reportNull$$$0(13);
        }
        return false;
    }

    protected boolean isHtmlTagState(int state) {
        return state == 6 || state == 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_baseLexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/BaseHtmlLexer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedment";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/BaseHtmlLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagEmbedmentStartTokenSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeEmbedmentTokenSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedContentSupportList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "skipEmbedment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAttributeEmbedmentToken";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTagEmbedmentStartToken";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptEmbeddedContentProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyCustomTagName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 11 -> new IllegalStateException(string);
        };
    }

    private static class HtmlLexerPosition
    implements LexerPosition {
        private final int myOffset;
        private final int myState;
        final LexerPosition myDelegateLexerPosition;
        final Map<HtmlEmbeddedContentProvider, Object> myProvidersState;

        HtmlLexerPosition(int offset, int state, LexerPosition delegateLexerPosition, Map<HtmlEmbeddedContentProvider, Object> providersState) {
            this.myOffset = offset;
            this.myState = state;
            this.myDelegateLexerPosition = delegateLexerPosition;
            this.myProvidersState = providersState;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getState() {
            return this.myState;
        }
    }
}

