/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\f\rB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/completion/XmlAttributeValueQuotationHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "myStyle", "Lcom/intellij/codeInsight/completion/XmlAttributeValueQuotationHandler$AttributeValueQuotationStyle;", "<init>", "(Lcom/intellij/codeInsight/completion/XmlAttributeValueQuotationHandler$AttributeValueQuotationStyle;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "AttributeValueQuotationStyle", "Companion", "intellij.xml.impl"})
public final class XmlAttributeValueQuotationHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AttributeValueQuotationStyle myStyle;
    @JvmField
    @NotNull
    public static final XmlAttributeValueQuotationHandler QUOTES = new XmlAttributeValueQuotationHandler(AttributeValueQuotationStyle.QUOTES);
    @JvmField
    @NotNull
    public static final XmlAttributeValueQuotationHandler BRACES = new XmlAttributeValueQuotationHandler(AttributeValueQuotationStyle.BRACES);
    @JvmField
    @NotNull
    public static final XmlAttributeValueQuotationHandler EQUAL_ONLY = new XmlAttributeValueQuotationHandler(AttributeValueQuotationStyle.EQUAL_ONLY);

    public XmlAttributeValueQuotationHandler(@NotNull AttributeValueQuotationStyle myStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)myStyle), (String)"myStyle");
        this.myStyle = myStyle;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        boolean hasValue;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int caretOffset = editor2.getCaretModel().getOffset();
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        boolean hasQuotes = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='");
        boolean hasBraces = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"={");
        boolean bl = hasValue = hasQuotes || hasBraces;
        if (!hasValue && CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=")) {
            document2.deleteString(caretOffset, caretOffset + 1);
        }
        AttributeValueQuotationStyle effective = this.myStyle;
        boolean insertQuotes = WebEditorOptions.getInstance().isInsertQuotesForAttributeValue();
        if (!insertQuotes && effective == AttributeValueQuotationStyle.QUOTES) {
            effective = AttributeValueQuotationStyle.EQUAL_ONLY;
        }
        if (!hasValue) {
            String toInsert = switch (WhenMappings.$EnumSwitchMapping$0[effective.ordinal()]) {
                case 1 -> "={}";
                case 2 -> "=\"\"";
                case 3 -> "=";
                default -> throw new NoWhenBranchMatchedException();
            };
            if (caretOffset < document2.getTextLength() && StringsKt.indexOf$default((CharSequence)"/> \n\t\r", (char)chars.charAt(caretOffset), (int)0, (boolean)false, (int)6, null) < 0) {
                document2.insertString(caretOffset, (CharSequence)(toInsert + " "));
            } else {
                document2.insertString(caretOffset, (CharSequence)toInsert);
            }
            if ('=' == context.getCompletionChar()) {
                context.setAddCompletionChar(false);
            }
        }
        int move = switch (WhenMappings.$EnumSwitchMapping$0[effective.ordinal()]) {
            case 1, 2 -> 2;
            case 3 -> 1;
            default -> throw new NoWhenBranchMatchedException();
        };
        editor2.getCaretModel().moveToOffset(caretOffset + move);
        if (effective != AttributeValueQuotationStyle.EQUAL_ONLY || hasValue) {
            TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(editor2);
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getSelectionModel().removeSelection();
        if (effective == AttributeValueQuotationStyle.BRACES) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(editor2, null);
        } else {
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/completion/XmlAttributeValueQuotationHandler$AttributeValueQuotationStyle;", "", "<init>", "(Ljava/lang/String;I)V", "QUOTES", "BRACES", "EQUAL_ONLY", "intellij.xml.impl"})
    public static final class AttributeValueQuotationStyle
    extends Enum<AttributeValueQuotationStyle> {
        public static final /* enum */ AttributeValueQuotationStyle QUOTES = new AttributeValueQuotationStyle();
        public static final /* enum */ AttributeValueQuotationStyle BRACES = new AttributeValueQuotationStyle();
        public static final /* enum */ AttributeValueQuotationStyle EQUAL_ONLY = new AttributeValueQuotationStyle();
        private static final /* synthetic */ AttributeValueQuotationStyle[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AttributeValueQuotationStyle[] values() {
            return (AttributeValueQuotationStyle[])$VALUES.clone();
        }

        public static AttributeValueQuotationStyle valueOf(String value) {
            return Enum.valueOf(AttributeValueQuotationStyle.class, value);
        }

        @NotNull
        public static EnumEntries<AttributeValueQuotationStyle> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = attributeValueQuotationStyleArray = new AttributeValueQuotationStyle[]{AttributeValueQuotationStyle.QUOTES, AttributeValueQuotationStyle.BRACES, AttributeValueQuotationStyle.EQUAL_ONLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/completion/XmlAttributeValueQuotationHandler$Companion;", "", "<init>", "()V", "QUOTES", "Lcom/intellij/codeInsight/completion/XmlAttributeValueQuotationHandler;", "BRACES", "EQUAL_ONLY", "intellij.xml.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttributeValueQuotationStyle.values().length];
            try {
                nArray[AttributeValueQuotationStyle.BRACES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeValueQuotationStyle.QUOTES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeValueQuotationStyle.EQUAL_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

