/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.IntrospectionError;

@Deprecated(since="3", forRemoval=true)
public class OnFieldsComparator
extends FieldByFieldComparator {
    private final String[] fields;

    public OnFieldsComparator(Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        super(comparatorByPropertyOrField, comparatorByType);
        Preconditions.checkArgument(!Arrays.isNullOrEmpty(fields), "No fields/properties specified", new Object[0]);
        for (String field : fields) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(field) && !Strings.isNullOrEmpty(field.trim()), "Null/blank fields/properties are invalid, fields/properties were %s", ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(fields));
        }
        this.fields = fields;
    }

    public OnFieldsComparator(String ... fields) {
        this(new HashMap(), TypeComparators.defaultTypeComparators(), fields);
    }

    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected boolean areEqual(Object actualElement, Object otherElement) {
        try {
            return Objects.instance().areEqualToComparingOnlyGivenFields(actualElement, otherElement, this.comparatorsByPropertyOrField, this.comparatorsByType, this.fields);
        }
        catch (IntrospectionError e2) {
            return false;
        }
    }

    @Override
    protected String description() {
        if (this.fields.length == 1) {
            return "single field/property comparator on field/property " + ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this.fields[0]);
        }
        return "field/property by field/property comparator on fields/properties " + ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this.fields);
    }
}

